/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.isv.ISVService;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.newdevportal.gpt.GPTMockUtil;

class FieldTypeFactory {
    private static final Map<String, FieldDesc> fieldDescMap = new HashMap<String, FieldDesc>(5);

    FieldTypeFactory() {
    }

    public static String getDataTypeDisplay(String type) {
        FieldDesc fieldDesc = fieldDescMap.get((type = GPTMockUtil.fixFieldType(type)).toLowerCase());
        if (fieldDesc != null) {
            return fieldDesc.caption();
        }
        return "";
    }

    public static Field<?> createField(String type, FieldAp fieldAp, JSONObject fieldJson, List<ControlAp<?>> controlApList) {
        FieldDesc fieldDesc = fieldDescMap.get(type.toLowerCase());
        if (fieldDesc != null) {
            Field<?> field = fieldDesc.createField(fieldAp, fieldJson, controlApList);
            field.setId(fieldAp.getId());
            field.setKey(fieldAp.getKey());
            fieldAp.setField(field);
            field.setName(fieldAp.getName());
            field.setMustInput("true".equals(fieldJson.get((Object)"mustinput")));
            String fieldName = "f" + fieldAp.getKey();
            if (!"kingdee".equals(ISVService.getISVInfo().getId()) && !"".equals(ISVService.getISVInfo().getId()) && (fieldName = "fk_" + fieldAp.getKey()).length() > 25) {
                fieldName = fieldName.substring(0, 25);
            }
            field.setFieldName(fieldName);
            return field;
        }
        return null;
    }

    private static FieldAp getBaseField(String key, List<ControlAp<?>> fieldApList) {
        for (ControlAp<?> fieldAp : fieldApList) {
            if (fieldAp.getKey().equalsIgnoreCase(DevportalUtil.autoIsvNumber((String)key))) {
                return (FieldAp)fieldAp;
            }
            if (!fieldAp.getName().toString().contains(key.toLowerCase())) continue;
            return (FieldAp)fieldAp;
        }
        return null;
    }

    static {
        fieldDescMap.put("textedit", new FieldDesc(){

            @Override
            public String caption() {
                return ResManager.loadKDString((String)"\u6587\u672c", (String)"FieldTypeFactory_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            }

            @Override
            public Field<?> createField(FieldAp fieldAp, JSONObject fieldJson, List<ControlAp<?>> controlApList) {
                return new TextField();
            }
        });
        fieldDescMap.put("comboedit", new FieldDesc(){

            @Override
            public String caption() {
                return ResManager.loadKDString((String)"\u4e0b\u62c9\u5217\u8868", (String)"FieldTypeFactory_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            }

            @Override
            public Field<?> createField(FieldAp fieldAp, JSONObject fieldJson, List<ControlAp<?>> controlApList) {
                return new ComboField();
            }
        });
        fieldDescMap.put("basedataedit", new FieldDesc(){

            @Override
            public String caption() {
                return ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"FieldTypeFactory_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            }

            @Override
            public Field<?> createField(FieldAp fieldAp, JSONObject fieldJson, List<ControlAp<?>> controlApList) {
                BasedataField basedataField = new BasedataField();
                basedataField.setBaseEntityId(GPTMockUtil.getBaseDataEntityId((String)fieldJson.get((Object)"basedata"), (String)fieldJson.get((Object)"name")));
                GPTMockUtil.setBaseDataField(basedataField);
                return basedataField;
            }
        });
        fieldDescMap.put("basedataprop", new FieldDesc(){

            @Override
            public String caption() {
                return ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027", (String)"FieldTypeFactory_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            }

            @Override
            public Field<?> createField(FieldAp fieldAp, JSONObject fieldJson, List<ControlAp<?>> controlApList) {
                BasedataPropField basedataPropField = new BasedataPropField();
                String propKey = GPTMockUtil.guessProp(fieldJson);
                if (propKey != null) {
                    FieldAp refBaseData = FieldTypeFactory.getBaseField(propKey, controlApList);
                    GPTMockUtil.setBaseDataProp(basedataPropField, refBaseData, fieldAp.getName().toString());
                }
                return basedataPropField;
            }
        });
        fieldDescMap.put("decimaledit", new FieldDesc(){

            @Override
            public String caption() {
                return ResManager.loadKDString((String)"\u6570\u91cf", (String)"FieldTypeFactory_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            }

            @Override
            public Field<?> createField(FieldAp fieldAp, JSONObject fieldJson, List<ControlAp<?>> controlApList) {
                DecimalField decimalField = new DecimalField();
                decimalField.setScale(GPTMockUtil.getScale(fieldAp));
                return decimalField;
            }
        });
        fieldDescMap.put("dateedit", new FieldDesc(){

            @Override
            public String caption() {
                return ResManager.loadKDString((String)"\u65e5\u671f", (String)"FieldTypeFactory_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            }

            @Override
            public Field<?> createField(FieldAp fieldAp, JSONObject fieldJson, List<ControlAp<?>> controlApList) {
                return new DateField();
            }
        });
    }

    static interface FieldDesc {
        public String caption();

        public Field<?> createField(FieldAp var1, JSONObject var2, List<ControlAp<?>> var3);
    }
}

