/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.designer.dao.DesignerData;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.newdevportal.gpt.FieldTypeFactory;
import kd.bos.newdevportal.gpt.GPTMockUtil;

public class FormMetadataBuilder {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private final Map<String, Object> blankDesignMeta;
    private final Map<String, Object> formDesignMeta;
    private final FormMetadata formMetadata;

    public FormMetadataBuilder(String bizAppId, JSONObject ocrResult) {
        FormMetadata blankMetadata = this.createBlankMetadata(bizAppId, ocrResult.getString("title"));
        this.blankDesignMeta = blankMetadata.buildDesignMeta("zh_CN");
        this.formMetadata = this.createFormMetadata(blankMetadata, ocrResult);
        this.formDesignMeta = this.formMetadata.buildDesignMeta("zh_CN");
    }

    private FormMetadata createBlankMetadata(String bizAppId, String title) {
        String yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        if (StringUtils.isBlank((CharSequence)title)) {
            title = ResManager.loadKDString((String)"GPT\u751f\u6210\u5355\u636e", (String)"FormMetadataBuilder_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        }
        String key = "gpt" + yyyyMMddHHmmss;
        String modelType = "BillFormModel";
        String parentId = "ab7efc31000010ac";
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", key);
        params.put("name", title);
        params.put("parentId", parentId);
        params.put("modelType", modelType);
        params.put("bizappid", bizAppId);
        return new DesignerData().createBlankMetadata(params);
    }

    private FormMetadata createFormMetadata(FormMetadata blankMetada, JSONObject ocrResult) {
        GPTMockUtil.hideAttatchmentPanel(blankMetada);
        Entity billEntity = (Entity)blankMetada.getEntityMetadata().getItems().get(0);
        String tableName = "t_" + blankMetada.getKey();
        billEntity.setTableName(tableName);
        String tableNamePosfix = "_e";
        int seq = 1;
        for (EntityItem item : blankMetada.getEntityMetadata().getItems()) {
            if (!(item instanceof EntryEntity)) continue;
            tableName = "t_" + blankMetada.getKey() + tableNamePosfix;
            ((EntryEntity)item).setTableName(tableName);
            tableNamePosfix = "_e" + seq;
            ++seq;
        }
        this.addGPTFields(blankMetada, ocrResult);
        blankMetada.createIndex(true);
        blankMetada.getEntityMetadata().createIndex(true);
        blankMetada.bindEntityMetadata(blankMetada.getEntityMetadata());
        return blankMetada;
    }

    private void addGPTFields(FormMetadata formMetadata, JSONObject gpt) {
        HashSet<String> controlSet = new HashSet<String>(16);
        formMetadata.getItems().forEach(o -> controlSet.add(o.getKey()));
        List<ControlAp<?>> controlApList = this.createControl(controlSet, formMetadata, gpt);
        for (ControlAp<?> controlAp : controlApList) {
            controlSet.add(controlAp.getKey());
            formMetadata.getItems().add(controlAp);
            if (!(controlAp instanceof FieldAp)) continue;
            formMetadata.getEntityMetadata().getItems().add(((FieldAp)controlAp).getField());
        }
    }

    private List<ControlAp<?>> createControl(Set<String> existsControl, FormMetadata formMetadata, JSONObject gpt) {
        Object entry;
        Object header = gpt.getOrDefault((Object)"header", null);
        ArrayList list = new ArrayList(16);
        if (header != null) {
            JSONArray jsonArray = (JSONArray)header;
            String parentId = "";
            for (ControlAp item : formMetadata.getItems()) {
                if (!item.getKey().equals("fs_baseinfo")) continue;
                parentId = item.getId();
                break;
            }
            this.addFieldApToList(existsControl, list, jsonArray, parentId, false);
        }
        if ((entry = gpt.getOrDefault((Object)"entry", null)) != null) {
            JSONArray jsonArray = (JSONArray)entry;
            String parentId = "";
            for (ControlAp item : formMetadata.getItems()) {
                if (!item.getKey().equals("entryentity")) continue;
                parentId = item.getId();
                break;
            }
            this.addFieldApToList(existsControl, list, jsonArray, parentId, true);
        }
        return list;
    }

    private void addFieldApToList(Set<String> existsControl, List<ControlAp<?>> list, JSONArray jsonArray, String parentId, boolean isEntry) {
        for (Object o : jsonArray) {
            JSONObject f = (JSONObject)o;
            GPTMockUtil.normalizeField(f);
            if (existsControl.contains(f.getString("id"))) continue;
            String type = (String)f.get((Object)"type");
            EntryFieldAp fieldAp = isEntry ? new EntryFieldAp() : new FieldAp();
            fieldAp.setId(Uuid8.generateShortUuid());
            fieldAp.setFieldId(fieldAp.getId());
            fieldAp.setKey(DevportalUtil.autoIsvNumber((String)f.getString("id")));
            fieldAp.setName(new LocaleString((String)f.get((Object)"name")));
            fieldAp.setParentId(parentId);
            Field<?> field = FieldTypeFactory.createField(type, (FieldAp)fieldAp, f, list);
            if (field == null) continue;
            if (isEntry) {
                field.setParentId(parentId);
            }
            list.add((ControlAp<?>)fieldAp);
        }
    }

    public Map<String, Object> getBlankDesignMeta() {
        return this.blankDesignMeta;
    }

    public Map<String, Object> getFormDesignMeta() {
        return this.formDesignMeta;
    }

    public FormMetadata getFormMetadata() {
        return this.formMetadata;
    }
}

