/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class GPTAssistFormUtil {
    private static Log logger = LogFactory.getLog(GPTAssistFormUtil.class);
    private static final String GPT_GAI_FORM_PAGEID = "gpt_gai_form_pageid";

    public static void showAssistForm(IFormView desingerView, Map<String, Object> customParams, boolean switchSide) {
        try {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_chat_ai_customcontrol");
            fsp.setCustomParam("adapterWindow", (Object)Boolean.TRUE);
            fsp.setCustomParam("formId", (Object)"bos_devpn_formdesign");
            fsp.setCustomParam("showIcon", (Object)switchSide);
            fsp.setCustomParam("switchSide", (Object)switchSide);
            fsp.setCustomParam("slideEnv", (Object)"NEW_DEVDESIGNER");
            customParams.forEach((k, v) -> fsp.setCustomParam(k, v));
            fsp.getOpenStyle().setTargetKey("gptpanel");
            fsp.getOpenStyle().setShowType(ShowType.InContainer);
            String pageId = fsp.getPageId();
            desingerView.getPageCache().put(GPT_GAI_FORM_PAGEID, pageId);
            desingerView.showForm(fsp);
        }
        catch (Exception e) {
            desingerView.getPageCache().remove(GPT_GAI_FORM_PAGEID);
            logger.error("start gpt assist form failed.", (Throwable)e);
        }
    }

    public static void switchAssistForm(IFormView designerView, boolean showSlide) {
        String pageId = designerView.getPageCache().get(GPT_GAI_FORM_PAGEID);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return;
        }
        IFormView view = designerView.getViewNoPlugin(pageId);
        if (view == null) {
            logger.info("gpt_gai view not exist,pageId:{}", (Object)pageId);
            return;
        }
        CustomControl control = (CustomControl)view.getControl("customcontrolap");
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Object data = JSONObject.parse((String)("{\"switchSide\":" + showSlide + ",\"time\":\"" + sf.format(new Date()) + "\"}"));
        control.setData(data);
        GPTAssistFormUtil.sendFormAction(designerView, pageId, view.getActionResult());
    }

    public static void switchAssistForm(IFormView designerView) {
        String pageId = designerView.getPageCache().get(GPT_GAI_FORM_PAGEID);
        if (StringUtils.isBlank((CharSequence)pageId) || designerView.getViewNoPlugin(pageId) == null) {
            GPTAssistFormUtil.showAssistForm(designerView, new HashMap<String, Object>(16), true);
            return;
        }
        boolean showSlide = !GPTAssistFormUtil.isGPTControlVisible(designerView);
        GPTAssistFormUtil.switchAssistForm(designerView, showSlide);
    }

    private static void sendFormAction(IFormView designerView, String pageId, List<Object> acts) {
        HashMap<String, Object> arg = new HashMap<String, Object>(3);
        arg.put("pageId", pageId);
        arg.put("actions", acts);
        IClientViewProxy clientViewProxy = (IClientViewProxy)designerView.getService(IClientViewProxy.class);
        clientViewProxy.addAction("sendDynamicFormAction", arg);
    }

    public static boolean isGPTControlVisible(IFormView designerView) {
        String pageId = designerView.getPageCache().get(GPT_GAI_FORM_PAGEID);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return false;
        }
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        return "true".equals(pageCache.get("control_visible_status"));
    }

    public static void showProcessList(String designerPageId) {
        try {
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"bos_openworkflow")};
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_process", (QFilter[])filters);
            if (obj == null) {
                logger.warn("GaiService.startProcessInSideBar error, bos_openworkflow process not exists.");
                return;
            }
            long processId = obj.getLong("id");
            DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"startProcessInSideBar", (Object[])new Object[]{processId, designerPageId, new HashMap()});
        }
        catch (Exception e) {
            logger.error("GaiService.startProcessInSideBar error", (Throwable)e);
        }
    }
}

