/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.gpt.IGPTFormAction;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.newdevportal.form.designer.ProFormDesignerPlugin;
import kd.bos.newdevportal.gpt.BizRuleBuilder;
import kd.bos.newdevportal.gpt.FormMetadataBuilder;
import kd.bos.newdevportal.gpt.GPTFieldPropertyBuilder;
import kd.bos.newdevportal.gpt.GPTMockUtil;
import kd.bos.newdevportal.gpt.IFrameUtil;
import kd.bos.newdevportal.gpt.model.GPTRule;
import kd.bos.newdevportal.gpt.model.GPTShowRule;

public class GPTDesignerAction
implements IGPTFormAction {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final Log logger = LogFactory.getLog(GPTDesignerAction.class);
    private static final String LIST_META = "ListMeta";
    private static final String MOB_META = "MobMeta";
    private static final String MOB_LIST_META = "MobListMeta";
    private static final String CURRENT_METADATA = "current_metadata";
    private static final String CACHE_KEY_ALLMETADATA = "cache_all_metadata";
    public static final String SHOW_RULES = "SHOW_RULES";
    public static final String MODIFYBACKCOLOR = "MODIFYBACKCOLOR";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> invokeAction(String pageId, String action, Map<String, String> params) {
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        if (formView == null) {
            logger.warn("FormView not exits. pageID:{}", (Object)pageId);
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            boolean excuteAction = false;
            if (action.equals("CREATE_BILL")) {
                JSONObject ocrResult = GPTMockUtil.parseObject(params.get("input"));
                String bizappId = (String)formView.getFormShowParameter().getCustomParam("bizappid");
                this.createBillFormByOCR(formView, bizappId, ocrResult);
                IFrameUtil.stopOcrAnimate(formView);
                excuteAction = true;
            } else if (action.equals("CREATE_BILL_RULE")) {
                JSONObject jsonInput = GPTMockUtil.parseObject(params.get("input"));
                Map<String, Object> map = this.getDesignerContent(formView);
                Map formMeta = (Map)map.get("formmeta");
                EntityMetadata entityMetadata = this.convertToEntityMetadata((Map)formMeta.get("entitymeta"));
                GPTRule[] rules = new BizRuleBuilder().createRule(entityMetadata, jsonInput);
                if (rules.length <= 0) throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u5408\u9002\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u60a8\u7684\u63cf\u8ff0\u5e76\u91cd\u8bd5\u3002%1$s", (String)"GPTDesignerAction_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{RequestContext.get().getTraceId()}));
                IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
                for (GPTRule gptRule : rules) {
                    proxy.invokeControlMethod(this.getDesignerKey(), "addRules", new Object[]{gptRule.toMap()});
                }
                formView.getPageCache().put("isaddrule", "true");
                formView.getPageCache().put("gptruledesc", rules[0].getRules().get(0).getDescription().toString());
                GPTShowRule gptShowRule = new GPTShowRule();
                gptShowRule.setEntityId(rules[0].getId());
                gptShowRule.setRuleId(rules[0].getRules().get(0).getId());
                HashMap<String, String> customParams = new HashMap<String, String>(16);
                customParams.put("ruleid", IFrameUtil.toBase64(gptShowRule));
                customParams.put("designerpageid", pageId);
                FormConfig formConfig = FormMetadataCache.getFormConfig((String)"bos_devnp_disprule");
                LocaleString lheight = formConfig.getHeight();
                int height = 80;
                if (lheight != null) {
                    String sheight = lheight.toString().replace("px", "").replace("%", "");
                    height = Integer.parseInt(sheight);
                }
                result.put("ruleurl", IFrameUtil.buildUrl(height, "bos_devnp_disprule", customParams));
                excuteAction = true;
            } else if (action.equals(SHOW_RULES)) {
                String s = params.get("ruleid");
                ProFormDesignerPlugin.sendRuleDesignMetaStatic(formView, this.getDesignerContent(formView), "businessrules_new", "entitymeta", 1, GPTMockUtil.parseObject(s));
                excuteAction = true;
            } else if (action.equals(MODIFYBACKCOLOR) || action.equals("MODIFYPROPERTY")) {
                this.doModifyProperty(params.get("input"), formView);
                excuteAction = true;
            }
            if (!excuteAction) return null;
            List actionResult = formView.getActionResult();
            result.put("actionresult", SerializationUtils.toJsonString((Object)actionResult));
            return result;
        }
        catch (Exception ex) {
            if (!action.equals("CREATE_BILL")) throw ex;
            IFrameUtil.stopOcrAnimate(formView);
            throw ex;
        }
    }

    private void doModifyProperty(String gptJSON, IFormView formView) {
        Map<String, Object> map = this.getDesignerContent(formView);
        Map formMeta = (Map)map.get("formmeta");
        FormMetadata formMetadata = this.convertToFormMetadata(formMeta);
        JSONObject jsonObject = GPTMockUtil.parseObject(gptJSON);
        String fields = jsonObject.getString("fields");
        if (StringUtils.isBlank((CharSequence)fields)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"GPTDesignerAction_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        HashSet fieldSet = "all".equals(fields) ? Collections.EMPTY_SET : new HashSet(Arrays.stream(fields.split("\\,")).collect(Collectors.toList()));
        GPTFieldPropertyBuilder gptFieldPropertyBuilder = new GPTFieldPropertyBuilder();
        for (ControlAp controlAp : formMetadata.getItems()) {
            if (!(controlAp instanceof FieldAp) || !fieldSet.isEmpty() && !fieldSet.contains(controlAp.getKey())) continue;
            gptFieldPropertyBuilder.getFieldIdList().add((FieldAp)controlAp);
        }
        if (gptFieldPropertyBuilder.getFieldIdList().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u6b63\u786e\u7684\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"GPTDesignerAction_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        if (!gptFieldPropertyBuilder.parseProperty(jsonObject)) {
            String errorInfo = gptFieldPropertyBuilder.getErrorInfo();
            throw new KDBizException(errorInfo);
        }
        gptFieldPropertyBuilder.build((FormDesigner)formView.getControl(this.getDesignerKey()));
    }

    private FormMetadata convertToFormMetadata(Map<String, Object> content) {
        return (FormMetadata)new FormMetadataConverter().convertTo(content);
    }

    private EntityMetadata convertToEntityMetadata(Map<String, Object> content) {
        MetadataSerializer serializer = new MetadataSerializer(String.valueOf(content.get("ModelType")));
        DomainModelBinder binder = (DomainModelBinder)serializer.getBinder();
        binder.setLCId("zh_CN");
        binder.setWriteInheritFlag(true);
        binder.setSerializeDefaultValue(true);
        EntityMetadata entityMetadata = (EntityMetadata)serializer.deserializeFromMap(content, null);
        List items = (List)content.get("Items");
        for (Map it : items) {
            if (entityMetadata.getRootEntity().getId().equals(it.get("Id").toString())) continue;
            EntityItem entityItem = entityMetadata.getItemById(it.get("Id").toString());
            entityItem.setInherit(Boolean.parseBoolean(String.valueOf(it.get("Inherit"))));
        }
        return entityMetadata;
    }

    private void createBillFormByOCR(IFormView formView, String bizAppId, JSONObject ocrResult) {
        FormMetadataBuilder formMetadataBuilder = new FormMetadataBuilder(bizAppId, ocrResult);
        formView.getPageCache().put("originMetadata", SerializationUtils.toJsonString(formMetadataBuilder.getBlankDesignMeta()));
        Map<String, Object> designerMetadata = formMetadataBuilder.getFormDesignMeta();
        designerMetadata.put("subSystem", 1);
        designerMetadata.put("isv", ISVService.getISVInfo().getId());
        designerMetadata.put("appNum", AppReader.getAppNumberById((String)bizAppId));
        designerMetadata.put("bizappid", bizAppId);
        String modelType = "BillFormModel";
        ArrayList prodesignerData = new ArrayList();
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put("id", "formmeta");
        Object formName = designerMetadata.get("caption");
        formData.put("name", String.valueOf(formName));
        formData.put("isPC", Boolean.TRUE);
        formData.put("data", designerMetadata);
        formData.put("type", ResManager.loadKDString((String)"\u8868\u5355", (String)"GPTDesignerAction_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        prodesignerData.add(formData);
        HashMap<String, Object> allMetaViewData = new HashMap<String, Object>(3);
        allMetaViewData.put("formmeta", designerMetadata);
        if (StringUtils.equalsIgnoreCase((CharSequence)"BillFormModel", (CharSequence)modelType) || StringUtils.equalsIgnoreCase((CharSequence)"BaseFormModel", (CharSequence)modelType)) {
            Map<String, Object> listViewMeta = this.openSubDesigner(formView, designerMetadata, LIST_META);
            HashMap<String, Object> listData = new HashMap<String, Object>();
            listData.put("id", "listmeta");
            listData.put("name", String.valueOf(formName));
            listData.put("isPC", Boolean.TRUE);
            listData.put("data", listViewMeta);
            listData.put("type", ResManager.loadKDString((String)"\u5217\u8868", (String)"GPTDesignerAction_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            prodesignerData.add(listData);
            allMetaViewData.put("listmeta", listViewMeta.get("formmeta"));
        }
        this.cacheProDesignerContent(formView, allMetaViewData);
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getDesignerKey(), "open", new Object[]{modelType, Boolean.TRUE, prodesignerData});
        formView.executeClientCommand("setCaption", new Object[]{(String)designerMetadata.get("caption")});
        String cacheKey = String.format("%s_%s", "formmeta", "latestEntityVersion");
        formView.getPageCache().put(cacheKey, String.valueOf(this.getLatestEntityVersion(formView)));
        cacheKey = String.format("%s_%s", "listmeta", "latestEntityVersion");
        formView.getPageCache().put(cacheKey, String.valueOf(this.getLatestEntityVersion(formView)));
        formView.getPageCache().put("gptcreatebill", "true");
        this.reloadBaseInfo(formView);
    }

    private Map<String, Object> getDesignerContent(IFormView formView) {
        String cacheAllMetadata = formView.getPageCache().get(CACHE_KEY_ALLMETADATA);
        return (Map)SerializationUtils.fromJsonString((String)cacheAllMetadata, Map.class);
    }

    private long getLatestEntityVersion(IFormView formView) {
        String entityId = formView.getPageCache().get("entityId");
        DesignEntityMeta data = (DesignEntityMeta)BusinessDataReader.read((Object)entityId, (IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMeta.class), (Boolean)Boolean.TRUE);
        return data.getVersion();
    }

    private void reloadBaseInfo(IFormView formView) {
        String json = formView.getPageCache().get("proformdesigner.designerbar.page");
        Map tabPageMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        for (Map.Entry it : tabPageMap.entrySet()) {
            IFormView subView;
            if (!this.isBaseInfoTab((String)it.getKey()) || !StringUtils.isNotBlank((CharSequence)((CharSequence)it.getValue())) || (subView = formView.getView((String)it.getValue())) == null) continue;
            IFormController formController = (IFormController)subView.getService(IFormController.class);
            formController.loadData();
            formView.sendFormAction(subView);
        }
    }

    private boolean isBaseInfoTab(String tabId) {
        return StringUtils.startsWith((CharSequence)tabId, (CharSequence)"baseinfo_");
    }

    private void cacheProDesignerContent(IFormView formView, Map<String, Object> proContent) {
        if (proContent != null) {
            formView.getPageCache().put(CURRENT_METADATA, SerializationUtils.toJsonString((Object)proContent.get("formmeta")));
            formView.getPageCache().put(CACHE_KEY_ALLMETADATA, SerializationUtils.toJsonString(proContent));
        }
    }

    private Map<String, Object> openSubDesigner(IFormView formView, Map<String, Object> content, String subDesignerName) {
        return ProFormDesignerPlugin.openSubDesignerStatic(formView, content, subDesignerName);
    }

    private String getDesignerKey() {
        return "proformdesigner";
    }
}

