/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.FormDesigner;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;

class GPTFieldPropertyBuilder {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final Log logger = LogFactory.getLog(GPTFieldPropertyBuilder.class);
    private final List<FieldAp> fieldIdList = new ArrayList<FieldAp>(16);
    private Object value;
    private String propName;
    private String errorInfo;

    GPTFieldPropertyBuilder() {
    }

    public Object getValue() {
        return this.value;
    }

    public String getPropName() {
        return this.propName;
    }

    public List<FieldAp> getFieldIdList() {
        return this.fieldIdList;
    }

    public boolean parseProperty(JSONObject jsonObject) {
        String value = jsonObject.getString("fieldbackcolor");
        boolean result = false;
        if (value != null) {
            this.value = value;
            this.propName = "BackColor";
            result = true;
        }
        if ((value = jsonObject.getString("fieldtextcolor")) != null) {
            this.value = value;
            this.propName = "ForeColor";
            result = true;
        }
        if ((value = jsonObject.getString("fieldforecolor")) != null) {
            this.value = value;
            this.propName = "ForeColor";
            result = true;
        }
        if ((value = jsonObject.getString("fontsize")) != null) {
            if (StringUtils.isNotBlank((CharSequence)(value = (String)this.normalValue(value)))) {
                try {
                    this.value = Integer.valueOf(value);
                }
                catch (NumberFormatException ignore) {
                    logger.warn("error integer value {}", (Object)value);
                    this.errorInfo = ResManager.loadKDString((String)"\u5b57\u4f53\u503c\u5e94\u4e3a\u6574\u6570\u503c\u3002", (String)"GPTFieldPropertyBuilder_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    return false;
                }
            } else {
                this.value = value;
            }
            this.propName = "FontSize";
            result = true;
        }
        if ((value = jsonObject.getString("fontweight")) != null) {
            this.value = value;
            this.propName = "FontWeight";
            result = true;
        }
        this.value = this.normalValue(this.value);
        return result;
    }

    private Object normalValue(Object value) {
        if ("default".equalsIgnoreCase(value.toString())) {
            return "";
        }
        return value;
    }

    public void build(FormDesigner formDesigner) {
        for (FieldAp fieldAp : this.fieldIdList) {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("itemId", fieldAp.getId());
            param.put("propertyName", this.normalizeProp(fieldAp, this.propName));
            param.put("metaType", "formmeta");
            param.put("value", this.value);
            formDesigner.setProperty(param);
        }
    }

    private String normalizeProp(FieldAp fieldAp, String propName) {
        if ("BackColor".equals(propName)) {
            return fieldAp instanceof EntryFieldAp ? "BackColor" : "FieldBackColor";
        }
        return propName;
    }

    public String getErrorInfo() {
        if (StringUtils.isBlank((CharSequence)this.errorInfo)) {
            return ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5c5e\u6027\u4fe1\u606f\u3002", (String)"GPTFieldPropertyBuilder_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        }
        return this.errorInfo;
    }
}

