/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.ProFormDesigner;
import kd.bos.form.control.events.DesignerBarAction;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.newdevportal.form.designer.ProFormDesignerPlugin;
import kd.bos.newdevportal.gpt.GPTAssistFormUtil;
import kd.bos.newdevportal.gpt.GPTDesignerAction;

public class GPTFormDesignerPlugin
extends AbstractFormPlugin
implements DesignerBarListener {
    public static final String SHOWGPTFORMS = "showgptforms";
    public static final String SHOWGPTFORMSTRUE = "showgptformstrue";
    public static final String SHOWPROCESSLIST = "showprocesslist";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProFormDesigner designer = (ProFormDesigner)this.getView().getControl(this.getDesignerKey());
        designer.addBarListener((DesignerBarListener)this);
        this.addClickListeners(new String[]{"btncreaterule", "openbizrule"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isStartSkill()) {
            this.getView().addClientCallBack(SHOWGPTFORMS, Integer.valueOf(100));
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            String animatetype = (String)this.getView().getFormShowParameter().getCustomParam("animatetype");
            if (animatetype != null) {
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), animatetype, new Object[]{Boolean.TRUE});
            }
        }
    }

    private boolean isStartSkill() {
        String gptskill = (String)this.getView().getFormShowParameter().getCustomParam("gptskill");
        return StringUtils.isNotBlank((CharSequence)gptskill);
    }

    private String getStartSkillNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("gptskill");
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (SHOWGPTFORMS.equals(e.getName())) {
            this.getView().addClientCallBack(SHOWGPTFORMSTRUE, Integer.valueOf(100));
        }
        if (SHOWGPTFORMSTRUE.equals(e.getName())) {
            HashMap<String, Object> mapCustom = new HashMap<String, Object>(16);
            boolean switchSide = false;
            if (this.isStartSkill()) {
                mapCustom.put("imageUrl", this.getView().getFormShowParameter().getCustomParam("gptpicurl"));
                mapCustom.put("processNumber", this.getStartSkillNumber());
                mapCustom.put("billInfo", this.getView().getFormShowParameter().getCustomParam("gptbillinfo"));
                mapCustom.put("lockSide", Boolean.TRUE);
                switchSide = true;
            }
            GPTAssistFormUtil.showAssistForm(this.getView(), mapCustom, switchSide);
            if (!this.isStartSkill()) {
                this.getView().addClientCallBack(SHOWPROCESSLIST, Integer.valueOf(1000));
            }
        }
        if (SHOWPROCESSLIST.equals(e.getName())) {
            GPTAssistFormUtil.showProcessList(this.getView().getPageId());
        }
    }

    private String getDesignerKey() {
        return "proformdesigner";
    }

    public void designerBarClick(DesignerBarEvent e) {
        if (DesignerBarAction.Click == e.getActionId()) {
            switch (e.getBarItemKey().toLowerCase(Locale.ENGLISH)) {
                case "gpt": {
                    GPTAssistFormUtil.switchAssistForm(this.getView());
                    break;
                }
                case "gotokde": {
                    GPTAssistFormUtil.switchAssistForm(this.getView(), false);
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        if (ctl.getKey().equals("btncreaterule")) {
            GPTDesignerAction gptDesignerAction = new GPTDesignerAction();
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("input", (String)this.getModel().getValue("rule"));
            Map<String, String> result = gptDesignerAction.invokeAction(this.getView().getPageId(), "CREATE_BILL_RULE", params);
            String actionresult = result.get("actionresult");
            List acts = SerializationUtils.fromJsonStringToList((String)actionresult, Object.class);
            this.sendFormAction(this.getView().getPageId(), acts);
        } else if (ctl.getKey().equals("openbizrule")) {
            Map<String, Object> content = this.getDesignerContent(this.getView());
            ProFormDesignerPlugin.sendRuleDesignMetaStatic(this.getView(), content, "businessrules_new", "entitymeta", 1, null);
        }
    }

    private void sendFormAction(String pageId, List<Object> acts) {
        HashMap<String, Object> arg = new HashMap<String, Object>(3);
        arg.put("pageId", pageId);
        arg.put("actions", acts);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("sendDynamicFormAction", arg);
    }

    private Map<String, Object> getDesignerContent(IFormView formView) {
        String cacheAllMetadata = formView.getPageCache().get("cache_all_metadata");
        return (Map)SerializationUtils.fromJsonString((String)cacheAllMetadata, Map.class);
    }
}

