/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.newdevportal.util.ImageUtil;
import kd.bos.servicehelper.DispatchServiceHelper;

public class GPTOCRAction
implements IGPTAction {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final Log logger = LogFactory.getLog(GPTOCRAction.class);
    private static final String ocrAction = "bill_ocr";
    private static final String business_object = "gai_operation";

    public Map<String, String> invokeAction(String action, Map<String, String> fileInfo) {
        logger.info(String.format("bill_ocr,\u5f53\u524d\u9884\u7f6e\u64cd\u4f5c\uff1a%s", action));
        if (ocrAction.equalsIgnoreCase(action)) {
            String billKeyWords = ResManager.loadKDString((String)"\u5355", (String)"GPTOCRAction_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            String unTitleBill = ResManager.loadKDString((String)"\u672a\u547d\u540d\u5355", (String)"GPTOCRAction_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            HashMap<String, String> ocrResult = new HashMap<String, String>(1);
            String templateNumber = "OPM-GeneralTablePreset";
            String filePath = fileInfo.get("file_path");
            String imageData = ImageUtil.getImageBase64(filePath);
            String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])new Object[]{business_object, templateNumber, imageData});
            OcrResult result = (OcrResult)SerializationUtils.fromJsonString((String)resultStr, OcrResult.class);
            int errCode = result.getErrorCode();
            if (0 != errCode) {
                throw new KDBizException(result.getDescription());
            }
            Map datas = (Map)((List)result.getData()).get(0);
            List pageDatas = (List)datas.get("pageData");
            StringBuilder title = new StringBuilder(ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0:", (String)"GPTOCRAction_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            StringBuilder header = new StringBuilder(ResManager.loadKDString((String)"\u8868\u5934\u4fe1\u606f:", (String)"GPTOCRAction_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            StringBuilder entry = new StringBuilder(ResManager.loadKDString((String)"\u8868\u4f53\u4fe1\u606f:", (String)"GPTOCRAction_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            StringBuilder all = new StringBuilder();
            boolean existEntry = false;
            for (Map pageData : pageDatas) {
                String text;
                String objectType = (String)pageData.get("objectType");
                if (!existEntry && "table with line".equals(objectType)) {
                    ArrayList cells = (ArrayList)pageData.get("cells");
                    for (LinkedHashMap cell : cells) {
                        String text2 = (String)cell.get("combinedText");
                        Integer row = (Integer)cell.get("startRows");
                        if (row == null || row >= 2 || !StringUtils.isNotBlank((CharSequence)text2)) continue;
                        entry.append(text2).append(',');
                        existEntry = true;
                    }
                    if (existEntry) {
                        entry.deleteCharAt(entry.length() - 1);
                    }
                }
                if (!"plain text".equals(objectType) || !StringUtils.isNotBlank((CharSequence)(text = (String)pageData.get("combinedText")))) continue;
                all.append(text);
            }
            if (all.length() > 0) {
                int i;
                String[] allText = all.toString().split("\\n");
                int index = -1;
                for (i = 0; i < allText.length; ++i) {
                    if (!allText[i].endsWith(billKeyWords)) continue;
                    title.append(allText[i]);
                    index = i;
                    break;
                }
                if (index == -1) {
                    title.append(unTitleBill);
                }
                for (i = 0; i < allText.length; ++i) {
                    if (i == index) continue;
                    header.append(allText[i]).append(',');
                }
                if (allText.length > 1 || index == -1 && allText.length > 0) {
                    header.deleteCharAt(header.length() - 1);
                } else {
                    header = new StringBuilder();
                }
            } else {
                title.append(unTitleBill);
                header = new StringBuilder();
            }
            ocrResult.put("bill_info", title.append('\n').append((CharSequence)header).append('\n').append((CharSequence)entry).toString());
            ocrResult.put("status", ResManager.loadKDString((String)"\u8bc6\u522b\u5b8c\u6210", (String)"GPTOCRAction_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return ocrResult;
        }
        return null;
    }

    static class OcrResult {
        private String requestId;
        private int errorCode;
        private String description;
        private Object data;

        OcrResult() {
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

