/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.newdevportal.gpt.GPTMockUtil;
import kd.bos.newdevportal.gpt.IFrameUtil;

public class GPTShowResultAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(GPTShowResultAction.class);

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        String pageId = params.get("PAGE_ID");
        HashMap<String, String> result = new HashMap<String, String>(16);
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        String debugJson = System.getProperty("debug_json");
        if (StringUtils.isNotBlank((CharSequence)debugJson)) {
            params.put("jsonresult", debugJson);
        }
        String jsonResult = params.get("jsonresult");
        StringBuilder logInfo = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)jsonResult)) {
            logInfo.append("jsonresult is null");
        }
        jsonResult = GPTMockUtil.fixJsonKey(jsonResult);
        logInfo.append(String.format(" GPT recognition result:%s", jsonResult));
        logger.info(logInfo.toString());
        pageCache.put("gptjsonresult", jsonResult);
        pageCache.saveChanges();
        JSONObject billJson = GPTMockUtil.parseObject(jsonResult);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("designerpageid", pageId);
        JSONArray entry = billJson.getJSONArray("entry");
        JSONArray header = billJson.getJSONArray("header");
        int i = Math.min(entry.size(), 10) + Math.min(header.size(), 10);
        int height = i * 39 + 272;
        result.put("actionresult", IFrameUtil.buildUrl(height, "bos_devpn_dispgptresult", map));
        return result;
    }
}

