/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.url.UrlService;

public class IFrameUtil {
    public static String buildUrl(int height, String formId, Map<String, String> customParams) {
        int width = 350;
        HashMap<String, Integer> mapSize = new HashMap<String, Integer>();
        mapSize.put("width", width);
        mapSize.put("height", height);
        mapSize.put("padding", 0);
        try {
            String domainContextUrl = UrlService.getDomainContextUrl();
            if (!domainContextUrl.endsWith("/")) {
                domainContextUrl = domainContextUrl + "/";
            }
            return domainContextUrl + "?" + URLEncoder.encode("formId=" + formId + "&customParams=" + SerializationUtils.toJsonString(customParams) + "&gaiIframeSize=" + SerializationUtils.toJsonString(mapSize), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendFormActionByWS(String pageId, List<Object> acts) {
        PushMessage message = new PushMessage(PushMessageRange.RootPage, pageId, (Object)JSON.toJSONString(acts));
        PushServiceHelper.push((PushMessage)message);
    }

    public static void stopOcrAnimate(IFormView formView) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("proformdesigner", "setOcrAnimateVisible", new Object[]{false});
        clientViewProxy.invokeControlMethod("proformdesigner", "setSkeletonScreenVisible", new Object[]{false});
    }

    public static String toBase64(Object o) {
        return Base64.getUrlEncoder().encodeToString(SerializationUtils.toJsonString((Object)o).getBytes(StandardCharsets.UTF_8));
    }

    public static String fromBase64(String o) {
        return new String(Base64.getUrlDecoder().decode(o.getBytes(StandardCharsets.UTF_8)));
    }
}

