/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.home;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.newdevportal.home.BoardCardData;
import kd.bos.newdevportal.home.index.ChanelLevelUtil;
import kd.bos.newdevportal.util.NotificationUtils;
import kd.bos.url.UrlService;

public class CommonProblemCardPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void afterCreateNewData(EventObject e) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        List<BoardCardData> data = this.getData();
        this.getModel().batchCreateNewEntryRow("entryentity", data.size());
        String domainUrl = UrlService.getDomainContextUrl();
        for (int i = 0; i < data.size(); ++i) {
            String url = domainUrl + data.get(i).getLink();
            ((DynamicObject)entryentity.get(i)).set("imageap", (Object)url);
            ((DynamicObject)entryentity.get(i)).set("textfield", (Object)data.get(i).getContent());
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void entryRowClick(RowClickEvent evt) {
        if (NotificationUtils.isTobeContinued) {
            NotificationUtils.showToBeContinuedNotification(this.getView());
            return;
        }
        int row = evt.getRow();
        List<BoardCardData> data = this.getData();
        String link = data.get(row).getLink();
        if (StringUtils.isNotBlank((CharSequence)link)) {
            link = ChanelLevelUtil.format(link);
            this.getView().openUrl(link);
        }
    }

    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnmore"});
    }

    public void click(EventObject evt) {
        if (NotificationUtils.isTobeContinued) {
            NotificationUtils.showToBeContinuedNotification(this.getView());
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if ("btnmore".equals(key)) {
            this.showMore();
        }
    }

    private void showMore() {
        this.getView().openUrl(ChanelLevelUtil.format("https://vip.kingdee.com/knowledge?productLineId=29&productCategory=C05&productId=3&domain=DEV&module=devportal&labels=HotIssues#tabMain", "&"));
    }

    private List<BoardCardData> getData() {
        ArrayList<BoardCardData> data = new ArrayList<BoardCardData>(10);
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u4e91FAQ\u603b\u7ed3", (String)"CommonProblemCardPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/228461585390666496"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u5143\u6570\u636e\u95ee\u9898FAQ\u6c47\u603b", (String)"CommonProblemCardPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/231437297898821120"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"BOTP\u5355\u636e\u5173\u8054\u914d\u7f6e", (String)"CommonProblemCardPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/241154993057440512"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u4e8c\u5f00\u5b89\u88c5\u5305\u5236\u4f5c", (String)"CommonProblemCardPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://club.kdcloud.com/article/43334364500131840"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u5217\u8868F7\u6570\u636e\u8fc7\u6ee4\u95ee\u9898\u6392\u67e5\u65b9\u6848", (String)"CommonProblemCardPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/218296792725426432"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u62a5\u8868\u52a8\u6001\u589e\u51cf\u5217", (String)"CommonProblemCardPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/130023762799890432"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u663e\u793a\u5c5e\u6027\u52a8\u6001\u6269\u5c55", (String)"CommonProblemCardPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/165851926159292160"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u52a8\u6001\u4fee\u6539\u57fa\u7840\u8d44\u6599F7\u6a21\u677f", (String)"CommonProblemCardPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/159756445859256064"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u7f51\u7edc\u4e92\u65a5", (String)"CommonProblemCardPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/165500593120081664"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u5217\u8868\u529f\u80fd\u4ecb\u7ecd\u4e0e\u5f00\u53d1\u76f8\u5173\u6c47\u603b", (String)"CommonProblemCardPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "https://vip.kingdee.com/article/325292858402481664"));
        return data;
    }
}

