/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.home;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.isv.IsvParamCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.IFormController;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;

public class HomePlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static Log logger = LogFactory.getLog(HomePlugin.class);
    private static final String Key_Search = "searchap";
    private static final String TABAP = "tabap";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String SEARCHPAGEID = "searchpageid";

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        formShowParameter.setCustomParam("appid", (Object)"devnew");
        if (StringUtils.isBlank((CharSequence)formShowParameter.getAppId())) {
            formShowParameter.setAppId("devnew");
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u5f00\u53d1\u5e73\u53f0", (String)"BizAppListPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        boolean hasPermission = DevpPermissionUtils.hasBizAppViewPermission(null, "47150e89000000ac");
        if (!hasPermission) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u4e1a\u52a1\u5e94\u7528\u5217\u8868\u201d\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u67e5\u8be2\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"HomePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        String isv = "";
        try {
            IsvParamCache.setIsvParam((boolean)true);
            isv = ISVService.getISVInfo().getId();
            if (StringUtils.isBlank((CharSequence)isv)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u7684\u5f00\u53d1\u5546\u6807\u8bc6\uff0c\u8bf7\u5148\u5b8c\u6210\u5f00\u53d1\u5546\u8d44\u8d28\u8ba4\u8bc1\u3002", (String)"HomePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            }
        }
        catch (KDException kde) {
            logger.error((Throwable)kde);
            IsvParamCache.remove();
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u5f00\u53d1\u5546\u8d44\u8d28\u6587\u4ef6\u3002", (String)"MainPlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), kde.getMessage()));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String isv;
        this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u5f00\u53d1\u5e73\u53f0", (String)"BizAppListPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])});
        long userId = RequestContext.get().getCurrUserId();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        this.showUserInfo(userId, proxy);
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showMessage(msg);
        }
        if (StringUtils.isNotBlank((CharSequence)(isv = AppUtils.getDeveloperInfo())) && !isv.equals(isv.toLowerCase(Locale.ENGLISH))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f00\u53d1\u5546\u6807\u8bc6\u5fc5\u987b\u4e3a\u5c0f\u5199\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539?", (String)"MainPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("openisvform_confirmcallback"));
        }
        this.getView().addClientCallBack("gptInfo", Integer.valueOf(1000));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (Objects.equals("gptInfo", e.getName())) {
            this.showGPTPage();
        }
    }

    private void showGPTPage() {
        try {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_chat_ai_customcontrol");
            fsp.setCustomParam("slideEnv", (Object)"BOS");
            fsp.getOpenStyle().setTargetKey("gpt_gai_panel");
            fsp.getOpenStyle().setShowType(ShowType.InContainer);
            this.getView().showForm(fsp);
        }
        catch (Exception e) {
            logger.warn(" showGPTPage error" + e.getMessage(), (Throwable)e);
        }
    }

    public void registerListener(EventObject e) {
        Search search = (Search)this.getControl(Key_Search);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"switch2old"});
        Button logo = (Button)this.getControl("imageap1");
        if (logo != null) {
            logo.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "switch2old": {
                this.switch2old();
                break;
            }
            case "imageap1": {
                this.openMainPage();
                break;
            }
        }
    }

    private void switch2old() {
        this.getView().openUrl(UrlService.getDomainContextUrl() + "?formId=pc_devportal_main");
    }

    private void openMainPage() {
        this.getView().openUrl("index.html");
    }

    private void showUserInfo(long userId, IClientViewProxy proxy) {
        IImage icon = (IImage)this.getControl("usericon1");
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)true);
        String imgURL = (String)userAvatarPathMap.get(userId);
        if (StringUtils.isBlank((CharSequence)imgURL)) {
            icon.setUrl("/images/pc/emotion/default_person_82_82.png");
        } else {
            icon.setUrl(imgURL);
        }
    }

    public void search(SearchEnterEvent arg0) {
        List searchFields = arg0.getSearchFields();
        this.openSearchWindow(arg0.getText(), searchFields);
    }

    public void openSearchWindow(String text, List<Map<String, Object>> searchFields) {
        boolean isHasPermisson = DevpPermissionUtils.hasBizAppViewPermission(null, "47150e89000000ac");
        if (!isHasPermisson) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5f00\u53d1\u8005\u95e8\u6237\u9996\u9875\u201d\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u67e5\u8be2\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.getPageCache().get(SEARCHPAGEID) == null) {
            String selectPageId = UUID.randomUUID().toString();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devpn_search");
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setCaption(ResManager.loadKDString((String)"\u641c\u7d22\u7ed3\u679c", (String)"MainPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "searchCloseCallBack"));
            parameter.setPageId(selectPageId);
            parameter.setCustomParam("searchtext", (Object)text);
            parameter.setCustomParam("searchFields", searchFields);
            parameter.setCustomParam("createNewData", (Object)"true");
            this.getView().showForm(parameter);
            this.getPageCache().put(SEARCHPAGEID, selectPageId);
        } else {
            String searchPageId = this.getPageCache().get(SEARCHPAGEID);
            IFormView searchView = this.getView().getView(searchPageId);
            if (this.hasSearchValue(searchFields) && searchView != null) {
                FormShowParameter parameter = this.getView().getView(searchPageId).getFormShowParameter();
                parameter.setCustomParam("searchtext", (Object)text);
                parameter.setCustomParam("searchFields", searchFields);
                parameter.setCustomParam("createNewData", (Object)"false");
                searchView.cacheFormShowParameter();
                searchView.activate();
                FormController formController = (FormController)this.getView().getView(searchPageId).getService(IFormController.class);
                formController.loadData();
                this.getView().sendFormAction(searchView);
            }
        }
    }

    private boolean hasSearchValue(List<Map<String, Object>> searchFields) {
        if (searchFields == null || searchFields.isEmpty()) {
            return false;
        }
        for (Map<String, Object> map : searchFields) {
            List valueList = (List)map.get("value");
            if (valueList == null) continue;
            HashSet values = new HashSet(10);
            values.addAll(valueList.stream().filter(val -> StringUtils.isNotBlank((CharSequence)val)).collect(Collectors.toSet()));
            if (values.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("searchCloseCallBack".equals(e.getActionId())) {
            this.getPageCache().remove(SEARCHPAGEID);
        }
    }
}

