/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.home;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.newdevportal.home.BoardCardData;
import kd.bos.newdevportal.util.NotificationUtils;
import kd.bos.url.UrlService;

public class IntroductionPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void afterCreateNewData(EventObject e) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        List<BoardCardData> data = this.getData();
        this.getModel().batchCreateNewEntryRow("entryentity", data.size());
        for (int i = 0; i < data.size(); ++i) {
            ((DynamicObject)entryentity.get(i)).set("textfield_title", (Object)data.get(i).getTitle());
            ((DynamicObject)entryentity.get(i)).set("textfield_content", (Object)data.get(i).getContent());
            ((DynamicObject)entryentity.get(i)).set("imageap", (Object)this.getImagePrefixUrl(data.get(i).getImage()));
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void entryRowClick(RowClickEvent evt) {
        if (NotificationUtils.isTobeContinued) {
            NotificationUtils.showToBeContinuedNotification(this.getView());
            return;
        }
        int row = evt.getRow();
        List<BoardCardData> data = this.getData();
        String link = data.get(row).getLink();
        if (StringUtils.isNotBlank((CharSequence)link)) {
            this.getView().openUrl(link);
        }
    }

    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnmore"});
    }

    public void click(EventObject evt) {
        if (NotificationUtils.isTobeContinued) {
            NotificationUtils.showToBeContinuedNotification(this.getView());
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if ("btnmore".equals(key)) {
            this.showMore();
        }
    }

    private void showMore() {
        this.getView().openUrl("https://vip.kingdee.com");
    }

    private List<BoardCardData> getData() {
        ArrayList<BoardCardData> data = new ArrayList<BoardCardData>(10);
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u5355\u636e\u5f00\u53d1", (String)"IntroductionPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5305\u62ec\u5e94\u7528\u7684\u521b\u5efa\u4ee5\u53ca\u5355\u636e\u3001\u57fa\u7840\u6570\u636e\u7b49\u6807\u51c6\u6a21\u578b\u9875\u9762\u7684\u914d\u7f6e", (String)"IntroductionPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "", "private/bos/devplat/devplugin.png"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u8868\u5355\u5f00\u53d1", (String)"IntroductionPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5305\u62ec\u52a8\u6001\u8868\u5355\u3001\u5361\u7247\u3001\u79fb\u52a8\u9875\u9762\u7b49\u590d\u6742\u9875\u9762\u7684\u5f00\u53d1", (String)"IntroductionPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "", "private/bos/devplat/bos_form_50_50.png"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u63d2\u4ef6\u5f00\u53d1", (String)"IntroductionPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u5e73\u53f0\u5404\u7c7b\u63d2\u4ef6\u5f00\u53d1\u7684\u76f8\u5173\u4ecb\u7ecd", (String)"IntroductionPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "", "private/bos/devplat/bos_plugin_50_50.png"));
        data.add(new BoardCardData(ResManager.loadKDString((String)"\u90e8\u7f72\u4e0e\u53d1\u5e03", (String)"IntroductionPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5305\u62ec\u5e94\u7528\u3001\u5355\u636e\u3001\u9875\u9762\u3001\u63d2\u4ef6\u7684\u5bfc\u51fa\u4ee5\u53ca\u90e8\u7f72\u673a\u5236\u4ecb\u7ecd", (String)"IntroductionPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "", "private/bos/devplat/bos_server_50_50.png"));
        return data;
    }

    private String getImagePrefixUrl(String imageUrl) {
        if (kd.bos.util.StringUtils.isBlank((String)imageUrl)) {
            return "";
        }
        String prefix = UrlService.getDomainContextUrl();
        int count = 0;
        if ('/' == prefix.charAt(prefix.length() - 1)) {
            ++count;
        }
        if ('/' == imageUrl.charAt(0)) {
            ++count;
        }
        if (count == 0) {
            return prefix + "/" + imageUrl;
        }
        if (count == 2) {
            return prefix + imageUrl.substring(1);
        }
        return prefix + imageUrl;
    }
}

