/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.home.index;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.MyAppUtils;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.url.UrlService;

public class AbstractDevportalListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String KEY_NUMBER = "number";
    private static final String MODELTYPE = "modeltype";
    protected static final String Key_AppEntryEntity = "appentryentity";
    protected static final String Key_PageEntryEntity = "pageentryentity";
    protected static final String Key_LayOutEntryEntity = "layoutentryentity";
    protected static final String Key_ObjectEntryEntity = "bizobjectentryentity";
    protected static final String Key_ReportEntryEntity = "reportentryentity";
    protected static final String Key_ParameterEntryEntity = "parameterentryentity";
    private static final String ENTITY_ID_KEY = "entityId";
    protected static final String Key_ID = "id";
    private static final String Key_AppImage = "appimage";
    private static final String Key_AppName = "appname";
    private static final String Key_BizAppId = "bizappid";
    protected static final String KEY_DESCRIPTION = "description";
    private static final String Key_ObjectId = "objectid";
    private static final String Key_ObjectTitle = "objecttitle";
    private static final String Key_ObjectNumber = "objectnumber";
    private static final String Key_ObjectBizApp = "objectbizapp";
    private static final String Key_ObjectBizAppId = "objectbizappid";
    private static final String Key_ObjectBizUnit = "objectbizunitname";
    private static final String Key_ObjectBizUnitId = "objectbizunit";
    private static final String Key_PagetId = "pageid";
    private static final String Key_PageTitle = "pagetitle";
    private static final String Key_PageNumber = "pagenumber";
    private static final String Key_PageBizApp = "pagebizapp";
    private static final String Key_PageBizAppId = "pagebizappid";
    private static final String Key_PageBizUnit = "pagebizunitname";
    private static final String Key_PageBizUnitId = "pagebizunit";
    private static final String Key_LayOutId = "layoutid";
    private static final String Key_LayOutTitle = "layouttitle";
    private static final String Key_LayOutNumber = "layoutnumber";
    private static final String Key_LayOUtBizApp = "layoutbizapp";
    private static final String Key_LayOutBizAppId = "layoutbizappid";
    private static final String Key_LayOutBizUnit = "layoutbizunitname";
    private static final String Key_LayOutBizUnitId = "layoutbizunit";
    private static final String Key_LayOutEntityId = "layoutentityid";
    private static final String Key_ReportId = "reportid";
    private static final String Key_ReportTitle = "reporttitle";
    private static final String Key_ReportNumber = "reportnumber";
    private static final String Key_ReportBizApp = "reportbizapp";
    private static final String Key_ReportBizAppId = "reportbizappid";
    private static final String Key_ReportBizUnit = "reportbizunitname";
    private static final String Key_ReportBizUnitId = "reportbizunit";
    private static final String Key_ParameterId = "parameterid";
    private static final String Key_ParameterTitle = "parametertitle";
    private static final String Key_ParameterNumber = "parameternumber";
    private static final String Key_ParameterBizApp = "parameterbizapp";
    private static final String Key_ParameterBizAppId = "parameterbizappid";
    private static final String Key_ParameterBizUnit = "parameterbizunitname";
    private static final String Key_ParameterBizUnitId = "parameterbizunit";
    private static final String Key_KSId = "ksid";
    private static final String Key_KSNumber = "ksnumber";
    private static final String Key_KSBizAppId = "ksbizappid";
    private static final String Key_KSBizUnitId = "ksbizunitid";
    protected static final String Key_Object = "object";
    protected static final String Key_Layout = "layout";
    protected static final String Key_Page = "page";
    protected static final String Key_Report = "report";
    protected static final String Key_Parameter = "parameter";
    protected static final String Key_Collect_ID = "collectid";
    private static final String Key_App_EntryRow = "appcardentryrow";
    private static final String Key_Object_EntryRow = "objectcardentryrow";
    private static final String Key_Layout_EntryRow = "layoutcardentryrow";
    private static final String Key_Page_EntryRow = "pagecardentryrow";
    private static final String Key_Report_EntryRow = "reportcardentryrow";
    private static final String Key_Param_EntryRow = "paramcardentryrow";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_App_EntryRow, Key_Object_EntryRow, Key_Page_EntryRow, Key_Report_EntryRow, Key_Param_EntryRow, Key_Layout_EntryRow});
        EntryGrid objectGrid = (EntryGrid)this.getControl(Key_ObjectEntryEntity);
        objectGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid pageGrid = (EntryGrid)this.getControl(Key_PageEntryEntity);
        pageGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid reportGrid = (EntryGrid)this.getControl(Key_ReportEntryEntity);
        reportGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid parameterGrid = (EntryGrid)this.getControl(Key_ParameterEntryEntity);
        parameterGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid layoutGrid = (EntryGrid)this.getControl(Key_LayOutEntryEntity);
        layoutGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        int rowIndex = -1;
        switch (key) {
            case "appcardentryrow": {
                rowIndex = this.getView().getModel().getEntryCurrentRowIndex(Key_AppEntryEntity);
                String id = (String)this.getModel().getValue("bizappid", rowIndex);
                this.showAppDetail(id, "", PageType.EntityObject.getValue());
                break;
            }
            case "objectcardentryrow": {
                rowIndex = this.getView().getModel().getEntryCurrentRowIndex(Key_ObjectEntryEntity);
                String id = (String)this.getModel().getValue(Key_ObjectId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.EntityObject.getValue(), this.getView(), id);
                break;
            }
            case "layoutcardentryrow": {
                rowIndex = this.getView().getModel().getEntryCurrentRowIndex(Key_LayOutEntryEntity);
                String id = (String)this.getModel().getValue(Key_LayOutId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), id);
                break;
            }
            case "pagecardentryrow": {
                rowIndex = this.getView().getModel().getEntryCurrentRowIndex(Key_PageEntryEntity);
                String id = (String)this.getModel().getValue(Key_PagetId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), id);
                break;
            }
            case "reportcardentryrow": {
                rowIndex = this.getView().getModel().getEntryCurrentRowIndex(Key_ReportEntryEntity);
                String id = (String)this.getModel().getValue(Key_ReportId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.Report.getValue(), this.getView(), id);
                break;
            }
            case "paramcardentryrow": {
                rowIndex = this.getView().getModel().getEntryCurrentRowIndex(Key_ParameterEntryEntity);
                String id = (String)this.getModel().getValue(Key_ParameterId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.Parameter.getValue(), this.getView(), id);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String fieldKey = evt.getFieldName();
        String id = "";
        String name = "";
        String bizappId = "";
        String bizunitId = "";
        switch (fieldKey) {
            case "objectnumber": {
                id = (String)this.getModel().getValue(Key_ObjectId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.EntityObject.getValue(), this.getView(), id);
                break;
            }
            case "objectbizunitname": {
                id = (String)this.getModel().getValue(Key_ObjectId, rowIndex);
                bizappId = (String)this.getModel().getValue(Key_ObjectBizAppId, rowIndex);
                bizunitId = (String)this.getModel().getValue(Key_ObjectBizUnitId, rowIndex);
                MyAppUtils.showAppDetail(this.getView(), bizappId, bizunitId, id, PageType.EntityObject.getValue());
                break;
            }
            case "pagenumber": {
                id = (String)this.getModel().getValue(Key_PagetId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), id);
                break;
            }
            case "pagebizunitname": {
                id = (String)this.getModel().getValue(Key_PagetId, rowIndex);
                bizappId = (String)this.getModel().getValue(Key_PageBizAppId, rowIndex);
                bizunitId = (String)this.getModel().getValue(Key_PageBizUnitId, rowIndex);
                MyAppUtils.showAppDetail(this.getView(), bizappId, bizunitId, id, PageType.Page.getValue());
                break;
            }
            case "layoutnumber": {
                id = (String)this.getModel().getValue(Key_LayOutId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), id);
                break;
            }
            case "layoutbizunitname": {
                bizappId = (String)this.getModel().getValue(Key_LayOutBizAppId, rowIndex);
                bizunitId = (String)this.getModel().getValue(Key_LayOutBizUnitId, rowIndex);
                String layoutId = (String)this.getModel().getValue(Key_LayOutId, rowIndex);
                MyAppUtils.showAppDetail(this.getView(), bizappId, bizunitId, layoutId, PageType.LayOut.getValue());
                break;
            }
            case "reportnumber": {
                id = (String)this.getModel().getValue(Key_ReportId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.Report.getValue(), this.getView(), id);
                break;
            }
            case "reportbizunitname": {
                id = (String)this.getModel().getValue(Key_ReportId, rowIndex);
                bizappId = (String)this.getModel().getValue(Key_ReportBizAppId, rowIndex);
                bizunitId = (String)this.getModel().getValue(Key_ReportBizUnitId, rowIndex);
                MyAppUtils.showAppDetail(this.getView(), bizappId, bizunitId, id, PageType.Report.getValue());
                break;
            }
            case "parameternumber": {
                id = (String)this.getModel().getValue(Key_ParameterId, rowIndex);
                GotoDesignerUtils.gotoDesigner(PageType.Parameter.getValue(), this.getView(), id);
                break;
            }
            case "parameterbizunitname": {
                id = (String)this.getModel().getValue(Key_ParameterId, rowIndex);
                bizappId = (String)this.getModel().getValue(Key_ParameterBizAppId, rowIndex);
                bizunitId = (String)this.getModel().getValue(Key_ParameterBizUnitId, rowIndex);
                MyAppUtils.showAppDetail(this.getView(), bizappId, bizunitId, id, PageType.Parameter.getValue());
                break;
            }
            case "ksnumber": {
                bizappId = (String)this.getModel().getValue(Key_KSBizAppId, rowIndex);
                bizunitId = (String)this.getModel().getValue(Key_KSBizUnitId, rowIndex);
                String bizPageId = (String)this.getModel().getValue(Key_KSId, rowIndex);
                this.gotoKDE(bizappId, bizunitId, bizPageId);
                break;
            }
            case "objectbizapp": {
                bizappId = (String)this.getModel().getValue(Key_ObjectBizAppId, rowIndex);
                MyAppUtils.showAppList(this.getView(), bizappId);
                break;
            }
            case "pagebizapp": {
                bizappId = (String)this.getModel().getValue(Key_PageBizAppId, rowIndex);
                MyAppUtils.showAppList(this.getView(), bizappId);
                break;
            }
            case "layoutbizapp": {
                bizappId = (String)this.getModel().getValue(Key_LayOutBizAppId, rowIndex);
                MyAppUtils.showAppList(this.getView(), bizappId);
                break;
            }
            case "reportbizapp": {
                bizappId = (String)this.getModel().getValue(Key_ReportBizAppId, rowIndex);
                MyAppUtils.showAppList(this.getView(), bizappId);
                break;
            }
            case "parameterbizapp": {
                bizappId = (String)this.getModel().getValue(Key_ParameterBizAppId, rowIndex);
                MyAppUtils.showAppList(this.getView(), bizappId);
                break;
            }
        }
    }

    private void showAppDetail(String id, String bizunit, String pageType) {
        MyAppUtils.showAppDetail(this.getView(), id, bizunit, pageType);
    }

    private void gotoKDE(String bizAppId, String bizUnitId, String bizPageId) {
        if (StringUtils.isBlank((CharSequence)bizUnitId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u811a\u672c\u6240\u5c5e\u529f\u80fd\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"SearchListPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        AppMetadata appInfo = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        Boolean flag = Boolean.TRUE;
        for (AppFunctionPacketElement funcPacket : appInfo.getAppFunctionPackets()) {
            String unitId = funcPacket.getId();
            if (!bizUnitId.equals(unitId)) continue;
            flag = Boolean.FALSE;
            break;
        }
        if (flag.booleanValue()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u811a\u672c\u6240\u5c5e\u529f\u80fd\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"SearchListPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setFormId("bos_devp_kde");
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam(BIZCLOUDID, (Object)appInfo.getBizCloudID());
        parameter.setCustomParam("bizscriptid", (Object)bizPageId);
        this.getView().showForm(parameter);
    }

    protected void setVisible(int size, String advconap) {
        if (size > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{advconap});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{advconap});
        }
    }

    protected JSONArray getPageDataByType(JSONArray pageData, PageType pageType) {
        JSONArray pageArray = new JSONArray();
        if (pageData == null || pageData.isEmpty()) {
            return pageArray;
        }
        List<String> modelTypes = DevportalModelTypes.getModelTypesByType(pageType.getValue());
        for (int i = 0; i < pageData.size(); ++i) {
            JSONObject pageItem = pageData.getJSONObject(i);
            String modelType = pageItem.getString(MODELTYPE);
            String formId = pageItem.getString("bizpageid");
            String entityId = pageItem.getString("entityid");
            if ("PCLayout".equals(modelType) && PageType.LayOut == pageType) {
                pageArray.add((Object)pageItem);
                continue;
            }
            if (!DevportalModelTypes.isPageTypeMatch(pageType.getValue(), modelTypes, modelType, formId, entityId)) continue;
            pageArray.add((Object)pageItem);
        }
        return pageArray;
    }

    protected void renderApp(JSONArray appItems) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(Key_AppEntryEntity);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(Key_AppEntryEntity);
        if (appItems == null || appItems.isEmpty()) {
            this.getView().updateView(Key_AppEntryEntity);
            return;
        }
        String domainUrl = UrlService.getDomainContextUrl();
        for (int i = 0; i < appItems.size(); ++i) {
            JSONObject appItem = appItems.getJSONObject(i);
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            String image = appItem.getString("image");
            image = StringUtils.isNotBlank((CharSequence)image) && image.startsWith("/") ? domainUrl + image : domainUrl + "/" + image;
            row.set(Key_AppImage, (Object)image);
            row.set(Key_AppName, (Object)appItem.getString("name"));
            row.set("bizappid", (Object)appItem.getString(Key_ID));
            row.set("appnumber", (Object)appItem.getString(KEY_NUMBER));
            row.set(KEY_DESCRIPTION, (Object)appItem.getString(KEY_DESCRIPTION));
            rows.add((Object)row);
        }
        this.getView().updateView(Key_AppEntryEntity);
    }

    protected void renderPage(JSONArray dataItems, String type) {
        this.renderPage(dataItems, type, false);
    }

    protected void renderPage(JSONArray dataItems, String type, boolean isCollect) {
        String entryEntityKey = Key_ObjectEntryEntity;
        switch (type) {
            case "object": {
                break;
            }
            case "layout": {
                entryEntityKey = Key_LayOutEntryEntity;
                break;
            }
            case "page": {
                entryEntityKey = Key_PageEntryEntity;
                break;
            }
            case "report": {
                entryEntityKey = Key_ReportEntryEntity;
                break;
            }
            case "parameter": {
                entryEntityKey = Key_ParameterEntryEntity;
                break;
            }
        }
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryEntityKey);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(entryEntityKey);
        if (dataItems == null || dataItems.isEmpty()) {
            this.setVisible(0, type + "advconap");
            this.getView().updateView(entryEntityKey);
            return;
        }
        String number = type + KEY_NUMBER;
        String title = type + "title";
        String bizappId = type + "bizappid";
        String bizappName = type + "bizapp";
        String bizUnitId = type + "bizunit";
        String bizUnitName = type + "bizunitname";
        String idKey = type + Key_ID;
        String entityIdKey = type + "entityid";
        String collectId = type + Key_Collect_ID;
        for (int i = 0; i < dataItems.size(); ++i) {
            JSONObject item = dataItems.getJSONObject(i);
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(title, (Object)item.getString("name"));
            row.set(number, (Object)item.getString(KEY_NUMBER));
            row.set(bizappId, (Object)item.getString("bizappid"));
            row.set(bizappName, (Object)item.getString("bizappname"));
            row.set(bizUnitId, (Object)item.getString("bizunitid"));
            row.set(bizUnitName, (Object)item.getString("bizunitname"));
            row.set(idKey, (Object)item.getString("bizpageid"));
            row.set(entityIdKey, (Object)item.getString("entityid"));
            if (isCollect) {
                row.set(collectId, item.get((Object)Key_ID));
            }
            rows.add((Object)row);
        }
        this.getView().updateView(entryEntityKey);
        this.setVisible(dataItems.size(), type + "advconap");
    }
}

