/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.home.index;

import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.url.UrlService;

public class CommonToolsPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"metasearch", "metalog", "servicemonitor", "reachmore"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String domainUrl = UrlService.getDomainContextUrl();
        switch (key) {
            case "metasearch": {
                String metaUrl = domainUrl + "/metadata/help.do";
                this.getView().openUrl(metaUrl);
                break;
            }
            case "metalog": {
                this.showMetaLog();
                break;
            }
            case "servicemonitor": {
                String monitorUrl = domainUrl + "/monitor/";
                this.getView().openUrl(monitorUrl);
                break;
            }
            case "reachmore": {
                String devToolsUrl = domainUrl + "?formId=pc_devportal_main&accesstype=home";
                this.getView().openUrl(devToolsUrl);
                break;
            }
        }
    }

    private void showMetaLog() {
        IFormView parentView;
        ListShowParameter sp = new ListShowParameter();
        sp.getOpenStyle().setShowType(ShowType.NewTabPage);
        sp.getOpenStyle().setTargetKey("_submaintab_");
        sp.setBillFormId("meta_log");
        String rootPageId = this.getView().getFormShowParameter().getRootPageId();
        if (StringUtils.isNotBlank((CharSequence)rootPageId) && (parentView = this.getView().getView(rootPageId)) != null) {
            parentView.showForm((FormShowParameter)sp);
            this.getView().sendFormAction(parentView);
            return;
        }
        sp.getOpenStyle().setShowType(ShowType.Modal);
        sp.getOpenStyle().setTargetKey("");
        this.getView().showForm((FormShowParameter)sp);
    }
}

