/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.home.index;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.report.CellStyle;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.MyAppUtils;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.bean.DynamicFormInfo;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MyDevPagecardPlugin
extends AbstractFormPlugin
implements ListboxClickListener,
HyperLinkClickListener {
    private static final String CacheId_PageType = "currpagetype";
    private static final String EntityId_App = "bos_devportal_bizapp";
    private static final String EntityId_Form = "bos_devpn_formmeta";
    private static final String EntityId_Entity = "bos_devpn_entitymeta";
    private static final String EntityId_Cloud = "bos_devportal_bizcloud";
    private static final String EntityId_User = "bos_user";
    private static final String Key_EntryEntity = "entryentity";
    private static final String KEY_BTN_OBJECT = "entityobject";
    private static final String KEY_BTN_PAGE = "page";
    private static final String KEY_BTN_REPORT = "report";
    private static final String KEY_BTN_PARAMETER = "parameter";
    private static final String KEY_BTN_LAYOUT = "layout";
    private static final String KINGDEE = "kingdee";
    private static final int maxCout = 10;
    protected static final String Key_FORMID = "formid";
    protected static final String KEY_MYDEVPAGE_PAGEID = "myDevPageId";

    public void initialize() {
        super.initialize();
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(Key_EntryEntity);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.getPageCache().put(KEY_MYDEVPAGE_PAGEID, this.getView().getPageId());
        }
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem node = new ListboxItem();
        node.setId(KEY_BTN_OBJECT);
        node.setContent(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"MyDevPagecardPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(KEY_BTN_LAYOUT);
        node.setContent(ResManager.loadKDString((String)"\u5e03\u5c40", (String)"MyDevPagecardPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(KEY_BTN_PAGE);
        node.setContent(ResManager.loadKDString((String)"\u9875\u9762", (String)"MyDevPagecardPlugin_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(KEY_BTN_REPORT);
        node.setContent(ResManager.loadKDString((String)"\u62a5\u8868", (String)"MyDevPagecardPlugin_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(KEY_BTN_PARAMETER);
        node.setContent(ResManager.loadKDString((String)"\u53c2\u6570", (String)"MyDevPagecardPlugin_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        listboxItems.add(node);
        listbox.addItems(listboxItems);
        String pageType = PageType.EntityObject.getValue();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("pageType")))) {
            pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        }
        String tabId = this.pageTypeToTab(pageType);
        listbox.activeItem(tabId);
        this.operateVisible(PageType.EntityObject.getValue());
        this.refreshEntry(PageType.EntityObject.getValue());
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        if ("number".equals(args.getFieldName())) {
            String pageType = this.getPageCache().get(CacheId_PageType);
            String formId = (String)this.getModel().getValue(Key_FORMID, args.getRowIndex());
            if (StringUtils.isBlank((CharSequence)pageType) || "0".equals(pageType)) {
                GotoDesignerUtils.gotoDesigner(PageType.EntityObject.getValue(), this.getView(), formId);
            } else {
                GotoDesignerUtils.gotoDesigner(pageType, this.getView(), formId);
            }
        } else if ("bizapp".equals(args.getFieldName())) {
            String pageType = this.getPageCache().get(CacheId_PageType);
            DynamicObject bizapp = (DynamicObject)this.getModel().getValue("bizapp", args.getRowIndex());
            String bizappId = bizapp == null ? "" : bizapp.getString("id");
            MyAppUtils.showAppDetail(this.getView(), bizappId, "", pageType);
        }
    }

    public void listboxClick(ListboxEvent event) {
        String pageType = PageType.EntityObject.getValue();
        switch (event.getItemId()) {
            case "entityobject": {
                this.refreshEntry(PageType.EntityObject.getValue());
                break;
            }
            case "page": {
                pageType = PageType.Page.getValue();
                this.refreshEntry(PageType.Page.getValue());
                break;
            }
            case "report": {
                pageType = PageType.Report.getValue();
                this.refreshEntry(PageType.Report.getValue());
                break;
            }
            case "parameter": {
                pageType = PageType.Parameter.getValue();
                this.refreshEntry(PageType.Parameter.getValue());
                break;
            }
            case "layout": {
                pageType = PageType.LayOut.getValue();
                this.refreshEntry(PageType.LayOut.getValue());
                break;
            }
        }
        this.operateVisible(pageType);
        this.getPageCache().put(CacheId_PageType, pageType);
    }

    private void operateVisible(String pageType) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(Key_EntryEntity);
        if (PageType.EntityObject.getValue().equals(pageType)) {
            entryGrid.setColumnProperty("operationcolumnap", "vi", (Object)Boolean.TRUE);
            entryGrid.setColumnProperty("operationcolumnap1", "vi", (Object)Boolean.FALSE);
        } else {
            entryGrid.setColumnProperty("operationcolumnap", "vi", (Object)Boolean.FALSE);
            entryGrid.setColumnProperty("operationcolumnap1", "vi", (Object)Boolean.FALSE);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            Donothing op = (Donothing)args.getSource();
            String key = op.getOperateKey();
            int index = this.getModel().getEntryCurrentRowIndex(Key_EntryEntity);
            String formId = (String)this.getModel().getValue(Key_FORMID, index);
            switch (key) {
                case "showentity": {
                    GotoDesignerUtils.gotoDesigner(PageType.EntityObject.getValue(), this.getView(), formId);
                    break;
                }
                case "showpage": {
                    GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), formId);
                    break;
                }
                case "edit": {
                    GotoDesignerUtils.gotoDesigner(this.getPageCache().get(CacheId_PageType), this.getView(), formId);
                    break;
                }
            }
        }
    }

    private void refreshEntry(String pageType) {
        QFilter[] qFilters = new QFilter[4];
        String isv = ISVService.getISVInfo().getId();
        QFilter isvFilter = new QFilter("isv", "=", (Object)isv);
        if (KINGDEE.equals(isv)) {
            isvFilter = new QFilter("isv", "in", (Object)new String[]{KINGDEE, " "});
        }
        List<String> types = DevportalModelTypes.getModelTypesByType(pageType);
        if (PageType.Page.getValue().equals(pageType)) {
            List<String> commTypes = DevportalModelTypes.getModelTypesByType(PageType.Common.getValue());
            types.removeAll(commTypes);
        }
        qFilters[0] = isvFilter;
        qFilters[1] = new QFilter("modeltype", "in", (Object)types.toArray());
        qFilters[2] = new QFilter("modifydate", "is not null", null);
        qFilters[3] = new QFilter("bizappid.bizcloud", "!=", (Object)"2HGKCE94QELW");
        ArrayList forms = new ArrayList(10);
        ArrayList cloudIds = new ArrayList(10);
        ArrayList appIds = new ArrayList(10);
        ArrayList userIds = new ArrayList(10);
        ORM orm = ORM.create();
        try (DataSet formMetaDataSet = orm.queryDataSet(EntityId_Form, EntityId_Form, "id formid,name,number,modeltype,bizappid, modifydate, modifierid,basedatafield", qFilters, "modifydate desc", 0, 1000);
             DataSet bizAppDataSet = orm.queryDataSet(EntityId_App, EntityId_App, "id, type,bizcloud", new QFilter[]{new QFilter("bizcloud", "!=", (Object)"2HGKCE94QELW"), new QFilter("id", "!=", (Object)"2HGKTA7HH43C")}, "");
             DataSet result = bizAppDataSet.join(formMetaDataSet, JoinType.INNER).on("id", "bizappid").select(new String[]{Key_FORMID, "name", "number", "modeltype", "bizappid", "modifydate", "modifierid", "basedatafield"}, new String[]{"type", "bizcloud"}).finish().orderBy(new String[]{"modifydate desc"});){
            result.forEach(rs -> {
                if (forms.size() >= 10) {
                    return;
                }
                String bizappId = rs.getString("bizappid");
                String formId = rs.getString(Key_FORMID);
                String name = rs.getString("name");
                String number = rs.getString("number");
                String modelType = rs.getString("modeltype");
                Date modifyDate = rs.getDate("modifydate");
                String modifierId = rs.getString("modifierid");
                String bizcloudId = rs.getString("bizcloud");
                String entityId = rs.getString("basedatafield");
                if (PageType.EntityObject.getValue().equals(pageType) && !formId.equalsIgnoreCase(entityId)) {
                    return;
                }
                DynamicFormInfo info = new DynamicFormInfo(number, name, modelType, bizappId, modifierId, modifyDate);
                info.setBizCloud(bizcloudId);
                info.setFormId(formId);
                info.setEntityId(entityId);
                forms.add(info);
                appIds.add(bizappId);
                if (StringUtils.isNotBlank((CharSequence)modifierId)) {
                    userIds.add(Long.parseLong(modifierId));
                }
                cloudIds.add(bizcloudId);
            });
        }
        MainEntityType userDt = EntityMetadataCache.getDataEntityType((String)EntityId_User);
        MainEntityType appDt = EntityMetadataCache.getDataEntityType((String)EntityId_App);
        MainEntityType cloudDt = EntityMetadataCache.getDataEntityType((String)EntityId_Cloud);
        Map clouds = BusinessDataServiceHelper.loadFromCache((Object[])cloudIds.toArray(), (DynamicObjectType)cloudDt);
        Map apps = BusinessDataServiceHelper.loadFromCache((Object[])appIds.toArray(), (DynamicObjectType)appDt);
        Map users = BusinessDataServiceHelper.loadFromCache((Object[])userIds.toArray(), (DynamicObjectType)userDt);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(Key_EntryEntity);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(Key_EntryEntity);
        for (DynamicFormInfo info : forms) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(Key_FORMID, (Object)info.getFormId());
            row.set("name", (Object)info.getName());
            row.set("number", (Object)info.getNumber());
            if (PageType.LayOut.getValue().equals(pageType)) {
                row.set("modeltype", (Object)ResManager.loadKDString((String)"\u8868\u5355+\u5217\u8868", (String)"MyDevPagecardPlugin_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            } else {
                row.set("modeltype", (Object)info.getModelType());
            }
            String modelType = info.getModelType();
            String terminal = "pc";
            if ("MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileListModel".equals(modelType)) {
                terminal = "mobile";
            }
            row.set("terminal", (Object)terminal);
            row.set("bizapp", StringUtils.isBlank((CharSequence)info.getBizApp()) ? null : apps.get(info.getBizApp()));
            row.set("bizcloud", StringUtils.isBlank((CharSequence)info.getBizCloud()) ? null : clouds.get(info.getBizCloud()));
            row.set("modifier", StringUtils.isBlank((CharSequence)info.getModifier()) ? null : users.get(Long.parseLong(info.getModifier())));
            row.set("modifydate", (Object)info.getModifyDate());
            row.set("codestatus", (Object)0);
            rows.add((Object)row);
        }
        this.getView().updateView(Key_EntryEntity);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
        for (int i = 0; i < forms.size(); ++i) {
            cellStyles.add(this.greenStyle("codestatus", i));
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(Key_EntryEntity);
        entryGrid.setCellStyle(cellStyles);
    }

    private CellStyle greenStyle(String key, int i) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(key);
        cellStyle.setRow(i);
        cellStyle.setForeColor("#2ab277");
        return cellStyle;
    }

    private String pageTypeToTab(String pageType) {
        String tab = KEY_BTN_OBJECT;
        switch (pageType) {
            case "0": {
                tab = KEY_BTN_OBJECT;
                break;
            }
            case "1": {
                tab = KEY_BTN_PAGE;
                break;
            }
            case "2": {
                tab = KEY_BTN_REPORT;
                break;
            }
            case "3": {
                tab = KEY_BTN_PARAMETER;
                break;
            }
            case "5": {
                tab = KEY_BTN_LAYOUT;
                break;
            }
        }
        return tab;
    }

    private int getCount(char type) {
        String isv = ISVService.getISVInfo().getId();
        String sql = String.format("select count(1) from t_meta_bizapp where fmodeltype = '%s' and fisv = '%s' ", Character.valueOf(type), isv);
        if (KINGDEE.equals(isv)) {
            sql = String.format("select count(1) from t_meta_bizapp where fmodeltype = '%s' and fisv in ('kingdee',' ')", Character.valueOf(type));
        }
        return (Integer)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            }
        });
    }
}

