/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.home.index;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.home.index.AbstractDevportalListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.session.SystemPropertyUtils;

public class SearchListPlugin
extends AbstractDevportalListPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(SearchListPlugin.class);
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_NAME = "name";
    private static final String NAME_ASC = "name asc";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BIZCLOUD = "bizcloud";
    private static final String BASEDATAFIELD = "basedatafield";
    private static final String MODELTYPE = "modeltype";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    private static final String Key_KSEntryEntity = "ksentryentity";
    private static final String Key_KSId = "ksid";
    private static final String Key_KSTitle = "kstitle";
    private static final String Key_KSNumber = "ksnumber";
    private static final String Key_KSBizApp = "ksbizapp";
    private static final String Key_KSBizAppId = "ksbizappid";
    private static final String Key_KSBizUnitName = "ksbizunitname";
    private static final String Key_KSBizUnitId = "ksbizunitid";
    private static final String Key_App = "app";
    private static final String Key_Object = "object";
    private static final String Key_Layout = "layout";
    private static final String Key_Page = "page";
    private static final String Key_Report = "report";
    private static final String Key_Parameter = "parameter";
    private static final String[] searchKeyList = new String[]{"id", "name", "number"};
    private static final String[] searchKeyListWithoutID = new String[]{"name", "number"};
    private static final int ID_LENGTH = 8;
    private static final String BOS_DEVPN_SEARCH_MAX = "bos.devpn.search.max";
    private static final int searchMax = 500;
    private static List<String> metaTypeList = new ArrayList<String>(5);

    private int getMaxCount() {
        String tenantId = RequestContext.get().getTenantId();
        String value = SystemPropertyUtils.getProptyByTenant((String)BOS_DEVPN_SEARCH_MAX, (String)tenantId);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        return 500;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid layOutGrid = (EntryGrid)this.getControl("layoutentryentity");
        layOutGrid.addHyperClickListener((HyperLinkClickListener)this);
        layOutGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject evt) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String value = (String)parameter.getCustomParam("searchtext");
        List searchFields = (List)parameter.getCustomParam("searchFields");
        String createNewData = (String)parameter.getCustomParam("createNewData");
        if (this.hasSearchValue(searchFields)) {
            this.searchByNumberOrNameOrId(value, searchFields);
        } else if (createNewData != null && "true".equals(createNewData)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            this.setVisible(0, "appadvconap");
            this.setVisible(0, "ksadvconap");
            this.setVisible(0, "objectadvconap");
            this.setVisible(0, "layoutadvconap");
            this.setVisible(0, "pageadvconap");
            this.setVisible(0, "reportadvconap");
            this.setVisible(0, "parameteradvconap");
        }
    }

    private void searchByNumberOrNameOrId(String condition, List<Map<String, Object>> searchFields) {
        int parameterCount;
        HashMap<String, Set<String>> fieldNames = new HashMap<String, Set<String>>(16);
        this.mergerSearchFields(searchFields, fieldNames);
        JSONArray appItems = new JSONArray();
        JSONArray metaData = new JSONArray();
        JSONArray scriptItems = new JSONArray();
        JSONArray objectData = new JSONArray();
        JSONArray layoutData = new JSONArray();
        JSONArray pageData = new JSONArray();
        JSONArray reportData = new JSONArray();
        JSONArray parameterData = new JSONArray();
        if (searchFields == null || searchFields.isEmpty()) {
            HashSet<String> values = new HashSet<String>(1);
            values.add(condition);
            metaData = this.searchPageData(values);
            appItems = this.searchAppData(values);
            objectData = this.getPageDataByType(metaData, PageType.EntityObject);
            layoutData = this.getPageDataByType(metaData, PageType.LayOut);
            pageData = this.getPageDataByType(metaData, PageType.Page);
            reportData = this.getPageDataByType(metaData, PageType.Report);
            parameterData = this.getPageDataByType(metaData, PageType.Parameter);
        } else {
            JSONObject searchMap = new JSONObject();
            for (Map.Entry entry : fieldNames.entrySet()) {
                String fieldName = (String)entry.getKey();
                Set values = (Set)entry.getValue();
                if (metaTypeList.contains(fieldName) && !values.isEmpty()) {
                    String key = String.join((CharSequence)",", values);
                    if (searchMap.containsKey((Object)key)) {
                        metaData = (JSONArray)searchMap.get((Object)key);
                    } else {
                        metaData = this.searchPageData(values);
                        searchMap.put(key, (Object)metaData);
                    }
                }
                switch (fieldName) {
                    case "app": {
                        appItems.addAll((Collection)this.searchAppData(values));
                        break;
                    }
                    case "object": {
                        objectData.addAll((Collection)this.getPageDataByType(metaData, PageType.EntityObject));
                        break;
                    }
                    case "layout": {
                        layoutData.addAll((Collection)this.getPageDataByType(metaData, PageType.LayOut));
                        break;
                    }
                    case "page": {
                        pageData.addAll((Collection)this.getPageDataByType(metaData, PageType.Page));
                        break;
                    }
                    case "report": {
                        reportData.addAll((Collection)this.getPageDataByType(metaData, PageType.Report));
                        break;
                    }
                    case "parameter": {
                        parameterData.addAll((Collection)this.getPageDataByType(metaData, PageType.Parameter));
                        break;
                    }
                }
            }
            metaData.clear();
            searchMap.clear();
        }
        this.renderApp(appItems);
        this.renderPage(objectData, Key_Object);
        this.renderPage(layoutData, Key_Layout);
        this.renderPage(pageData, Key_Page);
        this.renderPage(reportData, Key_Report);
        this.renderPage(parameterData, Key_Parameter);
        int appCount = appItems == null ? 0 : appItems.size();
        int scriptCount = scriptItems == null ? 0 : scriptItems.size();
        int objectCount = objectData == null ? 0 : objectData.size();
        int layoutCount = layoutData == null ? 0 : layoutData.size();
        int pageCount = pageData == null ? 0 : pageData.size();
        int reportCount = reportData == null ? 0 : reportData.size();
        int n = parameterCount = parameterData == null ? 0 : parameterData.size();
        if (appCount == 0 && scriptCount == 0 && layoutCount == 0 && objectCount == 0 && pageCount == 0 && reportCount == 0 && parameterCount == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
        this.setVisible(appItems == null ? 0 : appItems.size(), "appadvconap");
        this.setVisible(scriptItems == null ? 0 : scriptItems.size(), "ksadvconap");
    }

    private void mergerSearchFields(List<Map<String, Object>> searchFields, Map<String, Set<String>> fieldNames) {
        if (searchFields == null || searchFields.isEmpty()) {
            return;
        }
        for (Map<String, Object> map : searchFields) {
            List fields = (List)map.get("fieldName");
            List valueList = (List)map.get("value");
            if (fields == null || fields.isEmpty()) continue;
            for (String field : fields) {
                Set<String> values = fieldNames.get(field);
                if (values == null) {
                    values = new HashSet<String>(10);
                }
                if (valueList != null && !valueList.isEmpty()) {
                    values.addAll(valueList.stream().filter(val -> StringUtils.isNotBlank((CharSequence)val)).collect(Collectors.toSet()));
                }
                fieldNames.put(field, values);
            }
        }
    }

    private boolean hasSearchValue(List<Map<String, Object>> searchFields) {
        if (searchFields == null || searchFields.isEmpty()) {
            return false;
        }
        for (Map<String, Object> map : searchFields) {
            List valueList = (List)map.get("value");
            if (valueList == null) continue;
            HashSet values = new HashSet(10);
            values.addAll(valueList.stream().filter(val -> StringUtils.isNotBlank((CharSequence)val)).collect(Collectors.toSet()));
            if (values.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private JSONArray searchAppData(Set<String> values) {
        ArrayList<String> idList = new ArrayList<String>();
        JSONArray AppArray = new JSONArray();
        String selectFields = "id, number, name, bizcloud, image, description";
        List<QFilter> filters = this.buildFilter(values);
        try (DataSet result = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_BIZAPP, (String)BOS_DEVPORTAL_BIZAPP, (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)NAME_ASC);){
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                try {
                    Row row = (Row)iterator.next();
                    if (idList.contains(row.getString("id")) || "2HGKCE94QELW".equalsIgnoreCase((String)row.get(BIZCLOUD)) || "2HGKTA7HH43C".equalsIgnoreCase(row.getString("id"))) continue;
                    idList.add(row.getString("id"));
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("id", (Object)row.getString("id"));
                    jsonObject.put(KEY_NUMBER, (Object)row.getString(KEY_NUMBER));
                    jsonObject.put(KEY_NAME, row.get(KEY_NAME));
                    jsonObject.put(BIZCLOUDID, (Object)row.getString(BIZCLOUD));
                    jsonObject.put("image", (Object)row.getString("image"));
                    jsonObject.put("description", (Object)row.getString("description"));
                    AppArray.add((Object)jsonObject);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        return AppArray;
    }

    private JSONArray searchPageData(Set<String> values) {
        JSONArray pageArray = new JSONArray();
        HashMap<String, AppMetadata> appMetadataMap = new HashMap<String, AppMetadata>();
        List<QFilter> filters = this.buildFilter(values);
        String selectFields = "id,number,name,modeltype,type,basedatafield";
        String unitrelForselectFields = "bizapp,bizunit,form";
        String bizAppselectFields = "id,name appname,bizcloud";
        try (DataSet dsNameCondition = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)NAME_ASC, (int)this.getMaxCount());
             DataSet dsUnitRelForm = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelForselectFields, null, (String)"form asc");
             DataSet dsApp = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_BIZAPP, (String)BOS_DEVPORTAL_BIZAPP, (String)bizAppselectFields, null, (String)NAME_ASC);
             DataSet result = dsNameCondition.join(dsUnitRelForm, JoinType.LEFT).on("id", "form").select(new String[]{"id", KEY_NUMBER, KEY_NAME, MODELTYPE, "type", BASEDATAFIELD}, new String[]{BIZAPP, BIZUNIT}).finish().join(dsApp, JoinType.LEFT).on(BIZAPP, "id").select(new String[]{"id", KEY_NUMBER, KEY_NAME, MODELTYPE, "type", BASEDATAFIELD, BIZAPP, BIZUNIT}, new String[]{"appname", BIZCLOUD}).finish().filter("bizapp<>null and bizunit<>null");){
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                try {
                    String bizAppId;
                    Row row = (Row)iter.next();
                    if ("2HGKCE94QELW".equalsIgnoreCase(row.getString(BIZCLOUD)) || "2HGKTA7HH43C".equalsIgnoreCase(bizAppId = row.getString(BIZAPP))) continue;
                    String modelType = row.getString(MODELTYPE);
                    String bizUnitId = row.getString(BIZUNIT);
                    String entityId = row.getString(BASEDATAFIELD);
                    JSONObject pageObject = new JSONObject();
                    String formId = row.getString("id");
                    pageObject.put("bizpageid", (Object)formId);
                    pageObject.put("entityid", (Object)entityId);
                    pageObject.put(KEY_NUMBER, (Object)row.getString(KEY_NUMBER));
                    if (StringUtils.isBlank((CharSequence)row.getString(KEY_NAME))) {
                        String formName = "";
                        if ("PrintModel".equals(modelType)) {
                            PrintMetadata printMeta = (PrintMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
                            formName = printMeta.getName().getLocaleValue();
                        } else {
                            FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
                            formName = formMeta.getName().getLocaleValue();
                        }
                        pageObject.put(KEY_NAME, (Object)formName);
                    } else {
                        pageObject.put(KEY_NAME, (Object)row.getString(KEY_NAME));
                    }
                    if (formId.equals(entityId) || "PrintModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "QueryListModel".equals(modelType)) {
                        pageObject.put(MODELTYPE, (Object)modelType);
                    } else {
                        pageObject.put(MODELTYPE, (Object)"PCLayout");
                    }
                    pageObject.put(BIZAPPID, (Object)bizAppId);
                    pageObject.put(BIZUNITID, (Object)bizUnitId);
                    pageObject.put("bizappname", (Object)row.getString("appname"));
                    pageObject.put(BIZCLOUDID, (Object)row.getString(BIZCLOUD));
                    AppMetadata appMetadata = (AppMetadata)appMetadataMap.get(bizAppId);
                    if (appMetadata == null) {
                        appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                        appMetadataMap.put(bizAppId, appMetadata);
                    }
                    if (StringUtils.isBlank((Object)appMetadata)) continue;
                    List functionPackets = appMetadata.getAppFunctionPackets();
                    String appIsv = AppMetaServiceHelper.getIsvByApp((AppMetadata)appMetadata);
                    pageObject.put("isv", (Object)appIsv);
                    pageObject.put("apptype", (Object)appMetadata.getDevType());
                    pageObject.put("isowner", (Object)(appIsv.equals(AppUtils.getDeveloperInfo()) ? 1 : 0));
                    pageObject.put("ismobile", (Object)(modelType.startsWith("Mob") ? 1 : 0));
                    for (AppFunctionPacketElement functionPacket : functionPackets) {
                        if (!functionPacket.getId().equals(bizUnitId)) continue;
                        pageObject.put("bizunitname", (Object)functionPacket.getName().getLocaleValue());
                        String pageType = row.getString("type");
                        pageObject.put("devtype", (Object)pageType);
                        break;
                    }
                    pageArray.add((Object)pageObject);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        return pageArray;
    }

    private void renderKS(JSONArray scriptItems) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(Key_KSEntryEntity);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(Key_KSEntryEntity);
        if (scriptItems == null || scriptItems.isEmpty()) {
            this.getView().updateView(Key_KSEntryEntity);
            return;
        }
        for (int i = 0; i < scriptItems.size(); ++i) {
            JSONObject item = scriptItems.getJSONObject(i);
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(Key_KSTitle, (Object)item.getString(KEY_NAME));
            row.set(Key_KSNumber, (Object)item.getString(KEY_NUMBER));
            row.set(Key_KSBizApp, (Object)item.getString("bizappname"));
            row.set(Key_KSBizAppId, (Object)item.getString(BIZAPPID));
            row.set(Key_KSBizUnitName, (Object)item.getString("bizunitname"));
            row.set(Key_KSBizUnitId, (Object)item.getString(BIZUNITID));
            row.set(Key_KSId, (Object)item.getString("id"));
            rows.add((Object)row);
        }
        this.getView().updateView(Key_KSEntryEntity);
    }

    private JSONArray searchScriptData(Set<String> values) {
        JSONArray scriptInfos = new JSONArray();
        HashMap<String, AppMetadata> appMetadataMap = new HashMap<String, AppMetadata>();
        ArrayList<String> idList = new ArrayList<String>();
        String selectFields = "id,txt_scriptname,txt_scriptnumber,cbox_script_type,bizunitid,bizappid";
        List<QFilter> filters = this.buildFilter(values);
        try (DataSet result = QueryServiceHelper.queryDataSet((String)"ide_pluginscript", (String)"ide_pluginscript", (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"txt_scriptnumber asc");){
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                try {
                    Row script = (Row)iterator.next();
                    String id = script.getString("id");
                    if (idList.contains(id)) continue;
                    String bizUnitId = script.getString(BIZUNITID);
                    String bizAppId = script.getString(BIZAPPID);
                    JSONObject scriptInfo = new JSONObject();
                    scriptInfo.put("id", (Object)id);
                    scriptInfo.put(KEY_NAME, script.get("txt_scriptname"));
                    scriptInfo.put(KEY_NUMBER, script.get("txt_scriptnumber"));
                    scriptInfo.put("type", script.get("cbox_script_type"));
                    scriptInfo.put(BIZUNITID, (Object)bizUnitId);
                    scriptInfo.put(BIZAPPID, (Object)bizAppId);
                    AppMetadata appMetadata = (AppMetadata)appMetadataMap.get(bizAppId);
                    if (appMetadata == null) {
                        appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                        appMetadataMap.put(bizAppId, appMetadata);
                    }
                    if (appMetadata == null) continue;
                    scriptInfo.put("bizappname", (Object)appMetadata.getName().getLocaleValue());
                    List functionPackets = appMetadata.getAppFunctionPackets();
                    for (AppFunctionPacketElement functionPacket : functionPackets) {
                        if (!functionPacket.getId().equals(bizUnitId)) continue;
                        scriptInfo.put("bizunitname", (Object)functionPacket.getName().getLocaleValue());
                        break;
                    }
                    scriptInfos.add((Object)scriptInfo);
                    idList.add(id);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        return scriptInfos;
    }

    private List<QFilter> buildFilter(Set<String> values) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (values == null || values.isEmpty()) {
            return qFilters;
        }
        QFilter qFilter = null;
        for (String value : values) {
            String[] searchKey = searchKeyListWithoutID;
            if (value != null && value.length() >= 8) {
                searchKey = searchKeyList;
            }
            String string = value = value == null ? "" : value.trim();
            if (qFilter == null) {
                qFilter = QFilter.ftlike((boolean)false, (String)value, (String[])searchKey);
                continue;
            }
            qFilter.or(QFilter.ftlike((boolean)false, (String)value, (String[])searchKey));
        }
        qFilters.add(qFilter);
        return qFilters;
    }

    static {
        metaTypeList.add(Key_Object);
        metaTypeList.add(Key_Layout);
        metaTypeList.add(Key_Page);
        metaTypeList.add(Key_Report);
        metaTypeList.add(Key_Parameter);
    }
}

