/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.home.index;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.home.index.AbstractDevportalListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.url.UrlService;

public class ShortCutListPlugin
extends AbstractDevportalListPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BIZPAGE = "bizpage";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    private static final String ID_ASC = "id asc";
    private static final String BIZAPP = "bizapp";
    private static final String BIZCLOUD = "bizcloud";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BASEDATAFIELD = "basedatafield";
    private static final String MODELTYPE = "modeltype";
    private static final String NUMBER = "number";
    private static final String BIZUNIT = "bizunit";
    private static final String Key_AppImage = "appimage";
    private static final String Key_AppName = "appname";
    private static final String Key_BizAppId = "bizappid";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_DESCRIPTION = "description";
    private static final String Key_UnCollect_App = "uncollectapp";
    private static final String Key_UnCollect_Object = "uncollectobject";
    private static final String Key_UnCollect_Page = "uncollectpage";
    private static final String Key_UnCollect_Report = "uncollectreport";
    private static final String Key_UnCollect_Param = "uncollectparam";
    private static final String Key_UnCollect_Layout = "uncollectlayout";
    private static final String Key_App_Collect_ID = "appcollectid";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_UnCollect_App, Key_UnCollect_Object, Key_UnCollect_Page, Key_UnCollect_Report, Key_UnCollect_Param, Key_UnCollect_Layout});
    }

    public void afterBindData(EventObject evt) {
        JSONArray appItems = ShortCutListPlugin.listMyAppData();
        JSONArray metaItems = ShortCutListPlugin.listMyPageData();
        JSONArray objectData = this.getPageDataByType(metaItems, PageType.EntityObject);
        JSONArray layoutData = this.getPageDataByType(metaItems, PageType.LayOut);
        JSONArray pageData = this.getPageDataByType(metaItems, PageType.Page);
        JSONArray reportData = this.getPageDataByType(metaItems, PageType.Report);
        JSONArray parameterData = this.getPageDataByType(metaItems, PageType.Parameter);
        this.renderApp(appItems);
        this.renderPage(objectData, "object", true);
        this.renderPage(layoutData, "layout", true);
        this.renderPage(pageData, "page", true);
        this.renderPage(reportData, "report", true);
        this.renderPage(parameterData, "parameter", true);
        int appCount = appItems == null ? 0 : appItems.size();
        int objectCount = objectData == null ? 0 : objectData.size();
        int pageCount = pageData == null ? 0 : pageData.size();
        int reportCount = reportData == null ? 0 : reportData.size();
        int parameterCount = parameterData == null ? 0 : parameterData.size();
        int layoutCount = layoutData == null ? 0 : layoutData.size();
        this.setVisible(appItems == null ? 0 : appItems.size(), "appadvconap");
        if (appCount == 0 && objectCount == 0 && pageCount == 0 && reportCount == 0 && parameterCount == 0 && layoutCount == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "uncollectapp": {
                this.deleteMyApp();
                break;
            }
            case "uncollectobject": {
                this.deleteMyPage(PageType.EntityObject);
                break;
            }
            case "uncollectpage": {
                this.deleteMyPage(PageType.Page);
                break;
            }
            case "uncollectreport": {
                this.deleteMyPage(PageType.Report);
                break;
            }
            case "uncollectparam": {
                this.deleteMyPage(PageType.Parameter);
                break;
            }
            case "uncollectlayout": {
                this.deleteMyPage(PageType.LayOut);
            }
        }
        this.SetNoDataPanel();
    }

    private void SetNoDataPanel() {
        int appCount = this.getEntryRows("appentryentity");
        int objectCount = this.getEntryRows("bizobjectentryentity");
        int pageCount = this.getEntryRows("pageentryentity");
        int reportCount = this.getEntryRows("reportentryentity");
        int parameterCount = this.getEntryRows("parameterentryentity");
        int layoutCount = this.getEntryRows("layoutentryentity");
        if (appCount == 0 && objectCount == 0 && pageCount == 0 && reportCount == 0 && parameterCount == 0 && layoutCount == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    private int getEntryRows(String entryEntityKey) {
        if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
            return 0;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryEntityKey);
        return rows == null ? 0 : rows.size();
    }

    @Override
    protected void renderApp(JSONArray appItems) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("appentryentity");
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get("appentryentity");
        if (appItems == null || appItems.isEmpty()) {
            this.getView().updateView("appentryentity");
            return;
        }
        String domainUrl = UrlService.getDomainContextUrl();
        for (int i = 0; i < appItems.size(); ++i) {
            JSONObject appItem = appItems.getJSONObject(i);
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            String image = appItem.getString("image");
            image = StringUtils.isNotBlank((CharSequence)image) && image.startsWith("/") ? domainUrl + image : domainUrl + "/" + image;
            row.set(Key_AppImage, (Object)image);
            row.set(Key_AppName, (Object)appItem.getString("name"));
            row.set("bizappid", (Object)appItem.getString("bizappid"));
            row.set("appnumber", (Object)appItem.getString("number"));
            row.set(Key_App_Collect_ID, appItem.get((Object)"id"));
            row.set(KEY_DESCRIPTION, appItem.get((Object)KEY_DESCRIPTION));
            rows.add((Object)row);
        }
        this.getView().updateView("appentryentity");
    }

    public static JSONArray listMyAppData() {
        JSONArray array = new JSONArray();
        String description = ResManager.loadKDString((String)"\u8fd9\u662f\u4e00\u4e2a\u65b0\u7684\u5e94\u7528", (String)"ShortCutListPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        QFilter qUser = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter qpageId = new QFilter(BIZPAGE, "=", (Object)" ");
        QFilter[] filters = new QFilter[]{qUser, qpageId};
        String selectFields = "id,user,bizapp";
        String bizAppselectFields = "id,name,bizcloud,image,description";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_SHORTCUT, (String)BOS_DEVPORTAL_SHORTCUT, (String)selectFields, (QFilter[])filters, (String)ID_ASC);
             DataSet dsApp = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_BIZAPP, (String)BOS_DEVPORTAL_BIZAPP, (String)bizAppselectFields, null, (String)ID_ASC);
             DataSet dsInfo = ds.hashJoin(dsApp.toHashTable("id"), BIZAPP, new String[]{"name", BIZCLOUD, "image", KEY_DESCRIPTION}).selectLeftFields(new String[]{"id", "user", BIZAPP}).finish();){
            for (Row row : dsInfo) {
                JSONObject jsonObject = new JSONObject();
                String bizAppId = row.get(BIZAPP).toString();
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                jsonObject.put("id", row.get("id"));
                jsonObject.put("userid", row.get("user"));
                jsonObject.put("bizappid", (Object)bizAppId);
                jsonObject.put("name", (Object)appMetadata.getName().getLocaleValue());
                jsonObject.put(BIZCLOUDID, (Object)appMetadata.getBizCloudID());
                jsonObject.put("image", (Object)appMetadata.getAppElement().getImage());
                jsonObject.put(KEY_DESCRIPTION, (Object)(row.get(KEY_DESCRIPTION) == null ? description : row.get(KEY_DESCRIPTION).toString()));
                array.add((Object)jsonObject);
            }
        }
        return array;
    }

    private void deleteMyApp() {
        String collectId = this.getSelectId("appentryentity", Key_App_Collect_ID);
        QFilter filter = new QFilter("id", "=", (Object)collectId);
        DeleteServiceHelper.delete((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])new QFilter[]{filter});
        JSONArray appItems = ShortCutListPlugin.listMyAppData();
        this.renderApp(appItems);
        this.setVisible(appItems == null ? 0 : appItems.size(), "appadvconap");
    }

    private void deleteMyPage(PageType pageType) {
        String entryKey = "bizobjectentryentity";
        String type = "object";
        switch (pageType) {
            case EntityObject: {
                break;
            }
            case Page: {
                entryKey = "pageentryentity";
                type = "page";
                break;
            }
            case Report: {
                entryKey = "reportentryentity";
                type = "report";
                break;
            }
            case Parameter: {
                entryKey = "parameterentryentity";
                type = "parameter";
                break;
            }
            case LayOut: {
                entryKey = "layoutentryentity";
                type = "layout";
                break;
            }
        }
        String id = this.getSelectId(entryKey, type + "id");
        QFilter filter = new QFilter(BIZPAGE, "=", (Object)id);
        DeleteServiceHelper.delete((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])new QFilter[]{filter});
        JSONArray metaItems = ShortCutListPlugin.listMyPageData();
        JSONArray data = this.getPageDataByType(metaItems, pageType);
        this.renderPage(data, type);
        if (pageType == PageType.LayOut) {
            JSONArray entityData = this.getPageDataByType(metaItems, PageType.EntityObject);
            this.renderPage(entityData, "object");
        } else if (pageType == PageType.EntityObject) {
            JSONArray pageData = this.getPageDataByType(metaItems, PageType.LayOut);
            this.renderPage(pageData, "layout");
        }
    }

    private String getSelectId(String entryKey, String idKey) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        int[] selRows = grid.getSelectRows();
        if (selRows == null || selRows.length < 1) {
            return null;
        }
        int index = this.getModel().getEntryCurrentRowIndex(entryKey);
        Object value = this.getModel().getValue(idKey, index);
        if (value == null) {
            return null;
        }
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getPkValue().toString();
        }
        return value.toString();
    }

    /*
     * Exception decompiling
     */
    public static JSONArray listMyPageData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

