/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.manage.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public abstract class AbstractModelTreeListPlugin
extends StandardTreeListPlugin {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void initializeTree(EventObject e) {
        TreeNode root = null;
        root = this.isRuntimeTree() ? (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app") : (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)false, (boolean)false);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractModelTreeListPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        treeView.addNode(root);
        this.getTreeListView().getTreeModel().setRoot(root);
        this.getTreeListView().getTreeView().focusNode(root);
    }

    protected boolean isRuntimeTree() {
        return true;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DataProvider());
    }

    protected DynamicObjectType createQueryDataType() {
        DynamicObjectType type = new DynamicObjectType("queryplain");
        DynamicSimpleProperty pkprop = new DynamicSimpleProperty("id", String.class, (Object)"");
        pkprop.setPrimaryKey(true);
        type.registerSimpleProperty(pkprop);
        type.registerSimpleProperty(new DynamicSimpleProperty("num", String.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("name", String.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("type", String.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("srcnum", String.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("unit", String.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("app", String.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("cloud", String.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("modifier", String.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("modifytime", Date.class, null));
        type.registerSimpleProperty(new DynamicSimpleProperty("modeltype", String.class, null));
        return type;
    }

    private DynamicObjectCollection convet2BindValue(DynamicObjectCollection datasource) {
        DynamicObjectType type = this.createQueryDataType();
        DynamicObjectCollection cols = new DynamicObjectCollection(type, null);
        Map<String, String> templateNames = this.getTemplateInfo();
        HashSet<String> appIds = new HashSet<String>(10);
        HashSet<String> formIds = new HashSet<String>();
        HashSet<Long> userIds = new HashSet<Long>();
        for (DynamicObject it : datasource) {
            String appId = it.getString("bizappid");
            String formId = it.getString("id");
            String modifierid = it.getString("modifierid");
            String masterid = it.getString("masterid");
            appIds.add(appId);
            formIds.add(formId);
            formIds.add(masterid);
            userIds.add(StringUtils.isBlank((CharSequence)modifierid) ? 0L : Long.parseLong(modifierid));
        }
        Map<String, String> userMapping = this.loadUserNames(userIds);
        Map<String, DynamicObject> appMapping = this.loadAppInfo(appIds);
        Map<String, String[]> formMapping = this.loadFormInfo(formIds);
        for (DynamicObject it : datasource) {
            String[] masterInfo;
            String userId;
            String appId;
            DynamicObject appInfo;
            String pk = it.getString("id");
            DynamicObject object = new DynamicObject(type, (Object)pk);
            object.set("num", it.get("number"));
            object.set("name", it.get("name"));
            String inheritPath = it.getString("inheritpath");
            StringTokenizer tokens = new StringTokenizer(inheritPath, ",");
            while (tokens.hasMoreTokens()) {
                String srcId = tokens.nextToken();
                String typeNum = templateNames.get(srcId);
                if (typeNum == null) continue;
                object.set("type", (Object)typeNum);
                break;
            }
            if ((appInfo = appMapping.get(appId = it.getString("bizappid"))) != null) {
                object.set("app", (Object)appInfo.getString("name"));
                object.set("cloud", (Object)appInfo.getString("bizcloud.name"));
            }
            if (StringUtils.isNotBlank((CharSequence)(userId = it.getString("modifierid")))) {
                object.set("modifier", (Object)userMapping.get(userId));
            }
            String masterid = it.getString("masterid");
            String[] formInfo = formMapping.get(pk);
            if (formInfo != null) {
                object.set("unit", (Object)formInfo[1]);
            }
            if ((masterInfo = formMapping.get(StringUtils.isBlank((CharSequence)masterid) ? pk : masterid)) != null) {
                object.set("srcnum", (Object)masterInfo[0]);
            }
            object.set("modeltype", (Object)it.getString("modeltype"));
            object.set("modifytime", (Object)it.getDate("modifydate"));
            cols.add((Object)object);
        }
        return cols;
    }

    private Map<String, String[]> loadFormInfo(Set<String> formIds) {
        if (formIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append(" select t1.fid, t1.fnumber,t4.fname,t2.fbizappid ,t2.fbizunitid from t_meta_formdesign t1 ", new Object[0]).append(" left join t_meta_bizunitrelform t2 on t1.fid = t2.fformid ", new Object[0]).append(" left join t_meta_bizunit t3 on t2.fbizunitid  = t3.fid ", new Object[0]).append(" left join t_meta_bizunit_l t4 on t3.fid  = t4.fid ", new Object[0]).append(" and ", new Object[0]).appendIn("t4.flocaleid", new Object[]{RequestContext.get().getLang().toString()}).append(" where ", new Object[0]).appendIn("t1.fid", formIds.toArray());
        Map result = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            HashMap<String, String[]> map = new HashMap<String, String[]>(16);
            ArrayList<String> apps = new ArrayList<String>(10);
            HashMap<String, String> unitnames = new HashMap<String, String>();
            while (rs.next()) {
                String formId = rs.getString(1);
                String string = rs.getString(2);
                String appid = rs.getString(4);
                String bizunitid = rs.getString(5);
                apps.add(appid);
                map.put(formId, new String[]{string, bizunitid});
            }
            for (String string : apps) {
                if (StringUtils.isBlank((CharSequence)string)) continue;
                try {
                    List menus = AppMetadataCache.getAppMenusInfoByAppId((String)string);
                    for (AppMenuInfo menu : menus) {
                        unitnames.put(menu.getId(), menu.getName().toString());
                    }
                }
                catch (Exception menus) {
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                String unitId = (String)entry.getKey();
                ((String[])entry.getValue())[1] = (String)unitnames.get(unitId);
            }
            return map;
        });
        return result;
    }

    private Map<String, DynamicObject> loadAppInfo(Set<String> appids) {
        if (appids.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id,name,number,bizcloud.id,bizcloud.name,bizcloud.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)appids.toArray())});
        for (Map.Entry it : datas.entrySet()) {
            map.put(it.getKey().toString(), (DynamicObject)it.getValue());
        }
        return map;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String nodeId = e.getNodeId() == null ? "rootNode" : e.getNodeId().toString();
        TreeNode node = this.getTreeListView().getTreeModel().getRoot().getTreeNode(nodeId, 10);
        Object type = node.getData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"cloud", (CharSequence)String.valueOf(type))) {
            DynamicObjectCollection cols = BizAppServiceHelp.getAllBizAppsByCloudID((String)nodeId);
            ArrayList<String> appIds = new ArrayList<String>();
            for (DynamicObject col : cols) {
                appIds.add(col.getString("id"));
            }
            e.addQFilter(new QFilter("bizappid", "in", (Object)appIds.toArray()));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"app", (CharSequence)String.valueOf(type))) {
            e.addQFilter(new QFilter("bizappid", "in", this.getAppIdsBy(nodeId)));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"root", (CharSequence)String.valueOf(type))) {
            return;
        }
    }

    private List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)tType)) {
                return app.getString("id");
            }
            return app.getString("masterid");
        }).orElse("");
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return new ArrayList<String>();
        }
        return allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "refrsh": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "close": {
                this.getView().close();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private Map<String, String> loadUserNames(Set<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userIds.toArray())});
        for (Map.Entry it : datas.entrySet()) {
            map.put(it.getKey().toString(), ((DynamicObject)it.getValue()).getString("name"));
        }
        return map;
    }

    protected abstract Map<String, String> getTemplateInfo();

    protected abstract List<QFilter> getModelDataFilter();

    protected Consumer<PackageDataEvent> getPackageDataConsumer() {
        return t -> {
            Object src = t.getSource();
            if (!(src instanceof DynamicTextColumnDesc)) {
                return;
            }
            long userId = RequestContext.get().getCurrUserId();
            AbstractColumnDesc dytextcol = (AbstractColumnDesc)src;
            Object fmtValue = "";
            switch (dytextcol.getKey()) {
                case "modifytime": {
                    Date date = t.getRowData().getDate("modifytime");
                    if (date == null) break;
                    fmtValue = TimeServiceHelper.formatUserTime((Date)date, (Long)userId);
                    break;
                }
                default: {
                    if (!t.getRowData().getDataEntityType().getProperties().containsKey((Object)dytextcol.getKey())) break;
                    fmtValue = t.getRowData().get(dytextcol.getKey());
                }
            }
            t.setFormatValue(fmtValue);
        };
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addPackageDataListener(this.getPackageDataConsumer());
    }

    class DataProvider
    extends ListDataProvider {
        DataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection collection;
            QFilter[] filters = this.getQueryBuilder().getFilters();
            ArrayList<QFilter> newFilter = new ArrayList<QFilter>();
            newFilter.addAll(Arrays.asList(filters));
            newFilter.addAll(AbstractModelTreeListPlugin.this.getModelDataFilter());
            this.getQueryBuilder().setFilters(newFilter.toArray(new QFilter[newFilter.size()]));
            StringBuilder sb = new StringBuilder();
            sb.append("id,number,name,inheritpath,parentid,bizappid,modifydate,modifierid,masterid,modeltype");
            String selectFields = sb.toString();
            ORM orm = ORM.create();
            try (DataSet dataSet = orm.queryDataSet("xxx", this.getQueryBuilder().getEntityName(), selectFields, newFilter.toArray(new QFilter[newFilter.size()]), null, this.getQueryBuilder().getStart(), this.getQueryBuilder().getLimit());){
                collection = AbstractModelTreeListPlugin.this.convet2BindValue(orm.toPlainDynamicObjectCollection(dataSet));
            }
            return collection;
        }

        public int getMaxReturnData() {
            return 10000;
        }

        public int getRealCount() {
            int id;
            ORM orm = ORM.create();
            QFilter[] filter = this.getQueryBuilder().getFilters();
            ArrayList<QFilter> newFilter = new ArrayList<QFilter>();
            newFilter.addAll(Arrays.asList(filter));
            newFilter.addAll(AbstractModelTreeListPlugin.this.getModelDataFilter());
            try (DataSet dataSet = orm.queryDataSet("xxx", this.getQueryBuilder().getEntityName(), "id", newFilter.toArray(new QFilter[newFilter.size()]));){
                id = dataSet.count("id", true);
            }
            return id;
        }

        public int getMaxCount() {
            return this.getRealCount();
        }
    }
}

