/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.page.BizGuidTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;

public class AbstractGuidPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-new-plugin";
    private static final String KEY_MESSAGE_TYPE_CLOUD = "cloud";
    private static final String KEY_MESSAGE_TYPE_ECOLOGICAL = "ecological";
    private static final String KEY_MESSAGE_TYPE_ORIGIN = "original";
    private static final String KEY_MESSAGE_TYPE_NODATA = "nodata";
    private static final String FORM_ID = "formid";
    private static final String SEARCH_AP = "searchap";
    private static final String MASTER_ID = "masterid";
    private static final String ROOT_NODE = "rootNode";
    private static final String KEY_BIZ_APP_ID = "bizappid";
    private static final String BOS_DEVPORTAL_BIZ_APP = "bos_devportal_bizapp";
    private static final String TREE_VIEW_AP = "treeviewap";
    private static final String CACHE_TREE_NODES = "cacheNodes";
    private static final String CACHE_ID_MASTER = "cacheIdMaster";
    private static final String CACHE_JSON_VALUE = "cacheJsonValue";
    private static final String CACHEID_CURRNODE = "currnode";
    private List<DynamicObject> valueList;
    private TreeNode root;
    protected static final String KEY_MODEL_TYPE = "modeltype";
    protected static final String KEY_BIZ_APPID = "bizAppId";
    protected static final String KEY_BIZ_UNITID = "fungroup";
    protected static final String KEY_PAGE_TYPE = "pageType";
    protected static final String BOS_FORM_META = "bos_formmeta";

    public void registerListener(EventObject e) {
        TreeView tView = (TreeView)this.getControl(TREE_VIEW_AP);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.changeListView(true, "");
    }

    public void afterBindData(EventObject e) {
        TreeNode rootNode = this.getRootNode();
        TreeView tView = (TreeView)this.getControl(TREE_VIEW_AP);
        tView.addNode(rootNode);
        tView.setRootVisible(false);
        List children = rootNode.getChildren();
        if (children != null && !children.isEmpty()) {
            TreeNode treeNode = (TreeNode)children.get(0);
            tView.focusNode(treeNode);
            this.getPageCache().put("initSelectTreeNodeCache", SerializationUtils.toJsonString((Object)treeNode));
        }
        String currNodeId = this.getCurrNodeId();
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_APPID);
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap21"});
            currNodeId = bizAppId;
        }
        TreeNode treeNode = rootNode.getTreeNode(currNodeId, 10);
        tView.focusNode(treeNode);
        this.getPageCache().put(CACHEID_CURRNODE, currNodeId);
        this.doSearch(currNodeId, "");
    }

    protected TreeNode getRootNode() {
        if (this.root == null) {
            String bizExtAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_APPID);
            BizGuidTreeBuilder treeBuilder = new BizGuidTreeBuilder();
            this.root = treeBuilder.buildTreeNodes(this.getView(), bizExtAppId, this.isExt());
        }
        return this.root;
    }

    protected void refreshEntryGrid(List<DynamicObject> forms) {
    }

    public void search(SearchEnterEvent event) {
        Search search = (Search)event.getSource();
        if (StringUtils.equals((CharSequence)SEARCH_AP, (CharSequence)search.getKey())) {
            String searchText = event.getText();
            this.doSearch(this.getCurrNodeId(), searchText);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.doSearch(nodeId, "");
        this.getPageCache().put(CACHEID_CURRNODE, nodeId);
    }

    protected String getCurrNodeId() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_APPID);
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            return bizAppId;
        }
        String nodeId = this.getPageCache().get(CACHEID_CURRNODE);
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            TreeNode rootNode = this.getRootNode();
            List children = rootNode.getChildren();
            nodeId = children != null && !children.isEmpty() ? ((TreeNode)children.get(0)).getId() : rootNode.getId();
        }
        return nodeId;
    }

    protected DynamicObject loadSingleFromCache(Object pk, String entityName) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)entityName);
    }

    protected Map<Object, DynamicObject> loadFromCache(Object[] pkArray, String entityName) {
        return BusinessDataServiceHelper.loadFromCache((Object[])pkArray, (String)entityName);
    }

    protected Map<Object, DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters, String orderBy) {
        return BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBy);
    }

    /*
     * WARNING - void declaration
     */
    private void doSearch(String nodeId, String searchText) {
        void var12_20;
        String pageType;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        TreeNode rootNode = this.getRootNode();
        TreeNode currNode = rootNode.getTreeNode(nodeId, 10);
        if (currNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractGuidPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashSet<String> appIds = new HashSet<String>(10);
        boolean checkable = true;
        String type = "";
        if (ROOT_NODE.equals(currNode.getParentid())) {
            checkable = false;
            type = KEY_MESSAGE_TYPE_CLOUD;
        } else {
            DynamicObject bizApp = this.loadSingleFromCache(nodeId, BOS_DEVPORTAL_BIZ_APP);
            String masterId = bizApp == null ? "" : bizApp.getString(MASTER_ID);
            String isv = bizApp == null ? "" : bizApp.getString("isv");
            String string = ISVServiceHelper.getISVInfo().getId();
            if (StringUtils.isBlank((CharSequence)masterId)) {
                type = KEY_MESSAGE_TYPE_ORIGIN;
                if (this.isExt()) {
                    checkable = false;
                }
            } else if (!string.equals(isv)) {
                type = KEY_MESSAGE_TYPE_ECOLOGICAL;
                checkable = false;
            }
            if (!this.isExt() && !string.equals(isv)) {
                type = KEY_MESSAGE_TYPE_ECOLOGICAL;
                checkable = false;
            }
            appIds.add(nodeId);
        }
        List children = rootNode.getChildren();
        if (children == null || children.isEmpty()) {
            checkable = false;
            type = KEY_MESSAGE_TYPE_NODATA;
        }
        if (!checkable) {
            this.changeListView(false, type);
            this.refreshEntryGrid(null);
            return;
        }
        this.changeListView(true, "");
        Map<Object, DynamicObject> bizApps = this.loadFromCache(appIds.toArray(), BOS_DEVPORTAL_BIZ_APP);
        for (Map.Entry entry : bizApps.entrySet()) {
            DynamicObject app = (DynamicObject)entry.getValue();
            String inheritPath = app.getString("inheritpath");
            if (!StringUtils.isNotBlank((CharSequence)inheritPath)) continue;
            List<String> pathList = Arrays.asList(inheritPath.split(","));
            pathList.stream().forEach(key -> appIds.add((String)key));
        }
        qFilters.add(new QFilter(KEY_BIZ_APP_ID, "in", appIds));
        if (!"".equals(searchText)) {
            String formatSearchText = String.format("%s%s%s", "%", searchText, "%");
            QFilter qFilter = new QFilter("name", "like", (Object)formatSearchText);
            qFilter.or(new QFilter("number", "like", (Object)formatSearchText));
            qFilters.add(qFilter);
        }
        if (StringUtils.isBlank((CharSequence)(pageType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PAGE_TYPE)))) {
            pageType = PageType.EntityObject.getValue();
        }
        List<String> list = DevportalModelTypes.getModelTypesByType(pageType, false);
        String terminalType = (String)this.getView().getFormShowParameter().getCustomParam("pcOrMobile");
        if ("mobile".equals(terminalType)) {
            if ("5".equals(pageType)) {
                List<String> list2 = Collections.singletonList("MobileBillFormModel");
            } else {
                List<String> list3 = Arrays.asList("MobileFormModel", "MobUserGuideFormModel");
            }
        } else if ("pc".equals(terminalType)) {
            list.removeIf(item -> item.startsWith("Mob"));
        }
        qFilters.add(new QFilter(KEY_MODEL_TYPE, "in", (Object)var12_20));
        if (!this.isExt()) {
            qFilters.add(new QFilter(MASTER_ID, "in", (Object)new String[]{"null", " "}));
        }
        Map<Object, DynamicObject> bosFormMeta = this.loadFromCache(BOS_FORM_META, "bizappid,modeltype,type,basedatafield,isv,masterid,inheritpath", qFilters.toArray(new QFilter[0]), "number desc");
        String bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_UNITID);
        Set<Object> formIds = new HashSet(16);
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            String sql = "select fformid from t_meta_bizunitrelform where fbizunitid = ?";
            Object[] param = new Object[]{bizUnitId};
            formIds = this.getDBQuery(sql, param);
        }
        HashSet formIdSet = formIds;
        if ("5".equals(pageType)) {
            ArrayList<DynamicObject> list4;
            if (this.isExt()) {
                list4 = new ArrayList(16);
                for (Map.Entry<Object, DynamicObject> keyValue : bosFormMeta.entrySet()) {
                    DynamicObject formData = keyValue.getValue();
                    if (keyValue.getKey().equals(formData.getString("basedatafield.id")) || !formIdSet.isEmpty() && !formIdSet.contains(keyValue.getKey().toString())) continue;
                    list4.add(keyValue.getValue());
                }
            } else {
                list4 = new ArrayList<DynamicObject>(bosFormMeta.values());
            }
            this.refreshEntryGrid(list4);
        } else {
            Map<Object, DynamicObject> map = bosFormMeta.entrySet().stream().filter(r -> r.getKey().equals(((DynamicObject)r.getValue()).getString("basedatafield.id")) && (StringUtils.isBlank((CharSequence)bizUnitId) || formIdSet.contains(r.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Collection<DynamicObject> values = map.values();
            this.valueList = new ArrayList<DynamicObject>(values);
            this.refreshEntryGrid(this.valueList);
        }
    }

    protected Set<String> getDBQuery(String sql, Object[] param) {
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])param, rs -> {
            HashSet<String> ids = new HashSet<String>(16);
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            return ids;
        });
    }

    private void IteratorNode(List<TreeNode> nodes, Set<String> appIds) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (TreeNode node : nodes) {
            appIds.add(node.getId());
            List children = node.getChildren();
            if (children == null) continue;
            this.IteratorNode(children, appIds);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(CACHE_TREE_NODES);
        this.getPageCache().remove(CACHE_JSON_VALUE);
        this.getPageCache().remove(CACHE_ID_MASTER);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int index = event.getRowIndex();
        String formId = (String)this.getModel().getValue(FORM_ID, index);
        DevportalUtil.gotoEntityDesigner((IFormView)this.getView(), (String)formId);
    }

    private void changeListView(boolean isShowList, String type) {
        if (isShowList) {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getEntryEntityKey()});
            this.getView().setVisible(Boolean.FALSE, new String[]{"showtips"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getEntryEntityKey()});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showtips"});
            String message = "";
            switch (type) {
                case "cloud": {
                    message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u8282\u70b9\u3002", (String)"AbstractGuidPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "original": {
                    message = ResManager.loadKDString((String)"\u539f\u5e94\u7528\u4e0d\u5141\u8bb8\u6269\u5c55\u3002", (String)"AbstractGuidPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "ecological": {
                    message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u5f00\u53d1\u5546\u7684\u6269\u5c55\u5e94\u7528\u3002", (String)"AbstractGuidPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "nodata": {
                    if (this.isExt()) {
                        message = ResManager.loadKDString((String)"\u6682\u65e0\u6269\u5c55\u5e94\u7528\uff0c\u8bf7\u6269\u5c55\u5e94\u7528\u540e\u64cd\u4f5c\u3002", (String)"AbstractGuidPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                        break;
                    }
                    message = ResManager.loadKDString((String)"\u6682\u65e0\u5e94\u7528\uff0c\u8bf7\u65b0\u5efa\u5e94\u7528\u540e\u64cd\u4f5c\u3002", (String)"AbstractGuidPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                    break;
                }
            }
            Label label = (Label)this.getControl("labelap1");
            label.setText(message);
        }
    }

    protected String getEntryEntityKey() {
        return "entryentity";
    }

    protected boolean isExt() {
        return true;
    }
}

