/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.isv.ISVService;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BizGuidTreeBuilder {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String ISV = "isv";
    private static final String MASTER_ID = "masterid";
    private static final String ROOT_NODE = "rootNode";
    private static final String BIZ_CLOUD = "bizcloud";
    private static final String BOS_DEVPORTAL_BIZ_APP = "bos_devportal_bizapp";
    protected static final String KEY_KINGDEE = "kingdee";

    protected TreeNode buildTreeNodes(IFormView formView, String bizAppId, boolean isExt) {
        String isv;
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        if (isExt) {
            qfilters.add(new QFilter(TYPE, "=", (Object)"2"));
        }
        if (KEY_KINGDEE.equals(isv = ISVService.getISVInfo().getId())) {
            qfilters.add(new QFilter(ISV, "in", (Object)new String[]{KEY_KINGDEE, " "}));
        } else {
            qfilters.add(new QFilter(ISV, "=", (Object)isv));
        }
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            qfilters.add(new QFilter(ID, "=", (Object)bizAppId));
        } else {
            qfilters.add(new QFilter(ID, "in", this.getHasDataAppIds(formView, isExt)));
        }
        DynamicObjectCollection appObjects = QueryServiceHelper.query((String)BOS_DEVPORTAL_BIZ_APP, (String)"id, bizcloud,masterid", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
        HashSet<String> appIds = new HashSet<String>(16);
        HashSet<String> cloudIds = new HashSet<String>(16);
        for (DynamicObject app : appObjects) {
            appIds.add((String)app.get(ID));
            cloudIds.add((String)app.get(BIZ_CLOUD));
            String masterId = app.getString(MASTER_ID);
            if (!StringUtils.isNotBlank((CharSequence)masterId)) continue;
            appIds.add(masterId);
        }
        TreeNode root = new TreeNode();
        root.setId(ROOT_NODE);
        root.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"BizGuidTreeBuilder_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        this.getCloudData(allNodes, cloudIds);
        this.getAppData(allNodes, appIds);
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            root.addChild(node);
        }
        return root;
    }

    private List<TreeNode> getCloudData(Map<String, TreeNode> allNodes, Set<String> cloudIds) {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>(10);
        if (cloudIds == null || cloudIds.isEmpty()) {
            return cloudNode;
        }
        Map bizClouds = BusinessDataServiceHelper.loadFromCache((Object[])cloudIds.toArray(), (String)"bos_devportal_bizcloud");
        ArrayList bizCloudList = new ArrayList(10);
        if (bizClouds != null) {
            bizCloudList.addAll(bizClouds.values());
            Collections.sort(bizCloudList, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    int sequence2;
                    int sequence1 = o1.getInt("sequence");
                    if (sequence1 < (sequence2 = o2.getInt("sequence"))) {
                        return -1;
                    }
                    if (sequence1 == sequence2) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        for (DynamicObject cloud : bizCloudList) {
            TreeNode node = new TreeNode();
            node.setId(cloud.getString(ID));
            node.setParentid(ROOT_NODE);
            node.setText(cloud.getString(NAME));
            node.setCheckable(false);
            cloudNode.add(node);
            allNodes.put(node.getId(), node);
        }
        return cloudNode;
    }

    private List<TreeNode> getAppData(Map<String, TreeNode> allNodes, Set<String> appIds) {
        ArrayList<TreeNode> appNode = new ArrayList<TreeNode>(10);
        if (appIds == null || appIds.isEmpty()) {
            return appNode;
        }
        Map bizApps = BusinessDataServiceHelper.loadFromCache((Object[])appIds.toArray(), (String)BOS_DEVPORTAL_BIZ_APP);
        for (DynamicObject app : bizApps.values()) {
            String parentId;
            String masterId = app.getString(MASTER_ID);
            DynamicObject cloud = app.getDynamicObject(BIZ_CLOUD);
            String string = parentId = cloud == null ? "" : cloud.getString(ID);
            if (StringUtils.isNotBlank((CharSequence)masterId)) {
                parentId = masterId;
            }
            TreeNode node = new TreeNode();
            node.setId(app.getString(ID));
            node.setParentid(parentId);
            node.setText(app.getString(NAME));
            appNode.add(node);
            allNodes.put(node.getId(), node);
        }
        return appNode;
    }

    protected Set<String> getHasDataAppIds(IFormView formView, boolean isExt) {
        String pageType = (String)formView.getFormShowParameter().getCustomParam("pageType");
        if (StringUtils.isBlank((CharSequence)pageType)) {
            pageType = PageType.EntityObject.getValue();
        }
        List<String> modelTypes = DevportalModelTypes.getModelTypesByType(pageType, false);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("modeltype", "in", modelTypes));
        if (!isExt) {
            qFilters.add(new QFilter(MASTER_ID, "in", (Object)new String[]{"null", " "}));
        }
        Map bosFormMeta = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"bizappid,modeltype,basedatafield,isv,masterid,inheritpath", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"number desc");
        HashSet<String> appIds = new HashSet<String>(10);
        if (bosFormMeta == null) {
            return appIds;
        }
        for (Map.Entry entry : bosFormMeta.entrySet()) {
            DynamicObject form = (DynamicObject)entry.getValue();
            String bizAppId = form.getString("bizappid");
            if (StringUtils.isBlank((CharSequence)bizAppId)) continue;
            appIds.add(bizAppId);
        }
        Map extApps = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZ_APP, (String)ID, (QFilter[])new QFilter[]{new QFilter(MASTER_ID, "in", appIds)});
        if (extApps != null) {
            for (Map.Entry entry : extApps.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                String id = dynamicObject.getString(ID);
                appIds.add(id);
            }
        }
        return appIds;
    }
}

