/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.page.AbstractGuidPlugin;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BizInheritGuidePlugin
extends AbstractGuidPlugin
implements SearchEnterListener,
HyperLinkClickListener,
TreeNodeClickListener {
    private static final String APP = "app";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String NEXT = "next";
    private static final String NUMBER = "number";
    private static final String ISV = "isv";
    private static final String TITLE = "title";
    private static final String FORM_ID = "formid";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_MODEL_TYPE = "modeltype";
    private static final String KEY_PAGE_TYPE = "pageType";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String INHERIT_BUSINESS_OBJECT = "inheritBusinessObject_callBack";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String MODELTYPE = "modeltype";
    private static final String ISINHERIT = "isinherit";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{NEXT});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String title = this.getCaption();
        Label inherit = (Label)this.getView().getControl(TITLE);
        inherit.setText(title);
    }

    @Override
    protected void refreshEntryGrid(List<DynamicObject> values) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizAppId");
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PAGE_TYPE);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        rows.clear();
        if (values == null || values.isEmpty()) {
            this.getView().updateView(ENTRY_ENTITY);
            return;
        }
        ArrayList<DynamicObject> enableList = new ArrayList<DynamicObject>();
        for (DynamicObject val : values) {
            String type = val.getString(TYPE);
            String masterId = val.getString("masterid");
            if (!StringUtils.isBlank((CharSequence)type) && !type.equals("0") || !StringUtils.isBlank((CharSequence)masterId)) continue;
            enableList.add(val);
        }
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(ENTRY_ENTITY);
        int seq = 1;
        for (DynamicObject val : enableList) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            DynamicObject entity = (DynamicObject)val.get("basedatafield");
            String entityId = entity == null ? "" : entity.getPkValue().toString();
            row.set("seq", (Object)seq);
            row.set(NUMBER, val.get(NUMBER));
            row.set(NAME, (Object)val.get(NAME).toString());
            String type = (String)val.get("modeltype");
            if (StringUtils.equals((CharSequence)"5", (CharSequence)pageType)) {
                row.set(TYPE, (Object)ResManager.loadKDString((String)"\u8868\u5355+\u5217\u8868", (String)"BizInheritGuidePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                row.set("layouttype", (Object)type);
            } else {
                row.set(TYPE, (Object)type);
            }
            row.set("terminal", (Object)this.getTerminalByModelType(type));
            row.set(ISV, val.get(ISV));
            row.set(APP, (Object)bizAppId);
            row.set(FORM_ID, (Object)entityId);
            row.set("id", (Object)val.getString("id"));
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private String getTerminalByModelType(String modelType) {
        String terminal = "";
        if (StringUtils.isBlank((CharSequence)modelType)) {
            return terminal;
        }
        terminal = "MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileListModel".equals(modelType) ? "mobile" : "pc";
        return terminal;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int index = evt.getRowIndex();
        String formId = (String)this.getModel().getValue("id", index);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PAGE_TYPE);
        pageType = StringUtils.isBlank((CharSequence)pageType) ? PageType.EntityObject.getValue() : pageType;
        GotoDesignerUtils.gotoDesigner(pageType, this.getView(), formId);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (NEXT.equals(key)) {
            this.next();
        }
    }

    private void next() {
        String selectFields;
        DynamicObject parent;
        boolean isInHerit;
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BizInheritGuidePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        String name = (String)this.getModel().getValue(NAME, rowIndex);
        String number = (String)this.getModel().getValue(NUMBER, rowIndex);
        String formId = (String)this.getModel().getValue(FORM_ID, rowIndex);
        String id = (String)this.getModel().getValue("id", rowIndex);
        String modeltype = (String)this.getModel().getValue(TYPE, rowIndex);
        if (ResManager.loadKDString((String)"\u8868\u5355+\u5217\u8868", (String)"BizInheritGuidePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]).equals(modeltype)) {
            modeltype = (String)this.getModel().getValue("layouttype", rowIndex);
        }
        boolean bl = isInHerit = (parent = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)BOS_FORMMETA, (String)(selectFields = "isinherit,modeltype"))) == null ? true : parent.getBoolean(ISINHERIT);
        if (!isInHerit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u88ab\u7ee7\u627f\u3002", (String)"BizInheritGuidePlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if ("PCLayout".equals(modeltype) && parent != null) {
            modeltype = parent.getString("modeltype");
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_devpn_inheritbusobj2");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(FORM_ID, (Object)formId);
        showParameter.setCustomParam("parentId", (Object)id);
        showParameter.setCustomParam(APP, (Object)this.getCurrNodeId());
        showParameter.setCustomParam(NUMBER, (Object)number);
        showParameter.setCustomParam(NAME, (Object)name);
        showParameter.setCustomParam("modeltype", (Object)modeltype);
        showParameter.setCaption(this.getCaption());
        showParameter.setCustomParam("layoutCreationMethod", this.getView().getFormShowParameter().getCustomParam("newType"));
        showParameter.setCustomParam("bizUnitId", this.getView().getFormShowParameter().getCustomParam("fungroup"));
        showParameter.setCustomParam(KEY_PAGE_TYPE, this.getView().getFormShowParameter().getCustomParam(KEY_PAGE_TYPE));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, INHERIT_BUSINESS_OBJECT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object data = event.getReturnData();
        if (data instanceof Map) {
            Map map;
            String actionId = event.getActionId();
            if (INHERIT_BUSINESS_OBJECT.equals(actionId) && (map = (Map)event.getReturnData()) != null && map.get(KEY_SUCCESS) != null) {
                if (((Boolean)map.get(KEY_SUCCESS)).booleanValue()) {
                    String formId = (String)map.get("bizpageid");
                    String bizUnitId = (String)map.get("bizunitid");
                    String bizAppId = (String)map.get("bizappid");
                    HashMap<String, String> returnData = new HashMap<String, String>(3);
                    returnData.put("bizUnitId", bizUnitId);
                    returnData.put("bizPageId", formId);
                    returnData.put("bizAppId", bizAppId);
                    this.getView().returnDataToParent(returnData);
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(map.get(KEY_MESSAGE).toString());
                }
            }
        } else if (data == null) {
            this.getView().close();
        }
    }

    private String getCaption() {
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PAGE_TYPE);
        String content = ResManager.loadKDString((String)"\u7ee7\u627f\u4e1a\u52a1\u5bf9\u8c61", (String)"BizInheritGuidePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)pageType)) {
            switch (pageType) {
                case "0": {
                    content = ResManager.loadKDString((String)"\u7ee7\u627f\u4e1a\u52a1\u5bf9\u8c61", (String)"BizInheritGuidePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "1": {
                    content = ResManager.loadKDString((String)"\u7ee7\u627f\u9875\u9762", (String)"BizInheritGuidePlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "2": {
                    content = ResManager.loadKDString((String)"\u7ee7\u627f\u62a5\u8868", (String)"BizInheritGuidePlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "3": {
                    content = ResManager.loadKDString((String)"\u7ee7\u627f\u53c2\u6570", (String)"BizInheritGuidePlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    break;
                }
                case "5": {
                    content = this.getContent();
                    break;
                }
            }
        }
        return content;
    }

    private String getContent() {
        String content = ResManager.loadKDString((String)"\u7ee7\u627f\u5e03\u5c40", (String)"BizInheritGuidePlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        String newType = (String)this.getView().getFormShowParameter().getCustomParam("newType");
        if ("2".equals(newType)) {
            content = ResManager.loadKDString((String)"\u590d\u5236\u5e03\u5c40", (String)"BizInheritGuidePlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        }
        return content;
    }

    @Override
    protected String getEntryEntityKey() {
        return ENTRY_ENTITY;
    }

    @Override
    protected boolean isExt() {
        return false;
    }
}

