/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.PageType;

public class BizObjectLayoutPageUtils {
    public static List<String> queryBizObjectLayout(String entityId, boolean onlyCreateRelation) {
        SqlBuilder objectPageBuilder = new SqlBuilder();
        objectPageBuilder.append("select fformid from T_META_BIZOBJLAYOUTREL where ", new Object[0]).appendIn("fentityid", (Object[])new String[]{entityId});
        List createdFormIds = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)objectPageBuilder, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                String formId = rs.getString("fformid");
                if (!StringUtils.isNotBlank(ids)) continue;
                ids.add(formId);
            }
            return ids;
        });
        if (onlyCreateRelation) {
            createdFormIds.remove(entityId);
            return createdFormIds;
        }
        createdFormIds.add(entityId);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        String masterId = StringUtils.isBlank((CharSequence)entityMetadata.getMasterId()) ? entityId : entityMetadata.getMasterId();
        SqlBuilder layoutBuilder = new SqlBuilder();
        layoutBuilder.append("select fid,fentityid from t_meta_formdesign where ", new Object[0]).appendIn("fentityid", (Object[])new String[]{masterId});
        List allFormIds = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)layoutBuilder, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                String formId = rs.getString("fid");
                String entity = rs.getString("fentityid");
                if (!StringUtils.isNotBlank(ids) || StringUtils.equals((CharSequence)formId, (CharSequence)entity)) continue;
                ids.add(formId);
            }
            return ids;
        });
        SqlBuilder extQueryBuilder = new SqlBuilder();
        extQueryBuilder.append("select fid from t_meta_entitydesign where ftype =? and fparentid = ?", (Object[])new SqlParameter[]{new SqlParameter(":ftype", 1, (Object)Character.valueOf('2')), new SqlParameter(":fparentid", 12, (Object)entityId)});
        boolean existExt = (Boolean)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)extQueryBuilder, resultSet -> resultSet.next());
        if (existExt) {
            return createdFormIds;
        }
        allFormIds.removeAll(createdFormIds);
        if (!allFormIds.isEmpty()) {
            SqlBuilder sbuilder = new SqlBuilder();
            sbuilder.append("select fformid from T_META_BIZOBJLAYOUTREL where ", new Object[0]).appendIn("fformid", allFormIds.toArray());
            DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sbuilder, rs -> {
                while (rs.next()) {
                    allFormIds.remove(rs.getString("fformid"));
                }
                return null;
            });
        }
        allFormIds.addAll(createdFormIds);
        List<String> distinct = allFormIds.stream().distinct().collect(Collectors.toList());
        return distinct;
    }

    public static List<String> getExtFormIds(String entityId) {
        SqlBuilder entityBuilder = new SqlBuilder();
        entityBuilder.append("select fmasterid from t_meta_entitydesign where fistemplate='0' and fid=?", new Object[]{new SqlParameter(":fid", 12, (Object)entityId)});
        Set masterIds = (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)entityBuilder, rs -> {
            HashSet<String> ids = new HashSet<String>(10);
            while (rs.next()) {
                String masterId = rs.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)masterId)) continue;
                ids.add(masterId);
            }
            return ids;
        });
        masterIds.add(entityId);
        List<String> formTypes = DevportalModelTypes.getModelTypesByType(PageType.LayOut.getValue());
        SqlBuilder entityBuilder2 = new SqlBuilder();
        entityBuilder2.append("select fid from t_meta_entitydesign where ", new Object[0]).appendIn("fmodeltype", formTypes.toArray()).append(" and (", new Object[0]).appendIn("fid", masterIds.toArray()).append(" or ", new Object[0]).appendIn("fmasterid", masterIds.toArray()).append(" )", new Object[0]);
        Set entityIds = (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)entityBuilder2, rs -> {
            HashSet<String> ids = new HashSet<String>(10);
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            return ids;
        });
        if (entityIds.isEmpty()) {
            entityIds.add(entityId);
        }
        SqlBuilder formBuilder = new SqlBuilder();
        formBuilder.append("select fid from t_meta_formdesign where ", new Object[0]).appendIn("fmodeltype", formTypes.toArray()).append(" and ", new Object[0]).appendIn("fentityid", entityIds.toArray()).append(" ORDER BY fmodifydate desc", new Object[0]);
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)formBuilder, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                String fid = rs.getString(1);
                ids.add(fid);
            }
            return ids;
        });
    }

    public List<String> getExtAndInhFormIds(String entityId) {
        List<String> formTypes = DevportalModelTypes.getModelTypesByType(PageType.LayOut.getValue());
        SqlBuilder entityBuilder = new SqlBuilder();
        entityBuilder.append("select fid,finheritpath from t_meta_entitydesign where ", new Object[0]).append("fistemplate='0'", new Object[0]).append(" and (", new Object[0]).append("fid=?", new Object[]{new SqlParameter(":fid", 12, (Object)entityId)}).append(" or ", new Object[0]).append("finheritpath like ?)", new Object[]{new SqlParameter(":finheritpath", 12, (Object)("%" + entityId + "%"))});
        Set entityIds = (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)entityBuilder, rs -> {
            HashSet<String> ids = new HashSet<String>(10);
            while (rs.next()) {
                String fid = rs.getString(1);
                ids.add(fid);
                String finheritpath = rs.getString(2);
                if (finheritpath.isEmpty()) continue;
                ids.addAll(Arrays.asList(finheritpath.split(",")));
            }
            return ids;
        });
        SqlBuilder formBuilder = new SqlBuilder();
        formBuilder.append("select fid,finheritpath from t_meta_formdesign where ", new Object[0]).append("fistemplate='0'", new Object[0]).append(" and ", new Object[0]).appendIn("fmodeltype", formTypes.toArray()).append(" and ", new Object[0]).appendIn("fentityid", entityIds.toArray());
        Set formIds = (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)formBuilder, rs -> {
            HashSet<String> ids = new HashSet<String>(10);
            while (rs.next()) {
                String fid = rs.getString(1);
                ids.add(fid);
                String finheritpath = rs.getString(2);
                if (finheritpath.isEmpty()) continue;
                ids.addAll(Arrays.asList(finheritpath.split(",")));
            }
            return ids;
        });
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(formIds);
        return list;
    }
}

