/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.newdevportal.page.GetPageTemplatePlugin;
import kd.bos.url.UrlService;

public class ByPublicTemplateCreateLastPlugin
extends AbstractFormPlugin
implements ListboxClickListener,
RowClickEventListener {
    private static final String BTN_NEXT = "next";
    private static final String ID = "id";
    private static final String APP = "app";
    private static final String TYPE = "type";
    private static final String PAGE_TYPE = "pageType";
    private static final String BASE_DATA = "basedata";
    private static final String BILL = "bill";
    private static final String LOG_MODEL = "logmodel";
    private static final String DYNAMIC_FORM = "dynamicform";
    private static final String CARD = "card";
    private static final String REPORT = "report";
    private static final String PARAMETER = "parameter";
    private static final String BTN_PC = "pc";
    private static final String BTN_MOBILE = "mobile";
    private static final String MODEL_TYPE = "modeltype";
    private static final String FUN_GROUP = "fungroup";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String PC_OR_MOBILE = "pcOrMobile";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_NEXT});
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void listboxClick(ListboxEvent event) {
        this.setPageTemplate(event.getItemId());
        this.selectFirst();
    }

    public void afterCreateNewData(EventObject e) {
        this.initNewPage();
        Map<String, List<String>> imageKeyAndDesc = GetPageTemplatePlugin.getImageKeyAndDesc();
        this.getPageCache().put("imageKeyAndDesc", SerializationUtils.toJsonString(imageKeyAndDesc));
    }

    public void afterBindData(EventObject e) {
        this.selectFirst();
    }

    private void selectFirst() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.selectRows(0);
    }

    private void initNewPage() {
        String parameter = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_TYPE);
        String terminalType = (String)this.getView().getFormShowParameter().getCustomParam(PC_OR_MOBILE);
        this.getPageCache().put(PC_OR_MOBILE, terminalType);
        switch (parameter.toLowerCase(Locale.ENGLISH)) {
            case "0": {
                this.initBusinessObjListBox();
                break;
            }
            case "1": {
                this.initPageListBox(terminalType);
                break;
            }
            case "2": {
                this.setPageTemplate(REPORT);
                break;
            }
            case "3": {
                this.setPageTemplate(PARAMETER);
                break;
            }
        }
    }

    private void initBusinessObjListBox() {
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem node = new ListboxItem();
        node.setId(BASE_DATA);
        node.setContent(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ByPublicTemplateCreateLastPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(BILL);
        node.setContent(ResManager.loadKDString((String)"\u5355\u636e", (String)"ByPublicTemplateCreateLastPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        listbox.addItems(listboxItems);
        this.setPageTemplate(BASE_DATA);
    }

    private void initPageListBox(String terminalType) {
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem node = new ListboxItem();
        node.setId(DYNAMIC_FORM);
        node.setContent(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355", (String)"ByPublicTemplateCreateLastPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        if (BTN_PC.equals(terminalType)) {
            node = new ListboxItem();
            node.setId(CARD);
            node.setContent(ResManager.loadKDString((String)"\u5361\u7247", (String)"ByPublicTemplateCreateLastPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            listboxItems.add(node);
            listbox.addItems(listboxItems);
        }
        this.setPageTemplate(DYNAMIC_FORM);
    }

    private void setPageTemplate(String pageType) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        Set<Object> pageTemplate = new LinkedHashSet(7);
        switch (pageType) {
            case "basedata": {
                pageTemplate = GetPageTemplatePlugin.getBaseDataTplType();
                break;
            }
            case "bill": {
                pageTemplate = GetPageTemplatePlugin.getBillTplType();
                break;
            }
            case "logmodel": {
                pageTemplate = GetPageTemplatePlugin.getLogModelTplType();
                break;
            }
            case "dynamicform": {
                pageTemplate = GetPageTemplatePlugin.getDynamicFormPCTplType();
                String pcOrMobile = this.getPageCache().get(PC_OR_MOBILE);
                if (!BTN_MOBILE.equalsIgnoreCase(pcOrMobile)) break;
                pageTemplate = GetPageTemplatePlugin.getDynamicFormMobileTplType();
                break;
            }
            case "card": {
                pageTemplate = GetPageTemplatePlugin.getCardTplType();
                break;
            }
            case "report": {
                pageTemplate = GetPageTemplatePlugin.getReportTplType();
                break;
            }
            case "parameter": {
                pageTemplate = GetPageTemplatePlugin.getParameterTplType();
                break;
            }
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, pageTemplate.size());
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_ENTITY);
        Iterator<Object> iterator = pageTemplate.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            this.getModel().setValue(TYPE, next.get(TYPE), i);
            this.getModel().setValue(ID, next.get(ID), i);
            this.getModel().setValue(MODEL_TYPE, next.get("modelType"), i);
            cardEntry.setCustomProperties(ENTRY_ENTITY, i, this.toImageKey((String)next.get("vectorap")));
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private Map<String, Object> toImageKey(String imageKey) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        String domainUrl = UrlService.getDomainContextUrl();
        map.put("imageKey", domainUrl + imageKey);
        root.put("smallimageap", map);
        return root;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_NEXT.equals(key)) {
            this.next();
        }
    }

    private void next() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"ByPublicTemplateCreateLastPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String appId = (String)parameter.getCustomParam(APP);
        String funGroup = (String)parameter.getCustomParam(FUN_GROUP);
        String modelType = (String)this.getModel().getValue(MODEL_TYPE);
        String id = (String)this.getModel().getValue(ID);
        String type = (String)this.getModel().getValue(TYPE);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_devpn_pubtplnext");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(APP, (Object)appId);
        formShowParameter.setCustomParam(FUN_GROUP, (Object)funGroup);
        formShowParameter.setCustomParam(MODEL_TYPE, (Object)modelType);
        formShowParameter.setCustomParam(ID, (Object)id);
        formShowParameter.setCustomParam(TYPE, (Object)type);
        formShowParameter.setCustomParam(PC_OR_MOBILE, (Object)this.getPageCache().get(PC_OR_MOBILE));
        formShowParameter.setCustomParam("imageKey", (Object)this.getPageCache().get("imageKey_cache"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "next_closeCallBack"));
        this.getView().showForm(formShowParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        String id = (String)this.getModel().getValue(ID);
        String type = (String)this.getModel().getValue(TYPE);
        if (ResManager.loadKDString((String)"\u7a7a\u767d\u9875\u9762", (String)"ByPublicTemplateCreateLastPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]).equals(type)) {
            type = BTN_MOBILE.equals(this.getPageCache().get(PC_OR_MOBILE)) ? type + "_mobile" : type + "_pc";
        }
        List list = new ArrayList(2);
        String imageKeyAndDesc = this.getPageCache().get("imageKeyAndDesc");
        Map map = (Map)SerializationUtils.fromJsonString((String)imageKeyAndDesc, Map.class);
        list = StringUtils.isBlank((CharSequence)id) || "blankPage".equals(id) ? (List)map.get(type) : (List)map.get(id);
        String imageKey = (String)list.get(0);
        this.getPageCache().put("imageKey_cache", imageKey);
        IImage image = (IImage)this.getControl("imageap");
        image.setUrl(imageKey);
        this.getModel().setValue("textareafield", list.get(1));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            this.getView().close();
        } else if (returnData instanceof Map) {
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

