/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class ByTemplateCreate
extends AbstractFormPlugin
implements ListboxClickListener,
HyperLinkClickListener {
    private static final String ID = "id";
    private static final String ENTITY_ID = "entityid";
    private static final String DESC = "desc";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String CLOUD = "cloud";
    private static final String BTN_NEXT = "next";
    private static final String MODEL_TYPE = "modeltype";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BIZ_APP_ID = "app";
    private static final String BIZ_UNIT_ID = "fungroup";
    private static final String MODELNUMBER = "modelnumber";
    private static final String MODELNAME = "modelname";
    private static final String MODEL_TYPE_CACHE = "modelTypeCache";
    private static final String IS_MODEL = "ismodel";
    private static final String PC_OR_MOBILE = "pcOrMobile";
    private static final String PAGE_TYPE = "pageType";
    private static final String BASE_DATA = "basedata";
    private static final String BILL = "bill";
    private static final String LOG_MODEL = "logmodel";
    private static final String DYNAMIC_FORM = "dynamicform";
    private static final String CARD = "card";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_NEXT});
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String bizCloudId = null;
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            bizCloudId = BizCloudServiceHelp.getBizCloudByAppID((String)appId).getString(ID);
        }
        this.getPageCache().put(CLOUD, bizCloudId);
        this.initNewPage();
        this.initCloudComboField(bizCloudId);
    }

    private void initNewPage() {
        String parameter = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_TYPE);
        String terminalType = (String)this.getView().getFormShowParameter().getCustomParam(PC_OR_MOBILE);
        switch (parameter.toLowerCase(Locale.ENGLISH)) {
            case "0": {
                this.initBusinessObjListBox();
                break;
            }
            case "1": {
                this.initPageListBox(terminalType);
                break;
            }
            case "2": {
                this.loadTemplate("ReportFormModel", this.getPageCache().get(CLOUD));
                break;
            }
            case "3": {
                this.loadTemplate("ParameterFormModel", this.getPageCache().get(CLOUD));
                break;
            }
        }
    }

    private void loadTemplate(String pageType, String bizCloudId) {
        this.getPageCache().put(MODEL_TYPE_CACHE, pageType);
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRY_ENTITY);
        Set<Map<String, Object>> template = this.getTemplate(pageType, bizCloudId);
        if (template == null || template.isEmpty()) {
            this.getView().updateView(ENTRY_ENTITY);
            return;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, template.size());
        Iterator<Map<String, Object>> iterator = template.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            model.setValue(ID, next.get(ID), i);
            model.setValue(ENTITY_ID, next.get(ENTITY_ID), i);
            model.setValue(NAME, next.get(NAME), i);
            model.setValue(NUMBER, next.get(NUMBER), i);
            model.setValue(MODEL_TYPE, next.get(MODEL_TYPE), i);
            if ("1".equals(next.get(IS_MODEL))) {
                model.setValue(MODELNUMBER, next.get(MODELNUMBER), i);
                model.setValue(MODELNAME, next.get(MODELNAME), i);
            }
            ++i;
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private List<Object> getModelAppIdByCloudId(String cloudid) {
        String sql = "select t3.fid from t_meta_bizcloudentry t1 inner join t_meta_bizapp t3 on t3.fbizcloudid  = t1.fid inner join t_meta_bizcloud t2 on t1.frefcloudid  = t2.fid  where t2.fid =? ";
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":ID", 12, (Object)cloudid)};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParameters, rs -> {
            ArrayList<String> list = new ArrayList<String>(16);
            while (rs.next()) {
                list.add(rs.getString("FID"));
            }
            return list;
        });
    }

    private Set<Map<String, Object>> getTemplate(String modelType, String cloudId) {
        if (StringUtils.isBlank((CharSequence)cloudId)) {
            return null;
        }
        List<Object> appIdList = this.getModelAppIdByCloudId(cloudId);
        Map appMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("bizcloud", "=", (Object)cloudId)});
        for (DynamicObject appInfo : appMap.values()) {
            appIdList.add(appInfo.get(ID));
        }
        if (appIdList.isEmpty()) {
            return null;
        }
        final HashSet<Map<String, Object>> templateArray = new HashSet<Map<String, Object>>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select a.fnumber,b.fname,a.fmodeltype,c.fisinherit,c.fid,c.fentityid,cloud.fnumber as modelnumber,cloud_l.fname as modelname,cloud.fismodel as ismodel", new Object[0]).append(" from t_meta_entitydesign a ", new Object[0]).append(" inner join t_meta_entitydesign_l b on a.fnumber=b.fnumber and b.flocaleid=? ", new Object[]{new SqlParameter(":flocaleid", 12, (Object)"zh_CN")}).append(" inner join t_meta_formdesign c  on a.fnumber = c.fnumber  ", new Object[0]).append(" left join t_meta_bizapp app on a.fbizappid = app.fid ", new Object[0]).append(" left join t_meta_bizcloud cloud on app.fbizcloudid = cloud.fid ", new Object[0]).append(" left join t_meta_bizcloud_l cloud_l on app.fbizcloudid = cloud_l.fid and cloud_l.flocaleid=? ", new Object[]{new SqlParameter(":flocaleid", 12, (Object)"zh_CN")}).appendIn(" where a.fbizappid ", appIdList).append(" and a.fistemplate=? ", new Object[]{new SqlParameter(":fistemplate", 1, (Object)"1")}).append(" and a.fmodeltype like ? ", new Object[]{new SqlParameter(":fmdoeltype", 12, (Object)(modelType + "%"))}).append(" and c.ftype!=? ", new Object[]{new SqlParameter(":ftype", 1, (Object)"2")}).append(" order by a.fnumber asc", new Object[0]);
        DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)new ResultSetHandler<Set<Map<String, Object>>>(){

            public Set<Map<String, Object>> handle(ResultSet rs) throws KDException {
                try {
                    while (rs.next()) {
                        boolean isInherit = rs.getBoolean("fisinherit");
                        if (!isInherit) continue;
                        HashMap<String, String> template = new HashMap<String, String>(3);
                        template.put(ByTemplateCreate.NUMBER, rs.getString(1));
                        template.put(ByTemplateCreate.NAME, rs.getString(2));
                        template.put(ByTemplateCreate.MODEL_TYPE, rs.getString(3));
                        template.put(ByTemplateCreate.ID, rs.getString(5));
                        template.put(ByTemplateCreate.ENTITY_ID, rs.getString(6));
                        template.put(ByTemplateCreate.MODELNUMBER, rs.getString(ByTemplateCreate.MODELNUMBER));
                        template.put(ByTemplateCreate.MODELNAME, rs.getString(ByTemplateCreate.MODELNAME));
                        template.put(ByTemplateCreate.IS_MODEL, rs.getString(ByTemplateCreate.IS_MODEL));
                        templateArray.add(template);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
                }
                return templateArray;
            }
        });
        return templateArray;
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        String cloudId = this.getPageCache().get(CLOUD);
        switch (itemId) {
            case "dynamicform": {
                this.loadTemplate("DynamicFormModel", cloudId);
                break;
            }
            case "card": {
                this.loadTemplate("WidgetFormModel", cloudId);
                break;
            }
            case "basedata": {
                this.loadTemplate("BaseFormModel", cloudId);
                break;
            }
            case "bill": {
                this.loadTemplate("BillFormModel", cloudId);
                break;
            }
            case "logmodel": {
                this.loadTemplate("LogBillFormModel", cloudId);
                break;
            }
        }
    }

    private void initPageListBox(String terminalType) {
        if ("pc".equals(terminalType)) {
            Listbox listbox = (Listbox)this.getView().getControl("listboxap");
            ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
            ListboxItem node = new ListboxItem();
            node.setId(DYNAMIC_FORM);
            node.setContent(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355", (String)"ByTemplateCreate_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            listboxItems.add(node);
            node = new ListboxItem();
            node.setId(CARD);
            node.setContent(ResManager.loadKDString((String)"\u5361\u7247", (String)"ByTemplateCreate_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            listboxItems.add(node);
            listbox.addItems(listboxItems);
            this.loadTemplate("DynamicFormModel", this.getPageCache().get(CLOUD));
        } else {
            this.loadTemplate("MobileFormModel", this.getPageCache().get(CLOUD));
        }
    }

    private void initBusinessObjListBox() {
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem node = new ListboxItem();
        node.setId(BASE_DATA);
        node.setContent(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ByTemplateCreate_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(BILL);
        node.setContent(ResManager.loadKDString((String)"\u5355\u636e", (String)"ByTemplateCreate_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        listbox.addItems(listboxItems);
        this.loadTemplate("BaseFormModel", this.getPageCache().get(CLOUD));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String entityId = (String)this.getModel().getValue(ENTITY_ID, rowIndex);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_TYPE);
        GotoDesignerUtils.gotoDesigner(pageType, this.getView(), entityId);
    }

    public void click(EventObject evt) {
        String key = ((Button)evt.getSource()).getKey();
        if (BTN_NEXT.equals(key)) {
            this.next();
        }
    }

    private void next() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] rows = entryGrid.getEntryState().getSelectedRows();
        if (rows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ByTemplateCreate_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int row = rows[0];
        DynamicObject data = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        String number = data.getString(NUMBER);
        String modelType = data.getString(MODEL_TYPE);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID);
        String bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_UNIT_ID);
        String pageType = "pc";
        String terminalType = (String)this.getView().getFormShowParameter().getCustomParam(PC_OR_MOBILE);
        if (StringUtils.isNotBlank((CharSequence)terminalType)) {
            pageType = terminalType;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devpn_creobjbybustpl");
        parameter.setCustomParam("templateNumber", (Object)number);
        parameter.setCustomParam(PC_OR_MOBILE, (Object)pageType);
        parameter.setCustomParam("cloudId", (Object)this.getPageCache().get(CLOUD));
        parameter.setCustomParam(BIZ_APP_ID, (Object)bizAppId);
        parameter.setCustomParam(BIZ_UNIT_ID, (Object)bizUnitId);
        parameter.setCustomParam(MODEL_TYPE, (Object)modelType);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "inheritBusiness_callBack"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object data = event.getReturnData();
        if (data == null) {
            this.getView().close();
        } else if (data instanceof Map) {
            Map returnData = (Map)data;
            HashMap map = new HashMap(2);
            map.put("bizUnitId", returnData.get("bizUnitId"));
            map.put("bizPageId", returnData.get("bizPageId"));
            map.put("bizAppId", returnData.get("bizAppId"));
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private void initCloudComboField(String bizCloudId) {
        if (StringUtils.isNotBlank((CharSequence)bizCloudId)) {
            DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizcloud", (String)"id, name", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)bizCloudId)});
            String cloudName = cloud.getString(NAME);
            ComboEdit cloudCombo = (ComboEdit)this.getControl(CLOUD);
            ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(1);
            comboList.add(new ComboItem(new LocaleString(cloudName), bizCloudId));
            cloudCombo.setComboItems(comboList);
            this.getModel().setValue(CLOUD, (Object)bizCloudId);
            this.getView().setEnable(Boolean.FALSE, new String[]{CLOUD});
        } else {
            Map cloudsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"id,name,number,sequence", null, (String)"sequence asc");
            if (StringUtils.isBlank((Object)cloudsMap)) {
                return;
            }
            ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(cloudsMap.size());
            for (DynamicObject clouds : cloudsMap.values()) {
                comboList.add(new ComboItem(new LocaleString(clouds.getString(NAME)), clouds.getString(ID)));
            }
            ComboEdit cloudCombo = (ComboEdit)this.getControl(CLOUD);
            cloudCombo.setComboItems(comboList);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (CLOUD.equals(e.getProperty().getName())) {
            String modelType = this.getPageCache().get(MODEL_TYPE_CACHE);
            String cloudId = (String)this.getModel().getValue(CLOUD);
            this.getPageCache().put(CLOUD, cloudId);
            this.loadTemplate(modelType, cloudId);
        }
    }
}

