/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.PageBuilder;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.newdevportal.page.GetPageTemplatePlugin;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class CreateBusinessObjectPlugin
extends AbstractFormPlugin
implements ListboxClickListener,
BeforeF7SelectListener {
    private static final String BTN_OK = "ok";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String APP = "app";
    private static final String TYPE = "type";
    private static final String PAGE_TYPE = "pageType";
    private static final String BASE_DATA = "basedata";
    private static final String BILL = "bill";
    private static final String LOG_MODEL = "logmodel";
    private static final String DYNAMIC_FORM = "dynamicform";
    private static final String CARD = "card";
    private static final String REPORT = "report";
    private static final String PARAMETER = "parameter";
    private static final String BTN_PC = "pc";
    private static final String BTN_MOBILE = "mobile";
    private static final String TWO = "2";
    private static final String VECTOR_AP = "vectorap";
    private static final String DESCRIBE = "describe";
    private static final String MODEL_TYPE = "modelType";
    private static final String FUN_GROUP = "fungroup";
    private static final String BLANK_PAGE = "blankPage";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ISV_CHECK_RESULT = "isvcheckresult";
    private static final String KET_BIZ_FUN_UNIT_ID = "bizFunUnitId";
    private static final String FUN_GROUP_INFO_CALL_BACK = "funGroupInfoCallBack";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, FUN_GROUP, BTN_PC, BTN_MOBILE});
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
        BasedataEdit basedataBillType = (BasedataEdit)this.getControl(APP);
        basedataBillType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initNewPage();
        this.OpenFromTheApplicationDetailsPage();
    }

    private void initNewPage() {
        String parameter = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_TYPE);
        switch (parameter.toLowerCase(Locale.ENGLISH)) {
            case "0": {
                this.hideItem();
                this.initBusinessObjListBox();
                break;
            }
            case "1": {
                this.displayItem();
                this.initPageListBox();
                break;
            }
            case "2": {
                this.hideItem();
                this.setPageTemplate(REPORT);
                break;
            }
            case "3": {
                this.hideItem();
                this.setPageTemplate(PARAMETER);
                break;
            }
        }
    }

    private void initPageListBox() {
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem node = new ListboxItem();
        node.setId(DYNAMIC_FORM);
        node.setContent(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355", (String)"CreateBusinessObjectPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(CARD);
        node.setContent(ResManager.loadKDString((String)"\u5361\u7247", (String)"CreateBusinessObjectPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        listbox.addItems(listboxItems);
        this.setPageTemplate(DYNAMIC_FORM);
    }

    private void initBusinessObjListBox() {
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem node = new ListboxItem();
        node.setId(BASE_DATA);
        node.setContent(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"CreateBusinessObjectPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(BILL);
        node.setContent(ResManager.loadKDString((String)"\u5355\u636e", (String)"CreateBusinessObjectPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        node = new ListboxItem();
        node.setId(LOG_MODEL);
        node.setContent(ResManager.loadKDString((String)"\u65e5\u5fd7\u6a21\u578b", (String)"CreateBusinessObjectPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        listbox.addItems(listboxItems);
        this.setPageTemplate(BASE_DATA);
    }

    private void OpenFromTheApplicationDetailsPage() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String appId = (String)parameter.getCustomParam(APP);
        String funGroup = (String)parameter.getCustomParam(FUN_GROUP);
        if (appId != null) {
            this.getModel().setValue(APP, (Object)appId);
            this.getView().setEnable(Boolean.FALSE, new String[]{APP});
        }
        if (funGroup != null) {
            this.getView().getPageCache().put(KET_BIZ_FUN_UNIT_ID, funGroup);
            String funGroupName = this.getFunGroupNameById(funGroup, appId);
            this.getModel().setValue(FUN_GROUP, (Object)funGroupName);
        }
    }

    private String getFunGroupNameById(String bizUnitId, String bizAppId) {
        AppFunctionPacketElement functionPacket = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        if (functionPacket == null) {
            return "";
        }
        return functionPacket.getName().getLocaleValue();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.confirm();
        } else if (FUN_GROUP.equals(key)) {
            DynamicObject appInfo = (DynamicObject)this.getModel().getValue(APP);
            if (appInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"CreateBusinessObjectPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            } else {
                String bizAppId = (String)appInfo.get(ID);
                this.getFunctionUnit(bizAppId);
            }
        } else if (BTN_PC.equals(key)) {
            this.getPageCache().put("pcOrMobile", BTN_PC);
            this.setPageTemplate(DYNAMIC_FORM);
        } else if (BTN_MOBILE.equals(key)) {
            this.getPageCache().put("pcOrMobile", BTN_MOBILE);
            this.setPageTemplate(DYNAMIC_FORM);
        }
    }

    private void confirm() {
        Map message;
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CreateBusinessObjectPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        ILocaleString name = (ILocaleString)this.getModel().getValue(NAME);
        String number = (String)this.getModel().getValue(NUMBER);
        StringBuilder errorMsg = PageBuilder.validateNameAndNumber((String)number, (ILocaleString)name, (boolean)false);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg.toString());
            return;
        }
        String bizUnitId = this.getView().getPageCache().get(KET_BIZ_FUN_UNIT_ID);
        DynamicObject appInfo = (DynamicObject)this.getModel().getValue(APP);
        String value = (String)this.getModel().getValue(FUN_GROUP);
        if (appInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"CreateBusinessObjectPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u529f\u80fd\u5206\u7ec4\u3002", (String)"CreateBusinessObjectPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"CreateBusinessObjectPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = (String)appInfo.get(ID);
        String modelType = (String)this.getModel().getValue(MODEL_TYPE);
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put(MODEL_TYPE, modelType);
        map.put(ID, number);
        map.put(NAME, (String)name);
        map.put("bizappid", bizAppId);
        map.put("bizunitid", bizUnitId);
        String pageTempId = (String)this.getModel().getValue(ID);
        if (StringUtils.isNotBlank((CharSequence)pageTempId) && BLANK_PAGE.equals(pageTempId)) {
            Map message2 = DevportalUtil.buildNewPage(map, (String)bizAppId, (String)bizUnitId, (IFormView)this.getView(), (boolean)false);
            if (StringUtils.isNotBlank((Object)message2) && StringUtils.isBlank(message2.get(ISV_CHECK_RESULT))) {
                String formId = (String)message2.get("formid");
                GotoDesignerUtils.gotoDesigner(modelType, this.getView(), formId);
                HashMap<String, String> returnData = new HashMap<String, String>(2);
                returnData.put("bizunitid", bizUnitId);
                returnData.put("bizpageid", formId);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)pageTempId)};
        DynamicObject templateFormObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id, number, type", (QFilter[])filters);
        if (templateFormObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"CreateBusinessObjectPlugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String templateFormId = templateFormObject.getString(ID);
        map.put("parentId", templateFormId);
        if (TWO.equals(templateFormObject.get(TYPE).toString())) {
            map.put("devType", TWO);
        }
        if (StringUtils.isNotBlank((Object)(message = DevportalUtil.buildNewPage(map, (String)bizAppId, (String)bizUnitId, (IFormView)this.getView(), (boolean)false))) && StringUtils.isBlank(message.get(ISV_CHECK_RESULT))) {
            String formId = (String)message.get("formid");
            GotoDesignerUtils.gotoDesigner(modelType, this.getView(), formId);
            HashMap<String, String> returnData = new HashMap<String, String>(2);
            returnData.put("bizunitid", bizUnitId);
            returnData.put("bizpageid", formId);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void getFunctionUnit(String bizAppId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devpn_fungroup");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(APP, (Object)bizAppId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FUN_GROUP_INFO_CALL_BACK));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() == null) {
            return;
        }
        String actionId = event.getActionId();
        if (FUN_GROUP_INFO_CALL_BACK.equals(actionId)) {
            Map data = (Map)event.getReturnData();
            Map dataMap = (Map)data.get("selectFunUnit");
            String unitId = (String)dataMap.get(ID);
            String unitName = (String)dataMap.get(NAME);
            this.getModel().setValue(FUN_GROUP, (Object)unitName);
            this.getView().getPageCache().put(KET_BIZ_FUN_UNIT_ID, unitId);
        }
    }

    private void setPageTemplate(String pageType) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        Set<Object> pageTemplate = new LinkedHashSet(7);
        switch (pageType) {
            case "basedata": {
                pageTemplate = GetPageTemplatePlugin.getBaseDataTplType();
                break;
            }
            case "bill": {
                pageTemplate = GetPageTemplatePlugin.getBillTplType();
                break;
            }
            case "logmodel": {
                pageTemplate = GetPageTemplatePlugin.getLogModelTplType();
                break;
            }
            case "dynamicform": {
                this.displayItem();
                pageTemplate = GetPageTemplatePlugin.getDynamicFormPCTplType();
                String pcOrMobile = this.getPageCache().get("pcOrMobile");
                if (!BTN_MOBILE.equalsIgnoreCase(pcOrMobile)) break;
                pageTemplate = GetPageTemplatePlugin.getDynamicFormMobileTplType();
                break;
            }
            case "card": {
                this.hideItem();
                pageTemplate = GetPageTemplatePlugin.getCardTplType();
                break;
            }
            case "report": {
                pageTemplate = GetPageTemplatePlugin.getReportTplType();
                break;
            }
            case "parameter": {
                pageTemplate = GetPageTemplatePlugin.getParameterTplType();
                break;
            }
        }
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, pageTemplate.size());
        Iterator<Object> iterator = pageTemplate.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            this.getModel().setValue(TYPE, next.get(TYPE), i);
            this.getModel().setValue(ID, next.get(ID), i);
            this.getModel().setValue(MODEL_TYPE, next.get(MODEL_TYPE), i);
            cardEntry.setCustomProperties(ENTRY_ENTITY, i, this.toVectorValue((String)next.get(VECTOR_AP)));
            cardEntry.setCustomProperties(ENTRY_ENTITY, i, this.toDescribeValue((String)next.get(DESCRIBE)));
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private Map<String, Object> toVectorValue(String url) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fontClass", url);
        root.put(VECTOR_AP, map);
        return root;
    }

    private Map<String, Object> toDescribeValue(String url) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", url);
        root.put(DESCRIBE, map);
        return root;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ArrayList<String> appIdList = new ArrayList<String>(10);
        Map allApp = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)ID, null);
        for (DynamicObject bizApp : allApp.values()) {
            String id = bizApp.getString(ID);
            if (!AppUtils.checkResourceBelongsToCurDeveloper((String)id)) continue;
            appIdList.add(id);
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter(ID, "in", appIdList));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (NUMBER.equals(property)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber((String)number);
            this.getModel().beginInit();
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().endInit();
        }
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        this.setPageTemplate(listboxEvent.getItemId());
    }

    private void hideItem() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"item"});
    }

    private void displayItem() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"item"});
    }
}

