/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.formtemplate.FormTemplateUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.devportal.util.PageBuilder;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.newdevportal.page.LayoutTemplateUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CreateLayoutPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SelectRowsEventListener,
BeforeF7SelectListener {
    private static final String PC = "pc";
    private static final String MOBILE = "mobile";
    private static final String NEXT = "next";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String APP = "app";
    private static final String UNIT = "unit";
    private static final String ENTITY = "entity";
    private static final String AUTO_CRE_LIST = "autocrelist";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final Log LOG = LogFactory.getLog(CreateLayoutPlugin.class);
    private static final String SUCCESS = "success";
    private static final String ERRORS = "errors";
    private static final String MESSAGE = "message";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    private static final String FORMID = "formid";
    private static final String FORMNAME = "formname";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PC, MOBILE, NEXT});
        BasedataEdit bsdPrintTpl = (BasedataEdit)this.getView().getControl(ENTITY);
        bsdPrintTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String bizAppId = (String)showParameter.getCustomParam("bizAppId");
        String bizUnitId = (String)showParameter.getCustomParam("bizUnitId");
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "=", (Object)bizAppId)};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)NAME, (QFilter[])qFilter);
        DynamicObject appInfo = (DynamicObject)new ArrayList(map.values()).get(0);
        this.getModel().setValue(APP, (Object)appInfo.get(NAME).toString());
        String bizUnitName = DevportalUtil.getBizUnitNameById((String)bizAppId, (String)bizUnitId);
        this.getModel().setValue(UNIT, (Object)bizUnitName);
        this.getModel().setValue(AUTO_CRE_LIST, (Object)Boolean.TRUE);
        this.getModel().setValue("textareafield", this.getView().getFormShowParameter().getCustomParam("description"));
        IImage image = (IImage)this.getControl("imageUrl");
        image.setUrl((String)this.getView().getFormShowParameter().getCustomParam("imageUrl"));
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "next": {
                this.next();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        if ("layoutPageFieldSelectClose".equals(e.getActionId()) && (returnData = e.getReturnData()) instanceof Map) {
            boolean isCancel = Boolean.parseBoolean(String.valueOf(((Map)returnData).get("isBack")));
            if (isCancel) {
                return;
            }
            String bizAppId = this.getView().getFormShowParameter().getCustomParam("bizAppId").toString();
            String bizUnitId = this.getView().getFormShowParameter().getCustomParam("bizUnitId").toString();
            String modelType = ((DynamicObject)this.getModel().getValue(ENTITY)).getString("modelType");
            String layoutNumber = this.getModel().getValue(NUMBER).toString();
            layoutNumber = DevportalUtil.autoIsvNumber((String)layoutNumber);
            ILocaleString layoutName = (ILocaleString)this.getModel().getValue(NAME);
            if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
                this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
                return;
            }
            StringBuilder errorMsg = PageBuilder.validateNameAndNumber((String)layoutNumber, (ILocaleString)layoutName, (boolean)false);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.getView().showTipNotification(errorMsg.toString());
                return;
            }
            String srcId = (String)((Map)returnData).get("srcId");
            List fieldIds = (List)((Map)returnData).get("fieldIds");
            OperateOption option = OperateOption.create();
            String entityId = ((DynamicObject)this.getModel().getValue(ENTITY)).getString("dentityid");
            option.setVariableValue("entityId", entityId);
            option.setVariableValue("fieldIds", SerializationUtils.toJsonString((Object)fieldIds));
            String terminalType = this.getView().getFormShowParameter().getCustomParam("modelType").toString();
            if ("layoutmobile".equals(terminalType)) {
                this.newMobileLayout(bizAppId, layoutName, entityId, layoutNumber, bizUnitId, fieldIds, ((Map)returnData).get("mobileInfo"));
            } else if ("layoutpc".equals(terminalType)) {
                this.newPCLayout(fieldIds, srcId, option, layoutName, layoutNumber, entityId, bizAppId, modelType, bizUnitId);
            }
        }
    }

    private void newPCLayout(List<String> fieldIds, String srcId, OperateOption option, ILocaleString layoutName, String layoutNumber, String entityId, String bizAppId, String modelType, String bizUnitId) {
        if (fieldIds.isEmpty()) {
            HashMap<String, Object> map = new HashMap<String, Object>(9);
            map.put("pagetype", "Empty");
            map.put("bizappid", bizAppId);
            map.put("islayout", true);
            LocaleString formName = new LocaleString();
            formName.putAll((Map)layoutName);
            map.put(NAME, formName);
            map.put("entityId", entityId);
            map.put("id", layoutNumber);
            map.put("modelType", modelType);
            map.put("isRuntime", true);
            map.put("bizunitid", bizUnitId);
            MetaDataUtil metadataUtil = new MetaDataUtil();
            Map content = new HashMap(16);
            content = metadataUtil.createBlankModel(map);
            metadataUtil.save(content);
            String formId = (String)content.get("id");
            this.getView().returnDataToParent(this.buildUnitRelform(new HashMap<String, Object>(), formId, bizAppId, bizUnitId, layoutName));
            this.getView().close();
        } else {
            option.setVariableValue("onlyPcLayout", "true");
            FormMetadata meta = LayoutTemplateUtil.createMeta(srcId, option);
            LocaleString formName = new LocaleString();
            formName.putAll((Map)layoutName);
            meta.setKey(layoutNumber);
            meta.setName(formName);
            meta.setSrcBizObjId(entityId);
            meta.setBizappId(bizAppId);
            MetadataWriter writer = new MetadataWriter(modelType);
            writer.save(new AbstractMetadata[]{meta});
            this.getView().returnDataToParent(this.buildUnitRelform(new HashMap<String, Object>(), meta.getId(), bizAppId, bizUnitId, layoutName));
            this.getView().close();
        }
    }

    private void newMobileLayout(String bizAppId, ILocaleString layoutName, String entityId, String layoutNumber, String bizUnitId, List<String> fieldIds, Object mobileInfo) {
        if (fieldIds.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("pagetype", "Empty");
            params.put("bizappid", bizAppId);
            params.put("islayout", true);
            params.put(NAME, layoutName);
            params.put("entityId", entityId);
            params.put("id", layoutNumber);
            params.put("modelType", "MobileBillFormModel");
            params.put("bizunitid", bizUnitId);
            Map message = DevportalUtil.buildNewLayout(params, (String)bizAppId, (String)bizUnitId, (IFormView)this.getView(), (boolean)false);
            message.put("bizAppId", bizAppId);
            message.put("bizUnitId", bizUnitId);
            message.put("bizPageId", message != null ? message.get(FORMID) : "");
            this.getView().returnDataToParent((Object)message);
            this.getView().close();
        } else {
            Map map = new HashMap(16);
            if (mobileInfo != null) {
                map = (Map)mobileInfo;
            }
            try {
                List entryFields;
                FormTemplateUtil templateUtil = FormTemplateUtil.getTemplateUtil((String)"bos_devp_tplmobbill");
                HashMap<String, String> metaInfo = new HashMap<String, String>(16);
                metaInfo.put("formTemplateId", templateUtil.getTemplateId());
                metaInfo.put(NAME, (String)layoutName);
                metaInfo.put(NUMBER, layoutNumber);
                metaInfo.put("pagemetaid", entityId);
                EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
                List billFields = (List)map.get("billfield");
                if (StringUtils.isNotBlank((Object)billFields)) {
                    JSONArray billArray = new JSONArray();
                    for (Object billfieldid : billFields) {
                        String id = (String)billfieldid;
                        Field billField = meta.getFieldById(id);
                        JSONObject billObject = new JSONObject();
                        if (billField == null) continue;
                        billObject.put("Field", (Object)billField);
                        billArray.add((Object)billObject);
                    }
                    metaInfo.put("billfield", (String)billArray);
                }
                if (StringUtils.isNotBlank((Object)(entryFields = (List)map.get("entryfield")))) {
                    JSONArray entryArray = new JSONArray();
                    for (Object entryfieldid : entryFields) {
                        String id = (String)entryfieldid;
                        Field entryField = meta.getFieldById(id);
                        JSONObject entryObject = new JSONObject();
                        if (entryField == null) continue;
                        entryObject.put("Field", (Object)entryField);
                        entryArray.add((Object)entryObject);
                    }
                    metaInfo.put("entryfield", (String)entryArray);
                }
                String entryentityId = (String)map.get("entryentityid");
                metaInfo.put("entryentityid", entryentityId);
                HashMap<String, String> params = new HashMap<String, String>(16);
                params.put(BIZAPP, bizAppId);
                params.put(BIZUNIT, bizUnitId);
                AbstractMetadata metadata = templateUtil.builderMetadata(metaInfo);
                metadata.setBizappId(bizAppId);
                templateUtil.saveMetadata(metadata, params);
                HashMap<String, Object> message = new HashMap<String, Object>();
                message.put(FORMID, metadata.getId());
                message.put(SUCCESS, Boolean.TRUE);
                message.put(MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"BizPageNewTempMobPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                message.put("bizAppId", bizAppId);
                message.put("bizUnitId", bizUnitId);
                message.put("bizPageId", metadata.getId());
                message.put(FORMNAME, layoutName);
                this.getView().returnDataToParent(message);
                this.getView().close();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.error(e.getMessage());
            }
        }
    }

    protected Map<String, Object> buildUnitRelform(Map<String, Object> message, String formId, String bizAppId, String bizUnitId, ILocaleString name) {
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "CreateLayoutPlugin_0", BOS_DEVPORTAL_NEW_PLUGIN);
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4fdd\u5b58\u8868\u5355\u5e03\u5c40", "CreateLayoutPlugin_1", BOS_DEVPORTAL_NEW_PLUGIN);
        AppUtils.addOpLog((String)BOS_FORMMETA, (String)"save", (String)BOS_FORMMETA, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[0]);
        DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVPORTAL_UNITRELFORM);
        dObject.set(BIZAPP, (Object)bizAppId);
        dObject.set(BIZUNIT, (Object)bizUnitId);
        dObject.set("form", (Object)formId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
        MultiLangEnumBridge opDescriptionSuccess = new MultiLangEnumBridge("\u521b\u5efa\u6210\u529f", "CreateLayoutPlugin_2", BOS_DEVPORTAL_NEW_PLUGIN);
        AppUtils.addOpLog((String)BOS_FORMMETA, (String)"save", (String)BOS_FORMMETA, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescriptionSuccess, (String[])new String[0]);
        message.put(FORMID, formId);
        message.put(FORMNAME, name);
        message.put(SUCCESS, Boolean.TRUE);
        message.put(MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"CreateLayoutPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        message.put("bizAppId", bizAppId);
        message.put("bizUnitId", bizUnitId);
        message.put("bizPageId", formId);
        return message;
    }

    private void next() {
        ILocaleString name = (ILocaleString)this.getModel().getValue(NAME);
        String number = (String)this.getModel().getValue(NUMBER);
        if (StringUtils.isBlank((Object)name) && StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e03\u5c40\u7f16\u7801\u3001\u5e03\u5c40\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateLayoutPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((Object)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e03\u5c40\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateLayoutPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e03\u5c40\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateLayoutPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue(ENTITY))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateLayoutPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_devpn_fieldsel");
        showParameter.setCustomParam("modelType", (Object)((DynamicObject)this.getModel().getValue(ENTITY)).getString("modelType"));
        showParameter.setCustomParam("entityId", (Object)((DynamicObject)this.getModel().getValue(ENTITY)).getString("dentityid"));
        showParameter.setCustomParam("terminalType", (Object)this.getView().getFormShowParameter().getCustomParam("modelType").toString());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "layoutPageFieldSelectClose");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (NUMBER.equals(property)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber((String)number);
            this.getModel().beginInit();
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().endInit();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        FormShowParameter showParameter = arg0.getFormShowParameter();
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizAppId");
        bizAppId = this.getOriBizAppId(bizAppId);
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            listShowParameter.setCustomParam("currentNodeId", (Object)bizAppId);
        }
    }

    private String getOriBizAppId(String appId) {
        String oriBizAppId = "";
        Object[] params = new SqlParameter[]{new SqlParameter(":fmasterid", 12, (Object)appId)};
        String sql = "select fmasterid from t_meta_bizapp where fid=?";
        try {
            oriBizAppId = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    String oriBizAppId = "";
                    while (rs.next()) {
                        oriBizAppId = rs.getString(1);
                    }
                    return oriBizAppId;
                }
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)oriBizAppId)) {
            oriBizAppId = appId;
        }
        return oriBizAppId;
    }
}

