/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.devportal.util.PageBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class ExtendBusinessObject2Plugin
extends AbstractFormPlugin {
    private static final String OK = "ok";
    private static final String ID = "id";
    private static final String BTN_LAST = "last";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String APP = "app";
    private static final String TYPE = "type";
    private static final String FUN_GROUP = "fungroup";
    private static final String DESC = "desc";
    private static final String FORM_ID = "formid";
    private static final String BIZ_FUN_UNIT_ID = "bizFunUnitId";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_ERRORS = "errors";
    private static final String KEY_MESSAGE = "message";
    private static final String PAGE_TYPE = "pageType";
    private static final String KEY_BIZ_EXT_APP_ID = "bizExtAppId";
    private static final String FUN_GROUP_INFO_CALL_BACK = "funGroupInfoCallBack";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final Log LOGGER = LogFactory.getLog(ExtendBusinessObject2Plugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{OK, FUN_GROUP, BTN_LAST});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String name = (String)showParameter.getCustomParam(NAME);
        String number = (String)showParameter.getCustomParam(NUMBER);
        String formId = (String)showParameter.getCustomParam("parentId");
        String bizAppId = (String)showParameter.getCustomParam(APP);
        String extAppId = (String)showParameter.getCustomParam(KEY_BIZ_EXT_APP_ID);
        String app = "";
        app = StringUtils.isNotBlank((CharSequence)extAppId) ? extAppId : this.getExtBizAppId(bizAppId);
        this.getPageCache().put("bizAppId_cache", app);
        String formDefaultNumber = AppUtils.autoExtendedNumber((String)number);
        formDefaultNumber = DevportalUtil.autoFormNumber((String)formDefaultNumber, (String)"_ext");
        formDefaultNumber = DevportalUtil.autoIsvNumber((String)formDefaultNumber);
        this.getModel().setValue(NAME, (Object)name);
        this.getModel().setValue(NUMBER, (Object)formDefaultNumber);
        QFilter[] qFilter = new QFilter[]{new QFilter(ID, "=", (Object)app)};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)NAME, (QFilter[])qFilter);
        DynamicObject appInfo = (DynamicObject)new ArrayList(map.values()).get(0);
        this.getModel().setValue(APP, (Object)appInfo.get(NAME).toString());
        QFilter[] qFilters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        Map mapUnit = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_unitrelform", (String)"bizunit", (QFilter[])qFilters);
        DynamicObject unitInfo = (DynamicObject)new ArrayList(mapUnit.values()).get(0);
        String bizUnitId = String.valueOf(unitInfo.get("bizunit"));
        String bizUnitName = "";
        try {
            bizUnitName = DevportalUtil.getBizUnitNameById((String)bizAppId, (String)bizUnitId);
        }
        catch (NullPointerException exception) {
            JSONArray array = DevportalUtil.getUnitListData((String)bizAppId);
            if (array.isEmpty()) {
                return;
            }
            for (int i = 0; i < array.size(); ++i) {
                if (!ResManager.loadKDString((String)"\u9996\u9875", (String)"ExtendBusinessObject2Plugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]).equals(((Map)array.get(i)).get(NAME))) continue;
                bizUnitId = (String)((Map)array.get(i)).get(ID);
                bizUnitName = ResManager.loadKDString((String)"\u9996\u9875", (String)"ExtendBusinessObject2Plugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            }
        }
        this.getModel().setValue(FUN_GROUP, (Object)bizUnitName);
        this.getView().getPageCache().put(BIZ_FUN_UNIT_ID, bizUnitId);
        this.setPageTypeField();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (FUN_GROUP.equals(key)) {
            String appId = (String)this.getView().getFormShowParameter().getCustomParam(APP);
            this.getFunctionUnit(appId);
        } else if (OK.equals(key)) {
            this.confirm();
        } else if (BTN_LAST.equals(key)) {
            this.getView().returnDataToParent((Object)BTN_LAST);
            this.getView().close();
        }
    }

    private void confirm() {
        boolean isExtended;
        String extBizAppId = this.getPageCache().get("bizAppId_cache");
        String oriBizUnitId = this.getView().getPageCache().get(BIZ_FUN_UNIT_ID);
        String oriFormId = (String)this.getView().getFormShowParameter().getCustomParam("parentId");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(TYPE);
        DynamicObject oriForm = BusinessDataServiceHelper.loadSingleFromCache((Object)oriFormId, (String)"bos_formmeta", (String)"isextended");
        boolean bl = isExtended = oriForm == null ? true : oriForm.getBoolean("isextended");
        if (!isExtended) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u88ab\u6269\u5c55\u3002", (String)"ExtendBusinessObject2Plugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String count = DevportalUtil.getParallelExtCountByIsv((String)oriFormId, (String)"bos_formmeta", (String)"parentid");
        if (!"0".equals(count)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u53ea\u5141\u8bb8\u6269\u5c551\u6b21\u3002", (String)"ExtendBusinessObject2Plugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.saveFormAndBindForm(oriBizUnitId, extBizAppId, oriFormId, modelType);
    }

    public String getExtBizAppId(String id) {
        String extBizAppId = "";
        Object[] params = new SqlParameter[]{new SqlParameter(":fmasterid", 12, (Object)id)};
        String sql = "select fid from t_meta_bizapp where fmasterid=?";
        try {
            extBizAppId = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    String extBizAppId = "";
                    while (rs.next()) {
                        extBizAppId = rs.getString(1);
                    }
                    return extBizAppId;
                }
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)extBizAppId)) {
            extBizAppId = id;
        }
        return extBizAppId;
    }

    private void saveFormAndBindForm(String oriUnitId, String extBizAppId, String oriFormId, String modelType) {
        String extPageNumber = (String)this.getModel().getValue(NUMBER);
        ILocaleString extPageName = (ILocaleString)this.getModel().getValue(NAME);
        extPageNumber = DevportalUtil.autoIsvNumber((String)extPageNumber);
        ILocaleString name = (ILocaleString)this.getModel().getValue(NAME);
        String number = (String)this.getModel().getValue(NUMBER);
        StringBuilder errorMsg = PageBuilder.validateNameAndNumber((String)number, (ILocaleString)name, (boolean)false);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg.toString());
            return;
        }
        this.getModel().setDataChanged(false);
        String bizcloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)extBizAppId, (boolean)false).getBizCloudID();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String formId = (String)showParameter.getCustomParam(FORM_ID);
        String pageType = (String)showParameter.getCustomParam(PAGE_TYPE);
        HashMap<String, Object> messageMap = new HashMap<String, Object>(16);
        String entityId = "";
        String bizpageId = "";
        try (TXHandle tx = TX.required((String)"mdl_ExtendBusinessObject2Plugin_saveFormAndBindForm");){
            entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
            bizpageId = this.createBlankModel(oriUnitId, extBizAppId, oriFormId, entityId, modelType, extPageName, extPageNumber, messageMap);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        if (messageMap.get(KEY_MESSAGE) != null) {
            messageMap.put("bizappid", extBizAppId);
            messageMap.put("bizunitid", oriUnitId);
            messageMap.put("bizpageid", bizpageId);
            this.getView().returnDataToParent(messageMap);
            this.getView().close();
        } else {
            messageMap.put("bizappid", extBizAppId);
            messageMap.put("bizunitid", oriUnitId);
            messageMap.put("bizpageid", bizpageId);
            messageMap.put(KEY_SUCCESS, Boolean.TRUE);
            messageMap.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"ExtendBusinessObject2Plugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            JSONObject arg = new JSONObject();
            arg.put("bizcloudid", (Object)bizcloudId);
            arg.put("bizappid", (Object)extBizAppId);
            arg.put("bizunitid", (Object)oriUnitId);
            arg.put("bizpageid", (Object)bizpageId);
            messageMap.put("data", arg);
            this.getView().returnDataToParent(messageMap);
            this.getView().close();
        }
    }

    private String createBlankModel(String oriUnitId, String extBizAppId, String oriFormId, String oriEntityId, String modelType, ILocaleString extPageName, String extPageNumber, Map<String, Object> message) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("bizappid", extBizAppId);
        map.put("bizunitid", oriUnitId);
        map.put(NAME, (String)extPageName);
        map.put(ID, extPageNumber);
        map.put("modelType", modelType);
        map.put("parentId", oriFormId);
        map.put("devType", "2");
        String parentEntityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        if (!parentEntityId.equals(oriFormId)) {
            map.put("entityId", parentEntityId);
            map.put("srcBizObjId", oriEntityId);
        }
        Map save = new HashMap(16);
        String formId = "";
        try (TXHandle tx = TX.required((String)"mdl_ExtendBusinessObject2Plugin_createBlankModel");){
            String string;
            MetaDataUtil metaDataUtil = new MetaDataUtil();
            Map content = metaDataUtil.createBlankModel(map);
            save = metaDataUtil.save(content);
            if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue()) {
                message.put(KEY_SUCCESS, Boolean.FALSE);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue() && save.get(KEY_ERRORS) != null) {
                    message.put(KEY_MESSAGE, ((ErrorInfo)((ArrayList)save.get(KEY_ERRORS)).get(0)).getError());
                } else {
                    message.put(KEY_MESSAGE, String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u521b\u5efa\u5931\u8d25\u3002", (String)"ExtendBusinessObject2Plugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), extPageName));
                }
                String string2 = formId;
                return string2;
            }
            try {
                formId = (String)content.get(ID);
                DynamicObject newUnitrelform = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                newUnitrelform.set("bizapp", (Object)extBizAppId);
                newUnitrelform.set("bizunit", (Object)oriUnitId);
                newUnitrelform.set("form", (Object)formId);
                MainEntityType unitrelformEntityType = EntityMetadataCache.getDataEntityType((String)"bos_devportal_unitrelform");
                BusinessDataServiceHelper.save((IDataEntityType)unitrelformEntityType, (Object[])new DynamicObject[]{newUnitrelform});
            }
            catch (NullPointerException nullPointerException) {
                tx.markRollback();
                LOGGER.error((Throwable)nullPointerException);
                message.put(KEY_SUCCESS, Boolean.FALSE);
                message.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\u3002", (String)"ExtendBusinessObject2Plugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                string = formId;
                return string;
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error((Throwable)e);
                message.put(KEY_SUCCESS, Boolean.FALSE);
                if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue() && save.get(KEY_ERRORS) != null) {
                    message.put(KEY_MESSAGE, ((ErrorInfo)((ArrayList)save.get(KEY_ERRORS)).get(0)).getError());
                } else {
                    message.put(KEY_MESSAGE, String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u521b\u5efa\u5931\u8d25\u3002", (String)"ExtendBusinessObject2Plugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), extPageName));
                }
                string = formId;
                return string;
            }
        }
        return formId;
    }

    private void getFunctionUnit(String bizAppId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devpn_fungroup");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(APP, (Object)bizAppId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FUN_GROUP_INFO_CALL_BACK));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() == null) {
            return;
        }
        String actionId = event.getActionId();
        if (FUN_GROUP_INFO_CALL_BACK.equals(actionId)) {
            Map data = (Map)event.getReturnData();
            Map dataMap = (Map)data.get("selectFunUnit");
            String unitId = (String)dataMap.get(ID);
            String unitName = (String)dataMap.get(NAME);
            this.getModel().setValue(FUN_GROUP, (Object)unitName);
            this.getView().getPageCache().put(BIZ_FUN_UNIT_ID, unitId);
        }
    }

    private void setPageTypeField() {
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_TYPE);
        if (StringUtils.isNotBlank((CharSequence)pageType)) {
            switch (pageType) {
                case "1": {
                    this.setFieldCaption(ResManager.loadKDString((String)"\u9875\u9762\u7f16\u7801", (String)"ExtendBusinessObject2Plugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u9875\u9762\u540d\u79f0", (String)"ExtendBusinessObject2Plugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    this.setFieldCaption(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u7801", (String)"ExtendBusinessObject2Plugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"ExtendBusinessObject2Plugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "3": {
                    this.setFieldCaption(ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801", (String)"ExtendBusinessObject2Plugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"ExtendBusinessObject2Plugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    private void setFieldCaption(String number, String name) {
        HashMap<String, String> numberCaption = new HashMap<String, String>(1);
        numberCaption.put("zh_CN", number);
        HashMap<String, HashMap<String, String>> numberProp = new HashMap<String, HashMap<String, String>>(1);
        numberProp.put("caption", numberCaption);
        this.getView().updateControlMetadata(NUMBER, numberProp);
        HashMap<String, String> nameCaption = new HashMap<String, String>(1);
        nameCaption.put("zh_CN", name);
        HashMap<String, HashMap<String, String>> nameProp = new HashMap<String, HashMap<String, String>>(1);
        nameProp.put("caption", nameCaption);
        this.getView().updateControlMetadata(NAME, nameProp);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (NUMBER.equals(property)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber((String)number);
            this.getModel().beginInit();
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().endInit();
        }
    }
}

