/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ExtendBusinessObjectPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String ID = "id";
    private static final String APP = "app";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String NEXT = "next";
    private static final String NUMBER = "number";
    private static final String FORM_ID = "formid";
    private static final String SEARCH_AP = "searchap";
    private static final String MASTER_ID = "masterid";
    private static final String ROOT_NODE = "rootNode";
    private static final String BIZ_CLOUD = "bizcloud";
    private static final String KEY_BIZ_APP_ID = "bizappid";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_CHILDREN = "children";
    private static final String KEY_PARENT_ID = "parentid";
    private static final String KEY_MODEL_TYPE = "modeltype";
    private static final String KEY_BIZ_EXT_APP_ID = "bizExtAppId";
    private static final String BASE_FORM_MODEL = "BaseFormModel";
    private static final String BILL_FORM_MODEL = "BillFormModel";
    private static final String BOS_DEVPORTAL_BIZ_APP = "bos_devportal_bizapp";
    private static final String TREE_VIEW_AP = "treeviewap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BOS_FORM_META = "bos_formmeta";
    private static final String CACHE_TREE_NODES = "cacheNodes";
    private static final String CACHE_ID_MASTER = "cacheIdMaster";
    private static final String CACHE_JSON_VALUE = "cacheJsonValue";
    private static final String EXTEND_BUSINESS_OBJECT = "extendBusinessObject_callBack";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private List<DynamicObject> valueList;

    public void registerListener(EventObject e) {
        TreeView tView = (TreeView)this.getControl(TREE_VIEW_AP);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{NEXT});
    }

    public void afterBindData(EventObject e) {
        String bizExtAppId;
        TreeNode rootNode = this.buildTreeNodes();
        TreeView tView = (TreeView)this.getControl(TREE_VIEW_AP);
        tView.addNode(rootNode);
        tView.setRootVisible(false);
        List children = rootNode.getChildren();
        if (children != null && !children.isEmpty()) {
            TreeNode treeNode = (TreeNode)children.get(0);
            tView.focusNode(treeNode);
            this.getPageCache().put("initSelectTreeNodeCache", SerializationUtils.toJsonString((Object)treeNode));
        }
        if (StringUtils.isNotBlank((CharSequence)(bizExtAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_EXT_APP_ID)))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap21"});
        }
        this.populateInitData();
    }

    private TreeNode buildTreeNodes() {
        String bizExtAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_EXT_APP_ID);
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        qfilters.add(new QFilter(TYPE, "=", (Object)"2"));
        if (StringUtils.isNotBlank((CharSequence)bizExtAppId)) {
            qfilters.add(new QFilter(ID, "=", (Object)bizExtAppId));
        }
        DynamicObjectCollection extendAppIdAndCloudIds = QueryServiceHelper.query((String)BOS_DEVPORTAL_BIZ_APP, (String)"id, bizcloud", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
        ArrayList<String> extendAppIds = new ArrayList<String>(16);
        HashSet<String> cloudIds = new HashSet<String>(16);
        for (DynamicObject extendAppIdAndCloudId : extendAppIdAndCloudIds) {
            extendAppIds.add((String)extendAppIdAndCloudId.get(ID));
            cloudIds.add((String)extendAppIdAndCloudId.get(BIZ_CLOUD));
        }
        String[] strApp = extendAppIds.toArray(new String[0]);
        String[] strCloud = cloudIds.toArray(new String[0]);
        TreeNode root = AppUtils.getSubsysTree((String[])strCloud, (String[])strApp, null, (String)APP, (boolean)false, (boolean)false, (boolean)false);
        String json = SerializationUtils.toJsonString((Object)root);
        this.getPageCache().put(CACHE_TREE_NODES, json);
        return root;
    }

    public void afterCreateNewData(EventObject e) {
        this.populateAllData();
    }

    private void populateInitData() {
        String initSelectTreeNodeCache = this.getPageCache().get("initSelectTreeNodeCache");
        Map nodeMap = (Map)SerializationUtils.fromJsonString((String)initSelectTreeNodeCache, Map.class);
        String str = this.getPageCache().get(CACHE_ID_MASTER);
        Map idAndMasterMap = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        ArrayList<String> myNodes = new ArrayList<String>(10);
        List mapList = (List)nodeMap.get(KEY_CHILDREN);
        for (Map map : mapList) {
            String appId = (String)map.get(ID);
            myNodes.addAll((Collection)idAndMasterMap.get(appId));
        }
        this.queryRequiredValues(myNodes);
    }

    private void populateAllData() {
        String bizExtAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_EXT_APP_ID);
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        qfilters.add(new QFilter(TYPE, "=", (Object)"2"));
        if (StringUtils.isNotBlank((CharSequence)bizExtAppId)) {
            qfilters.add(new QFilter(ID, "=", (Object)bizExtAppId));
        }
        DynamicObjectCollection extendPages = QueryServiceHelper.query((String)BOS_DEVPORTAL_BIZ_APP, (String)"id, inheritpath", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
        HashMap idAndAllParentId = new HashMap(16);
        for (DynamicObject extendPage : extendPages) {
            ArrayList<String> appIds = new ArrayList<String>(16);
            String id = (String)extendPage.get(ID);
            String inheritPath = (String)extendPage.get("inheritpath");
            if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
                List<String> list = Arrays.asList(inheritPath.split(","));
                list.stream().forEach(key -> appIds.add((String)key));
            }
            appIds.add(id);
            idAndAllParentId.put(id, appIds);
        }
        String json = SerializationUtils.toJsonString(idAndAllParentId);
        this.getPageCache().put(CACHE_ID_MASTER, json);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (NEXT.equals(key)) {
            this.next();
        }
    }

    private void next() {
        boolean isExtended;
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ExtendBusinessObjectPlugin_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        String bizPageId = (String)this.getModel().getValue(FORM_ID, rowIndex);
        String bizAppId = "";
        String bizExtAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_EXT_APP_ID);
        bizAppId = StringUtils.isNotBlank((CharSequence)bizExtAppId) ? bizExtAppId : (String)this.getModel().getValue(APP, rowIndex);
        String number = (String)this.getModel().getValue(NUMBER, rowIndex);
        String name = (String)this.getModel().getValue(NAME, rowIndex);
        String type = (String)this.getModel().getValue(TYPE, rowIndex);
        String sql = String.format("select fentityid from t_meta_formdesign where fid = '%s'", bizPageId);
        String entityId = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            String entity = "";
            if (rs.next()) {
                entity = rs.getString(1);
            }
            return entity;
        });
        DynamicObject oriForm = BusinessDataServiceHelper.loadSingleFromCache((Object)bizPageId, (String)BOS_FORM_META, (String)"isextended");
        boolean bl = isExtended = oriForm == null ? true : oriForm.getBoolean("isextended");
        if (!isExtended) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u88ab\u6269\u5c55\u3002", (String)"ExtendBusinessObjectPlugin_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String count = DevportalUtil.getParallelExtCountByIsv((String)bizPageId, (String)BOS_FORM_META, (String)KEY_PARENT_ID);
        if ("0".equals(count)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_devpn_extbusobj2");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(FORM_ID, (Object)bizPageId);
            showParameter.setCustomParam(APP, (Object)bizAppId);
            showParameter.setCustomParam(NUMBER, (Object)number);
            showParameter.setCustomParam(NAME, (Object)name);
            showParameter.setCustomParam(TYPE, (Object)type);
            showParameter.setCustomParam("entityId", (Object)entityId);
            showParameter.setCustomParam(KEY_BIZ_EXT_APP_ID, this.getView().getFormShowParameter().getCustomParam(KEY_BIZ_EXT_APP_ID));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EXTEND_BUSINESS_OBJECT);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u4ec5\u5141\u8bb8\u6269\u5c551\u6b21\u3002", (String)"ExtendBusinessObjectPlugin_16", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map map;
        String actionId = event.getActionId();
        if (EXTEND_BUSINESS_OBJECT.equals(actionId) && (map = (Map)event.getReturnData()) != null && map.get(KEY_SUCCESS) != null) {
            if (((Boolean)map.get(KEY_SUCCESS)).booleanValue()) {
                JSONObject data = (JSONObject)map.get("data");
                String formId = (String)data.get((Object)"bizpageid");
                String bizUnitId = (String)data.get((Object)"bizunitid");
                HashMap<String, String> returnData = new HashMap<String, String>(2);
                returnData.put("bizunitid", bizUnitId);
                returnData.put("bizpageid", formId);
                this.getView().returnDataToParent(returnData);
                DevportalUtil.gotoEntityDesigner((IFormView)this.getView(), (String)formId);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(map.get(KEY_MESSAGE).toString());
            }
        }
    }

    private void refreshEntryGrid(List<DynamicObject> values) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(ENTRY_ENTITY);
        int seq = 1;
        for (DynamicObject val : values) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            DynamicObject formInfo = (DynamicObject)val.get("basedatafield");
            if (formInfo == null) continue;
            String formId = (String)formInfo.getPkValue();
            row.set("seq", (Object)seq);
            row.set(NUMBER, val.get(NUMBER));
            row.set(NAME, (Object)val.get(NAME).toString());
            row.set(TYPE, val.get(KEY_MODEL_TYPE));
            row.set(APP, val.get(KEY_BIZ_APP_ID));
            row.set(FORM_ID, (Object)formId);
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void search(SearchEnterEvent event) {
        Search search = (Search)event.getSource();
        if (StringUtils.equals((CharSequence)SEARCH_AP, (CharSequence)search.getKey())) {
            String searchText = event.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        QFilter numberOrNameFilter = null;
        if (!searchText.equals("")) {
            String formatSearchText = String.format("%s%s%s", "%", searchText, "%");
            numberOrNameFilter = new QFilter(NAME, "like", (Object)formatSearchText);
            numberOrNameFilter.or(new QFilter(NUMBER, "like", (Object)formatSearchText));
        }
        String str = this.getPageCache().get(CACHE_ID_MASTER);
        Map idAndMasterMap = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        ArrayList appIds = new ArrayList(10);
        for (List l : idAndMasterMap.values()) {
            appIds.addAll(l);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_BIZ_APP_ID, "in", appIds), new QFilter(TYPE, "=", (Object)"2"), new QFilter(KEY_MODEL_TYPE, "in", Arrays.asList(BASE_FORM_MODEL, BILL_FORM_MODEL))};
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)BOS_FORM_META, (String)KEY_PARENT_ID, (QFilter[])qFilters);
        ArrayList<String> idList = new ArrayList<String>(10);
        for (DynamicObject id : ids) {
            String parentId = id.getString("parentid.id");
            if (!StringUtils.isNotBlank((CharSequence)parentId)) continue;
            idList.add(parentId);
        }
        QFilter[] qFilter = new QFilter[]{new QFilter(ID, "not in", idList), new QFilter(KEY_BIZ_APP_ID, "in", appIds), numberOrNameFilter, new QFilter(KEY_MODEL_TYPE, "in", Arrays.asList(BASE_FORM_MODEL, BILL_FORM_MODEL))};
        Map bosFormMeta = BusinessDataServiceHelper.loadFromCache((String)BOS_FORM_META, (String)"bizappid,modeltype,basedatafield", (QFilter[])qFilter);
        Map<Object, DynamicObject> map = bosFormMeta.entrySet().stream().filter(r -> r.getKey().equals(((DynamicObject)r.getValue()).getString("basedatafield.id"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Collection<DynamicObject> values = map.values();
        ArrayList<DynamicObject> entityDataList = new ArrayList<DynamicObject>(values);
        this.refreshEntryGrid(entityDataList);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String parentNodeId = (String)evt.getParentNodeId();
        ArrayList<String> myNodes = new ArrayList(10);
        String s = this.getPageCache().get(CACHE_TREE_NODES);
        List nodesList = (List)((Map)SerializationUtils.fromJsonString((String)s, Map.class)).get(KEY_CHILDREN);
        String str = this.getPageCache().get(CACHE_ID_MASTER);
        Map idAndMasterMap = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        if (ROOT_NODE.equals(parentNodeId)) {
            for (Map nodeMap : nodesList) {
                if (!nodeId.equals(nodeMap.get(ID))) continue;
                List mapList = (List)nodeMap.get(KEY_CHILDREN);
                for (Map map : mapList) {
                    String appId = (String)map.get(ID);
                    myNodes.addAll((Collection)idAndMasterMap.get(appId));
                }
            }
            this.queryRequiredValues(myNodes);
        } else {
            myNodes = (List)idAndMasterMap.get(nodeId);
            this.queryRequiredValues(myNodes);
        }
    }

    private void queryRequiredValues(List<String> value) {
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_BIZ_APP_ID, "in", value), new QFilter(TYPE, "=", (Object)"2"), new QFilter(KEY_MODEL_TYPE, "in", Arrays.asList(BASE_FORM_MODEL, BILL_FORM_MODEL))};
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)BOS_FORM_META, (String)KEY_PARENT_ID, (QFilter[])qFilters);
        ArrayList<String> idList = new ArrayList<String>(10);
        for (DynamicObject id : ids) {
            String parentId = id.getString("parentid.id");
            if (!StringUtils.isNotBlank((CharSequence)parentId)) continue;
            idList.add(parentId);
        }
        QFilter[] qFilter = new QFilter[]{new QFilter(ID, "not in", idList), new QFilter(KEY_BIZ_APP_ID, "in", value), new QFilter(KEY_MODEL_TYPE, "in", Arrays.asList(BASE_FORM_MODEL, BILL_FORM_MODEL))};
        Map bosFormMeta = BusinessDataServiceHelper.loadFromCache((String)BOS_FORM_META, (String)"bizappid,modeltype,basedatafield", (QFilter[])qFilter);
        Map<Object, DynamicObject> map = bosFormMeta.entrySet().stream().filter(r -> r.getKey().equals(((DynamicObject)r.getValue()).getString("basedatafield.id"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Collection<DynamicObject> values = map.values();
        this.valueList = new ArrayList<DynamicObject>(values);
        String jsonValue = SerializationUtils.toJsonString(this.valueList);
        this.getPageCache().put(CACHE_JSON_VALUE, jsonValue);
        this.refreshEntryGrid(this.valueList);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(CACHE_TREE_NODES);
        this.getPageCache().remove(CACHE_JSON_VALUE);
        this.getPageCache().remove(CACHE_ID_MASTER);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int index = event.getRowIndex();
        String formId = (String)this.getModel().getValue(FORM_ID, index);
        DevportalUtil.gotoEntityDesigner((IFormView)this.getView(), (String)formId);
    }
}

