/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class FunctionUnitPlugin
extends AbstractFormPlugin {
    private static final String APP = "app";
    private static final String BTN_OK = "ok";
    private static final String BTN_ADD = "add";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, BTN_ADD});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String appId = (String)parameter.getCustomParam(APP);
        this.getPageCache().put(APP, appId);
        this.initFunctionEntity(appId);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.returnData();
        } else if (BTN_ADD.equals(key)) {
            this.addFunction();
        }
    }

    private void addFunction() {
        String bizAppId = this.getPageCache().get(APP);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_metadataunit");
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addFunction_callBack"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if ("addFunction_callBack".equals(event.getActionId())) {
            this.initFunctionEntity(this.getPageCache().get(APP));
        }
    }

    private void initFunctionEntity(String appId) {
        JSONArray array = DevportalUtil.getUnitListData((String)appId);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (array.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, array.size());
        for (int i = 0; i < array.size(); ++i) {
            this.getModel().setValue(NAME, ((Map)array.get(i)).get(NAME), i);
            this.getModel().setValue(NUMBER, ((Map)array.get(i)).get(NUMBER), i);
            this.getModel().setValue(ID, ((Map)array.get(i)).get(ID), i);
        }
    }

    private void returnData() {
        Map<String, Object> data = this.getSelectedUnit();
        HashMap<String, Map<String, Object>> returnData = new HashMap<String, Map<String, Object>>(1);
        returnData.put("selectFunUnit", data);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private Map<String, Object> getSelectedUnit() {
        HashMap<String, Object> unit = new HashMap<String, Object>(3);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] rowIndexs = entryGrid.getEntryState().getSelectedRows();
        if (rowIndexs.length > 0) {
            unit.put(NAME, this.getModel().getValue(NAME, rowIndexs[0]).toString());
            unit.put(NUMBER, this.getModel().getValue(NUMBER, rowIndexs[0]).toString());
            unit.put(ID, this.getModel().getValue(ID, rowIndexs[0]).toString());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u529f\u80fd\u5206\u7ec4\u3002", (String)"FunctionUnitPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        }
        return unit;
    }
}

