/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class InheritBusinessObjectPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
HyperLinkClickListener,
TreeNodeClickListener {
    private static final String APP = "app";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String NEXT = "next";
    private static final String NUMBER = "number";
    private static final String FORM_ID = "formid";
    private static final String SEARCH_AP = "searchap";
    private static final String KEY_BIZ_APP_ID = "bizappid";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_MODEL_TYPE = "modeltype";
    private static final String BASE_FORM_MODEL = "BaseFormModel";
    private static final String BILL_FORM_MODEL = "BillFormModel";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BOS_FORM_META = "bos_formmeta";
    private static final String INHERIT_BUSINESS_OBJECT = "inheritBusinessObject_callBack";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String MODELTYPE = "modeltype";
    private static final String ISINHERIT = "isinherit";
    private static final String TREE_VIEW_AP = "treeviewap";

    public void registerListener(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{NEXT});
        TreeView tView = (TreeView)this.getControl(TREE_VIEW_AP);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String title = (String)this.getView().getFormShowParameter().getCustomParam("title");
        Label inherit = (Label)this.getView().getControl("title");
        inherit.setText(title);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizAppId");
        String sql = String.format("select fid,finheritpath from t_meta_bizapp where fid = '%s'", bizAppId);
        List appIdList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            ArrayList<String> appIds = new ArrayList<String>(10);
            if (rs.next()) {
                String id = rs.getString(1);
                appIds.add(id);
                String inheritpath = rs.getString(2);
                if (StringUtils.isNotBlank((CharSequence)inheritpath)) {
                    String[] split = inheritpath.split(",");
                    appIds.addAll(Arrays.asList(split));
                }
            }
            return appIds;
        });
        this.getPageCache().put("appIdsCache", SerializationUtils.toJsonString((Object)appIdList));
        QFilter qFilter = null;
        this.selectCanInheritBusinessObj(qFilter);
    }

    public void afterBindData(EventObject e) {
        String bizAppId;
        TreeNode rootNode = this.buildTreeNodes();
        TreeView tView = (TreeView)this.getControl(TREE_VIEW_AP);
        tView.addNode(rootNode);
        List children = rootNode.getChildren();
        if (children != null && !children.isEmpty()) {
            TreeNode treeNode = (TreeNode)children.get(0);
            tView.focusNode(treeNode);
        }
        if (StringUtils.isNotBlank((CharSequence)(bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizAppId")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"treeflex"});
        }
    }

    private TreeNode buildTreeNodes() {
        TreeNode root = new TreeNode();
        return root;
    }

    private void refreshEntryGrid(List<DynamicObject> values) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizAppId");
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(ENTRY_ENTITY);
        int seq = 1;
        for (DynamicObject val : values) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            DynamicObject formInfo = (DynamicObject)val.get("basedatafield");
            if (formInfo == null) continue;
            String formId = (String)formInfo.getPkValue();
            row.set("seq", (Object)seq);
            row.set(NUMBER, val.get(NUMBER));
            row.set(NAME, (Object)val.get(NAME).toString());
            row.set(TYPE, val.get("modeltype"));
            row.set(APP, (Object)bizAppId);
            row.set(FORM_ID, (Object)formId);
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)SEARCH_AP, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        QFilter numberOrNameFilter = null;
        if (!searchText.equals("")) {
            String formatSearchText = String.format("%s%s%s", "%", searchText, "%");
            numberOrNameFilter = new QFilter(NAME, "like", (Object)formatSearchText);
            numberOrNameFilter.or(new QFilter(NUMBER, "like", (Object)formatSearchText));
        }
        this.selectCanInheritBusinessObj(numberOrNameFilter);
    }

    private void selectCanInheritBusinessObj(QFilter numberOrNameFilter) {
        String appIdsCache = this.getPageCache().get("appIdsCache");
        List appIdList = (List)SerializationUtils.fromJsonString((String)appIdsCache, List.class);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_BIZ_APP_ID, "in", (Object)appIdList), new QFilter(TYPE, "=", (Object)"0"), new QFilter("modeltype", "in", Arrays.asList(BASE_FORM_MODEL, BILL_FORM_MODEL)), numberOrNameFilter};
        Map bosFormMeta = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"bizappid,modeltype,basedatafield", (QFilter[])qFilters);
        Map<Object, DynamicObject> map = bosFormMeta.entrySet().stream().filter(r -> r.getKey().equals(((DynamicObject)r.getValue()).getString("basedatafield.id"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Collection<DynamicObject> values = map.values();
        ArrayList<DynamicObject> valueList = new ArrayList<DynamicObject>(values);
        this.refreshEntryGrid(valueList);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int index = evt.getRowIndex();
        String formId = (String)this.getModel().getValue(FORM_ID, index);
        DevportalUtil.gotoEntityDesigner((IFormView)this.getView(), (String)formId);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (NEXT.equals(key)) {
            this.next();
        }
    }

    private void next() {
        boolean isInHerit;
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InheritBusinessObjectPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        String name = (String)this.getModel().getValue(NAME, rowIndex);
        String bizAppId = (String)this.getModel().getValue(APP, rowIndex);
        String number = (String)this.getModel().getValue(NUMBER, rowIndex);
        String formId = (String)this.getModel().getValue(FORM_ID, rowIndex);
        String modeltype = (String)this.getModel().getValue(TYPE, rowIndex);
        String selectFields = "isinherit,modeltype";
        DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)"bos_formmeta", (String)selectFields);
        boolean bl = isInHerit = parent == null ? true : parent.getBoolean(ISINHERIT);
        if (!isInHerit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u88ab\u7ee7\u627f\u3002", (String)"InheritBusinessObjectPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if ("PCLayout".equals(modeltype) && parent != null) {
            modeltype = parent.getString("modeltype");
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_devpn_inheritbusobj2");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(FORM_ID, (Object)formId);
        showParameter.setCustomParam(APP, (Object)bizAppId);
        showParameter.setCustomParam(NUMBER, (Object)number);
        showParameter.setCustomParam(NAME, (Object)name);
        showParameter.setCustomParam("modeltype", (Object)modeltype);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, INHERIT_BUSINESS_OBJECT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map map;
        String actionId = event.getActionId();
        if (INHERIT_BUSINESS_OBJECT.equals(actionId) && (map = (Map)event.getReturnData()) != null && map.get(KEY_SUCCESS) != null) {
            if (((Boolean)map.get(KEY_SUCCESS)).booleanValue()) {
                String formId = (String)map.get("bizpageid");
                String bizUnitId = (String)map.get("bizunitid");
                HashMap<String, String> returnData = new HashMap<String, String>(2);
                returnData.put("bizunitid", bizUnitId);
                returnData.put("bizpageid", formId);
                this.getView().returnDataToParent(returnData);
                DevportalUtil.gotoEntityDesigner((IFormView)this.getView(), (String)formId);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(map.get(KEY_MESSAGE).toString());
            }
        }
    }
}

