/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class InheritBusinessTemplatePlugin
extends AbstractFormPlugin
implements TabSelectListener,
HyperLinkClickListener {
    private static final String ID = "id";
    private static final String ENTITY_ID = "entityid";
    private static final String DESC = "desc";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String BTN_NEXT = "next";
    private static final String BILL_TPL = "billtpl";
    private static final String BASE_TPL = "basetpl";
    private static final String TAB_AP = "tabap";
    private static final String MODEL_TYPE = "modeltype";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BIZ_APP_ID = "bizAppId";
    private static final String BIZ_UNIT_ID = "bizUnitId";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_NEXT});
        Tab tab = (Tab)this.getControl(TAB_AP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Tab tab = (Tab)this.getControl(TAB_AP);
        tab.activeTab(BILL_TPL);
    }

    public void click(EventObject evt) {
        String key = ((Button)evt.getSource()).getKey();
        if (BTN_NEXT.equals(key)) {
            this.next();
        }
    }

    private void next() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] rows = entryGrid.getEntryState().getSelectedRows();
        if (rows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InheritBusinessTemplatePlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        int row = rows[0];
        DynamicObject data = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        String number = data.getString(NUMBER);
        String modelType = this.getPageCache().get(MODEL_TYPE);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID);
        String bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_UNIT_ID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devpn_creobjbybustpl");
        parameter.setCustomParam("templateNumber", (Object)number);
        parameter.setCustomParam("pageType", (Object)"pc");
        parameter.setCustomParam(BIZ_APP_ID, (Object)bizAppId);
        parameter.setCustomParam(BIZ_UNIT_ID, (Object)bizUnitId);
        parameter.setCustomParam(MODEL_TYPE, (Object)modelType);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "inheritBusiness_callBack"));
        this.getView().showForm(parameter);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID);
        String modelType = BILL_TPL.equals(tabKey) ? "BillFormModel" : "BaseFormModel";
        this.getPageCache().put(MODEL_TYPE, modelType);
        Set<Map<String, Object>> businessTemplate = this.getBusinessTemplate(bizAppId, modelType);
        this.loadBusinessTemplateData(businessTemplate);
    }

    private void loadBusinessTemplateData(Set<Map<String, Object>> businessTemplate) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRY_ENTITY);
        if (businessTemplate.isEmpty()) {
            this.getView().updateView(ENTRY_ENTITY);
            return;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, businessTemplate.size());
        Iterator<Map<String, Object>> iterator = businessTemplate.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            model.setValue(ID, next.get(ID), i);
            model.setValue(ENTITY_ID, next.get(ENTITY_ID), i);
            model.setValue(NAME, next.get(NAME), i);
            model.setValue(NUMBER, next.get(NUMBER), i);
            ++i;
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private Set<Map<String, Object>> getBusinessTemplate(String bizAppId, String modelType) {
        final HashSet<Map<String, Object>> templateArray = new HashSet<Map<String, Object>>(16);
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        StringBuilder rt = new StringBuilder();
        String bizCloudId = appMetadata.getBizCloudID();
        JSONArray bizAppObjects = DevportalUtil.getAppsInCloud((String)bizCloudId);
        if (!bizAppObjects.isEmpty()) {
            for (Object bizAppObject : bizAppObjects) {
                JSONObject appInfo = (JSONObject)bizAppObject;
                String appId = (String)appInfo.get((Object)ID);
                if (bizAppId.equals(appId)) continue;
                rt.append('\'');
                rt.append(appId);
                rt.append("',");
            }
        }
        rt.append('\'');
        rt.append(bizAppId);
        rt.append('\'');
        Object[] params = new SqlParameter[]{new SqlParameter(":fistemplate", 1, (Object)"1"), new SqlParameter(":fmdoeltype", 12, (Object)("%" + modelType + "%")), new SqlParameter(":flocaleid", 12, (Object)"zh_CN"), new SqlParameter(":ftype", 1, (Object)"2")};
        String selectSql = String.format("select a.fnumber,b.fname,a.fmodeltype,c.fisinherit,c.fid,c.fentityid from t_meta_entitydesign a,t_meta_entitydesign_l b, t_meta_formdesign c where a.fbizappid in (%s) and a.fistemplate=? and a.fmodeltype like ? and b.flocaleid=? and c.ftype!=? and a.fnumber=b.fnumber and a.fnumber = c.fnumber order by a.fnumber asc", rt);
        DB.query((DBRoute)DBRoute.meta, (String)selectSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Map<String, Object>>>(){

            public Set<Map<String, Object>> handle(ResultSet rs) throws KDException {
                try {
                    while (rs.next()) {
                        boolean isInherit = rs.getBoolean("fisinherit");
                        if (!isInherit) continue;
                        HashMap<String, String> template = new HashMap<String, String>(3);
                        template.put(InheritBusinessTemplatePlugin.NUMBER, rs.getString(1));
                        template.put(InheritBusinessTemplatePlugin.NAME, rs.getString(2));
                        template.put(InheritBusinessTemplatePlugin.MODEL_TYPE, rs.getString(3));
                        template.put(InheritBusinessTemplatePlugin.ID, rs.getString(5));
                        template.put(InheritBusinessTemplatePlugin.ENTITY_ID, rs.getString(6));
                        templateArray.add(template);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
                }
                return templateArray;
            }
        });
        return templateArray;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String entityId = (String)this.getModel().getValue(ENTITY_ID, rowIndex);
        DevportalUtil.gotoEntityDesigner((IFormView)this.getView(), (String)entityId);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        if ("inheritBusiness_callBack".equals(event.getActionId()) && (returnData = (Map)event.getReturnData()) != null) {
            HashMap map = new HashMap(2);
            map.put("bizunitid", returnData.get("bizunitid"));
            map.put("bizpageid", returnData.get("formid"));
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }
}

