/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.PageBuilder;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.newdevportal.page.LayoutTemplateUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class LayoutCopyOrExtend
extends AbstractFormPlugin {
    private static final String OK = "ok";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String APP = "app";
    private static final String FUN_GROUP = "fungroup";
    private static final String FORM_ID = "formid";
    private static final String MODELTYPE = "modeltype";
    private static final String BIZ_UNIT_ID = "bizUnitId";
    private static final String BIZ_UNIT = "bizunit";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_ERRORS = "errors";
    private static final String KEY_MESSAGE = "message";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String BOS_DEPORTAL_UNITRELFORM = "bos_devportal_unitrelform";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{OK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String parentName = (String)showParameter.getCustomParam(NAME);
        String parentNumber = (String)showParameter.getCustomParam(NUMBER);
        String bizAppId = (String)showParameter.getCustomParam(APP);
        String formId = (String)showParameter.getCustomParam(FORM_ID);
        String type = (String)showParameter.getCustomParam("optype");
        String formNumSuffix = StringUtils.equals((CharSequence)"copy", (CharSequence)type) ? "_copy" : "_inh";
        String formNameSuffix = StringUtils.equals((CharSequence)"copy", (CharSequence)type) ? ResManager.loadKDString((String)"_\u590d\u5236", (String)"LayoutCopyOrExtend_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"_\u7ee7\u627f", (String)"LayoutCopyOrExtend_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        String formDefaultName = parentName + formNameSuffix;
        String formDefaultNumber = parentNumber + formNumSuffix;
        formDefaultNumber = DevportalUtil.autoIsvNumber((String)formDefaultNumber);
        formDefaultNumber = DevportalUtil.autoFormNumber((String)formDefaultNumber, (String)formNumSuffix);
        formDefaultName = DevportalUtil.autoFormName((String)formDefaultName);
        this.getView().getModel().setValue(NAME, (Object)formDefaultName);
        this.getView().getModel().setValue(NUMBER, (Object)formDefaultNumber);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)((String)this.getView().getFormShowParameter().getCustomParam("entityId")), (MetaCategory)MetaCategory.Entity);
        this.getView().getModel().setValue("entity", (Object)entityMetadata.getName().toString());
        QFilter[] qFilter = new QFilter[]{new QFilter(ID, "=", (Object)bizAppId)};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)NAME, (QFilter[])qFilter);
        DynamicObject appInfo = (DynamicObject)new ArrayList(map.values()).get(0);
        this.getModel().setValue(APP, (Object)appInfo.get(NAME).toString());
        QFilter[] qFilters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        Map mapUnit = BusinessDataServiceHelper.loadFromCache((String)BOS_DEPORTAL_UNITRELFORM, (String)BIZ_UNIT, (QFilter[])qFilters);
        DynamicObject unitInfo = (DynamicObject)new ArrayList(mapUnit.values()).get(0);
        String bizUnitId = String.valueOf(unitInfo.get(BIZ_UNIT));
        String bizUnitName = DevportalUtil.getBizUnitNameById((String)bizAppId, (String)bizUnitId);
        this.getModel().setValue(FUN_GROUP, (Object)bizUnitName);
        this.getView().getPageCache().put(BIZ_UNIT_ID, bizUnitId);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (OK.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(APP);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        ILocaleString formName = (ILocaleString)this.getModel().getValue(NAME);
        String formNumber = (String)this.getModel().getValue(NUMBER);
        StringBuilder errorMsg = PageBuilder.validateNameAndNumber((String)(formNumber = DevportalUtil.autoIsvNumber((String)formNumber)), (ILocaleString)formName, (boolean)false);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg.toString());
            return;
        }
        this.getModel().setDataChanged(false);
        String bizunitid = this.getPageCache().get(BIZ_UNIT_ID);
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(MODELTYPE);
        String parentId = (String)this.getView().getFormShowParameter().getCustomParam(FORM_ID);
        HashMap<String, Object> message = new HashMap<String, Object>();
        this.getModel().setDataChanged(false);
        String srcFormId = (String)this.getView().getFormShowParameter().getCustomParam(FORM_ID);
        FormMetadata metadata = null;
        metadata = StringUtils.equals((CharSequence)"copy", (CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("optype"))) ? LayoutTemplateUtil.copyFormMeta(srcFormId, formNumber, formName.getLocaleValue(), bizAppId) : LayoutTemplateUtil.inheritFormMeta(srcFormId, formNumber, formName.getLocaleValue(), bizAppId);
        metadata.setSrcBizObjId((String)this.getView().getFormShowParameter().getCustomParam("entityId"));
        MetadataWriter write = new MetadataWriter(metadata.getModelType());
        Map save = write.save(new AbstractMetadata[]{metadata});
        if (save.get(KEY_SUCCESS) != null && !((Boolean)save.get(KEY_SUCCESS)).booleanValue()) {
            throw new RuntimeException();
        }
        QFilter q1 = new QFilter("form", "=", (Object)metadata.getId());
        QFilter q2 = new QFilter(BIZ_UNIT, "=", (Object)bizunitid);
        QFilter[] filters = new QFilter[]{q1, q2};
        DeleteServiceHelper.delete((String)BOS_DEPORTAL_UNITRELFORM, (QFilter[])filters);
        DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEPORTAL_UNITRELFORM);
        dObject.set("bizapp", (Object)bizAppId);
        dObject.set(BIZ_UNIT, (Object)bizunitid);
        dObject.set("form", (Object)metadata.getId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
        message.put(FORM_ID, metadata.getId());
        message.put("formname", metadata.getName());
        message.put(KEY_SUCCESS, Boolean.TRUE);
        message.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"LayoutCopyOrExtend_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        this.getView().returnDataToParent(message);
        this.getView().close();
    }
}

