/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class LayoutSelectPlugin
extends AbstractFormPlugin {
    private static final String ID = "id";
    private static final String PID = "pid";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String TERMINAL = "terminal";
    private static final String FORMID = "formid";
    private static final String NUMBER = "number";
    private static final String ISV = "isv";
    private static final String DEVTYPE = "devtype";
    private static final String BTN_GOTO_LAYOUT = "gotolayout";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String MASTERID = "masterid";
    private static final String IS_DEFAULT_MOB = "isdefaultmob";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_GOTO_LAYOUT});
    }

    public void afterCreateNewData(EventObject e) {
        String focusId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        Object layoutIds = this.getView().getFormShowParameter().getCustomParam("layoutIds");
        List<String> layoutIdList = new ArrayList<String>(10);
        if (StringUtils.isNotBlank((Object)layoutIds)) {
            layoutIdList = (List)SerializationUtils.fromJsonString((String)((String)layoutIds), List.class);
        }
        this.initLayoutEntryEntity(layoutIdList, focusId);
    }

    private void initLayoutEntryEntity(List<String> layoutIdList, String focusId) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select t1.fnumber,t1.fmodeltype,t1.fmodifierid,t1.fmodifydate,t1.fid,t1.ftype,t1.fbizappid,t1.fisv,t2.fname,t1.fparentid,t1.fmasterid,t1.fentityid from t_meta_formdesign t1 left join t_meta_formdesign_l t2 on t1.fid=t2.fid and t2.flocaleid = ? where ", new Object[]{new SqlParameter(":flocaleid", 12, (Object)Lang.get().toString())}).appendIn("t1.fid", layoutIdList.toArray());
        HashSet emptyFormNames = new HashSet(10);
        List list = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            ArrayList list1 = new ArrayList(10);
            int index = 0;
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>(20);
                map.put(NUMBER, rs.getString(1));
                map.put(TYPE, this.getLayoutType(rs.getString(2)));
                map.put(TERMINAL, this.getTerminalByModelType(rs.getString(2)));
                map.put(FORMID, rs.getString(5));
                map.put(DEVTYPE, rs.getString(6));
                map.put(ISV, rs.getString(8));
                String name = rs.getString(9);
                if (StringUtils.isBlank((CharSequence)name)) {
                    name = "";
                    emptyFormNames.add(index);
                }
                ++index;
                map.put(NAME, name);
                map.put(PID, rs.getString(10));
                map.put(MASTERID, rs.getString(11));
                map.put(IS_DEFAULT_MOB, "false");
                list1.add(map);
            }
            return list1;
        });
        this.refreshEntryGrid(list, focusId);
    }

    private void refreshEntryGrid(List<Map<String, Object>> formList, String focusId) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        int selectRow = -1;
        if (!formList.isEmpty()) {
            Map<String, Object> val;
            int i;
            HashMap<String, Integer> formIdIndex = new HashMap<String, Integer>(formList.size());
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, formList.size());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (i = 0; i < formList.size(); ++i) {
                val = formList.get(i);
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                row.set(FORMID, val.get(FORMID));
                row.set(NUMBER, val.get(NUMBER));
                row.set(NAME, val.get(NAME));
                row.set(TYPE, val.get(TYPE));
                row.set(TERMINAL, val.get(TERMINAL));
                row.set(ISV, val.get(ISV));
                row.set(DEVTYPE, val.get(DEVTYPE));
                row.set(IS_DEFAULT_MOB, val.get(IS_DEFAULT_MOB));
                if (StringUtils.equals((CharSequence)String.valueOf(val.get(FORMID)), (CharSequence)focusId)) {
                    selectRow = i;
                }
                formIdIndex.put(val.get(FORMID).toString(), i);
            }
            for (i = 0; i < formList.size(); ++i) {
                DynamicObject row;
                Integer parentId;
                val = formList.get(i);
                String pid = val.get(PID).toString();
                String masterId = val.get(MASTERID).toString();
                if (!StringUtils.isNotBlank((CharSequence)pid) || !StringUtils.isNotBlank((CharSequence)masterId) || !StringUtils.isNotBlank((Object)(parentId = (Integer)formIdIndex.get(masterId))) || (row = (DynamicObject)entryEntity.get(parentId.intValue())) == null) continue;
                Long parentRowNum = row.getLong(ID);
                DynamicObject row2 = (DynamicObject)entryEntity.get(i);
                row2.set(PID, (Object)parentRowNum);
            }
        }
        this.getView().updateView(ENTRY_ENTITY);
        this.getModel().putContextVariable("firstSelectRow", (Object)selectRow);
        ((EntryGrid)this.getControl(ENTRY_ENTITY)).selectRows(selectRow, true);
    }

    private String getLayoutType(String type) {
        return "2";
    }

    private String getTerminalByModelType(String modelType) {
        String terminal = "";
        if (modelType.isEmpty()) {
            return terminal;
        }
        terminal = "MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileListModel".equals(modelType) ? "1" : "0";
        return terminal;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (BTN_GOTO_LAYOUT.equals(key)) {
            this.gotoLayout();
        }
    }

    private void gotoLayout() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] rows = entryGrid.getEntryState().getSelectedRows();
        if (rows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"LayoutSelectPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int row = rows[0];
        DynamicObject data = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        String formId = (String)data.get(FORMID);
        String isDefaultMob = (String)data.get(IS_DEFAULT_MOB);
        if ("true".equals(isDefaultMob)) {
            this.gotoOldPageDesigner(this.getView(), formId, "bos_devn_appdetail");
        } else if ("false".equals(isDefaultMob)) {
            GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), formId);
        }
        this.getView().close();
    }

    private void gotoOldPageDesigner(IFormView view, String id, String pageNumber) {
        boolean isHasPermisson = AppUtils.checkPagePermission((String)pageNumber, (String)"4715a0df000000ac");
        if (!isHasPermisson) {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"LayoutSelectPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter qFormId = new QFilter("form", "=", (Object)id);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u8df3\u8f6c\u5931\u8d25\uff0c\u7f16\u7801\u4e3a\u201c%s\u201d\u3002", (String)"LayoutSelectPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pageNumber));
            return;
        }
        String appId = pageRelInfo.getString("bizapp");
        DynamicObject pageInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_formmeta");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formdesigner");
        parameter.setCustomParam(ID, (Object)id);
        parameter.setCustomParam(NUMBER, pageInfo.get(NUMBER));
        parameter.setCustomParam("bizappid", (Object)appId);
        parameter.setClientParam("modeltype", pageInfo.get("modeltype"));
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        parameter.setCustomParam("hideFormListButton", (Object)"yes");
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        view.showForm(parameter);
    }
}

