/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.designer.dao.DynamicFormTemplate;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.operation.EntryOpParameter;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConBarItemAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.AdvConSummaryPanelAp;
import kd.bos.metadata.form.container.AdvConToolbarAp;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.lang.LangItemBuilder;
import kd.bos.metadata.lang.LocaleItem;
import kd.bos.servicehelper.DBServiceHelper;
import org.dom4j.Element;

class LayoutTemplateUtil {
    private static Log log = LogFactory.getLog(LayoutTemplateUtil.class);
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static Map<String, List<Map<String, Object>>> resourceInfosMapping = new HashMap<String, List<Map<String, Object>>>();
    private static Map<String, String[]> srcPathMapping = new HashMap<String, String[]>();
    private static final String BOS_BILLTPL = "00305e8b000006ac";
    private static final String BOS_BILLORGTPL = "ab7efc31000010ac";
    private static final String BOS_BSASETPL = "1942c188000065ac";
    private static final String CONTENT_PANEL_ID = "sb5ReliwR1";
    private static final String BSINFO_PANEL_ID = "mqK0FWAH2I";
    private static final String ATTACHMENT_PANEL_ID = "rrz4n5821A";
    protected static IMetaDao metaDao = new IMetaDao(){

        @Override
        public String getEntityNumberById(String entityId) {
            return MetadataDao.getEntityNumberById((String)entityId);
        }

        @Override
        public AbstractMetadata readRuntimeMeta(String entityId, MetaCategory category) {
            return MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)category);
        }
    };

    private LayoutTemplateUtil() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        URL src = LayoutTemplateUtil.class.getClassLoader().getResource("layouttemplate/templatelist.json");
        ObjectMapper mp = new ObjectMapper();
        mp.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mp.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        try {
            HashMap<String, String> captionMap = new HashMap<String, String>(6);
            captionMap.put("billtemplate", ResManager.loadKDString((String)"\u9ed8\u8ba4\u6a21\u677f", (String)"LayoutTemplateUtil_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            captionMap.put("billtpltemplate", ResManager.loadKDString((String)"\u9ed8\u8ba4\u5355\u636e\u6a21\u677f", (String)"LayoutTemplateUtil_10", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            captionMap.put("basetemplate", ResManager.loadKDString((String)"\u9ed8\u8ba4\u6a21\u677f", (String)"LayoutTemplateUtil_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            captionMap.put("basetpltemplate", ResManager.loadKDString((String)"\u9ed8\u8ba4\u57fa\u7840\u8d44\u6599\u6a21\u677f", (String)"LayoutTemplateUtil_11", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            List datas = (List)mp.readValue(src, List.class);
            for (Map data : datas) {
                String type = String.valueOf(data.get("modelType"));
                List srcDefines = (List)data.get("resources");
                if (srcDefines == null) continue;
                for (Map map : srcDefines) {
                    String srcId = (String)map.get("srcId");
                    String fileName = (String)map.get("fileName");
                    String caption = (String)map.get("caption");
                    HashMap<String, String> resourceInfo = new HashMap<String, String>(2);
                    resourceInfo.put("srcId", srcId);
                    resourceInfo.put("caption", captionMap.getOrDefault(srcId, caption));
                    resourceInfo.put("fileName", fileName);
                    List resourceInfos = resourceInfosMapping.getOrDefault(type, new ArrayList());
                    resourceInfos.add(resourceInfo);
                    resourceInfosMapping.put(type, resourceInfos);
                    srcPathMapping.put(srcId, new String[]{type, "/layouttemplate/" + fileName});
                }
            }
        }
        catch (IOException | IllegalArgumentException e) {
            log.error(e.getMessage());
        }
        finally {
            initialized.set(true);
        }
    }

    public static FormMetadata copyFormMeta(String srcId, String formNum, String formName, String bizAppId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)srcId, (MetaCategory)MetaCategory.Form);
        formMetadata.setId(DBServiceHelper.genStringId());
        formMetadata.setKey(formNum);
        formMetadata.setName(new LocaleString(formName));
        formMetadata.setParentId("");
        formMetadata.setInheritPath("");
        formMetadata.setIsv(ISVService.getISVInfo().getId());
        formMetadata.setBizappId(bizAppId);
        formMetadata.setRuntime(false);
        return formMetadata;
    }

    public static FormMetadata inheritFormMeta(String srcId, String formNum, String formName, String bizAppId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)srcId, (MetaCategory)MetaCategory.Form);
        formMetadata.setId(DBServiceHelper.genStringId());
        formMetadata.setKey(formNum);
        formMetadata.setName(new LocaleString(formName));
        formMetadata.setParentId(srcId);
        formMetadata.setInheritPath(String.join((CharSequence)",", formMetadata.getInheritPath(), srcId));
        formMetadata.setIsv(ISVService.getISVInfo().getId());
        formMetadata.setBizappId(bizAppId);
        return formMetadata;
    }

    public static List<Map<String, Object>> getTemplateInfo(String modelType) {
        if (!initialized.get()) {
            LayoutTemplateUtil.init();
        }
        return resourceInfosMapping.get(modelType);
    }

    public static FormMetadata createMeta(String resrcId, OperateOption options) {
        String masterId;
        if (options == null) {
            options = OperateOption.create();
        }
        FormMetadata metadata = LayoutTemplateUtil.loadMeta(resrcId);
        RefObject resultObj = new RefObject();
        options.tryGetVariableValue("entityId", resultObj);
        String entityId = (String)resultObj.getValue();
        options.tryGetVariableValue("fieldIds", resultObj);
        String fieldIds = (String)resultObj.getValue();
        List<String> fieldIdList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)fieldIds)) {
            fieldIdList = SerializationUtils.fromJsonStringToList((String)fieldIds, String.class);
        }
        resultObj = new RefObject();
        options.tryGetVariableValue("onlyPcLayout", resultObj);
        String onlyPcLayout = (String)resultObj.getValue();
        if ("true".equals(onlyPcLayout) && metadata.getRootAp() instanceof BillFormAp) {
            ((BillFormAp)metadata.getRootAp()).setMobListMeta(null);
            ((BillFormAp)metadata.getRootAp()).setMobMeta(null);
        }
        if (StringUtils.isNotBlank((CharSequence)(masterId = MetadataDao.getMasterId((String)entityId)))) {
            metadata.setEntityId(masterId);
        } else {
            metadata.setEntityId(entityId);
        }
        metadata.setIsv(ISVService.getISVInfo().getId());
        if (fieldIdList.isEmpty()) {
            return metadata;
        }
        LayoutTemplateUtil.fastMapping(metadata, entityId, fieldIdList);
        return metadata;
    }

    private static FormMetadata loadMeta(String resrcId) {
        String[] info;
        if (!initialized.get()) {
            LayoutTemplateUtil.init();
        }
        if ((info = srcPathMapping.get(resrcId)) == null) {
            throw new IllegalArgumentException("resourceId not existed");
        }
        String modelType = info[0];
        String srcPath = info[1];
        LayoutTemplate template = new LayoutTemplate(modelType, srcPath);
        FormMetadata meta = template.getFormMetadata();
        LayoutTemplateUtil.fillLocaleRes(resrcId, meta);
        return meta;
    }

    private static void fillLocaleRes(String resrcId, FormMetadata metadata) {
        String number = "";
        switch (resrcId) {
            case "billtemplate": 
            case "billtpltemplate": {
                number = "bos_billtpl";
                break;
            }
            case "basetemplate": 
            case "basetpltemplate": {
                number = "bos_basetpl";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)number)) {
            LayoutTemplateUtil.fillLocaleRes(metadata, number);
        }
    }

    private static void fillLocaleRes(FormMetadata metadata, String tplNumber) {
        String id = MetadataDao.getIdByNumber((String)tplNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata tpl = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        DomainModelType domainModel = DomainModelType.getDomainModelType((String)tpl.getModelType(), (boolean)false);
        DomainModelBinder binder = new DomainModelBinder(domainModel);
        NameItemBuilder builder = new NameItemBuilder((DcBinder)new DomainModelBinder(domainModel));
        builder.buildRes(tpl, binder.getDataEntityType((Object)tpl));
        NameItemWriter writer = new NameItemWriter((DcBinder)binder, metadata, builder.localeItems);
        ArrayList<String> langs = new ArrayList<String>(2);
        langs.add(Lang.get().toString());
        langs.add(Lang.zh_CN.toString());
        writer.setLocaleValue(langs);
    }

    private static void fastMapping(FormMetadata meta, String entityId, List<String> fieldIds) {
        if (StringUtils.isBlank((CharSequence)entityId) || StringUtils.isBlank((CharSequence)metaDao.getEntityNumberById(entityId))) {
            throw new IllegalArgumentException("entityId not found");
        }
        EntityMetadata entityMetadata = (EntityMetadata)metaDao.readRuntimeMeta(entityId, MetaCategory.Entity);
        entityMetadata.createIndex();
        ArrayList items = new ArrayList(fieldIds.size());
        for (String fieldId : fieldIds) {
            EntityItem entityItem = entityMetadata.getItemById(fieldId);
            if (entityItem == null) continue;
            items.add(entityItem);
        }
        BiFunction<EntityItem, EntityMetadata, Entity> getParentEntryFunc = (it, entityMeta) -> {
            if (it == null) {
                return null;
            }
            String parentId = it.getParentId();
            if (StringUtils.isBlank((CharSequence)parentId)) {
                return entityMeta.getRootEntity();
            }
            Entity parent = null;
            while (StringUtils.isNotBlank((CharSequence)parentId) && parent == null) {
                EntityItem p = entityMeta.getItemById(parentId);
                if (p instanceof Entity) {
                    parent = (Entity)p;
                    break;
                }
                if (p == null) break;
                parentId = p.getParentId();
            }
            return parent;
        };
        ControlApBuilder builder = new ControlApBuilder(meta, entityMetadata, items, getParentEntryFunc);
        List<ControlAp> newControlAps = builder.build();
        LinkedHashMap<String, FieldAp> fieldApMapping = new LinkedHashMap<String, FieldAp>(3);
        LinkedHashMap<String, EntryAp> entityApMapping = new LinkedHashMap<String, EntryAp>(3);
        for (ControlAp ap : newControlAps) {
            if (ap instanceof FieldAp) {
                fieldApMapping.put(((FieldAp)ap).getFieldId(), (FieldAp)ap);
                continue;
            }
            if (!(ap instanceof EntryAp)) continue;
            entityApMapping.put(((EntryAp)ap).getEntryId(), (EntryAp)ap);
        }
        String headFieldParentId = meta.getRootAp().getId();
        String contentFlexId = meta.getRootAp().getId();
        int entryStartIndex = meta.getItems().size();
        for (ControlAp controlAp : meta.getItems()) {
            if (!(controlAp instanceof FieldsetPanelAp)) continue;
            headFieldParentId = controlAp.getId();
            contentFlexId = controlAp.getParentId();
            entryStartIndex = controlAp.getIndex() + 1;
            break;
        }
        for (Map.Entry entry : fieldApMapping.entrySet()) {
            Entity parent = getParentEntryFunc.apply(entityMetadata.getItemById((String)entry.getKey()), entityMetadata);
            if (parent == null) continue;
            if (parent instanceof MainEntity) {
                ((FieldAp)entry.getValue()).setParentId(headFieldParentId);
            } else {
                EntryAp entryAp = (EntryAp)entityApMapping.get(parent.getId());
                if (entryAp != null) {
                    ((FieldAp)entry.getValue()).setParentId(entryAp.getId());
                }
            }
            meta.getItems().add(entry.getValue());
        }
        HashMap<String, String> newEntryMap = new HashMap<String, String>(16);
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        LayoutTemplateUtil.getOPEntryId(entityMetadata, newEntryMap, hashMap);
        for (Map.Entry entrySet : entityApMapping.entrySet()) {
            AdvConAp advConAp = (AdvConAp)IControlApCreator.createControlAP(meta.getModelType(), "AdvConAp");
            AdvConSummaryPanelAp advConSummaryPanelAp = (AdvConSummaryPanelAp)IControlApCreator.createControlAP(meta.getModelType(), "AdvConSummaryPanelAp");
            AdvConToolbarAp advConToolbarAp = (AdvConToolbarAp)IControlApCreator.createControlAP(meta.getModelType(), "AdvConToolbarAp");
            AdvConChildPanelAp advConChildPanelAp = (AdvConChildPanelAp)IControlApCreator.createControlAP(meta.getModelType(), "AdvConChildPanelAp");
            AdvConBarItemAp tbNew = (AdvConBarItemAp)IControlApCreator.createControlAP(meta.getModelType(), "AdvConBarItemAp");
            tbNew.setName(new LocaleString(ResManager.loadKDString((String)"\u589e\u884c", (String)"LayoutTemplateUtil_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0])));
            tbNew.setIndex(0);
            tbNew.setParentId(advConToolbarAp.getId());
            AdvConBarItemAp tbDel = (AdvConBarItemAp)IControlApCreator.createControlAP(meta.getModelType(), "AdvConBarItemAp");
            tbDel.setName(new LocaleString(ResManager.loadKDString((String)"\u5220\u884c", (String)"LayoutTemplateUtil_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0])));
            tbDel.setIndex(0);
            tbDel.setParentId(advConToolbarAp.getId());
            if (LayoutTemplateUtil.isInheritBillTpl(entityMetadata)) {
                String opKey;
                if (newEntryMap.containsKey(entrySet.getKey())) {
                    opKey = (String)newEntryMap.get(entrySet.getKey());
                    opKey = StringUtils.isBlank((CharSequence)opKey) ? "newentry" : opKey;
                    tbNew.setOperationKey(opKey);
                }
                if (hashMap.containsKey(entrySet.getKey())) {
                    opKey = (String)hashMap.get(entrySet.getKey());
                    opKey = StringUtils.isBlank((CharSequence)opKey) ? "deleteentry" : opKey;
                    tbDel.setOperationKey(opKey);
                }
                ((EntryAp)entrySet.getValue()).setShowSeq(true);
                ((EntryAp)entrySet.getValue()).setShowSelChexkbox(true);
            }
            advConAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5206\u5f55", (String)"LayoutTemplateUtil_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0])));
            advConAp.setParentId(contentFlexId);
            advConAp.setIndex(entryStartIndex++);
            advConAp.setCollapsible(true);
            advConAp.setGrow(0);
            advConAp.setShrink(0);
            advConSummaryPanelAp.setParentId(advConAp.getId());
            advConToolbarAp.setParentId(advConAp.getId());
            advConChildPanelAp.setParentId(advConAp.getId());
            ((EntryAp)entrySet.getValue()).setParentId(advConChildPanelAp.getId());
            meta.getItems().add(advConAp);
            meta.getItems().add(advConSummaryPanelAp);
            meta.getItems().add(advConToolbarAp);
            meta.getItems().add(advConChildPanelAp);
            meta.getItems().add(tbNew);
            meta.getItems().add(tbDel);
            meta.getItems().add(entrySet.getValue());
        }
        for (ControlAp ctl : meta.getItems()) {
            if (!(ctl instanceof AttachmentPanelAp)) continue;
            ctl.setIndex(entryStartIndex++);
            break;
        }
        if (LayoutTemplateUtil.isInheritBillTpl(entityMetadata)) {
            LayoutTemplateUtil.adjustmentLayout(meta);
        }
        if (LayoutTemplateUtil.isInheritBaseTpl(entityMetadata)) {
            LayoutTemplateUtil.adjsutMentBaseTplLayout(meta);
        }
    }

    private static void getOPEntryId(EntityMetadata entityMetadata, Map<String, String> newEntryMap, Map<String, String> delEntryMap) {
        if (entityMetadata == null) {
            return;
        }
        List operations = entityMetadata.getRootEntity().getOperations();
        if (operations != null) {
            for (Operation operation : operations) {
                if (!(operation.getParameter() instanceof EntryOpParameter)) continue;
                EntryOpParameter parameter = (EntryOpParameter)operation.getParameter();
                String entryId = parameter.getEntryId();
                if ("newentry".equals(operation.getOperationType())) {
                    newEntryMap.put(entryId, operation.getKey());
                }
                if (!"deleteentry".equals(operation.getOperationType())) continue;
                delEntryMap.put(entryId, operation.getKey());
            }
        }
    }

    private static boolean isInheritBillTpl(EntityMetadata entityMetadata) {
        if (entityMetadata == null) {
            return false;
        }
        String parentId = entityMetadata.getParentId();
        return BOS_BILLTPL.equals(parentId) || BOS_BILLORGTPL.equals(parentId);
    }

    private static void adjustmentLayout(FormMetadata formMeta) {
        FormAp formAp = formMeta.getRootAp();
        formAp.setBackColor("#E2E7EF");
        for (ControlAp ctl : formMeta.getItems()) {
            if (!(ctl instanceof AdvConAp)) continue;
            Style advStyle = new Style();
            Margin advMargin = new Margin();
            advMargin.setTop("10px");
            advStyle.setMargin(advMargin);
            ctl.setBackColor("#ffffff");
            ctl.setStyle(advStyle);
        }
        ControlAp contentPanelAp = formMeta.getItem(CONTENT_PANEL_ID);
        contentPanelAp.setBackColor("");
        Border contentPanelBorder = contentPanelAp.getStyle().getBorder();
        contentPanelBorder.setBottom("10px_solid_#E2E7EF");
        contentPanelBorder.setTop("10px_solid_#E2E7EF");
        contentPanelBorder.setLeft("10px_solid_#E2E7EF");
        contentPanelBorder.setRight("10px_solid_#E2E7EF");
        ControlAp bsinfoAp = formMeta.getItem(BSINFO_PANEL_ID);
        bsinfoAp.setBackColor("#ffffff");
        ControlAp attachmentpanel = formMeta.getItem(ATTACHMENT_PANEL_ID);
        if (attachmentpanel != null) {
            Style attachStyle = attachmentpanel.getStyle() == null ? new Style() : attachmentpanel.getStyle();
            Margin attachMargin = attachStyle.getMargin() == null ? new Margin() : attachStyle.getMargin();
            attachMargin.setTop("10px");
            attachStyle.setMargin(attachMargin);
            attachmentpanel.setStyle(attachStyle);
            attachmentpanel.setBackColor("#ffffff");
        }
    }

    private static boolean isInheritBaseTpl(EntityMetadata entityMetadata) {
        if (entityMetadata == null) {
            return false;
        }
        String inheritpath = entityMetadata.getInheritPath();
        return StringUtils.isNotBlank((CharSequence)inheritpath) && inheritpath.contains(BOS_BSASETPL);
    }

    private static void adjsutMentBaseTplLayout(FormMetadata formMeta) {
        FormAp formAp = formMeta.getRootAp();
        formAp.setBackColor("#E2E7EF");
        ControlAp titlepanel = formMeta.getItem("LL4BVAnADa");
        titlepanel.setBackColor("#ffffff");
        ControlAp conentpanel = formMeta.getItem("PxNfkkak4s");
        conentpanel.setGrow(0);
        conentpanel.setBackColor("#ffffff");
        Style conentpanelStyle = conentpanel.getStyle();
        if (conentpanelStyle == null) {
            return;
        }
        Padding conentpanelPadding = conentpanelStyle.getPadding();
        if (conentpanelPadding == null) {
            return;
        }
        conentpanelPadding.setLeft("2px");
        conentpanelPadding.setRight("");
        Border conentpanelBorder = new Border();
        conentpanelBorder.setBottom("10px_solid_#E2E7EF");
        conentpanelBorder.setLeft("10px_solid_#E2E7EF");
        conentpanelBorder.setRight("10px_solid_#E2E7EF");
        conentpanelBorder.setTop("10px_solid_#E2E7EF");
        conentpanelStyle.setBorder(conentpanelBorder);
    }

    static interface IMetaDao {
        public String getEntityNumberById(String var1);

        public AbstractMetadata readRuntimeMeta(String var1, MetaCategory var2);
    }

    static class LayoutTemplate {
        private final String modelType;
        private final DomainModelBinder binder;
        private final String path;

        public LayoutTemplate(String modelType, String path) {
            this.modelType = modelType;
            this.binder = new DomainModelProBinder(DomainModelType.getDomainModelType((String)this.modelType, (boolean)false));
            this.path = path;
        }

        public FormMetadata getFormMetadata() {
            DcxmlSerializer serXml = new DcxmlSerializer((DcBinder)this.binder);
            URL formUrl = DynamicFormTemplate.class.getResource(this.path);
            FormMetadata formMeta = (FormMetadata)serXml.deserialize(formUrl, null);
            formMeta.setId(DBServiceHelper.genStringIds((String)"", (int)1)[0]);
            formMeta.setModelType(this.modelType);
            return formMeta;
        }

        public Map<String, Object> serilizeToMap(Object meta) {
            DcJsonSerializer ser = new DcJsonSerializer((DcBinder)this.binder);
            this.binder.setWriteInheritFlag(true);
            return ser.serializeToMap(meta, null);
        }

        static class DomainModelProBinder
        extends DomainModelBinder {
            public DomainModelProBinder(DomainModelType type) {
                super(type);
            }

            public boolean readSimpleProperty(ISimpleProperty property, Element propElement, Object entity) {
                return super.readSimpleProperty(property, propElement, entity);
            }
        }
    }

    static interface IControlApCreator {
        public ControlAp create(EntityItem var1, FormMetadata var2, EntityMetadata var3);

        public static ControlAp createControlAP(String modelType, String elementId) {
            DomainModelType domainModelType = DomainModelType.getDomainModelType((String)modelType, (boolean)true);
            ElementType type = domainModelType.getElementType(elementId);
            HashMap<String, String> json = new HashMap<String, String>(type.getProperties().size());
            json.put("_Type_", type.getId());
            DomainModelBinder binder = new DomainModelBinder(domainModelType);
            for (Property prop : type.getProperties()) {
                Map editoConfig;
                String key = prop.getPropertyName();
                if (StringUtils.equalsIgnoreCase((CharSequence)"Name", (CharSequence)prop.getPropertyName())) {
                    json.put(key, type.getName().toString());
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"Key", (CharSequence)prop.getPropertyName())) {
                    json.put(key, type.getId().toLowerCase(Locale.ENGLISH) + Uuid8.generateShortUuid());
                }
                if ((editoConfig = prop.getEditor()) == null) continue;
                Object value = editoConfig.getOrDefault("value", null);
                if (value != null) {
                    json.put(key, (String)value);
                    continue;
                }
                Object defValue = editoConfig.getOrDefault("default", null);
                if (defValue == null) continue;
                json.put(key, (String)defValue);
            }
            DcJsonSerializer serJson = new DcJsonSerializer((DcBinder)binder);
            ControlAp result = (ControlAp)serJson.deserializeFromMap(json, null);
            result.setId(Uuid16.create().toString());
            return result;
        }
    }

    static class ControlApBuilder {
        private FormMetadata formMetadata;
        private EntityMetadata entityMetadata;
        private List<EntityItem<?>> entityItems;
        private Map<String, IControlApCreator> typeCreators;
        private DomainModelBinder binder;
        private BiFunction<EntityItem, EntityMetadata, Entity> getParentEntryFunc;
        private AtomicInteger suffix = new AtomicInteger(0);

        public ControlApBuilder(FormMetadata formMetadata, EntityMetadata entityMetadata, List<EntityItem<?>> entityItems, BiFunction<EntityItem, EntityMetadata, Entity> getParentEntryFunc) {
            this.formMetadata = formMetadata;
            this.entityMetadata = entityMetadata;
            this.entityItems = entityItems;
            this.binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)formMetadata.getModelType(), (boolean)true));
            this.getParentEntryFunc = getParentEntryFunc;
            this.typeCreators = new HashMap<String, IControlApCreator>(3);
        }

        public List<ControlAp> build() {
            ArrayList<ControlAp> controlAps = new ArrayList<ControlAp>(10);
            int seq = 0;
            for (EntityItem<?> it : this.entityItems) {
                ControlAp ap;
                IControlApCreator creator = this.getCreator(it);
                if (creator == null || (ap = creator.create(it, this.formMetadata, this.entityMetadata)) == null) continue;
                ap.setIndex(seq++);
                ap.setId(Uuid16.create().toString());
                controlAps.add(ap);
            }
            return controlAps;
        }

        private IControlApCreator getCreator(EntityItem item) {
            String className = item.getClass().getName();
            IControlApCreator creator = this.typeCreators.get(className);
            if (creator != null) {
                return creator;
            }
            if (Field.class.isAssignableFrom(item.getClass())) {
                creator = (entityItem, formMeta, entityMeta) -> {
                    Entity parentEntity = this.getParentEntryFunc.apply(entityItem, entityMeta);
                    String elementId = "";
                    if (parentEntity instanceof MainEntity) {
                        elementId = FieldAp.class.getSimpleName();
                    } else if (parentEntity instanceof EntryEntity) {
                        elementId = EntryFieldAp.class.getSimpleName();
                    }
                    ElementType type = DomainModelType.getDomainModelType((String)formMeta.getModelType()).getElementType(elementId);
                    HashMap<String, String> json = new HashMap<String, String>(type.getProperties().size());
                    json.put("_Type_", type.getId());
                    for (Property prop : type.getProperties()) {
                        Object value;
                        String key = prop.getPropertyName();
                        Map editoConfig = prop.getEditor();
                        if (editoConfig == null) continue;
                        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"FieldId")) {
                            json.put(key, entityItem.getId());
                            continue;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"Name", (CharSequence)prop.getPropertyName())) {
                            json.put(key, entityItem.getName().toString());
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"Key", (CharSequence)prop.getPropertyName())) {
                            json.put(key, type.getId().toLowerCase(Locale.ENGLISH) + this.suffix.addAndGet(1));
                        }
                        if ((value = editoConfig.getOrDefault("value", null)) != null) {
                            json.put(key, (String)value);
                            continue;
                        }
                        Object defValue = editoConfig.getOrDefault("default", null);
                        if (defValue == null) continue;
                        json.put(key, (String)defValue);
                    }
                    DcJsonSerializer serJson = new DcJsonSerializer((DcBinder)this.binder);
                    return (ControlAp)serJson.deserializeFromMap(json, null);
                };
            } else if (EntryEntity.class.isAssignableFrom(item.getClass())) {
                creator = (entityItem, formMeta, entityMeta) -> {
                    ElementType type = DomainModelType.getDomainModelType((String)formMeta.getModelType()).getElementType(EntryAp.class.getSimpleName());
                    HashMap<String, String> json = new HashMap<String, String>(type.getProperties().size());
                    json.put("_Type_", type.getId());
                    for (Property prop : type.getProperties()) {
                        Object value;
                        String key = prop.getPropertyName();
                        Map editoConfig = prop.getEditor();
                        if (editoConfig == null) continue;
                        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"EntryId")) {
                            json.put(key, entityItem.getId());
                            continue;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"Name", (CharSequence)prop.getPropertyName())) {
                            json.put(key, entityItem.getName().toString());
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"Key", (CharSequence)prop.getPropertyName())) {
                            json.put(key, type.getId().toLowerCase(Locale.ENGLISH) + this.suffix.addAndGet(1));
                        }
                        if ((value = editoConfig.getOrDefault("value", null)) != null) {
                            json.put(key, (String)value);
                            continue;
                        }
                        Object defValue = editoConfig.getOrDefault("default", null);
                        if (defValue == null) continue;
                        json.put(key, (String)defValue);
                    }
                    DcJsonSerializer serJson = new DcJsonSerializer((DcBinder)this.binder);
                    return (ControlAp)serJson.deserializeFromMap(json, null);
                };
            }
            this.typeCreators.put(className, creator);
            return creator;
        }
    }

    static class NameItemWriter {
        private List<LocaleItem> localeItems;
        private Map<String, ILocaleValue> langMaps = new HashMap<String, ILocaleValue>(10);

        NameItemWriter(DcBinder binder, Object entity, Map<String, ILocaleValue> langItems) {
            LangItemBuilder builder = new LangItemBuilder(binder);
            builder.builderResouces(entity, null);
            this.localeItems = builder.getLocaleItems();
            this.langMaps.putAll(langItems);
        }

        public void setLocaleValue(List<String> langs) {
            for (LocaleItem item : this.localeItems) {
                Map langValue;
                String id;
                ILocaleValue value = (ILocaleValue)item.getProperty().getValue(item.getDataEntity());
                if (value == null || StringUtils.isBlank((CharSequence)(id = value.toString())) || (langValue = (Map)this.langMaps.get(id)) == null) continue;
                for (String lang : langs) {
                    if (langValue.get(lang) == null) continue;
                    value.setItem(lang, (Object)((String)langValue.get(lang)));
                }
            }
        }
    }

    static class NameItemBuilder {
        private DcBinder binder;
        private Map<String, ILocaleValue> localeItems = new HashMap<String, ILocaleValue>();

        NameItemBuilder(DcBinder binder) {
            this.binder = binder;
            this.addDefLocaleItems();
        }

        private void addDefLocaleItems() {
            this.add2LocaleItem(ResManager.getLocaleString((String)"\u6309\u94ae1", (String)"LayoutTemplateUtil_3", (String)"bos-devportal-new-plugin"));
            this.add2LocaleItem(ResManager.getLocaleString((String)"\u6309\u94ae2", (String)"LayoutTemplateUtil_4", (String)"bos-devportal-new-plugin"));
            this.add2LocaleItem(ResManager.getLocaleString((String)"\u5206\u5f55", (String)"LayoutTemplateUtil_5", (String)"bos-devportal-new-plugin"));
            this.add2LocaleItem(ResManager.getLocaleString((String)"\u4fdd\u5b58\u5e76\u65b0\u589e", (String)"LayoutTemplateUtil_6", (String)"bos-devportal-new-plugin"));
            this.add2LocaleItem(ResManager.getLocaleString((String)"\u7981\u7528", (String)"LayoutTemplateUtil_7", (String)"bos-devportal-new-plugin"));
            this.add2LocaleItem(ResManager.getLocaleString((String)"\u5355\u636e\u4f53", (String)"LayoutTemplateUtil_8", (String)"bos-devportal-new-plugin"));
        }

        private void add2LocaleItem(LocaleString value) {
            if (value != null && StringUtils.isNotBlank((CharSequence)Lang.zh_CN.toString())) {
                this.localeItems.put((String)value.getItem(Lang.zh_CN.toString()), (ILocaleValue)value);
            }
        }

        void buildRes(Object currentEntity, IDataEntityType currentEntityType) {
            for (IDataEntityProperty p : currentEntityType.getProperties()) {
                Object val = p.getValue(currentEntity);
                if (val == null) continue;
                if (p instanceof ISimpleProperty && StringUtils.equalsIgnoreCase((CharSequence)"Name", (CharSequence)p.getName()) && p.getPropertyType() != null && ILocaleValue.class.isAssignableFrom(p.getPropertyType())) {
                    ILocaleValue currentLValue = (ILocaleValue)val;
                    this.localeItems.put(String.valueOf(currentLValue.get((Object)Lang.zh_CN.toString())), currentLValue);
                    continue;
                }
                if (p instanceof IComplexProperty) {
                    this.buildRes(val, this.binder.getDataEntityType(val));
                    continue;
                }
                if (!(p instanceof ICollectionProperty)) continue;
                this.builderCollectionReources((ICollectionProperty)p, currentEntity);
            }
        }

        private void builderCollectionReources(ICollectionProperty property, Object currentEntity) {
            Object currentValue = property.getValue(currentEntity);
            List listValue = (List)currentValue;
            for (Object objVal : listValue) {
                this.buildRes(objVal, this.binder.getDataEntityType(objVal));
            }
        }
    }
}

