/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.newdevportal.page.GetPageTemplatePlugin;
import kd.bos.url.UrlService;

public class PageCreateEntrancePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String PAGE_TYPE = "pageType";
    private static final String LABEL_TITLE = "title";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String TYPE = "type";
    private static final String DESCRIBE = "describe";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BIZ_APP_ID = "app";
    private static final String BIZ_UNIT_ID = "fungroup";
    private static final String KEY_BIZ_APPID = "bizAppId";
    private static final String BTN_PC = "pc";
    private static final String BTN_MOBILE = "mobile";
    private static final String PC_OR_MOBILE = "pcOrMobile";

    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{BTN_PC, BTN_MOBILE});
    }

    public void afterCreateNewData(EventObject e) {
        this.initEntrancePage();
    }

    private void initEntrancePage() {
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_TYPE);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_ENTITY);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        Set<Object> pageTemplate = new LinkedHashSet(3);
        switch (pageType) {
            case "1": {
                pageTemplate = GetPageTemplatePlugin.getPageCreateEntranceType();
                this.controlTerminalTypeVisible();
                break;
            }
            case "2": {
                pageTemplate = GetPageTemplatePlugin.getReportCreateEntranceType();
                break;
            }
            case "3": {
                pageTemplate = GetPageTemplatePlugin.getParameterCreateEntranceType();
                break;
            }
            case "5": {
                pageTemplate = GetPageTemplatePlugin.getLayoutCreateEntranceType();
                this.controlTerminalTypeVisible();
                break;
            }
            default: {
                pageTemplate = GetPageTemplatePlugin.getBusinessCreateEntranceType();
            }
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, pageTemplate.size());
        Iterator<Object> iterator = pageTemplate.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            cardEntry.setCustomProperties(ENTRY_ENTITY, i, this.toImageValue((String)next.get("vectorap")));
            this.getModel().setValue("textfield", next.get(TYPE), i);
            this.getModel().setValue("textareafield", next.get(DESCRIBE), i);
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void controlTerminalTypeVisible() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"items"});
        this.setButtonForeColor(BTN_PC, "#5582F3");
        this.setButtonForeColor(BTN_MOBILE, "#212121");
        this.setButtonImage(BTN_PC);
        this.getPageCache().put(PC_OR_MOBILE, BTN_PC);
    }

    private Map<String, Object> toImageValue(String url) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        String domainUrl = UrlService.getDomainContextUrl();
        map.put("imageKey", domainUrl + url);
        root.put("imageap", map);
        return root;
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_TYPE);
        if ("5".equals(pageType)) {
            this.gotoCreateLayout(row);
            return;
        }
        switch (row) {
            case 0: {
                this.gotoTypePage("bos_devpn_bypublictpl");
                break;
            }
            case 1: {
                this.gotoTypePage("bos_devpn_bytplnew");
                break;
            }
            case 2: {
                this.gotoTypePage("bos_devpn_inheritobj");
                break;
            }
            case 3: {
                this.gotoTypePage("bos_devpn_gptnewpage");
                break;
            }
        }
    }

    private void gotoCreateLayout(int row) {
        if (row == 1 || row == 2) {
            this.getPageCache().put("newType", String.valueOf(row));
            this.gotoTypePage("bos_devpn_inheritobj");
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_devpn_crepage");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            String imageUrl = "/images/pc/other/pt_bzdj_553_272.png";
            String modelType = "layoutpc";
            String terminalType = this.getPageCache().get(PC_OR_MOBILE);
            if (BTN_MOBILE.equals(terminalType)) {
                modelType = "layoutmobile";
                imageUrl = "/images/pc/other/pt_tylr_553_272.png";
            }
            formShowParameter.setCustomParam("description", (Object)ResManager.loadKDString((String)"\u8868\u5355", (String)"PageCreateEntrancePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            formShowParameter.setCustomParam("modelType", (Object)modelType);
            formShowParameter.setCustomParam("imageUrl", (Object)imageUrl);
            formShowParameter.setCustomParam(KEY_BIZ_APPID, this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID));
            formShowParameter.setCustomParam("bizUnitId", this.getView().getFormShowParameter().getCustomParam(BIZ_UNIT_ID));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "next_closeCallBack"));
            this.getView().showForm(formShowParameter);
        }
    }

    private void gotoTypePage(String formId) {
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_TYPE);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID);
        String fungroup = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_UNIT_ID);
        String bizUnitId = (String)this.getView().getFormShowParameter().getCustomParam("bizunitid");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.setCustomParam(PAGE_TYPE, (Object)pageType);
        parameter.setCustomParam(BIZ_APP_ID, (Object)bizAppId);
        parameter.setCustomParam(KEY_BIZ_APPID, (Object)bizAppId);
        parameter.setCustomParam(BIZ_UNIT_ID, (Object)fungroup);
        parameter.setCustomParam(PC_OR_MOBILE, (Object)this.getPageCache().get(PC_OR_MOBILE));
        if ("bos_devpn_inheritobj".equals(formId)) {
            parameter.setCustomParam(BIZ_UNIT_ID, (Object)bizUnitId);
            if ("0".equals(pageType)) {
                parameter.setCustomParam(LABEL_TITLE, (Object)ResManager.loadKDString((String)"\u7ee7\u627f\u4e1a\u52a1\u5bf9\u8c61\u65b0\u5efa", (String)"PageCreateEntrancePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            } else if ("1".equals(pageType)) {
                parameter.setCustomParam(LABEL_TITLE, (Object)ResManager.loadKDString((String)"\u7ee7\u627f\u9875\u9762\u65b0\u5efa", (String)"PageCreateEntrancePlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            } else if ("2".equals(pageType)) {
                parameter.setCustomParam(LABEL_TITLE, (Object)ResManager.loadKDString((String)"\u7ee7\u627f\u62a5\u8868\u65b0\u5efa", (String)"PageCreateEntrancePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            } else if ("3".equals(pageType)) {
                parameter.setCustomParam(LABEL_TITLE, (Object)ResManager.loadKDString((String)"\u7ee7\u627f\u53c2\u6570\u65b0\u5efa", (String)"PageCreateEntrancePlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            } else if ("5".equals(pageType)) {
                parameter.setCustomParam("newType", (Object)this.getPageCache().get("newType"));
            }
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "closeCallBack");
        parameter.setCloseCallBack(callBack);
        if ("bos_devpn_gptnewpage".equals(parameter.getFormId()) && this.getView().getParentView() != null) {
            this.getView().getParentView().showForm(parameter);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        } else {
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            if (returnData instanceof Map && ((Map)returnData).isEmpty()) {
                this.getView().close();
                return;
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void setButtonForeColor(String key, String foreColor) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fc", foreColor);
        this.getView().updateControlMetadata(key, paramMap);
    }

    private void setButtonImage(String key) {
        if (BTN_PC.equals(key)) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("imageKey", "/icons/pc/other/pc_80_80.png");
            this.getView().updateControlMetadata(key, paramMap);
            HashMap<String, String> paramMap1 = new HashMap<String, String>();
            paramMap1.put("imageKey", "/icons/pc/other/mobile_normal_80_80.png");
            this.getView().updateControlMetadata(BTN_MOBILE, paramMap1);
        } else if (BTN_MOBILE.equals(key)) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("imageKey", "/icons/pc/other/mobile_80_80.png");
            this.getView().updateControlMetadata(key, paramMap);
            HashMap<String, String> paramMap1 = new HashMap<String, String>();
            paramMap1.put("imageKey", "/icons/pc/other/pc_normal_80_80.png");
            this.getView().updateControlMetadata(BTN_PC, paramMap1);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_PC.equals(key)) {
            this.getPageCache().put(PC_OR_MOBILE, BTN_PC);
            this.setButtonForeColor(BTN_PC, "#5582F3");
            this.setButtonForeColor(BTN_MOBILE, "#212121");
            this.setButtonImage(BTN_PC);
        } else if (BTN_MOBILE.equals(key)) {
            this.getPageCache().put(PC_OR_MOBILE, BTN_MOBILE);
            this.setButtonForeColor(BTN_PC, "#212121");
            this.setButtonForeColor(BTN_MOBILE, "#5582F3");
            this.setButtonImage(BTN_MOBILE);
        }
    }
}

