/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.TreeEntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.newdevportal.page.LayoutTemplateUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class PageCreateFieldSelectPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String F_TARGET_PROPS = "ftargetprops";
    private static final String FIELD_CHOOSE_TREE = "fieldtree";
    private static final String BTN_REMOVE = "btnremove";
    private static final String BTN_OK = "btnok";
    private static final String BTN_BACK = "back";
    private static final String FT_NAME = "ftname";
    private static final String FT_ID = "ftid";
    private static final String FIELD_TREE_NODE_INFO_CACHE = "fieldTreeNodeInfoCache";
    private static final String CHECK_NODES = "checkNodes";
    private static final String BTN_ADD = "btnadd";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String BOS_BILLTPL = "00305e8b000006ac";
    private static final String BOS_BILLORGTPL = "ab7efc31000010ac";
    private static final String BOS_BSASETPL = "1942c188000065ac";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_REMOVE, BTN_OK, BTN_BACK, BTN_ADD});
        EntryGrid grid = (EntryGrid)this.getControl(F_TARGET_PROPS);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initFieldTree();
        this.initEntryGrid();
    }

    private void initFieldTree() {
        Set<String> noSupportItemIdSet;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        String terminalType = (String)this.getView().getFormShowParameter().getCustomParam("terminalType");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeBDRefProp(false);
        option.setOutKey(false);
        option.setIncludeAllMasterProps(false);
        option.addInvalidClassTypes(BasedataPropField.class);
        TreeNode root = FormTreeBuilder.buildEntityFieldsTree((EntityMetadata)entityMetadata, (EntityFieldTreeBuildOption)option);
        HashMap<String, EntityItem> itemKeyMapping = new HashMap<String, EntityItem>(entityMetadata.getItems().size());
        entityMetadata.getItems().forEach(t -> itemKeyMapping.put(t.getKey(), (EntityItem)t));
        this.reSetEntryNodeId(root, itemKeyMapping);
        if (StringUtils.isNotEmpty((CharSequence)terminalType) && "layoutmobile".equals(terminalType) && CollectionUtils.isNotEmpty(noSupportItemIdSet = this.getNoSupportItemIds(entityMetadata))) {
            this.removeNoSupportNode(root.getChildren(), noSupportItemIdSet);
        }
        TreeView tree = (TreeView)this.getView().getControl(FIELD_CHOOSE_TREE);
        tree.addNode(root);
        this.getView().getPageCache().put(FIELD_TREE_NODE_INFO_CACHE, SerializationUtils.toJsonString((Object)root));
        ArrayList<String> checkedNodeIds = new ArrayList<String>(10);
        this.markDefCheckedField(tree, root, entityMetadata, checkedNodeIds);
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkedNodeIds));
    }

    private void initEntryGrid() {
        String checkedNodeStr = this.getPageCache().get(CHECK_NODES);
        List checkedNodeIds = SerializationUtils.fromJsonStringToList((String)checkedNodeStr, String.class);
        if (checkedNodeIds.isEmpty()) {
            return;
        }
        int[] indexs = this.getModel().batchCreateNewEntryRow(F_TARGET_PROPS, checkedNodeIds.size());
        TreeNode rootInfo = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE_NODE_INFO_CACHE), TreeNode.class);
        for (int index : indexs) {
            TreeNode node = rootInfo.getTreeNode((String)checkedNodeIds.get(index));
            this.getModel().setValue(FT_ID, (Object)node.getId(), index);
            this.getModel().setValue(FT_NAME, (Object)node.getText(), index);
            this.getModel().setValue("parentid", (Object)node.getParentid(), index);
        }
    }

    private void reSetEntryNodeId(TreeNode node, Map<String, EntityItem> itemKeyMaping) {
        EntityItem entityItem;
        if (node.getChildren() != null && !node.getChildren().isEmpty() && (entityItem = itemKeyMaping.get(node.getId())) != null) {
            node.setId(entityItem.getId());
            for (TreeNode child : node.getChildren()) {
                child.setParentid(node.getId());
                this.reSetEntryNodeId(child, itemKeyMaping);
            }
        }
    }

    private void markDefCheckedField(TreeView treeView, TreeNode root, EntityMetadata entityMetadata, List<String> checkedNodeIds) {
        HashSet sysField = new HashSet(10);
        String parentId = entityMetadata.getParentId();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            EntityMetadata parent = (EntityMetadata)MetadataDao.readMeta((String)parentId, (MetaCategory)MetaCategory.Entity);
            parent.getItems().forEach(it -> {
                if (it instanceof EntryEntity || it instanceof Field) {
                    sysField.add(it.getId());
                }
            });
        }
        HashMap map = new HashMap(10);
        root.iterate(100, n -> map.put(n.getId(), n));
        ArrayList defCheckedNode = new ArrayList(10);
        sysField.stream().forEach(it -> {
            TreeNode node = (TreeNode)map.get(it);
            if (node != null) {
                defCheckedNode.add(node);
                checkedNodeIds.add(node.getId());
            }
        });
        treeView.checkNodes(defCheckedNode);
        this.getView().updateView(FIELD_CHOOSE_TREE);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_REMOVE.equals(key)) {
            this.delete();
        } else if (BTN_OK.equals(key)) {
            EntityMetadata entityMetadata;
            List<Map<String, Object>> datas = LayoutTemplateUtil.getTemplateInfo(this.getView().getFormShowParameter().getCustomParam("modelType").toString());
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
            String masterId = MetadataDao.getMasterId((String)entityId);
            if (StringUtils.isNotBlank((CharSequence)masterId)) {
                entityId = masterId;
            }
            datas = PageCreateFieldSelectPlugin.isInheritBillTpl(entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity)) ? PageCreateFieldSelectPlugin.removeSrcId(datas, "billtemplate") : PageCreateFieldSelectPlugin.removeSrcId(datas, "billtpltemplate");
            datas = PageCreateFieldSelectPlugin.isInheritBalseTpl(entityMetadata) ? PageCreateFieldSelectPlugin.removeSrcId(datas, "basetemplate") : PageCreateFieldSelectPlugin.removeSrcId(datas, "basetpltemplate");
            if (datas != null && datas.size() == 1) {
                String srcId = datas.get(0).get("srcId").toString();
                this.closedCallBack(new ClosedCallBackEvent((Object)this, "selectTemplate", (Object)srcId));
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_devpn_layouttemplate");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("modelType", (Object)this.getView().getFormShowParameter().getCustomParam("modelType").toString());
            fsp.setCustomParam("skipTemplate", (Object)"true");
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectTemplate"));
            this.getView().showForm(fsp);
        } else if (BTN_BACK.equals(key)) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(10);
            map.put("isBack", true);
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else if (BTN_ADD.equals(key)) {
            this.addNodeToRight();
        }
    }

    private static List<Map<String, Object>> removeSrcId(List<Map<String, Object>> datas, String srcId) {
        ArrayList<Map<String, Object>> newDatas = new ArrayList<Map<String, Object>>(10);
        if (datas == null || StringUtils.isBlank((CharSequence)srcId)) {
            return datas;
        }
        for (Map<String, Object> data : datas) {
            String sId = (String)data.get("srcId");
            if (sId.equals(srcId)) continue;
            newDatas.add(data);
        }
        return newDatas;
    }

    private static boolean isInheritBillTpl(EntityMetadata entityMetadata) {
        if (entityMetadata == null) {
            return false;
        }
        String parentId = entityMetadata.getParentId();
        return BOS_BILLTPL.equals(parentId) || BOS_BILLORGTPL.equals(parentId);
    }

    private static boolean isInheritBalseTpl(EntityMetadata entityMetadata) {
        String parentId = entityMetadata.getParentId();
        boolean isBaseTpl = false;
        if (BOS_BSASETPL.equals(parentId)) {
            isBaseTpl = true;
        } else if (StringUtils.isNotBlank((CharSequence)parentId)) {
            String inheritpath;
            DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)"bos_formmeta", (String)"id,inheritpath");
            String string = inheritpath = parent == null ? "" : parent.getString("inheritpath");
            if (StringUtils.isNotBlank((CharSequence)inheritpath) && inheritpath.contains(BOS_BSASETPL)) {
                isBaseTpl = true;
            }
        }
        return isBaseTpl;
    }

    private void addNodeToRight() {
        int addNewSize;
        TreeView tree = (TreeView)this.getView().getControl(FIELD_CHOOSE_TREE);
        List currChecks = tree.getTreeState().getCheckedNodeIds();
        if (currChecks.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u589e\u52a0\u7684\u5b57\u6bb5\u3002", (String)"PageCreateFieldSelectPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        TreeNode rootInfo = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE_NODE_INFO_CACHE), TreeNode.class);
        List<String> checkNodes = this.getEntryEntityIds();
        IDataModel model = this.getModel();
        checkNodes.remove(rootInfo.getId());
        currChecks.remove(rootInfo.getId());
        checkNodes.remove("_headNode_");
        currChecks.remove("_headNode_");
        currChecks.removeAll(checkNodes);
        if ((checkNodes.isEmpty() || currChecks.size() > 0) && (addNewSize = currChecks.size()) > 0) {
            int index = this.getModel().batchCreateNewEntryRow(F_TARGET_PROPS, addNewSize)[0];
            for (String id : currChecks) {
                TreeNode node = rootInfo.getTreeNode(id);
                model.setValue(FT_ID, (Object)node.getId(), index);
                model.setValue(FT_NAME, (Object)node.getText(), index);
                model.setValue("parentid", (Object)node.getParentid(), index);
                ++index;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("selectTemplate".equals(closedCallBackEvent.getActionId())) {
            Object srcId = closedCallBackEvent.getReturnData();
            if (srcId == null) {
                return;
            }
            TreeNode rootInfo = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE_NODE_INFO_CACHE), TreeNode.class);
            HashMap<String, Object> params = new HashMap<String, Object>();
            ArrayList<String> fieldIds = new ArrayList<String>(10);
            ArrayList<String> billFields = new ArrayList<String>(10);
            ArrayList<String> entryFields = new ArrayList<String>(10);
            String entryEntityId = "";
            DynamicObjectCollection fields = this.getModel().getEntryEntity(F_TARGET_PROPS);
            String fieldParentId = "";
            HashSet<String> entryIdSet = new HashSet<String>();
            for (DynamicObject field : fields) {
                TreeNode parent;
                TreeNode node;
                String fieldId = field.getString(FT_ID);
                fieldIds.add(fieldId);
                fieldParentId = field.getString("parentid");
                if (fieldParentId == null || "_headNode_".equals(fieldParentId)) {
                    billFields.add(fieldId);
                } else {
                    entryFields.add(fieldId);
                    node = rootInfo.getTreeNode(fieldId);
                    if (node != null) {
                        parent = rootInfo.getTreeNode(node.getParentid());
                        entryEntityId = parent.getId();
                        if (!rootInfo.getId().equals(entryEntityId)) {
                            entryIdSet.add(entryEntityId);
                        }
                    }
                }
                if ((node = rootInfo.getTreeNode(fieldId)) == null) continue;
                parent = rootInfo.getTreeNode(node.getParentid());
                while (parent != null && !StringUtils.equals((CharSequence)rootInfo.getId(), (CharSequence)parent.getId())) {
                    fieldIds.add(parent.getId());
                    parent = rootInfo.getTreeNode(parent.getParentid());
                }
            }
            if (entryIdSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5e03\u5c40\u4ec5\u652f\u6301\u4e00\u4e2a\u5355\u636e\u4f53\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PageCreateFieldSelectPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return;
            }
            List distincted = fieldIds.stream().distinct().collect(Collectors.toList());
            List bill = billFields.stream().distinct().collect(Collectors.toList());
            List entry = entryFields.stream().distinct().collect(Collectors.toList());
            HashMap<String, Object> mobileInfo = new HashMap<String, Object>(3);
            mobileInfo.put("billfield", bill);
            mobileInfo.put("entryfield", entry);
            mobileInfo.put("entryentityid", entryEntityId);
            params.put("fieldIds", distincted);
            params.put("srcId", srcId.toString());
            params.put("mobileInfo", mobileInfo);
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (F_TARGET_PROPS.equals(source.getKey())) {
            this.delete();
        }
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(F_TARGET_PROPS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u79fb\u9664\u7684\u5b57\u6bb5\u3002", (String)"PageCreateFieldSelectPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> nodeIds = new ArrayList<String>();
        ArrayList<String> toUncheckRows = new ArrayList<String>(10);
        ArrayList<Integer> toRemovedRows = new ArrayList<Integer>(10);
        TreeNode rootInfo = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE_NODE_INFO_CACHE), TreeNode.class);
        for (int row : rows) {
            if (row < 0) continue;
            toRemovedRows.add(row);
            nodeIds.add((String)model.getValue(FT_ID, row));
        }
        Map<String, Integer> idRowMapping = this.getNodeIdRowMapping();
        toUncheckRows.addAll(nodeIds);
        for (String nodeId : nodeIds) {
            TreeNode node = rootInfo.getTreeNode(nodeId);
            if (node == null) continue;
            this.addToRemoveList(node.getChildren(), idRowMapping, toUncheckRows, toRemovedRows);
        }
        int[] removeIndex = toRemovedRows.stream().distinct().mapToInt(Integer::intValue).toArray();
        model.deleteEntryRows(F_TARGET_PROPS, removeIndex);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_CHOOSE_TREE);
        tree.uncheckNodes(toUncheckRows);
    }

    private List<String> getEntryEntityIds() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(F_TARGET_PROPS);
        ArrayList<String> ids = new ArrayList<String>(entryEntity.size());
        for (DynamicObject row : entryEntity) {
            String rowId = (String)row.get(FT_ID);
            ids.add(rowId);
        }
        return ids;
    }

    private void addToRemoveList(List<TreeNode> nodes, Map<String, Integer> idRowMapping, List<String> unCheckedNodes, List<Integer> toRemovedRows) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (TreeNode node : nodes) {
            if (node == null) continue;
            unCheckedNodes.add(node.getId());
            Integer index = idRowMapping.get(node.getId());
            if (index != null) {
                toRemovedRows.add(index);
            }
            this.addToRemoveList(node.getChildren(), idRowMapping, unCheckedNodes, toRemovedRows);
        }
    }

    private Map<String, Integer> getNodeIdRowMapping() {
        int size = this.getModel().getEntryRowCount(F_TARGET_PROPS);
        HashMap<String, Integer> mapping = new HashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            mapping.put(this.getModel().getValue(FT_ID, i).toString(), i);
        }
        return mapping;
    }

    private Set<String> getNoSupportItemIds(EntityMetadata entityMetadata) {
        HashSet<String> noSupportItemIdSet = new HashSet<String>();
        List items = entityMetadata.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            return noSupportItemIdSet;
        }
        for (EntityItem item : items) {
            if (!(item instanceof TreeEntryEntity)) continue;
            noSupportItemIdSet.add(item.getId());
        }
        for (EntityItem item : items) {
            String parentEntryId;
            if (!(item instanceof SubEntryEntity) || !StringUtils.isNotEmpty((CharSequence)(parentEntryId = ((SubEntryEntity)item).getParentEntryId())) || !noSupportItemIdSet.contains(parentEntryId)) continue;
            noSupportItemIdSet.add(item.getId());
        }
        return noSupportItemIdSet;
    }

    private void removeNoSupportNode(List<TreeNode> nodeList, Set<String> noSupportItemIdSet) {
        if (CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        Iterator<TreeNode> iterator = nodeList.iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            if (noSupportItemIdSet.contains(node.getId())) {
                iterator.remove();
                continue;
            }
            this.removeNoSupportNode(node.getChildren(), noSupportItemIdSet);
        }
    }
}

