/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import com.alibaba.fastjson.JSONArray;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.newdevportal.app.my.DevpPermissionUtils;
import kd.bos.newdevportal.app.my.DevportalModelTypes;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.page.BizObjectLayoutPageUtils;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;

public class PageLayoutPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
SearchEnterListener {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String PID = "pid";
    private static final String FORMID = "formid";
    private static final String TERMINAL = "terminal";
    private static final String MODIFIER = "modifier";
    private static final String MOD_TIME = "modtime";
    private static final String MOD_TIME1 = "modtime1";
    private static final String ISV = "isv";
    private static final String MASTERID = "masterid";
    private static final String DEVTYPE = "devtype";
    private static final String PAGE_NUMBER = "pagenumber";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String NEW_PAGE = "newpage";
    private static final String COPY_PAGE = "copypage";
    private static final String EXTEND_PAGE = "extendpage";
    private static final String INHERIT_PAGE = "inheritpage";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_DEFAULT_LAYOUT = "defaultlayout";
    private static final String BTN_REFRESH = "refresh";
    private static final String VECTOR_CLOSE = "closevector";
    private static final String SEARCHAP = "searchap";
    private static final String CACHE_SEARCHVALUE = "cache_searchvalue";
    private static final String ACTIONID_DEFAULTPAGE = "defaultpagesetting";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String BIZAPPID = "bizappid";
    private static final String KINGDEE = "kingdee";

    public void initialize() {
        super.initialize();
        String isv = ISVService.getISVInfo().getId();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addPackageDataListener(event -> {
            if (event.getSource() instanceof OperationColumn && "operationcolumnap".equals(((OperationColumn)event.getSource()).getKey())) {
                List opItems = (List)event.getFormatValue();
                String devType = event.getRowData().getString(DEVTYPE);
                boolean isExt = StringUtils.equals((CharSequence)"2", (CharSequence)devType);
                String dataIsv = event.getRowData().getString(ISV);
                boolean isCurrentIsv = StringUtils.equals((CharSequence)isv, (CharSequence)dataIsv) || ISVServiceHelper.isKingdeeISV() && StringUtils.isBlank((CharSequence)dataIsv);
                for (OperationColItem item : opItems) {
                    if (isExt && (StringUtils.equals((CharSequence)"copy", (CharSequence)item.getOperationKey()) || StringUtils.equals((CharSequence)"inherit", (CharSequence)item.getOperationKey()))) {
                        item.setLocked(true);
                    }
                    if (isCurrentIsv || !StringUtils.equals((CharSequence)"delete", (CharSequence)item.getOperationKey())) continue;
                    item.setLocked(true);
                }
            }
        });
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{NEW_PAGE, COPY_PAGE, EXTEND_PAGE, BTN_OK, BTN_CANCEL, BTN_DEFAULT_LAYOUT, INHERIT_PAGE, BTN_REFRESH, "vectorap"});
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.hideButton();
        this.initLayoutEntryEntity((String)this.getView().getFormShowParameter().getCustomParam("formId"));
        String btnVisible = (String)this.getView().getFormShowParameter().getCustomParam("fromProDesigner");
        if (Boolean.parseBoolean(btnVisible)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnflex"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnflex"});
        }
    }

    private void hideButton() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        SqlBuilder builder = new SqlBuilder();
        builder.append("select ftype from t_meta_formdesign where ", new Object[0]).appendIn("fid", (Object[])new String[]{entityId});
        String fType = (String)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            String type = "";
            if (rs.next()) {
                type = rs.getString(1);
            }
            return type;
        });
        if ("2".equals(fType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{EXTEND_PAGE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXTEND_PAGE});
        }
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        if (appId != null && !AppUtils.checkResourceBelongsToCurDeveloper((String)appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{NEW_PAGE, EXTEND_PAGE, INHERIT_PAGE, COPY_PAGE, BTN_DEFAULT_LAYOUT});
            this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u8bf7\u901a\u8fc7\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\u548c\u8d44\u6e90\u6269\u5c55\u6309\u94ae\u6269\u5c55\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"PageLayoutPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void initLayoutEntryEntity(String focusId) {
        Long userId = RequestContext.get().getCurrUserId();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("layout_entityId");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        }
        List<String> formTypes = DevportalModelTypes.getModelTypesByType(PageType.LayOut.getValue());
        List<String> formIds = BizObjectLayoutPageUtils.getExtFormIds(entityId);
        String searchValue = this.getPageCache().get(CACHE_SEARCHVALUE);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select t1.fnumber,t1.fmodeltype,t1.fmodifierid,t1.fmodifydate,t1.fid,t1.ftype,t1.fbizappid,t1.fisv,t2.fname,t1.fparentid,t1.fmasterid from t_meta_formdesign t1 left join t_meta_formdesign_l t2 on t1.fid=t2.fid and t2.flocaleid = ? where ", new Object[]{new SqlParameter(":flocaleid", 12, (Object)Lang.get().toString())}).appendIn("t1.fmodeltype", formTypes.toArray()).append(" and ", new Object[0]).appendIn("t1.fid", formIds.toArray());
        if (StringUtils.isNotBlank((CharSequence)searchValue)) {
            builder.append(" and (t1.fnumber like ? ", new Object[]{new SqlParameter(":fnumber", 12, (Object)("%" + searchValue + "%"))}).append(" or t2.fname like ?) ", new Object[]{new SqlParameter(":fname", 12, (Object)("%" + searchValue + "%"))});
        }
        builder.append(" ORDER BY t1.fmodifydate desc", new Object[0]);
        HashSet emptyFormNames = new HashSet(10);
        List list = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            ArrayList list1 = new ArrayList(10);
            int index = 0;
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>(20);
                map.put(PAGE_NUMBER, rs.getString(1));
                map.put(TYPE, this.getLayoutType(rs.getString(2)));
                map.put(TERMINAL, this.getTerminalByModelType(rs.getString(2)));
                map.put(MODIFIER, this.getUserNameById(rs.getString(3)));
                Timestamp timestamp = rs.getTimestamp(4);
                map.put(MOD_TIME, this.getLayoutDate(new Date(timestamp.getTime()), userId));
                map.put(FORMID, rs.getString(5));
                map.put(DEVTYPE, rs.getString(6));
                map.put(BIZAPPID, rs.getString(7));
                map.put(ISV, rs.getString(8));
                String name = rs.getString(9);
                if (StringUtils.isBlank((CharSequence)name)) {
                    name = "";
                    emptyFormNames.add(index);
                }
                ++index;
                map.put(NAME, name);
                map.put(PID, rs.getString(10));
                map.put(MASTERID, rs.getString(11));
                list1.add(map);
            }
            return list1;
        });
        this.refreshEntryGrid(list, focusId);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            Donothing op = (Donothing)args.getSource();
            String key = op.getOperateKey();
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] rows = entryGrid.getEntryState().getSelectedRows();
            int row = rows[0];
            DynamicObject data = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
            switch (key) {
                case "preview": {
                    this.preview(data);
                    break;
                }
                case "delete": {
                    this.delete(data);
                    break;
                }
                case "copy": 
                case "inherit": {
                    this.copyPage(data, key);
                    break;
                }
            }
        }
    }

    private void copyPage(DynamicObject data, String type) {
        IDataEntityType metadataType;
        Object id = data.get(FORMID);
        DesignFormMeta formMeta = (DesignFormMeta)BusinessDataReader.read((Object)id, (IDataEntityType)(metadataType = OrmUtils.getDataEntityType(DesignFormMeta.class)), (Boolean)false);
        if ("2".equals(formMeta.getDevType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6269\u5c55\u8868\u5355\u4e0d\u652f\u6301\u590d\u5236\u3002", (String)"PageLayoutPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        AbstractMetadata metadata = MetadataDao.readMeta((String)id.toString(), (MetaCategory)MetaCategory.Form);
        String bizAppId = metadata.getBizappId();
        String pageName = ((FormMetadata)metadata).getName().getLocaleValue();
        String pageNumber = ((FormMetadata)metadata).getKey();
        String modelType = metadata.getModelType();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        QFilter[] qFilters = new QFilter[]{new QFilter("form", "=", id)};
        Map mapUnit = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_unitrelform", (String)"bizunit", (QFilter[])qFilters);
        DynamicObject unitInfo = (DynamicObject)new ArrayList(mapUnit.values()).get(0);
        String bizUnitId = unitInfo.getString("bizunit");
        Boolean isCopy = StringUtils.equals((CharSequence)"copy", (CharSequence)type);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("optype", (Object)type);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("bos_devpn_copylayout");
        fsp.setCustomParam("pk", id);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, isCopy != false ? "pageCopyCallBack" : "pageInheritCallBack"));
        String caption = isCopy != false ? ResManager.loadKDString((String)"\u590d\u5236\u5e03\u5c40", (String)"PageLayoutPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ee7\u627f\u5e03\u5c40", (String)"PageLayoutPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        fsp.setCaption(caption);
        fsp.setCustomParam(NAME, (Object)pageName);
        fsp.setCustomParam("number", (Object)pageNumber);
        fsp.setCustomParam("app", (Object)bizAppId);
        fsp.setCustomParam(FORMID, id);
        fsp.setCustomParam("modeltype", (Object)modelType);
        fsp.setCustomParam("bizUnitId", (Object)bizUnitId);
        fsp.setCustomParam("entityId", (Object)entityId);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() == null && !StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)ACTIONID_DEFAULTPAGE)) {
            return;
        }
        String focusId = "";
        Map map = (Map)event.getReturnData();
        String message = "";
        switch (event.getActionId()) {
            case "newPageCallBack": 
            case "pageInheritCallBack": 
            case "pageCopyCallBack": {
                message = (String)map.get("message");
                if (((Boolean)map.get("success")).booleanValue()) {
                    this.getView().showSuccessNotification(message);
                    focusId = map.get(FORMID) == null ? "" : map.get(FORMID).toString();
                    break;
                }
                this.getView().showErrorNotification(message);
                break;
            }
            case "pageDeleteCallBack": {
                if (map == null || !"ok".equals(map.get("btn"))) break;
                String formId = this.getPageCache().get("formId");
                String bizUnitId = this.getPageCache().get("bizUnitId");
                String collection = this.getPageCache().get("isCollection");
                boolean isCollection = "true".equals(collection);
                String bizAppId = this.getPageCache().get("bizAppId");
                String type = this.getPageCache().get(TYPE);
                Map result = DevportalUtil.deletePage((String)formId, (String)bizUnitId, (Boolean)isCollection, (String)bizAppId, (String)type, (String)"PAGE_TYPE", (String)"bos_formmeta");
                message = (String)result.get("message");
                if (((Boolean)result.get("success")).booleanValue()) {
                    this.getView().showSuccessNotification(message);
                    break;
                }
                this.getView().showErrorNotification(message);
                break;
            }
            case "defaultpagesetting": {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PageLayoutPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                break;
            }
        }
        this.initLayoutEntryEntity(focusId);
    }

    private void delete(DynamicObject data) {
        String isCollection;
        if (EnvTypeHelper.isProductEnv()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"PageLayoutPlugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String formid = data.getString(FORMID);
        String formName = data.getString(NAME);
        QFilter[] qFilter = new QFilter[]{new QFilter(ID, "=", (Object)formid)};
        Map formMeta = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"bizappid, modifierid, type, basedatafield.id", (QFilter[])qFilter);
        if (formMeta == null || formMeta.get(formid) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e03\u5c40\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"PageLayoutPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String focusFormId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if (StringUtils.equals((CharSequence)focusFormId, (CharSequence)formid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e03\u5c40\u6b63\u5728\u7f16\u8f91\u3002", (String)"PageLayoutPlugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject dy = (DynamicObject)formMeta.get(formid);
        String bizAppId = dy.getString(BIZAPPID);
        String entityId = dy.getString("basedatafield.id");
        if (StringUtils.equalsIgnoreCase((CharSequence)formid, (CharSequence)entityId)) {
            this.showDeleteFailTips(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u81ea\u52a8\u751f\u6210\u5e03\u5c40\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PageLayoutPlugin_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.checkDefaulLayout(formid)) {
            this.showDeleteFailTips(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e03\u5c40\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PageLayoutPlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        long userId = dy.getLong("modifierid");
        String type = dy.getString(TYPE);
        QFilter q1 = new QFilter("bizapp", "=", (Object)bizAppId);
        QFilter q2 = new QFilter("user", "=", (Object)userId);
        QFilter q3 = new QFilter("bizpage", "=", (Object)formid);
        QFilter[] filters = new QFilter[]{q1, q2, q3};
        boolean exists = QueryServiceHelper.exists((String)"bos_devportal_shortcut", (QFilter[])filters);
        String string = isCollection = exists ? "true" : "false";
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        boolean isHasPermisson = DevpPermissionUtils.hasBizPageViewPermission(this.getView().getFormShowParameter().getAppId(), "4715e1f1000000ac");
        if (!isHasPermisson) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"PageLayoutPlugin_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean checkDeleteResource = AppUtils.checkDeleteResource((String)formid, (String)bizAppId, (IFormView)this.getView(), (String)"page", (String)"devportal");
        if (!checkDeleteResource) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("form", "=", (Object)formid)};
        DynamicObject mapUnit = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_unitrelform", (String)"bizunit", (QFilter[])qFilters);
        String bizUnitId = null;
        if (mapUnit != null) {
            bizUnitId = mapUnit.getString("bizunit");
        }
        String source = formid + "-" + isCollection;
        JSONArray pageArray = new JSONArray();
        pageArray.add((Object)source);
        this.getPageCache().put("formId", formid);
        this.getPageCache().put("bizUnitId", bizUnitId);
        this.getPageCache().put("isCollection", isCollection);
        this.getPageCache().put("bizAppId", bizAppId);
        this.getPageCache().put(TYPE, type);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devportal_confirmdel");
        parameter.setCustomParam("message", (Object)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u9875\u9762%s\u5417?", (String)"PageLayoutPlugin_18", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), formName));
        parameter.setCustomParam("source", (Object)pageArray.toJSONString());
        parameter.setCustomParam(TYPE, (Object)"page");
        parameter.setCustomParam("bizAppId", (Object)bizAppId);
        parameter.setCustomParam(BIZAPPID, (Object)bizUnitId);
        parameter.setCustomParam("jsessionid", (Object)"");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pageDeleteCallBack"));
        this.getView().showForm(parameter);
    }

    private boolean checkDefaulLayout(String id) {
        String pclistId;
        String pcBillId;
        Map metaData = MetadataDao.loadDesignerMetadata((String)id);
        if (metaData == null) {
            return false;
        }
        Map entityMeta = (Map)metaData.get("entitymeta");
        if (entityMeta == null) {
            return false;
        }
        List entityItems = (List)entityMeta.get("Items");
        Map mainEntity = (Map)entityItems.get(0);
        String settingStr = (String)mainEntity.get("DefaultPageSetting");
        if (StringUtils.isBlank((CharSequence)settingStr)) {
            return false;
        }
        Map pageSetting = (Map)SerializationUtils.fromJsonString((String)settingStr, Map.class);
        String pcbillNumber = (String)pageSetting.get("pcbill");
        if (StringUtils.isNotBlank((CharSequence)pcbillNumber) && StringUtils.equals((CharSequence)(pcBillId = MetadataDao.getIdByNumber((String)pcbillNumber, (MetaCategory)MetaCategory.Form)), (CharSequence)id)) {
            return true;
        }
        String pclistNumber = (String)pageSetting.get("pclist");
        return StringUtils.isNotBlank((CharSequence)pclistNumber) && StringUtils.equals((CharSequence)(pclistId = MetadataDao.getIdByNumber((String)pclistNumber, (MetaCategory)MetaCategory.Form)), (CharSequence)id);
    }

    private void showDeleteFailTips(String message) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_delresourcetip");
        parameter.setCaption(ResManager.loadKDString((String)"\u5220\u9664\u9875\u9762\u63d0\u793a", (String)"PageLayoutPlugin_17", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam("scenetype", (Object)"devportal");
        parameter.setCustomParam("message", (Object)message);
        parameter.setCustomParam("hideDetails", (Object)true);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void preview(DynamicObject data) {
        String formid = data.getString(FORMID);
        QFilter[] qFilter = new QFilter[]{new QFilter(ID, "=", (Object)formid)};
        Map formMeta = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"type, modeltype", (QFilter[])qFilter);
        String type = ((DynamicObject)formMeta.get(formid)).getString(TYPE);
        String modelType = ((DynamicObject)formMeta.get(formid)).getString("modeltype");
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("formname", data.getString(NAME));
        map.put("formnumber", data.getString(PAGE_NUMBER));
        map.put(DEVTYPE, type);
        map.put(FORMID, formid);
        map.put("modeltype", modelType);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_pagepreview");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(map);
        parameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8\u4e0e\u8c03\u8bd5", (String)"PageLayoutPlugin_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "newpage": {
                this.newPage();
                break;
            }
            case "copypage": {
                this.chooseCopyOrExtendLayout(ResManager.loadKDString((String)"\u9009\u62e9\u590d\u5236\u9875\u9762", (String)"PageLayoutPlugin_20", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "copy");
                break;
            }
            case "extendpage": {
                this.chooseCopyOrExtendLayout(ResManager.loadKDString((String)"\u9009\u62e9\u6269\u5c55\u9875\u9762", (String)"PageLayoutPlugin_21", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "extend");
                break;
            }
            case "inheritpage": {
                this.chooseCopyOrExtendLayout(ResManager.loadKDString((String)"\u9009\u62e9\u7ee7\u627f\u9875\u9762", (String)"PageLayoutPlugin_22", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "inherit");
                break;
            }
            case "btnok": {
                this.switchLayout();
                break;
            }
            case "defaultlayout": {
                this.showDefaultLayoutPage();
                break;
            }
            case "btncancel": 
            case "vectorap": {
                this.getView().close();
                break;
            }
            case "refresh": {
                this.initLayoutEntryEntity("");
                break;
            }
        }
    }

    private void switchLayout() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int row = grid.getEntryState().getFocusRow();
        if (row >= 0) {
            String formid = this.getModel().getValue(FORMID, row).toString();
            String teminal = this.getModel().getValue(TERMINAL, row).toString();
            if (teminal.equals("1")) {
                GotoDesignerUtils.gotoDesigner(PageType.LayOut.getValue(), this.getView(), formid);
            } else {
                this.getView().returnDataToParent((Object)formid);
            }
        }
        this.getView().close();
    }

    private void showDefaultLayoutPage() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        BillEntity billEntity = (BillEntity)entityMetadata.getRootEntity();
        String defaultPageSetting = billEntity.getDefaultPageSetting();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_setdefaultpage");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("itemId", entityId);
        map.put("metaType", "entitymeta");
        map.put("propertyName", "DefaultPageSetting");
        map.put("value", defaultPageSetting);
        map.put("modelType", entityMetadata.getModelType());
        map.put("tag", "mxfl_defaultLayout");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID_DEFAULTPAGE));
        showParameter.setCustomParams(map);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void chooseCopyOrExtendLayout(String title, String logo) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_devpn_selectlayout");
        showParameter.setCustomParam("title", (Object)title);
        showParameter.setCustomParam("entityId", this.getView().getFormShowParameter().getCustomParam("entityId"));
        showParameter.setCustomParam("bizAppId", this.getView().getFormShowParameter().getCustomParam(BIZAPPID));
        showParameter.setCustomParam("operationType", (Object)logo);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "copyOrExtendCallBack"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void newPage() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        AbstractMetadata metadata = MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        String bizAppId = metadata.getBizappId();
        String pageName = ((EntityMetadata)metadata).getName().getLocaleValue();
        String pageNumber = ((EntityMetadata)metadata).getKey();
        String modelType = metadata.getModelType();
        QFilter[] qFilters = new QFilter[]{new QFilter("form", "=", (Object)entityId)};
        Map mapUnit = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_unitrelform", (String)"bizunit", (QFilter[])qFilters);
        DynamicObject unitInfo = (DynamicObject)new ArrayList(mapUnit.values()).get(0);
        String bizUnitId = unitInfo.getString("bizunit");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_devpn_sellayouttype");
        showParameter.setCustomParam("entityId", (Object)entityId);
        showParameter.setCustomParam("bizAppId", (Object)bizAppId);
        showParameter.setCustomParam("pageName", (Object)pageName);
        showParameter.setCustomParam("pageNumber", (Object)pageNumber);
        showParameter.setCustomParam("modelType", (Object)modelType);
        showParameter.setCustomParam("bizUnitId", (Object)bizUnitId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newPageCallBack"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String getFormNameByNumber(String number) {
        String formName = "";
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)NAME, (QFilter[])filters);
        formName = dynamicObject.get(NAME).toString();
        return formName;
    }

    private String getUserNameById(String id) {
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)id)};
        String sql = "select ftruename from t_SEC_User where fid =?";
        String name = (String)DB.query((DBRoute)new DBRoute("sys"), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return "";
            }
        });
        return name;
    }

    private String getLayoutType(String type) {
        return "2";
    }

    private String getTerminalByModelType(String modelType) {
        String terminal = "";
        if (modelType.isEmpty()) {
            return terminal;
        }
        terminal = "MobUserGuideFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) || "MobileFormModel".equals(modelType) ? "1" : "0";
        return terminal;
    }

    private String getLayoutDate(Date date, Long userId) {
        return TimeServiceHelper.formatUserTime((java.util.Date)date, (Long)userId);
    }

    private void refreshEntryGrid(List<Map<String, Object>> formList, String focusId) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        int selectRow = -1;
        if (!formList.isEmpty()) {
            Map<String, Object> val;
            int i;
            HashMap<String, Integer> formIdIndex = new HashMap<String, Integer>(formList.size());
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, formList.size());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (i = 0; i < formList.size(); ++i) {
                val = formList.get(i);
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                row.set(FORMID, val.get(FORMID));
                row.set(PAGE_NUMBER, val.get(PAGE_NUMBER));
                row.set(NAME, val.get(NAME));
                row.set(TYPE, val.get(TYPE));
                row.set(TERMINAL, val.get(TERMINAL));
                row.set(MODIFIER, val.get(MODIFIER));
                row.set(MOD_TIME, val.get(MOD_TIME));
                try {
                    Object date = val.get(MOD_TIME);
                    if (date instanceof String) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                        java.util.Date modtime = dateFormat.parse((String)date);
                        row.set(MOD_TIME1, (Object)modtime);
                    }
                }
                catch (ParseException date) {
                    // empty catch block
                }
                row.set(ISV, val.get(ISV));
                row.set(DEVTYPE, val.get(DEVTYPE));
                if (StringUtils.equals((CharSequence)String.valueOf(val.get(FORMID)), (CharSequence)focusId)) {
                    selectRow = i;
                }
                formIdIndex.put(val.get(FORMID).toString(), i);
            }
            for (i = 0; i < formList.size(); ++i) {
                DynamicObject row;
                Integer parentId;
                val = formList.get(i);
                String pid = val.get(PID).toString();
                String masterId = val.get(MASTERID).toString();
                if (!StringUtils.isNotBlank((CharSequence)pid) || !StringUtils.isNotBlank((CharSequence)masterId) || !StringUtils.isNotBlank((Object)(parentId = (Integer)formIdIndex.get(masterId))) || (row = (DynamicObject)entryEntity.get(parentId.intValue())) == null) continue;
                Long parentRowNum = row.getLong(ID);
                DynamicObject row2 = (DynamicObject)entryEntity.get(i);
                row2.set(PID, (Object)parentRowNum);
            }
        }
        this.getView().updateView(ENTRY_ENTITY);
        this.getModel().putContextVariable("firstSelectRow", (Object)selectRow);
        ((EntryGrid)this.getControl(ENTRY_ENTITY)).selectRows(selectRow, true);
    }

    public void afterBindData(EventObject e) {
        Object row = this.getModel().getContextVariable("firstSelectRow");
        if (row != null) {
            ((EntryGrid)this.getControl(ENTRY_ENTITY)).selectRows(((Integer)row).intValue(), true);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        String formId = (String)this.getModel().getValue(ID, rowIndex);
        DevportalUtil.gotoNewPageDesinger((IFormView)this.getView(), (String)formId, (String)"bos_devportal_bizpagelist");
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.getPageCache().put(CACHE_SEARCHVALUE, searchEnterEvent.getText());
        this.initLayoutEntryEntity("");
    }
}

