/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.newdevportal.page.LayoutTemplateUtil;
import kd.bos.url.UrlService;

public class QuickLayoutTemplateSelectPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(QuickLayoutTemplateSelectPlugin.class);
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String PROJECTNAME = "bos-devportal-new-plugin";
    private static final String BTN_CLOSE = "btn_close";
    private static final String BTN_OK = "btn_ok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CLOSE, BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String bizAppId = (String)params.get("bizappid");
        String modelType = (String)params.get("modelType");
        List<Map<String, Object>> datas = LayoutTemplateUtil.getTemplateInfo(modelType == null ? "BillFormModel" : modelType);
        if (datas != null && !datas.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, datas.size());
            int i = 0;
            for (Map<String, Object> data : datas) {
                Object imageUri = data.get("imageUri");
                this.getModel().setValue("srcid", data.get("srcId"), i);
                this.getModel().setValue("picture", (Object)String.format("%s%s", UrlService.getDomainContextUrl(), imageUri != null ? imageUri.toString() : "/images/pc/other/bos_jcl_480_26.png"), i);
                Object caption = data.get("caption");
                this.getModel().setValue("caption", (Object)(caption != null ? caption.toString() : ResManager.loadKDString((String)"\u9ed8\u8ba4\u6a21\u677f", (String)"QuickLayoutTemplateSelectPlugin_0", (String)PROJECTNAME, (Object[])new Object[0])), i);
                ++i;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u672a\u8bbe\u7f6e\u8d44\u6e90\u6587\u4ef6\u3002", (String)"QuickLayoutTemplateSelectPlugin_1", (String)PROJECTNAME, (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        int count = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        if (count > 0) {
            ((AbstractGrid)this.getControl(KEY_ENTRYENTITY)).selectRows(0);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_ok": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
                int[] selRows = entryGrid.getEntryState().getSelectedRows();
                if (selRows.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c", (String)"QuickLayoutTemplateSelectPlugin_2", (String)PROJECTNAME, (Object[])new Object[0]));
                    return;
                }
                String srcId = (String)this.getModel().getValue("srcid", selRows[0]);
                this.getView().returnDataToParent((Object)srcId);
                this.getView().close();
                break;
            }
            case "btn_close": {
                this.getView().close();
                break;
            }
        }
    }
}

