/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SelectCopyOrExtendLayout
extends AbstractFormPlugin
implements SearchEnterListener,
HyperLinkClickListener {
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String TERMINAL = "terminal";
    private static final String ENTITY_ID_INFO = "entityid";
    private static final String ENTITY_NAME = "entityname";
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String PAGE_ID = "pageid";
    private static final String PAGE_NAME = "pagename";
    private static final String PAGE_NUMBER = "pagenumber";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BTN_NEXT = "next";
    private static final String SEARCH_AP = "searchap";
    private static final String ENTITY_ID = "entityId";
    private static final String BOS_FORM_META = "bos_formmeta";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{BTN_NEXT});
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String title = (String)this.getView().getFormShowParameter().getCustomParam("title");
        this.getModel().setValue("title", (Object)title);
        this.getLayout(null);
    }

    public void click(EventObject evt) {
        String key = ((Button)evt.getSource()).getKey();
        if (key.equals(BTN_NEXT)) {
            String caption = "";
            String logo = (String)this.getView().getFormShowParameter().getCustomParam("operationType");
            if ("copy".equals(logo)) {
                caption = ResManager.loadKDString((String)"\u590d\u5236\u9875\u9762", (String)"SelectCopyOrExtendLayout_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            } else if ("extend".equals(logo)) {
                caption = ResManager.loadKDString((String)"\u6269\u5c55\u9875\u9762", (String)"SelectCopyOrExtendLayout_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            } else if ("inherit".equals(logo)) {
                caption = ResManager.loadKDString((String)"\u7ee7\u627f\u9875\u9762", (String)"SelectCopyOrExtendLayout_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            }
            this.next(caption, logo);
        }
    }

    private void next(String caption, String logo) {
        boolean isInherit;
        boolean isExtended;
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] rows = entryGrid.getEntryState().getSelectedRows();
        if (rows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"SelectCopyOrExtendLayout_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int row = rows[0];
        DynamicObject data = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        String name = data.getString(PAGE_NAME);
        String fid = data.getString(PAGE_ID);
        String number = data.getString(PAGE_NUMBER);
        DynamicObject oriForm = BusinessDataServiceHelper.loadSingleFromCache((Object)fid, (String)BOS_FORM_META, (String)"isextended,isinherit");
        boolean bl = isExtended = oriForm == null ? true : oriForm.getBoolean("isextended");
        if (!isExtended) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u88ab\u6269\u5c55\u3002", (String)"SelectCopyOrExtendLayout_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean bl2 = isInherit = oriForm == null ? true : oriForm.getBoolean("isinherit");
        if (!isInherit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u4e0d\u5141\u8bb8\u88ab\u7ee7\u627f\u3002", (String)"SelectCopyOrExtendLayout_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String count = DevportalUtil.getParallelExtCountByIsv((String)fid, (String)BOS_FORM_META, (String)"parentid");
        if ("0".equals(count) || "inherit".equals(logo)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_devpn_copylayout");
            showParameter.setCustomParam(ID, (Object)fid);
            showParameter.setCustomParam("name", (Object)name);
            showParameter.setCustomParam("number", (Object)number);
            showParameter.setCustomParam(ENTITY_ID, this.getView().getFormShowParameter().getCustomParam(ENTITY_ID));
            showParameter.setCustomParam("bizAppId", this.getView().getFormShowParameter().getCustomParam("bizAppId"));
            showParameter.setCustomParam("operationType", (Object)logo);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "nextCloseCallBack"));
            showParameter.setCaption(caption);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u53ea\u5141\u8bb8\u6269\u5c551\u6b21\u3002", (String)"SelectCopyOrExtendLayout_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void search(SearchEnterEvent event) {
        Search search = (Search)event.getSource();
        if (StringUtils.equals((CharSequence)SEARCH_AP, (CharSequence)search.getKey())) {
            String searchText = event.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        QFilter numberOrNameFilter = null;
        if (!searchText.equals("")) {
            String formatSearchText = String.format("%s%s%s", "%", searchText, "%");
            numberOrNameFilter = new QFilter("name", "like", (Object)formatSearchText);
            numberOrNameFilter.or(new QFilter("number", "like", (Object)formatSearchText));
        }
        this.getLayout(numberOrNameFilter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("nextCloseCallBack".equals(e.getActionId()) && e.getReturnData() != null) {
            this.getView().returnDataToParent(e.getReturnData());
            this.getView().close();
        }
    }

    private void getLayout(QFilter filter) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID);
        String operationType = (String)this.getView().getFormShowParameter().getCustomParam("operationType");
        QFilter f = null;
        if ("inherit".equals(operationType)) {
            f = new QFilter(TYPE, "!=", (Object)"2");
        }
        String sql = String.format("select fid,finheritpath from t_meta_formdesign where fid = '%s'", entityId);
        List idList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            if (rs.next()) {
                String id = rs.getString(1);
                ids.add(id);
                String inheritPath = rs.getString(2);
                if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
                    String[] split = inheritPath.split(",");
                    ids.addAll(Arrays.asList(split));
                }
            }
            return ids;
        });
        QFilter[] filter1 = new QFilter[]{new QFilter("basedatafield.id", "in", (Object)idList), new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel")), filter, f};
        Map<Object, DynamicObject> bosFormMeta = BusinessDataServiceHelper.loadFromCache((String)BOS_FORM_META, (String)"number,name,modeltype,basedatafield,type,parentid.id", (QFilter[])filter1);
        if ("extend".equals(operationType)) {
            List parentids = bosFormMeta.entrySet().stream().filter(r -> "2".equals(((DynamicObject)r.getValue()).getString(TYPE))).map(s -> ((DynamicObject)s.getValue()).getString("parentid.id")).collect(Collectors.toList());
            bosFormMeta = bosFormMeta.entrySet().stream().filter(r -> !r.getKey().equals(((DynamicObject)r.getValue()).getString("basedatafield.id")) || r.getKey().equals(entityId)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (parentids.size() > 0) {
                bosFormMeta = bosFormMeta.entrySet().stream().filter(r -> !parentids.contains(r.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
        } else if ("inherit".equals(operationType)) {
            bosFormMeta = bosFormMeta.entrySet().stream().filter(r -> !r.getKey().equals(((DynamicObject)r.getValue()).getString("basedatafield.id")) || r.getKey().equals(entityId)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        Collection values = bosFormMeta.values();
        ArrayList<DynamicObject> entityDataList = new ArrayList<DynamicObject>(values);
        this.refreshEntryGrid(entityDataList);
    }

    private void refreshEntryGrid(List<DynamicObject> entityDataList) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (entityDataList.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, entityDataList.size());
            int i = 0;
            for (DynamicObject info : entityDataList) {
                this.getModel().setValue(PAGE_NUMBER, (Object)info.getString("number"), i);
                this.getModel().setValue(PAGE_NAME, (Object)info.getString("name"), i);
                this.getModel().setValue(PAGE_ID, (Object)info.getString(ID), i);
                this.getModel().setValue(TYPE, (Object)ResManager.loadKDString((String)"\u8868\u5355+\u5217\u8868", (String)"SelectCopyOrExtendLayout_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), i);
                this.getModel().setValue(TERMINAL, (Object)"PC", i);
                DynamicObject entityInfo = (DynamicObject)info.get("basedatafield");
                this.getModel().setValue(ENTITY_NUMBER, (Object)entityInfo.getString("number"), i);
                this.getModel().setValue(ENTITY_NAME, (Object)entityInfo.getString("name"), i);
                this.getModel().setValue(ENTITY_ID_INFO, (Object)entityInfo.getString(ID), i);
                ++i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        int rowIndex = event.getRowIndex();
        String formId = "";
        if (fieldName.equals(PAGE_NUMBER)) {
            formId = (String)this.getModel().getValue(PAGE_ID, rowIndex);
            DevportalUtil.gotoNewPageDesinger((IFormView)this.getView(), (String)formId, (String)"bos_devportal_bizpagelist");
        } else if (fieldName.equals(ENTITY_NUMBER)) {
            formId = (String)this.getModel().getValue(ENTITY_ID_INFO, rowIndex);
            DevportalUtil.gotoEntityDesigner((IFormView)this.getView(), (String)formId);
        }
    }
}

