/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.newdevportal.page.GetPageTemplatePlugin;
import kd.bos.url.UrlService;

public class SelectLayoutTypePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String BTN_NEXT = "next";
    private static final String BTN_PC = "pc";
    private static final String BTN_MOBILE = "mobile";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_NEXT, BTN_PC, BTN_MOBILE});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem node = new ListboxItem();
        node.setId("type");
        node.setContent(ResManager.loadKDString((String)"\u5e03\u5c40\u7c7b\u578b", (String)"SelectLayoutTypePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(node);
        listbox.addItems(listboxItems);
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        this.loadLayoutTypeData(BTN_PC, modelType);
    }

    private void loadLayoutTypeData(String clientType, String modelType) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        List<Map<String, Object>> datas = GetPageTemplatePlugin.getLayoutTypeInfos();
        if (datas.isEmpty()) {
            return;
        }
        List clientDatas = datas.stream().filter(t -> StringUtils.equals((CharSequence)String.valueOf(t.get("client")), (CharSequence)clientType) && StringUtils.equals((CharSequence)String.valueOf(t.get("modelType")), (CharSequence)modelType)).collect(Collectors.toList());
        if (clientDatas.isEmpty()) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, clientDatas.size());
        int i = 0;
        for (Map clientData : clientDatas) {
            this.getModel().setValue("type", clientData.get("name"), i);
            this.getModel().setValue("id", clientData.get("id"), i);
            cardEntry.setCustomProperties(ENTRY_ENTITY, i, this.toImageKey((String)clientData.get("vectorap")));
            ++i;
        }
    }

    public void afterBindData(EventObject e) {
        this.selectFirst();
        this.setButtonForeColor(BTN_PC, "#5582F3");
        this.setButtonForeColor(BTN_MOBILE, "#212121");
    }

    private void selectFirst() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.selectRows(0);
    }

    private Map<String, Object> toImageKey(String imageKey) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        String domainUrl = UrlService.getDomainContextUrl();
        map.put("imageKey", domainUrl + imageKey);
        root.put("smallimageap", map);
        return root;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (BTN_NEXT.equals(key)) {
            this.next();
        } else if (BTN_PC.equals(key)) {
            this.loadLayoutTypeData(BTN_PC, modelType);
            this.selectFirst();
            this.setButtonForeColor(BTN_PC, "#5582F3");
            this.setButtonForeColor(BTN_MOBILE, "#212121");
        } else if (BTN_MOBILE.equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u529f\u80fd\u5f00\u53d1\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"SelectLayoutTypePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OK);
        }
    }

    private void setButtonForeColor(String key, String foreColor) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fc", foreColor);
        this.getView().updateControlMetadata(key, paramMap);
    }

    private void next() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"SelectLayoutTypePlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_devpn_crepage");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        formShowParameter.setCustomParam("description", this.getModel().getValue("type", selectRows[0]));
        formShowParameter.setCustomParam("imageUrl", (Object)this.getPageCache().get("imageUrl_cache"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "next_closeCallBack"));
        this.getView().showForm(formShowParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        IImage image = (IImage)this.getControl("imageap");
        if (evt.getRow() < 0) {
            image.setUrl("");
            this.getModel().setValue("textareafield", (Object)"");
            return;
        }
        String id = (String)this.getModel().getValue("id", evt.getRow());
        Optional<Map> value = GetPageTemplatePlugin.getLayoutTypeInfos().stream().filter(t -> StringUtils.equals((CharSequence)String.valueOf(t.get("id")), (CharSequence)id)).findFirst();
        String pictureUrl = (String)value.orElseGet(() -> new HashMap(10)).get("pictureurl");
        image.setUrl(pictureUrl);
        this.getPageCache().put("imageUrl_cache", pictureUrl);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        boolean isCancel;
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            this.getView().close();
        } else if (returnData instanceof Map && !(isCancel = Boolean.parseBoolean(String.valueOf(((Map)returnData).get("isBack"))))) {
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

