/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.page;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.PageBuilder;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ThroughBusinessTemplateCreatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_OK = "ok";
    private static final String BTN_LAST = "last";
    private static final String ID = "id";
    private static final String APP = "app";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String FUN_GROUP = "fungroup";
    private static final String MODEL_TYPE = "modeltype";
    private static final String PC_OR_MOBILE = "pcOrMobile";
    private static final String BTN_MOBILE = "mobile";
    private static final String BIZ_APP_ID = "bizAppId";
    private static final String BIZ_UNIT_ID = "bizUnitId";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String FUN_GROUP_INFO_CALL_BACK = "funGroupInfoCallBack";
    private static final String KET_BIZ_FUN_UNIT_ID = "bizFunUnitId";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, FUN_GROUP, BTN_LAST});
        BasedataEdit app = (BasedataEdit)this.getControl(APP);
        app.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String bizUnitId;
        String bizAppId;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String terminalType = (String)parameter.getCustomParam(PC_OR_MOBILE);
        if (BTN_MOBILE.equals(terminalType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"operateflexpanel"});
            this.getModel().setValue("radiogroupfield", (Object)"2");
        }
        if ((bizAppId = (String)parameter.getCustomParam(APP)) != null) {
            this.getModel().setValue(APP, (Object)bizAppId);
            this.getView().setEnable(Boolean.FALSE, new String[]{APP});
        }
        if ((bizUnitId = (String)parameter.getCustomParam(FUN_GROUP)) != null) {
            this.getView().getPageCache().put(KET_BIZ_FUN_UNIT_ID, bizUnitId);
            String bizUnitName = DevportalUtil.getBizUnitNameById((String)bizAppId, (String)bizUnitId);
            this.getModel().setValue(FUN_GROUP, (Object)bizUnitName);
        }
    }

    private void getFunctionUnit(String bizAppId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devpn_fungroup");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(APP, (Object)bizAppId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FUN_GROUP_INFO_CALL_BACK));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() == null) {
            return;
        }
        String actionId = event.getActionId();
        if (FUN_GROUP_INFO_CALL_BACK.equals(actionId)) {
            Map data = (Map)event.getReturnData();
            Map dataMap = (Map)data.get("selectFunUnit");
            String unitId = (String)dataMap.get(ID);
            String unitName = (String)dataMap.get(NAME);
            this.getModel().setValue(FUN_GROUP, (Object)unitName);
            this.getView().getPageCache().put(KET_BIZ_FUN_UNIT_ID, unitId);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.confirm();
        } else if (FUN_GROUP.equals(key)) {
            DynamicObject appInfo = (DynamicObject)this.getModel().getValue(APP);
            if (appInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"ThroughBusinessTemplateCreatePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            } else {
                String bizAppId = (String)appInfo.get(ID);
                this.getFunctionUnit(bizAppId);
            }
        } else if (BTN_LAST.equals(key)) {
            this.getView().returnDataToParent((Object)BTN_LAST);
            this.getView().close();
        }
    }

    private void confirm() {
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ThroughBusinessTemplateCreatePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String modelType = (String)parameter.getCustomParam(MODEL_TYPE);
        String templateNumber = (String)parameter.getCustomParam("templateNumber");
        String bizUnitId = this.getView().getPageCache().get(KET_BIZ_FUN_UNIT_ID);
        DynamicObject appInfo = (DynamicObject)this.getModel().getValue(APP);
        String value = (String)this.getModel().getValue(FUN_GROUP);
        if (appInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"ThroughBusinessTemplateCreatePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u529f\u80fd\u5206\u7ec4\u3002", (String)"ThroughBusinessTemplateCreatePlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ILocaleString name = (ILocaleString)this.getModel().getValue(NAME);
        String number = (String)this.getModel().getValue(NUMBER);
        StringBuilder errorMsg = PageBuilder.validateNameAndNumber((String)number, (ILocaleString)name, (boolean)false);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.getView().showTipNotification(errorMsg.toString());
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String bizAppId = appInfo.getString(ID);
        map.put(ID, number);
        map.put(NAME, (String)name);
        map.put("modelType", modelType);
        map.put("bizappid", appInfo.getString(ID));
        map.put("bizunitid", bizUnitId);
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)templateNumber)};
        DynamicObject templateFormObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id, number, type", (QFilter[])filters);
        if (templateFormObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"ThroughBusinessTemplateCreatePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String templateFormId = templateFormObject.getString(ID);
        map.put("parentId", templateFormId);
        if ("2".equals(templateFormObject.get(TYPE).toString())) {
            map.put("devType", "2");
        }
        String terminalType = (String)this.getView().getFormShowParameter().getCustomParam(PC_OR_MOBILE);
        String createModeRadio = (String)this.getModel().getValue("radiogroupfield");
        if (BTN_MOBILE.equals(terminalType)) {
            if ("1".equals(createModeRadio)) {
                Map message = DevportalUtil.buildNewPage(map, (String)bizAppId, (String)bizUnitId, (IFormView)this.getView(), (boolean)false);
                this.returnData(message, bizUnitId, bizAppId);
            } else if ("2".equals(createModeRadio)) {
                LocaleString formName = new LocaleString(name.getLocaleValue());
                Map message = DevportalUtil.copyMobleForm((String)templateFormId, (String)bizAppId, (String)bizUnitId, (String)number, (LocaleString)formName);
                this.returnData(message, bizUnitId, bizAppId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u521b\u5efa\u7684\u65b9\u5f0f\u3002", (String)"ThroughBusinessTemplateCreatePlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            }
        } else {
            Map message = DevportalUtil.buildNewPage(map, (String)bizAppId, (String)bizUnitId, (IFormView)this.getView(), (boolean)false);
            this.returnData(message, bizUnitId, bizAppId);
        }
    }

    private void returnData(Map<String, Object> message, String bizUnitId, String bizAppId) {
        boolean isSuccess;
        boolean bl = isSuccess = StringUtils.isBlank((Object)message.get("success")) ? false : (Boolean)message.get("success");
        if (StringUtils.isNotBlank(message)) {
            String checkResult = (String)message.get("checkresult");
            if (isSuccess) {
                String formId = (String)message.get("formid");
                HashMap<String, String> returnData = new HashMap<String, String>(2);
                returnData.put(BIZ_UNIT_ID, bizUnitId);
                returnData.put("bizPageId", formId);
                returnData.put(BIZ_APP_ID, bizAppId);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else {
                this.getView().showTipNotification(checkResult);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (NUMBER.equals(property)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber((String)number);
            this.getModel().beginInit();
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().endInit();
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        Object appId = e.getChangeSet()[0].getNewValue();
        if (APP.equals(fieldKey) && appId != null) {
            JSONArray array;
            if (appId instanceof DynamicObject) {
                appId = ((DynamicObject)appId).get(ID);
            }
            if ((array = DevportalUtil.getUnitListData((String)((String)appId))).isEmpty()) {
                return;
            }
            for (int i = 0; i < array.size(); ++i) {
                if (!ResManager.loadKDString((String)"\u9996\u9875", (String)"ThroughBusinessTemplateCreatePlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]).equals(((Map)array.get(i)).get(NAME))) continue;
                this.getView().getPageCache().put(KET_BIZ_FUN_UNIT_ID, (String)((Map)array.get(i)).get(ID));
                this.getModel().setValue(FUN_GROUP, (Object)ResManager.loadKDString((String)"\u9996\u9875", (String)"ThroughBusinessTemplateCreatePlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String currentIsv = ISVService.getISVInfo().getId();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String cloudId = (String)showParameter.getCustomParam("cloudId");
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(QFilter.like((String)"bizcloud", (String)cloudId));
        listShowParameter.getListFilterParameter().getQFilters().add(QFilter.like((String)"isv", (String)currentIsv));
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setLookUp(true);
    }
}

