/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.exception.CheckResultInfo;
import kd.bos.metadata.form.rule.FormRuleActionType;

public class CustomServiceSettingPlugin
extends AbstractFormPlugin {
    private static final String META_TYPE = "metaType";
    private static final String FORM_RULE_PANEL_PAGE_ID = "formrulepanel_pageid";
    private static final String KEY_EXPRESSION = "expression";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        String id;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramStr = (String)customParams.get("paramStr");
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
        String current_metadataStr = (String)customParams.get("current_metadata");
        String metaType = (String)paramMap.get(META_TYPE);
        Map serviceTypeMap = (Map)paramMap.get("serviceType");
        String serviceTypeStr = SerializationUtils.toJsonString((Object)serviceTypeMap);
        FormRuleActionType ruleActionType = (FormRuleActionType)SerializationUtils.fromJsonString((String)serviceTypeStr, FormRuleActionType.class);
        if (Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("fromProDesigner")) && ("DelRowFmtAction".equals(id = ruleActionType.getId()) || "SetRowFmtAction".equals(id) || "DelFieldFmtAction".equals(id) || "SetFieldFmtAction".equals(id))) {
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            parentView.showTipNotification(ResManager.loadKDString((String)"\u65b0\u7248\u672c\u8bbe\u8ba1\u5668\u6682\u4e0d\u652f\u6301\u8be5\u89c4\u5219\u3002", (String)"CustomServiceSettingPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            this.getView().close();
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("contentpanel");
        formShowParameter.setFormId(ruleActionType.getFormid());
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        formShowParameter.setCustomParam("paramStr", (Object)paramStr);
        formShowParameter.setCustomParam("current_metadata", (Object)current_metadataStr);
        formShowParameter.setCustomParam(META_TYPE, (Object)metaType);
        formShowParameter.setCustomParam("controlId", paramMap.get("treeNodeId"));
        formShowParameter.setCustomParam("value", paramMap.get("value"));
        formShowParameter.setCustomParam("serviceType", paramMap.get("serviceType"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "register"));
        this.getView().showForm(formShowParameter);
        this.getPageCache().put(FORM_RULE_PANEL_PAGE_ID, formShowParameter.getPageId());
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equalsIgnoreCase(btn.getKey())) {
            this.closeAndreturnData();
        } else if ("btncancel".equalsIgnoreCase(btn.getKey())) {
            this.getView().close();
        }
    }

    private void closeAndreturnData() {
        String pageId = this.getPageCache().get(FORM_RULE_PANEL_PAGE_ID);
        String expStr = null;
        IBizRuleEditor ruleEditor = null;
        if (pageId != null) {
            IFormView view = this.getView().getView(pageId);
            ruleEditor = this.getBizRuleEditor(view);
            if (ruleEditor != null) {
                CheckResultInfo resultInfo = ruleEditor.checkConfigAndReturn();
                if (resultInfo != null && !resultInfo.isSuccess()) {
                    this.getView().showTipNotification(resultInfo.getInfo().getError());
                    return;
                }
                expStr = ruleEditor.getOutConfig();
            }
            view.close();
            IPageCache childViewPageCache = (IPageCache)view.getService(IPageCache.class);
            String closeFailed = childViewPageCache.get("closeFailed");
            if (StringUtils.isNotBlank((CharSequence)closeFailed)) {
                this.getView().showErrorNotification(closeFailed);
                return;
            }
        }
        HashMap returnData = new HashMap();
        if (StringUtils.isNotBlank(expStr)) {
            Map expression = (Map)SerializationUtils.fromJsonString(expStr, Map.class);
            for (Map.Entry exp : expression.entrySet()) {
                returnData.put(exp.getKey(), SerializationUtils.fromJsonString((String)exp.getValue().toString(), List.class));
            }
            this.getView().returnDataToParent(returnData);
        }
        this.getView().close();
    }

    private IBizRuleEditor getBizRuleEditor(IFormView editForm) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)editForm.getService(FormViewPluginProxy.class);
        IBizRuleEditor bizRuleEditor = null;
        for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
            if (!(plugin instanceof IBizRuleEditor)) continue;
            bizRuleEditor = (IBizRuleEditor)plugin;
            break;
        }
        return bizRuleEditor;
    }
}

