/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.mvc.form.IFormController;
import kd.bos.newdevportal.designer.DesignerTabRefreshEvent;
import kd.bos.newdevportal.entity.AbstractEntityDesignerSubPagePlugin;

public class PluginClassificationShow
extends AbstractEntityDesignerSubPagePlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENABLE = "enable";
    private static final String NAME = "name";
    private static final String LOCAL = "local";
    private static final String PATH = "path";
    private static final String DESC = "desc";
    private static final String REFERENCE = "reference";

    public void afterCreateNewData(EventObject e) {
        Map<String, Plugin> pluginMap = this.getOperationPlugins();
        this.showPlugins(pluginMap);
    }

    private Map<String, Plugin> getOperationPlugins() {
        EntityMetadata metadata = this.getEntityMetadata();
        HashMap<String, Plugin> pluginMap = new HashMap<String, Plugin>(16);
        List operations = metadata.getRootEntity().getOperations();
        if (operations == null || operations.isEmpty()) {
            return pluginMap;
        }
        for (Operation op : operations) {
            List pluginList = op.getPlugins();
            if (pluginList.isEmpty()) continue;
            for (Plugin plugin : pluginList) {
                String className = plugin.getClassName();
                Plugin plugin2 = (Plugin)pluginMap.get(className);
                if (plugin2 != null) {
                    plugin2.setScriptFullName(plugin2.getScriptFullName() + ";" + op.getName());
                    continue;
                }
                plugin.setScriptFullName(op.getName().toString());
                pluginMap.put(className, plugin);
            }
        }
        return pluginMap;
    }

    private void showPlugins(Map<String, Plugin> plugins) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (plugins.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, plugins.size());
            int i = 0;
            for (Map.Entry<String, Plugin> entry : plugins.entrySet()) {
                this.getModel().setValue(REFERENCE, (Object)entry.getValue().getScriptFullName(), i);
                this.getModel().setValue(ENABLE, (Object)entry.getValue().isEnabled(), i);
                String pluginClassName = entry.getValue().getClassName();
                this.getModel().setValue(NAME, (Object)pluginClassName.substring(pluginClassName.lastIndexOf(".") + 1), i);
                this.getModel().setValue(LOCAL, (Object)(entry.getValue().isInherit() ? "0" : "1"), i);
                this.getModel().setValue(PATH, (Object)entry.getKey(), i);
                this.getModel().setValue(DESC, (Object)entry.getValue().getDescription(), i);
                ++i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    @Override
    public Map<String, Object> mergeModel(IDataModel subModel, Map<String, Object> mainEntityContext, Map<String, Object> entityMeta) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        return result;
    }

    @Override
    protected void fireRefreshTabEvent(DesignerTabRefreshEvent e) {
        IFormController controller = (IFormController)this.getView().getService(IFormController.class);
        if (controller != null) {
            controller.loadData();
        }
    }
}

