/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.FieldInfo;
import kd.bos.db.IndexInfo;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.newdevportal.table.ConstaintType;
import kd.bos.newdevportal.table.DesignerColumn;
import kd.bos.newdevportal.table.DesignerConstaint;
import kd.bos.newdevportal.table.DesignerIndex;
import kd.bos.newdevportal.table.DesignerTable;
import kd.bos.newdevportal.table.EntityTableUtil;
import kd.bos.newdevportal.table.IndexType;
import kd.bos.newdevportal.table.TableInfoProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.map.CaseInsensitiveMap;

class DBTableProvider
extends TableInfoProvider {
    private static Log log = LogFactory.getLog(DBTableProvider.class);
    private static boolean distinct = Boolean.parseBoolean(System.getProperty("bos.dev.tableprovider.distinct", "true"));
    protected IGetTableHandler handler;

    DBTableProvider() {
    }

    @Override
    public DesignerTable getTableInfo(String tableName, String entityNum) {
        String lowerTableName = tableName.toLowerCase();
        List<DesignerColumn> cols = this.handler.getColumns(this.route, lowerTableName);
        List<DesignerIndex> idxs = this.handler.getIndexs(this.route, lowerTableName);
        List<DesignerConstaint> constraints = this.handler.getConstraints(this.route, lowerTableName);
        return this.buildTableInfo(cols, constraints, idxs, lowerTableName, entityNum, false);
    }

    private DesignerTable buildTableInfo(List<DesignerColumn> cols, List<DesignerConstaint> constraints, List<DesignerIndex> idxs, String tableName, String entityNum, boolean fastMode) {
        DesignerTable tableInfo = new DesignerTable();
        tableInfo.setId(this.getRoute() + "#" + tableName);
        tableInfo.setComment((ILocaleString)new LocaleString(""));
        tableInfo.setCode(tableName);
        tableInfo.setName(tableName);
        if (cols != null) {
            for (DesignerColumn column : cols) {
                tableInfo.getCols().add(DesignerColumn.copy(column));
            }
        }
        if (constraints != null) {
            for (DesignerConstaint constaint : constraints) {
                tableInfo.getConstaints().add(DesignerConstaint.copy(constaint));
            }
        }
        if (idxs != null) {
            for (DesignerIndex index : idxs) {
                tableInfo.getIdxs().add(DesignerIndex.copy(index));
            }
        }
        if (distinct) {
            if (!tableInfo.getCols().isEmpty()) {
                ArrayList<DesignerColumn> distinctCols = new ArrayList<DesignerColumn>(10);
                tableInfo.getCols().stream().forEach(it -> {
                    if (!distinctCols.contains(it)) {
                        distinctCols.add((DesignerColumn)it);
                    }
                });
                tableInfo.setCols(distinctCols);
            }
            if (!tableInfo.getIdxs().isEmpty()) {
                ArrayList<DesignerIndex> distinctIdxs = new ArrayList<DesignerIndex>(10);
                tableInfo.getIdxs().stream().forEach(it -> {
                    if (!distinctIdxs.contains(it)) {
                        distinctIdxs.add((DesignerIndex)it);
                    }
                });
                tableInfo.setIdxs(distinctIdxs);
            }
            if (!tableInfo.getConstaints().isEmpty()) {
                ArrayList<DesignerConstaint> distinctCons = new ArrayList<DesignerConstaint>(10);
                tableInfo.getConstaints().stream().forEach(it -> {
                    if (!distinctCons.contains(it)) {
                        distinctCons.add((DesignerConstaint)it);
                    }
                });
                tableInfo.setConstaints(distinctCons);
            }
        }
        tableInfo.bindEntityMeta(entityNum, fastMode);
        return tableInfo;
    }

    @Override
    public List<DesignerTable> getTableInfoByAppId(List<String> appIds) {
        Object dbroute;
        QFilter[] filter = new QFilter[]{new QFilter("entryentity.mainentity.bizapp.id", "in", (Object)appIds.toArray())};
        CaseInsensitiveMap routeTables = new CaseInsensitiveMap(appIds.size());
        HashMap entityTableMapping = new HashMap(appIds.size());
        if (Boolean.getBoolean("entitytable.export.fastmode")) {
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_devp_tablediction", (String)"entity.bizapp.dbroute,entity.bizapp.number,tablename,entity.number", (QFilter[])filter);
            for (DynamicObject row : cols) {
                dbroute = row.getString("entity.bizapp.dbroute");
                String tableName = row.getString("tablename");
                String string = row.getString("entity.number");
                routeTables.putIfAbsent(dbroute, new HashMap());
                ((Map)routeTables.get(dbroute)).putIfAbsent(tableName, new HashSet());
                ((Set)((Map)routeTables.get(dbroute)).get(tableName)).add(string);
            }
        } else {
            SqlBuilder builder = new SqlBuilder();
            HashMap<String, Map> entityRouteMap = new HashMap<String, Map>(16);
            builder.append("select t1.fid as entityid,t1.fnumber as entitynum,t2.fdbroute as route from t_meta_formdesign t1 inner join t_meta_bizapp t2 on t1.fbizappid = t2.fid where t1.ftype != '2'  and ", new Object[0]).appendIn("t2.fid", appIds.toArray());
            DataSet dataSet = DB.queryDataSet((String)"entitytable", (DBRoute)DBRoute.meta, (SqlBuilder)builder);
            dbroute = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String string = row.getString("entityid");
                    String dbroute2 = row.getString("route");
                    String num = row.getString("entitynum");
                    if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)dbroute2) || StringUtils.isBlank((CharSequence)num)) continue;
                    Map map = entityRouteMap.getOrDefault(dbroute2, new HashMap(30));
                    map.put(string, num);
                    entityRouteMap.put(dbroute2, map);
                }
            }
            catch (Throwable row) {
                dbroute = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (dbroute != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)dbroute).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            for (Map.Entry it : entityRouteMap.entrySet()) {
                routeTables.put(it.getKey(), new HashMap(50));
                for (Map.Entry entry : ((Map)it.getValue()).entrySet()) {
                    try {
                        Map<String, EntityTableUtil.TableInfo> tableRef = EntityTableUtil.getTableRef((String)entry.getKey());
                        entityTableMapping.put(entry.getValue(), tableRef);
                        for (Map.Entry entry2 : tableRef.entrySet()) {
                            ((Map)routeTables.get(it.getKey())).putIfAbsent(entry2.getKey(), new HashSet());
                            ((Set)((Map)routeTables.get(it.getKey())).get(entry2.getKey())).add(entry.getValue());
                        }
                    }
                    catch (Exception e) {
                        log.error("\u5bfc\u51fa\u6570\u636e\u8868\u89e3\u6790\u5143\u6570\u636e\u62a5\u9519:" + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        int batchSize = Integer.getInteger("devp.tableprovider.batchsize", 1000);
        ArrayList<DesignerTable> result = new ArrayList<DesignerTable>(10);
        for (Map.Entry it : routeTables.entrySet()) {
            DBRoute route = DBRoute.of((String)((String)it.getKey()));
            try {
                DB.getDBType((DBRoute)route);
            }
            catch (Exception exception) {
                this.getLog().error((Throwable)exception);
                continue;
            }
            ArrayList arrayList = new ArrayList(((Map)it.getValue()).keySet());
            int max = arrayList.size();
            CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap();
            CaseInsensitiveMap indexMap = new CaseInsensitiveMap();
            CaseInsensitiveMap constraintMap = new CaseInsensitiveMap();
            for (int i = 0; i <= max; i += batchSize) {
                int off = i + batchSize > max ? max : i + batchSize;
                caseInsensitiveMap.putAll(this.handler.batchLoadColumns(route, arrayList.subList(i, off)));
                indexMap.putAll(this.handler.batchLoadIndexs(route, arrayList.subList(i, off)));
                constraintMap.putAll(this.handler.batchLoadConstraints(route, arrayList.subList(i, off)));
            }
            for (Map.Entry items : ((Map)it.getValue()).entrySet()) {
                for (String entityNum : (Set)items.getValue()) {
                    DesignerTable designerTable = this.buildTableInfo((List)caseInsensitiveMap.get(items.getKey()), (List)constraintMap.get(items.getKey()), (List)indexMap.get(items.getKey()), (String)items.getKey(), entityNum, true);
                    Object extCaption = ((Map)entityTableMapping.getOrDefault(entityNum, new HashMap(0))).getOrDefault(items.getKey(), new EntityTableUtil.TableInfo()).getExtInfo().get("caption");
                    if (extCaption instanceof ILocaleString) {
                        designerTable.setName(extCaption.toString());
                    }
                    result.add(designerTable);
                }
            }
        }
        return result;
    }

    @Override
    protected void setRoute(DBRoute route) {
        super.setRoute(route);
        this.initHandler(route);
    }

    protected void initHandler(DBRoute route) {
        this.handler = new DefaultTableHandler();
    }

    static interface IGetTableHandler {
        default public List<DesignerColumn> getColumns(DBRoute route, String tablename) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(tablename);
            return this.batchLoadColumns(route, list).get(tablename);
        }

        default public List<DesignerIndex> getIndexs(DBRoute route, String tablename) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(tablename);
            return this.batchLoadIndexs(route, list).get(tablename);
        }

        default public List<DesignerConstaint> getConstraints(DBRoute route, String tablename) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(tablename);
            return this.batchLoadConstraints(route, list).get(tablename);
        }

        default public Map<String, Object> getTableExtInfo(DBRoute route, String tablename) {
            return Collections.emptyMap();
        }

        public Map<String, List<DesignerColumn>> batchLoadColumns(DBRoute var1, List<String> var2);

        public Map<String, List<DesignerIndex>> batchLoadIndexs(DBRoute var1, List<String> var2);

        public Map<String, List<DesignerConstaint>> batchLoadConstraints(DBRoute var1, List<String> var2);

        default public Map<String, Map<String, Object>> batchLoadTableExtInfo(DBRoute route, List<String> tableNames) {
            return Collections.emptyMap();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        default public Map<String, List<String>> getPrimaryKeys(DBType dbType, DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<String>>();
            }
            SqlBuilder builder = new SqlBuilder();
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            List upCaseTables = tableNames.stream().map(String::toUpperCase).collect(Collectors.toList());
            if (DBType.Oracle != dbType && DBType.DM != dbType) {
                if (DBType.MySQL == dbType) {
                    builder.append("/*dialect*/select column_name,table_name from information_schema.key_column_usage where TABLE_SCHEMA = schema() and constraint_name= 'PRIMARY' ", new Object[0]).append(" and ", new Object[0]).appendIn("table_name", tableNames.toArray());
                    return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                        HashMap cols = new HashMap(16);
                        while (rs.next()) {
                            String table = rs.getString(2);
                            cols.put(table, new ArrayList());
                            List list = (List)cols.get(table);
                            list.add(rs.getString(1));
                        }
                        return cols;
                    });
                } else if (DBType.PostgreSQL == dbType) {
                    builder.append("/*dialect*/select kcu.column_name,kcu.table_name as key_column from information_schema.table_constraints tco join information_schema.key_column_usage kcu on kcu.constraint_name = tco.constraint_name and kcu.constraint_schema = tco.constraint_schema and kcu.constraint_name = tco.constraint_name where tco.constraint_type = 'PRIMARY KEY' ", new Object[0]).append(" and ", new Object[0]).appendIn("kcu.table_name", lowerCaseTables.toArray()).append(" order by kcu.ordinal_position", new Object[0]);
                    return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                        HashMap cols = new HashMap(16);
                        while (rs.next()) {
                            String table = rs.getString(2);
                            cols.put(table, new ArrayList());
                            List list = (List)cols.get(table);
                            list.add(rs.getString(1));
                        }
                        return cols;
                    });
                } else {
                    if (DBType.SQLServer != dbType) throw new RuntimeException("dbType " + dbType.name() + " not supported yet!");
                    builder.append("/*dialect*/select c.name,o.name from sysindexes i join sysindexkeys k on i.id = k.id and i.indid = k.indid join sysobjects o on i.id = o.id join syscolumns c on i.id=c.id and k.colid = c.colid where o.xtype = 'U' and exists(select 1 from sysobjects where xtype = 'PK' and name = i.name) ", new Object[0]).append(" and ", new Object[0]).appendIn("o.name", upCaseTables.toArray());
                }
                return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                    HashMap cols = new HashMap(16);
                    while (rs.next()) {
                        String table = rs.getString(2);
                        cols.put(table, new ArrayList());
                        List list = (List)cols.get(table);
                        list.add(rs.getString(1));
                    }
                    return cols;
                });
            } else {
                builder.append("/*dialect*/select col.column_name,col.table_name from user_constraints con, user_cons_columns col where con.constraint_name = col.constraint_name and con.constraint_type='P'", new Object[0]).append(" and ", new Object[0]).appendIn("col.table_name", upCaseTables.toArray()).append(" order by position", new Object[0]);
            }
            return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                HashMap cols = new HashMap(16);
                while (rs.next()) {
                    String table = rs.getString(2);
                    cols.put(table, new ArrayList());
                    List list = (List)cols.get(table);
                    list.add(rs.getString(1));
                }
                return cols;
            });
        }
    }

    static class DefaultTableHandler
    implements IGetTableHandler {
        DefaultTableHandler() {
        }

        @Override
        public Map<String, List<DesignerColumn>> batchLoadColumns(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerColumn>>();
            }
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            HashMap res = new HashMap(tableNames.size());
            for (String lowerTable : lowerCaseTables) {
                res.putIfAbsent(lowerTable, new HashMap());
                List fields = DB.getFieldInfo((DBRoute)route, (String)lowerTable);
                for (FieldInfo field : fields) {
                    DesignerColumn col = new DesignerColumn();
                    String name = field.getFieldName();
                    col.setCode(String.valueOf(name));
                    col.setName(name);
                    col.setType(field.getDataType());
                    col.setFullType(field.getDataType());
                    String desc = "";
                    col.setComment((ILocaleString)new LocaleString(desc));
                    Object defaultValue = field.getDataDefault();
                    col.setDefValue(defaultValue == null ? null : String.valueOf(defaultValue));
                    long fieldLenth = field.getDataLength();
                    if (fieldLenth == 0L) {
                        fieldLenth = field.getDataPrecision();
                    }
                    col.setLength(fieldLenth);
                    col.setPrecision(field.getDataPrecision());
                    col.setScale(field.getDataScale());
                    col.setNotnull(!field.isNullable());
                    ((Map)res.get(lowerTable)).put(name, col);
                }
            }
            HashMap<String, List<DesignerColumn>> resultData = new HashMap<String, List<DesignerColumn>>(16);
            for (Map.Entry item : res.entrySet()) {
                resultData.put((String)item.getKey(), new ArrayList(((Map)item.getValue()).values()));
            }
            return resultData;
        }

        @Override
        public Map<String, List<DesignerIndex>> batchLoadIndexs(DBRoute route, List<String> tableNames) {
            HashMap<String, List<DesignerIndex>> datas = new HashMap<String, List<DesignerIndex>>(tableNames.size());
            if (tableNames.isEmpty()) {
                return datas;
            }
            try {
                List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
                HashMap res = new HashMap(tableNames.size());
                for (String lowTable : lowerCaseTables) {
                    res.putIfAbsent(lowTable, new ArrayList());
                    List indexInfos = DB.getIndexInfo((DBRoute)route, (String)lowTable);
                    for (IndexInfo indexInfo : indexInfos) {
                        List idxs = (List)res.get(lowTable);
                        DesignerIndex idx = new DesignerIndex();
                        String indexName = indexInfo.getIndexName();
                        idx.setName(indexName);
                        idx.setCode(indexName);
                        idx.setIndexdef(IndexType.Common.typeValue);
                        idx.setIndexType(IndexType.Common);
                        List indexfieldInfos = indexInfo.getIndexFieldInfo();
                        ArrayList<String> fieldNames = new ArrayList<String>(10);
                        for (IndexInfo.IndexFieldInfo indexfieldInfo : indexfieldInfos) {
                            fieldNames.add(indexfieldInfo.getFieldName());
                        }
                        idx.setRefCols(fieldNames);
                        idxs.add(idx);
                    }
                }
                datas.putAll(res);
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u8868\u67e5\u8be2\u7d22\u5f15\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
            return datas;
        }

        @Override
        public Map<String, List<DesignerConstaint>> batchLoadConstraints(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerConstaint>>();
            }
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            HashMap<String, List<DesignerConstaint>> res = new HashMap<String, List<DesignerConstaint>>(10);
            for (String lowerTable : lowerCaseTables) {
                res.putIfAbsent(lowerTable, new ArrayList());
                List constaints = (List)res.get(lowerTable);
                List primaryKeys = DB.getPrimaryKeys((DBRoute)route, (String)lowerTable);
                for (String primaryKey : primaryKeys) {
                    DesignerConstaint constaint = new DesignerConstaint();
                    constaints.add(constaint);
                    constaint.setName(primaryKey);
                    constaint.setCode(primaryKey);
                    constaint.setRefCols(primaryKeys);
                    constaint.setConstaintType(ConstaintType.Primary);
                }
            }
            return res;
        }
    }

    static class KSQLTableHandler
    implements IGetTableHandler {
        KSQLTableHandler() {
        }

        @Override
        public Map<String, List<DesignerColumn>> batchLoadColumns(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerColumn>>();
            }
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            SqlBuilder builder = new SqlBuilder();
            builder.append("SELECT TABLE_NAME,COLUMN_DEFAULT,IS_NULLABLE", new Object[0]).append(",NUMERIC_SCALE,COLUMN_NAME,CHARACTER_MAXIMUM_LENGTH ", new Object[0]).append(",DATA_TYPE  ", new Object[0]).append(",NUMERIC_PRECISION  ", new Object[0]).append("  ", new Object[0]).append(" FROM KSQL_USERCOLUMNS WHERE ", new Object[0]).appendIn("KSQL_TABNAME", lowerCaseTables.toArray());
            Map data = (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                HashMap result = new HashMap(tableNames.size());
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    String name = rs.getString("COLUMN_NAME");
                    result.putIfAbsent(tableName, new HashMap());
                    DesignerColumn col = new DesignerColumn();
                    Object defvalue = rs.getObject("COLUMN_DEFAULT");
                    Object nullable = rs.getObject("IS_NULLABLE");
                    String type = rs.getString("DATA_TYPE");
                    Object length = rs.getObject("CHARACTER_MAXIMUM_LENGTH");
                    Object precision = rs.getObject("NUMERIC_PRECISION");
                    Object scale = rs.getObject("NUMERIC_SCALE");
                    String desc = "";
                    col.setCode(name);
                    col.setName(name);
                    col.setType(type);
                    col.setFullType(type);
                    col.setComment((ILocaleString)new LocaleString(desc));
                    String defstr = defvalue == null ? null : String.valueOf(defvalue);
                    col.setDefValue(defstr == null ? null : defstr.split("::")[0]);
                    col.setLength(length == null ? (long)Integer.parseInt(String.valueOf(precision == null ? "-1" : precision)) : (long)Integer.parseInt(String.valueOf(length)));
                    col.setScale(scale == null ? 0 : Integer.parseInt(String.valueOf(scale)));
                    col.setNotnull("NO".equalsIgnoreCase(String.valueOf(nullable)));
                    ((Map)result.get(tableName)).put(name, col);
                }
                return result;
            });
            SqlBuilder typeBuild = new SqlBuilder();
            typeBuild.append("/*dialect*/", new Object[0]).append(" select c.relname as ftablename,  a.attname   as fname, format_type(a.atttypid, a.atttypmod)  as ffulltype, t.typname  as  ftype   from pg_class c  inner join  pg_attribute a  on a.attrelid = c.oid\n             inner join pg_type t on a.atttypid = t.oid  where a.attnum > 0 and", new Object[0]).appendIn("c.relname", lowerCaseTables.toArray());
            DB.query((DBRoute)route, (SqlBuilder)typeBuild, rs -> {
                while (rs.next()) {
                    DesignerColumn item;
                    String table = rs.getString(1);
                    String column = rs.getString(2);
                    if (table == null || column == null) continue;
                    String fullType = rs.getString(3);
                    String type = rs.getString(4);
                    Map items = (Map)data.get(table);
                    if (items == null || (item = (DesignerColumn)items.get(column)) == null) continue;
                    item.setType(type);
                }
                return null;
            });
            HashMap<String, List<DesignerColumn>> resultData = new HashMap<String, List<DesignerColumn>>(16);
            for (Map.Entry item : data.entrySet()) {
                resultData.put((String)item.getKey(), new ArrayList(((Map)item.getValue()).values()));
            }
            return resultData;
        }

        @Override
        public Map<String, List<DesignerIndex>> batchLoadIndexs(DBRoute route, List<String> tableNames) {
            HashMap<String, List<DesignerIndex>> datas = new HashMap<String, List<DesignerIndex>>(tableNames.size());
            if (tableNames.isEmpty()) {
                return datas;
            }
            try {
                List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
                SqlBuilder builder = new SqlBuilder();
                builder.append(" SELECT ", new Object[0]).append(" INDEXNAME,INDEXDEF,TABLENAME ", new Object[0]).append(" FROM KSQL_INDEXES ", new Object[0]).append(" ", new Object[0]).append(" WHERE ", new Object[0]).appendIn("KSQL_TABNAME", lowerCaseTables.toArray());
                datas.putAll((Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                    HashMap result = new HashMap(tableNames.size());
                    while (rs.next()) {
                        String tableName = rs.getString("TABLENAME");
                        result.putIfAbsent(tableName, new ArrayList());
                        List idxs = (List)result.get(tableName);
                        DesignerIndex idx = new DesignerIndex();
                        String name = rs.getString("INDEXNAME");
                        String indexof = rs.getString("INDEXDEF");
                        idx.setName(name);
                        idx.setCode(name);
                        idx.setIndexdef(indexof);
                        idx.setIndexType(IndexType.of(this.exprIndexType(indexof, name)));
                        idx.setRefCols(this.exprIndexRef(indexof));
                        idxs.add(idx);
                    }
                    return result;
                }));
            }
            catch (Exception e) {
                DBType type = DB.getDBType((DBRoute)route);
                if (DBType.MySQL == type) {
                    for (String tablename : tableNames) {
                        StringBuilder sbuilder = new StringBuilder();
                        sbuilder.append("/*dialect*/").append(" show index from ").append(tablename);
                        datas.putIfAbsent(tablename, new ArrayList());
                        Map tableIndexs = (Map)DB.query((DBRoute)route, (String)sbuilder.toString(), rs -> {
                            HashMap<String, DesignerIndex> indexMap = new HashMap<String, DesignerIndex>(5);
                            while (rs.next()) {
                                String indexName = rs.getString("Key_name");
                                String column = rs.getString("Column_name");
                                indexMap.putIfAbsent(indexName, new DesignerIndex());
                                DesignerIndex index = (DesignerIndex)indexMap.get(indexName);
                                index.setCode(indexName);
                                index.setName(indexName);
                                index.setComment((ILocaleString)new LocaleString(indexName));
                                index.getRefCols().add(column);
                                index.setTablename(tablename);
                            }
                            return indexMap;
                        });
                        ((List)datas.get(tablename)).addAll(tableIndexs.values());
                    }
                }
                log.error("\u6570\u636e\u8868\u67e5\u8be2\u7d22\u5f15\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
            return datas;
        }

        private List<String> exprIndexRef(String createStr) {
            int start = createStr.indexOf(40) + 1;
            int end = createStr.indexOf(41);
            String data = createStr.substring(start, end);
            return Arrays.asList(data.split(","));
        }

        private String exprIndexType(String createStr, String idxNum) {
            String[] parts = createStr.split(idxNum);
            int index = parts[0].indexOf(" ") + 1;
            return parts[0].substring(index);
        }

        @Override
        public Map<String, List<DesignerConstaint>> batchLoadConstraints(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerConstaint>>();
            }
            List<String> lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            SqlBuilder builder = new SqlBuilder();
            builder.append("SELECT * FROM KSQL_CONSTRAINTS ", new Object[0]).append(" WHERE ", new Object[0]).appendIn("TABLE_NAME", lowerCaseTables.toArray()).append(" and CONSTRAINT_TYPE = 'PRIMARY KEY'", new Object[0]);
            Map<String, List<String>> pkInfos = this.getPrimaryKeys(DB.getDBType((DBRoute)route), route, lowerCaseTables);
            return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                HashMap result = new HashMap(10);
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    List cols = (List)pkInfos.get(tableName);
                    if (cols == null || cols.isEmpty()) continue;
                    result.putIfAbsent(tableName, new ArrayList());
                    List constaints = (List)result.get(tableName);
                    String name = rs.getString("CONSTRAINT_NAME");
                    DesignerConstaint constaint = new DesignerConstaint();
                    constaints.add(constaint);
                    constaint.setName(name);
                    constaint.setCode(name);
                    constaint.getRefCols().addAll(cols);
                    constaint.setConstaintType(ConstaintType.of(rs.getString("CONSTRAINT_TYPE")));
                }
                return result;
            });
        }
    }

    static class PostgreSQLHandler
    implements IGetTableHandler {
        PostgreSQLHandler() {
        }

        private boolean isNumricType(String type) {
            return "numeric".equalsIgnoreCase(type);
        }

        private List<String> exprIndexRef(String createStr) {
            int start = createStr.indexOf(40) + 1;
            int end = createStr.indexOf(41);
            String data = createStr.substring(start, end);
            return Arrays.asList(data.split(","));
        }

        private String exprIndexType(String createStr, String idxNum) {
            String[] parts = createStr.split(idxNum);
            int index = parts[0].indexOf(" ") + 1;
            return parts[0].substring(index);
        }

        @Override
        public Map<String, List<DesignerColumn>> batchLoadColumns(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerColumn>>();
            }
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            SqlBuilder builder = new SqlBuilder();
            builder.append("/*dialect*/ select distinct  c.relname as ftablename,\n", new Object[0]).append("a.attname   as fname,\n", new Object[0]).append("format_type(a.atttypid, a.atttypmod)  as ffulltype,\n", new Object[0]).append("(case when a.attlen > 0 then a.attlen else a.atttypmod - 4 end) as flength,\n", new Object[0]).append(" a.attnotnull      as fnullable,\n", new Object[0]).append(" pg_get_expr(d.adbin,d.adrelid)          as fdefvalue,\n", new Object[0]).append(" col_description(a.attrelid, a.attnum)                           as fdesc,\n", new Object[0]).append(" a.attlen   as   fattlen,    a.atttypmod   as    fatttypmod     ,t.typname  as  ftype", new Object[0]).append(" from pg_class c,\n", new Object[0]).append(" pg_attribute a\n", new Object[0]).append(" inner join (select  distinct a.attname, ad.adbin,ad.adrelid\n", new Object[0]).append(" from pg_class c,\n", new Object[0]).append(" pg_attribute a,\n", new Object[0]).append(" pg_attrdef ad,\n", new Object[0]).append(" pg_type t", new Object[0]).append(" where ", new Object[0]).appendIn("relname", lowerCaseTables.toArray()).append(" and ad.adrelid = c.oid\n", new Object[0]).append(" and adnum = a.attnum\n", new Object[0]).append(" and attrelid = c.oid) as d on a.attname = d.attname\n", new Object[0]).append("  , pg_type t ", new Object[0]).append("where ", new Object[0]).appendIn("c.relname", lowerCaseTables.toArray()).append("  and a.attrelid = c.oid\n", new Object[0]).append("  and a.attnum > 0 and a.atttypid = t.oid;", new Object[0]);
            return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                HashMap result = new HashMap(16);
                while (rs.next()) {
                    String tableName = rs.getString("ftablename");
                    result.putIfAbsent(tableName, new ArrayList());
                    List cols = (List)result.get(tableName);
                    DesignerColumn col = new DesignerColumn();
                    String name = rs.getString("fname");
                    String type = rs.getString("ftype");
                    int lenght = rs.getInt("flength");
                    boolean nullable = rs.getBoolean("fnullable");
                    Object defvalue = rs.getObject("fdefvalue");
                    String desc = rs.getString("fdesc");
                    col.setCode(name);
                    col.setName(name);
                    col.setType(type);
                    col.setFullType(rs.getString("ffulltype"));
                    Integer atttypmod = rs.getInt("fatttypmod");
                    col.setLength(lenght);
                    if (this.isNumricType(type)) {
                        int precision = atttypmod - 4 >> 16 & 0xFFFF;
                        int scale = atttypmod - 4 & 0xFFFF;
                        col.setLength(precision);
                        col.setPrecision(precision);
                        col.setScale(scale);
                    }
                    col.setNotnull(!nullable);
                    String defstr = defvalue == null ? null : String.valueOf(defvalue);
                    col.setDefValue(defstr == null ? null : defstr.split("::")[0]);
                    if (StringUtils.isNotBlank((CharSequence)desc)) {
                        col.setComment((ILocaleString)new LocaleString(desc));
                    } else {
                        col.setComment((ILocaleString)new LocaleString(name));
                    }
                    cols.add(col);
                }
                return result;
            });
        }

        @Override
        public Map<String, List<DesignerIndex>> batchLoadIndexs(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerIndex>>();
            }
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            SqlBuilder builder = new SqlBuilder();
            builder.append("/*dialect*/", new Object[0]).append(" SELECT TABLENAME,INDEXNAME,INDEXDEF ", new Object[0]).append(" FROM PG_INDEXES ", new Object[0]).append(" WHERE ", new Object[0]).appendIn("TABLENAME", lowerCaseTables.toArray());
            return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                HashMap result = new HashMap(tableNames.size());
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    result.putIfAbsent(tableName, new ArrayList());
                    List idxs = (List)result.get(tableName);
                    DesignerIndex idx = new DesignerIndex();
                    String name = rs.getString(2);
                    String indexof = rs.getString(3);
                    idx.setName(name);
                    idx.setCode(name);
                    idx.setIndexdef(indexof);
                    idx.setIndexType(IndexType.of(this.exprIndexType(indexof, name)));
                    idx.setRefCols(this.exprIndexRef(indexof));
                    idxs.add(idx);
                }
                return result;
            });
        }

        @Override
        public Map<String, List<DesignerConstaint>> batchLoadConstraints(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerConstaint>>();
            }
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            SqlBuilder builder = new SqlBuilder();
            builder.append("/*dialect*/", new Object[0]).append(" SELECT TC.TABLE_NAME,TC.CONSTRAINT_NAME, KCU.COLUMN_NAME,", new Object[0]).append(" TC.CONSTRAINT_TYPE ", new Object[0]).append(" FROM ", new Object[0]).append(" INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC \n", new Object[0]).append(" JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCU ON TC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME ", new Object[0]).append(" JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS CCU ON CCU.CONSTRAINT_NAME = TC.CONSTRAINT_NAME ", new Object[0]).append(" WHERE  ", new Object[0]).appendIn("TC.TABLE_NAME", lowerCaseTables.toArray());
            return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                HashMap result = new HashMap(10);
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    result.putIfAbsent(tableName, new ArrayList());
                    List constaints = (List)result.get(tableName);
                    String name = rs.getString(2);
                    DesignerConstaint constaint = new DesignerConstaint();
                    constaints.add(constaint);
                    constaint.setName(name);
                    constaint.setCode(name);
                    constaint.setComment((ILocaleString)new LocaleString(""));
                    constaint.getRefCols().add(rs.getString(3));
                    constaint.setConstaintType(ConstaintType.of(rs.getString(4)));
                }
                return result;
            });
        }
    }

    static class OracleHandler
    implements IGetTableHandler {
        OracleHandler() {
        }

        @Override
        public Map<String, List<DesignerColumn>> batchLoadColumns(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerColumn>>();
            }
            List upperTables = tableNames.stream().map(String::toUpperCase).collect(Collectors.toList());
            SqlBuilder builder = new SqlBuilder();
            builder.append("/*dialect*/", new Object[0]).append("select ", new Object[0]).append("T.TABLE_NAME AS TABLENAME,T.COLUMN_NAME AS COLUMNNAME, T.DATA_TYPE AS COLTYPE, T.DATA_LENGTH LENGTH,T.DATA_PRECISION AS COLPRECISION,T.DATA_SCALE AS COLSCALE,T.NULLABLE AS NULLABLE,C.COMMENTS  AS COMMENTS ,T.DATA_DEFAULT AS COLDEFAULT ", new Object[0]).append(" FROM USER_TAB_COLUMNS T, USER_COL_COMMENTS C WHERE T.TABLE_NAME = C.TABLE_NAME AND T.COLUMN_NAME = C.COLUMN_NAME AND ", new Object[0]).appendIn("T.TABLE_NAME", upperTables.toArray());
            return (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                CaseInsensitiveMap result = new CaseInsensitiveMap(tableNames.size());
                while (rs.next()) {
                    String tableName = rs.getString("TABLENAME");
                    result.putIfAbsent(tableName, new ArrayList());
                    List dbcols = (List)result.get(tableName);
                    DesignerColumn col = new DesignerColumn();
                    String name = rs.getString("COLUMNNAME");
                    Object nullable = rs.getObject("NULLABLE");
                    String type = rs.getString("COLTYPE");
                    Object length = rs.getObject("LENGTH");
                    Object precision = rs.getObject("COLPRECISION");
                    Object scale = rs.getObject("COLSCALE");
                    Object comment = rs.getObject("COMMENTS");
                    Object defvalue = rs.getObject("COLDEFAULT");
                    String desc = comment == null ? "" : comment.toString();
                    col.setCode(name);
                    col.setName(name);
                    col.setType(type);
                    col.setFullType(type);
                    col.setComment((ILocaleString)new LocaleString(desc));
                    col.setDefValue(defvalue == null ? null : String.valueOf(defvalue));
                    try {
                        col.setLength(precision == null ? (long)Integer.parseInt(String.valueOf(length)) : (long)Integer.parseInt(String.valueOf(precision)));
                    }
                    catch (Exception e) {
                        col.setLength(-1L);
                    }
                    col.setScale(scale == null ? 0 : Integer.parseInt(String.valueOf(scale)));
                    col.setNotnull("N".equalsIgnoreCase(String.valueOf(nullable)));
                    dbcols.add(col);
                }
                return result;
            });
        }

        @Override
        public Map<String, List<DesignerIndex>> batchLoadIndexs(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerIndex>>();
            }
            List upperTables = tableNames.stream().map(String::toUpperCase).collect(Collectors.toList());
            SqlBuilder builder = new SqlBuilder();
            builder.append("/*dialect*/", new Object[0]).append("SELECT T1.INDEX_NAME , T1.INDEX_TYPE, T1.UNIQUENESS,T1.TABLE_NAME, T2.COLUMN_NAME FROM USER_INDEXES T1 ", new Object[0]).append("INNER JOIN  USER_IND_COLUMNS T2  ON T1.INDEX_NAME = T2.INDEX_NAME  WHERE ", new Object[0]).appendIn("T1.TABLE_NAME", upperTables.toArray());
            Map queryResult = (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                CaseInsensitiveMap result = new CaseInsensitiveMap(tableNames.size());
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    result.putIfAbsent(tableName, new CaseInsensitiveMap());
                    Map idxs = (Map)result.get(tableName);
                    String name = rs.getString("INDEX_NAME");
                    Object unique = rs.getObject("UNIQUENESS");
                    DesignerIndex idx = idxs.getOrDefault(name, new DesignerIndex());
                    idxs.put(name, idx);
                    idx.setName(name);
                    idx.setTablename(tableName);
                    idx.setCode(name);
                    idx.getRefCols().add(rs.getString("COLUMN_NAME"));
                    if ("unique".equalsIgnoreCase(String.valueOf(unique))) {
                        idx.setIndexType(IndexType.Unique);
                        continue;
                    }
                    String type = rs.getString("INDEX_TYPE");
                    idx.setIndexType(IndexType.of(type));
                }
                return result;
            });
            CaseInsensitiveMap resultData = new CaseInsensitiveMap(16);
            for (Map.Entry item : queryResult.entrySet()) {
                resultData.put(item.getKey(), new ArrayList(((Map)item.getValue()).values()));
            }
            return resultData;
        }

        @Override
        public Map<String, List<DesignerConstaint>> batchLoadConstraints(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerConstaint>>();
            }
            List upperTables = tableNames.stream().map(String::toUpperCase).collect(Collectors.toList());
            SqlBuilder builder = new SqlBuilder();
            builder.append("/*dialect*/", new Object[0]).append("SELECT ", new Object[0]).append("  USER_CONS_COLUMNS.CONSTRAINT_NAME AS CONNAME , USER_CONS_COLUMNS.TABLE_NAME AS TABLENAME ,USER_CONS_COLUMNS.COLUMN_NAME AS COLNAME ", new Object[0]).append(" FROM USER_CONSTRAINTS JOIN USER_CONS_COLUMNS ON (USER_CONSTRAINTS.CONSTRAINT_NAME = USER_CONS_COLUMNS.CONSTRAINT_NAME) WHERE ", new Object[0]).append(" CONSTRAINT_TYPE = 'P' AND", new Object[0]).appendIn("USER_CONS_COLUMNS.TABLE_NAME", upperTables.toArray());
            Map data = (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                CaseInsensitiveMap result = new CaseInsensitiveMap();
                while (rs.next()) {
                    String tableName = rs.getString("TABLENAME");
                    String name = rs.getString("CONNAME");
                    result.putIfAbsent(tableName, new HashMap());
                    ((Map)result.get(tableName)).putIfAbsent(name, new DesignerConstaint());
                    DesignerConstaint constaint = (DesignerConstaint)((Map)result.get(tableName)).get(name);
                    constaint.setName(name);
                    constaint.setCode(name);
                    constaint.setComment((ILocaleString)new LocaleString(""));
                    constaint.getRefCols().add(rs.getString(3));
                    constaint.setConstaintType(ConstaintType.Primary);
                }
                return result;
            });
            CaseInsensitiveMap resultData = new CaseInsensitiveMap(16);
            for (Map.Entry item : data.entrySet()) {
                resultData.put(item.getKey(), new ArrayList(((Map)item.getValue()).values()));
            }
            return resultData;
        }
    }

    static class MySQLHandler
    implements IGetTableHandler {
        MySQLHandler() {
        }

        @Override
        public Map<String, List<DesignerColumn>> batchLoadColumns(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerColumn>>();
            }
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            String schema = this.getTableScheme(route);
            SqlBuilder builder = new SqlBuilder();
            builder.append("/*dialect*/", new Object[0]).append(" SELECT TABLE_NAME,COLUMN_NAME ,COLUMN_DEFAULT ,IS_NULLABLE ,DATA_TYPE ,CHARACTER_MAXIMUM_LENGTH ,NUMERIC_PRECISION ,NUMERIC_SCALE,COLLATION_NAME ,COLUMN_KEY ,COLUMN_COMMENT,COLUMN_TYPE  ", new Object[0]).append(" FROM information_schema.COLUMNS ", new Object[0]).append(" WHERE ", new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)schema)) {
                builder.append(" TABLE_SCHEMA = ? ", new Object[]{new SqlParameter(":TABLE_SCHEMA", 12, (Object)schema)}).append(" AND ", new Object[0]);
            }
            builder.appendIn(" TABLE_NAME ", lowerCaseTables.toArray());
            Map data = (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                HashMap result = new HashMap(tableNames.size());
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    result.putIfAbsent(tableName, new ArrayList());
                    List dbcols = (List)result.get(tableName);
                    DesignerColumn col = new DesignerColumn();
                    String name = rs.getString("COLUMN_NAME");
                    Object defvalue = rs.getObject("COLUMN_DEFAULT");
                    Object nullable = rs.getObject("IS_NULLABLE");
                    String type = rs.getString("DATA_TYPE");
                    Object length = rs.getObject("CHARACTER_MAXIMUM_LENGTH");
                    Object precision = rs.getObject("NUMERIC_PRECISION");
                    Object scale = rs.getObject("NUMERIC_SCALE");
                    Object comment = rs.getObject("COLUMN_COMMENT");
                    String desc = comment == null ? "" : comment.toString();
                    col.setCode(name);
                    col.setName(name);
                    col.setType(type);
                    col.setFullType(rs.getString("COLUMN_TYPE"));
                    col.setComment((ILocaleString)new LocaleString(desc));
                    col.setDefValue(defvalue == null ? null : String.valueOf(defvalue));
                    try {
                        col.setScale(scale == null ? 0 : Integer.parseInt(String.valueOf(scale)));
                        col.setLength(length == null ? (precision == null ? -1L : Long.parseLong(String.valueOf(precision))) : Long.parseLong(String.valueOf(length)));
                        col.setPrecision(col.getLength());
                    }
                    catch (Exception e) {
                        col.setLength(-1L);
                        col.setScale(0);
                    }
                    col.setNotnull("NO".equalsIgnoreCase(String.valueOf(nullable)));
                    dbcols.add(col);
                }
                return result;
            });
            return data;
        }

        private String getTableScheme(DBRoute route) {
            String schema = null;
            try {
                schema = TX.__getConnection((String)route.getRouteKey(), (boolean)true).getSchema();
            }
            catch (SQLException e) {
                throw new KDException(new ErrorCode("env.tablequery.err", "query databasename err"), new Object[]{e});
            }
            return schema;
        }

        @Override
        public Map<String, List<DesignerIndex>> batchLoadIndexs(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerIndex>>();
            }
            List lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            HashMap<String, List<DesignerIndex>> result = new HashMap<String, List<DesignerIndex>>(16);
            for (String tablename : lowerCaseTables) {
                result.putIfAbsent(tablename, new ArrayList());
                try {
                    StringBuilder sbuilder = new StringBuilder();
                    sbuilder.append("/*dialect*/").append(" show index from ").append(tablename);
                    Map tableIndexs = (Map)DB.query((DBRoute)route, (String)sbuilder.toString(), null, rs -> {
                        HashMap<String, DesignerIndex> indexMap = new HashMap<String, DesignerIndex>(5);
                        while (rs.next()) {
                            String indexName = rs.getString("Key_name");
                            String column = rs.getString("Column_name");
                            indexMap.putIfAbsent(indexName, new DesignerIndex());
                            DesignerIndex index = (DesignerIndex)indexMap.get(indexName);
                            index.setCode(indexName);
                            index.setName(indexName);
                            String uniqueStr = rs.getString("Non_unique");
                            if ("0".equals(uniqueStr)) {
                                index.setIndexType(IndexType.Unique);
                            } else {
                                index.setIndexType(IndexType.Common);
                            }
                            index.setIndexdef("");
                            index.setComment((ILocaleString)new LocaleString(indexName));
                            index.getRefCols().add(column);
                            index.setTablename(tablename);
                        }
                        return indexMap;
                    });
                    ((List)result.get(tablename)).addAll(tableIndexs.values());
                }
                catch (Exception e) {
                    log.error("devp.dbtableprovider.err", (Throwable)e);
                }
            }
            return result;
        }

        @Override
        public Map<String, List<DesignerConstaint>> batchLoadConstraints(DBRoute route, List<String> tableNames) {
            if (tableNames.isEmpty()) {
                return new HashMap<String, List<DesignerConstaint>>();
            }
            List<String> lowerCaseTables = tableNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            String schema = this.getTableScheme(route);
            SqlBuilder builder = new SqlBuilder();
            builder.append("/*dialect*/", new Object[0]).append("select  CONSTRAINT_NAME ,CONSTRAINT_TYPE,TABLE_NAME   FROM information_schema.TABLE_CONSTRAINTS ", new Object[0]).append(" WHERE ", new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)schema)) {
                builder.append("  CONSTRAINT_SCHEMA = ? ", new Object[]{new SqlParameter(":CONSTRAINT_SCHEMA", 12, (Object)schema)}).append(" AND ", new Object[0]);
            }
            builder.appendIn("TABLE_NAME", lowerCaseTables.toArray());
            Map<String, List<String>> pkInfos = this.getPrimaryKeys(DB.getDBType((DBRoute)route), route, lowerCaseTables);
            Map data = (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                HashMap result = new HashMap(16);
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    result.putIfAbsent(tableName, new HashMap());
                    List cols = (List)pkInfos.get(tableName);
                    if (cols == null || cols.isEmpty()) continue;
                    Map constaints = (Map)result.get(tableName);
                    String name = rs.getString("CONSTRAINT_NAME");
                    DesignerConstaint constaint = constaints.getOrDefault(name, new DesignerConstaint());
                    constaints.put(name, constaint);
                    constaint.setName(name);
                    constaint.setCode(name);
                    constaint.setComment((ILocaleString)new LocaleString(""));
                    if (constaint.getRefCols().isEmpty()) {
                        constaint.getRefCols().add((String)cols.get(0));
                    } else {
                        constaint.getRefCols().set(0, (String)cols.get(0));
                    }
                    constaint.setConstaintType(ConstaintType.of(rs.getString("CONSTRAINT_TYPE")));
                }
                return result;
            });
            HashMap<String, List<DesignerConstaint>> returnData = new HashMap<String, List<DesignerConstaint>>(data.size());
            data.forEach((k, v) -> returnData.put((String)k, new ArrayList(v.values())));
            return returnData;
        }
    }
}

