/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.entity.DBVersion;
import kd.bos.entity.EntityObjectReader;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.newdevportal.table.DataDictExportTask;
import kd.bos.newdevportal.table.DesignerColumn;
import kd.bos.newdevportal.table.DesignerConstaint;
import kd.bos.newdevportal.table.DesignerIndex;
import kd.bos.newdevportal.table.DesignerTable;
import kd.bos.newdevportal.table.IndexType;
import kd.bos.newdevportal.table.TableInfoProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;

public class DataDictHtmlExporter {
    private static final Log LOG = LogFactory.getLog(DataDictHtmlExporter.class);
    private static final String HTML = ".html";
    private static final String FILES = "_files";
    private static final String DICT_TPL = "dictTpl.zip";
    private static final String DICT_TPL_CLOUD = "cloud-tpl.html";
    private static final String DICT_TPL_APP = "app-tpl.html";
    private static final String DICT_TPL_ENTITY = "entity-tpl.html";
    private static final String DICT_TPL_INDEX = "index-tpl.html";
    private static final String DICT_INDEX = "index.html";
    private static final String FIELD_NAME_APP_ID = "appId";
    private static final String FIELD_NAME_MASTER_ID = "masterid";
    private static final String FIELD_NAME_APP_NUMBER = "appNumber";
    private static final String FIELD_NAME_APP_NAME = "appName";
    private static final String FIELD_NAME_CLOUD_ID = "cloudId";
    private static final String FIELD_NAME_CLOUD_INHERIT_PATH = "inheritpath";
    private static final String FIELD_NAME_CLOUD_NUMBER = "cloudNumber";
    private static final String FIELD_NAME_CLOUD_NAME = "cloudName";
    private static final String FIELD_NAME_DBROUTE = "dbroute";
    private static final String FIELD_NAME_ENTITY_ID = "id";
    private static final String FIELD_NAME_ENTITY_NUMBER = "number";
    private static final String FIELD_NAME_ENTITY_NAME = "name";
    private static final String FIELD_NAME_ENTITY_DENTITYID = "dentityid";
    private static final String FIELD_NAME_ENTITY_TABLENAME = "tablename";
    private static final String FIELD_NAME_ENTITY_PKFIELDNAME = "pkfieldname";
    private static final String FIELD_NAME_ENTITY_PKFIELDTYPE = "pkfieldtype";
    private static final String FIELD_NAME_ENTITY_MODELTYPE = "modeltype";
    private static final String DEFAULT_TABLE_NAME = "t_isv_xxx";
    private static final String PLACEHOLDER_ALLTPL_BROWERTITLE = "%Tpl-BrowerTitle%";
    private static final String PLACEHOLDER_CLOUDTPL_TITLE = "%CloudTpl-Title%";
    private static final String PLACEHOLDER_CLOUDTPL_SEARCH = "%CLoudTpl-Search%";
    private static final String LOGO_EN = "detail-logo-en.png";
    private static final String LOGO_ZH = "detail-logo.png";
    private static final String INDEX_LOGO_EN = "logo-en.png";
    private static final String INDEX_LOGO_ZH = "logo.png";
    public static final String COSMIC_BOS = "cosmic_bos";
    public static final String COSMIC_BIZ = "cosmic_biz";
    public static final String CCS_PREFIX = "constellation_";
    private String attachmentFilePath;
    private String indexUrl;
    private DynamicObjectCollection allSelectedCloudApps;
    private String bizVersion;
    private String fileNameNoExt;
    private List<String> appIds;
    private List<String> stdIcons = new ArrayList<String>(16);
    private DataDictExportTask task;

    public DataDictHtmlExporter(List<String> appIds, DataDictExportTask task) {
        this.appIds = appIds;
        this.task = task;
        QFilter qIds = new QFilter(FIELD_NAME_ENTITY_ID, "in", this.appIds);
        QFilter[] filters = new QFilter[]{qIds};
        String selectFields = "id as appId,masterid,number as appNumber,name as appName,bizcloud.id as cloudId,bizcloud.number as cloudNumber,bizcloud.name as cloudName,dbroute, inheritpath";
        this.allSelectedCloudApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters, (String)"bizcloud.sequence asc, sequence asc");
        RequestContext ctx = RequestContext.getOrCreate();
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        this.attachmentFilePath = String.format("/%s/%s/%s/%s", ctx.getTenantId(), ctx.getAccountId(), dateStr, UUID.randomUUID().toString());
        this.bizVersion = this.getBizVersion();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        String currDateTime = dateFormat.format(new Date());
        this.fileNameNoExt = String.format(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79%1$s\u6570\u636e\u5b57\u5178\u5bfc\u51fa%2$s", (String)"DataDictHtmlExporter_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), this.bizVersion, currDateTime);
        String dictDir = this.getDictDir();
        File file = new File(this.cleanString(dictDir));
        if (!file.exists()) {
            file.mkdir();
        }
        this.sureUnZipTpl();
        this.stdIcons.add("esc");
        this.stdIcons.add("icc");
        this.stdIcons.add("fi");
        this.stdIcons.add("ec");
        this.stdIcons.add("taxc");
        this.stdIcons.add("imc");
        this.stdIcons.add("epm");
        this.stdIcons.add("tmc");
        this.stdIcons.add("odc");
        this.stdIcons.add("hr");
        this.stdIcons.add("swc");
        this.stdIcons.add("hrmp");
        this.stdIcons.add("scmc");
        this.stdIcons.add("pur");
        this.stdIcons.add("drp");
        this.stdIcons.add("occ");
        this.stdIcons.add("mmc");
        this.stdIcons.add("qmc");
        this.stdIcons.add("pccs");
        this.stdIcons.add("mpscmm");
        this.stdIcons.add("wfs");
        this.stdIcons.add("bamp");
        this.stdIcons.add("eip");
        this.stdIcons.add("demo");
        this.stdIcons.add("data");
        this.stdIcons.add("sit");
        this.stdIcons.add("ai");
        this.stdIcons.add("sys");
        this.stdIcons.add("dev");
        this.stdIcons.add("bsc");
    }

    private String buildIndexPage(Map<String, String> dictionaries) throws IOException {
        long beginTime = System.currentTimeMillis();
        String tpl = this.getIndexTemplate();
        StringBuilder sb = new StringBuilder();
        List<DynamicObject> clouds = this.getDistinctClouds();
        int cloudCount = clouds.size();
        int progress = 10;
        int curStep = 0;
        for (DynamicObject cloud : clouds) {
            String cloudId = cloud.getString(FIELD_NAME_CLOUD_ID);
            String cloudNumber = cloud.getString(FIELD_NAME_CLOUD_NUMBER);
            String cloudName = cloud.getString(FIELD_NAME_CLOUD_NAME);
            String cloudHtmlFullFileName = this.getDictDir() + File.separator + this.getIdentify(cloudNumber, cloudName) + HTML;
            this.task.feedbackProgress(progress, String.format(ResManager.loadKDString((String)"\u6b63\u751f\u6210\u4e91\uff1a%s", (String)"DataDictHtmlExporter_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), cloudName), null);
            String cloudContent = this.buildCloud(cloud, cloudCount, dictionaries);
            if (cloudContent != null) {
                String string = this.writeHtml2File(cloudContent, cloudHtmlFullFileName);
            }
            sb.append(this.buildCloudCard(cloud));
            System.out.print("abcde  time:" + (System.currentTimeMillis() - beginTime) / 1000L + " s cloud:" + cloudName);
            progress = 10 + 80 * ++curStep / cloudCount;
        }
        tpl = tpl.replaceAll(PLACEHOLDER_ALLTPL_BROWERTITLE, ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u6570\u636e\u5b57\u5178", (String)"DataDictHtmlExporter_26", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        if (Lang.get() != Lang.zh_CN && Lang.get() != Lang.zh_TW) {
            tpl = tpl.replace(INDEX_LOGO_ZH, INDEX_LOGO_EN);
        }
        return tpl.replace("%CloudCard%", sb.toString());
    }

    private Map<String, String> buildBaseDiction() {
        HashMap<String, String> dictionaries = new HashMap<String, String>(16);
        List<DynamicObject> clouds = this.getDistinctClouds();
        for (DynamicObject cloud : clouds) {
            List<DynamicObject> apps = this.getAppsByCloud(cloud);
            for (DynamicObject app : apps) {
                String appId = app.getString(FIELD_NAME_APP_ID);
                List<String> appIds = this.getAppIdsBy(appId);
                List<DynamicObject> entities = this.getEntitiesByApp(appIds);
                for (DynamicObject entity : entities) {
                    String modelType = entity.getString(FIELD_NAME_ENTITY_MODELTYPE);
                    if (!"BaseFormModel".equals(modelType)) continue;
                    String entityNumber = entity.getString(FIELD_NAME_ENTITY_NUMBER);
                    String entityName = entity.getString(FIELD_NAME_ENTITY_NAME);
                    entityName = this.cleanXSSContent(entityName);
                    String entityIdentify = this.getIdentify(entityNumber, entityName);
                    String appNumber = app.getString(FIELD_NAME_APP_NUMBER);
                    String appName = app.getString(FIELD_NAME_APP_NAME);
                    appName = this.cleanXSSContent(appName);
                    String appIdentify = this.getIdentify(appNumber, appName);
                    String appFilesDir = appIdentify + FILES;
                    String entityHtmlFilename = entityIdentify + HTML;
                    String entityHtmlLink = "..\\" + appFilesDir + "\\" + entityHtmlFilename;
                    dictionaries.put(entityIdentify, entityHtmlLink);
                }
            }
        }
        return dictionaries;
    }

    private String buildCloudCard(DynamicObject cloud) {
        String cloudNumber = cloud.getString(FIELD_NAME_CLOUD_NUMBER);
        String cloudName = cloud.getString(FIELD_NAME_CLOUD_NAME);
        String cloudIdentify = this.getIdentify(cloudNumber, cloudName);
        String cardTpl = "                <a href=\"%s.html\" target=\"_blank\">\n                    <div class=\"cloudCard\"\n                        style=\"background: url(images/%s.png) 100%% no-repeat;background-size:100%% 100%%;\">\n                        <div class=\"cloudContent\">\n                            <div class=\"cloudIcon\">\n                                <img src=\"images/%s.svg\" />\n                            </div>\n                            <span class=\"cloudText\">%s</span>\n                        </div>\n                    </div>\n                </a>";
        String icon = this.stdIcons.contains(cloudIdentify) ? cloudIdentify : "custom";
        return String.format(cardTpl, cloudIdentify, icon, icon, cloudName);
    }

    private String buildCloud(DynamicObject cloud, int cloudCount, Map<String, String> dictionaries) throws IOException {
        String tpl = this.getCloudTemplate();
        StringBuilder sbMobileMenu = new StringBuilder();
        StringBuilder sbMenu = new StringBuilder();
        String cloudName = cloud.getString(FIELD_NAME_CLOUD_NAME);
        cloudName = this.cleanXSSContent(cloudName);
        List<DynamicObject> apps = this.getAppsByCloud(cloud);
        sbMobileMenu.append("<li class=\"mob-nav-one mob-nav-one-home nav-active\" onclick=\"navClick('home','','','").append(cloudName).append("',this, event)\">").append(cloudName).append("</li>\n");
        sbMenu.append("<li class=\"nav-one nav-one-home nav-active\" onclick=\"navClick('home','','','").append(cloudName).append("',this, event)\">").append(cloudName).append("</li>\n");
        int progress = 10;
        int curStep = 0;
        StringBuilder sbMobNavOne = new StringBuilder();
        StringBuilder sbNavOne = new StringBuilder();
        for (DynamicObject app : apps) {
            String appId = app.getString(FIELD_NAME_APP_ID);
            String masterId = app.getString(FIELD_NAME_MASTER_ID);
            if (StringUtils.isNotBlank((CharSequence)masterId)) continue;
            String appNumber = app.getString(FIELD_NAME_APP_NUMBER);
            String appName = app.getString(FIELD_NAME_APP_NAME);
            String appLongName = appName = this.cleanXSSContent(appName);
            if (StringUtils.isNotBlank((CharSequence)appNumber)) {
                appLongName = appLongName + "-" + appNumber;
            }
            String appIdentify = this.getIdentify(appNumber, appName);
            String appFilesDir = appIdentify + FILES;
            String appHtmlFilename = appIdentify + HTML;
            String appHtmlLink = appFilesDir + "\\" + appHtmlFilename;
            if (cloudCount == 1) {
                this.task.feedbackProgress(progress, String.format(ResManager.loadKDString((String)"\u6b63\u751f\u6210\u5e94\u7528\uff1a%s", (String)"DataDictHtmlExporter_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), appName), null);
            }
            try {
                List<DynamicObject> entities;
                List<String> appIds = this.getAppIdsBy(appId);
                if (appIds.size() > 0) {
                    Tuple<String, String> appExtNumberName = this.getAppExtNumberName(appId);
                    appNumber = (String)appExtNumberName.item1;
                    appLongName = appName = this.cleanXSSContent((String)appExtNumberName.item2);
                    if (StringUtils.isNotBlank((CharSequence)appNumber)) {
                        appLongName = appLongName + "-" + appNumber;
                    }
                    appIdentify = this.getIdentify(appNumber, appName);
                }
                if ((entities = this.getEntitiesByApp(appIds)).size() == 0) continue;
                boolean navOneAppended = false;
                sbMobNavOne.setLength(0);
                sbMobNavOne.append("                                    <li class=\"mob-nav-one ").append(appIdentify).append(" \" name='").append(appIdentify).append("' onclick=\"navClick('app','").append(appIdentify).append("','','").append(appLongName).append("',this, event)\">").append("<a href=\"").append(appHtmlLink).append("\" target=\"appContent\">").append(appLongName).append("</a>").append("\n");
                sbMobNavOne.append("                                      <ul class=\"flex flex-col space-y-2 \">\n");
                sbNavOne.setLength(0);
                sbNavOne.append("                                    <li class=\"nav-one ").append(appIdentify).append(" \" name='").append(appIdentify).append("' onclick=\"navClick('app','").append(appIdentify).append("','','").append(appLongName).append("',this, event)\">").append("<a href=\"").append(appHtmlLink).append("\" target=\"appContent\">").append(appLongName).append("</a>").append("\n");
                sbNavOne.append("                                      <ul class=\"flex flex-col space-y-2 \">\n");
                String dbRoute = app.getString(FIELD_NAME_DBROUTE);
                long beginTime = System.currentTimeMillis();
                TableInfoProvider provider = TableInfoProvider.create(DBRoute.of((String)(dbRoute == null ? "sys" : dbRoute)));
                List<DesignerTable> tableInfos = provider.getTableInfoByAppId(appIds);
                System.out.print("abcde       provider.getTableInfoByAppId time:" + (System.currentTimeMillis() - beginTime) / 1000L + " s app:" + appName);
                ArrayList<String> existsEntities = new ArrayList<String>(16);
                for (DynamicObject entity : entities) {
                    String entityNumber = entity.getString(FIELD_NAME_ENTITY_NUMBER);
                    String entityName = entity.getString(FIELD_NAME_ENTITY_NAME);
                    entityName = this.cleanXSSContent(entityName);
                    String entityIdentify = this.getIdentify(entityNumber, entityName);
                    String entityLongName = entityName + "-" + entityNumber;
                    List<DesignerTable> tables = tableInfos.stream().filter(t -> entityNumber.equalsIgnoreCase(t.getOwnerEntityNum())).collect(Collectors.toList());
                    if (existsEntities.contains(entityLongName)) continue;
                    existsEntities.add(entityLongName);
                    if (!navOneAppended) {
                        sbMobileMenu.append((CharSequence)sbMobNavOne);
                        sbMenu.append((CharSequence)sbNavOne);
                        navOneAppended = true;
                    }
                    String entityHtmlFilename = entityIdentify + HTML;
                    String entityHtmlLink = appFilesDir + "\\" + entityHtmlFilename;
                    sbMobileMenu.append("                                        <li class=\"mob-nav-two ").append(appIdentify).append(" ").append(entityIdentify).append(" \" onclick=\"navClick('entity', '").append(appIdentify).append("','").append(entityIdentify).append("','").append(entityName).append("',this, event)\">").append("<a href=\"").append(entityHtmlLink).append("\" target=\"appContent\">").append(entityLongName).append("</a>").append("</li>\n");
                    sbMenu.append("                                        <li class=\"nav-two ").append(appIdentify).append(" ").append(entityIdentify).append(" \" onclick=\"navClick('entity', '").append(appIdentify).append("','").append(entityIdentify).append("','").append(entityName).append("',this, event)\">").append("<a href=\"").append(entityHtmlLink).append("\" target=\"appContent\">").append(entityLongName).append("</a>").append("</li>\n");
                    this.buildEntity(entity, tables, appIdentify, appFilesDir, entityHtmlFilename, dictionaries);
                }
                if (!navOneAppended) continue;
                sbMobileMenu.append("                                      </ul>\n");
                sbMobileMenu.append("                                    </li>\n");
                sbMenu.append("                                      </ul>\n");
                sbMenu.append("                                    </li>\n");
                String dictDir = this.getDictDir();
                File file = new File(this.cleanString(dictDir));
                if (!file.exists()) {
                    file.mkdir();
                }
                this.buildApp(app, appLongName, appFilesDir, appHtmlFilename);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            progress = 10 + 80 * ++curStep / apps.size();
        }
        tpl = tpl.replaceAll(PLACEHOLDER_ALLTPL_BROWERTITLE, ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u6570\u636e\u5b57\u5178", (String)"DataDictHtmlExporter_26", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        tpl = tpl.replace(PLACEHOLDER_CLOUDTPL_TITLE, ResManager.loadKDString((String)"\u82cd\u7a79\u5e73\u53f0\u6570\u636e\u5b57\u5178HTML\u62a5\u544a", (String)"DataDictHtmlExporter_27", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        tpl = tpl.replace(PLACEHOLDER_CLOUDTPL_SEARCH, ResManager.loadKDString((String)"\u641c\u7d22", (String)"DataDictHtmlExporter_28", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        tpl = tpl.replace("%MobileMenu%", sbMobileMenu.toString());
        tpl = tpl.replace("%Menu%", sbMenu.toString());
        tpl = tpl.replace("%Version%", this.bizVersion);
        if (Lang.get() != Lang.zh_CN && Lang.get() != Lang.zh_TW) {
            tpl = tpl.replace(LOGO_ZH, LOGO_EN);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currDateTime = dateFormat.format(new Date());
        tpl = tpl.replace("%GenerateTime%", String.format(ResManager.loadKDString((String)"\u6587\u6863\u751f\u6210\u65e5\u671f\uff1a%s", (String)"DataDictHtmlExporter_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), currDateTime));
        return tpl;
    }

    private void buildApp(DynamicObject app, String appLongName, String appFilesDir, String appHtmlFilename) throws IOException {
        String tpl = this.getAppTemplate();
        String dir = this.getDictDir() + File.separator + appFilesDir;
        File dirFile = new File(this.cleanString(dir));
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        tpl = tpl.replaceAll(PLACEHOLDER_ALLTPL_BROWERTITLE, ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u6570\u636e\u5b57\u5178", (String)"DataDictHtmlExporter_26", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        tpl = tpl.replace("%cloudName%", appLongName);
        this.writeHtml2File(tpl, dir + File.separator + appHtmlFilename);
    }

    private void buildEntity(DynamicObject entity, List<DesignerTable> tables, String appIdentify, String appFilesDir, String entityHtmlFilename, Map<String, String> dictionaries) throws IOException {
        String entityNumber = entity.getString(FIELD_NAME_ENTITY_NUMBER);
        String entityName = entity.getString(FIELD_NAME_ENTITY_NAME);
        entityName = this.cleanXSSContent(entityName);
        String entityIdentify = this.getIdentify(entityNumber, entityName);
        String entityLongName = entityName;
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            entityLongName = entityLongName + "-" + entityNumber;
        }
        String tpl = this.getEntityTemplate();
        StringBuilder sbTables = new StringBuilder();
        for (DesignerTable table : tables) {
            if (DEFAULT_TABLE_NAME.equalsIgnoreCase(table.getCode())) continue;
            sbTables.append(ResManager.loadKDString((String)" <!-- \u8868:", (String)"DataDictHtmlExporter_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append(this.cleanXSSContent(table.getName())).append(" -->\n<div class=\"tbl app ").append(appIdentify).append(" entity ").append(entityIdentify).append(" \">").append("\n");
            this.buildTableSummary(sbTables, entity, table);
            this.buildTableDetail(sbTables, entity, table, dictionaries);
            this.buildConstaints(sbTables, entity, table);
            this.buildIndexs(sbTables, entity, table);
            sbTables.append("</div>").append("\n");
        }
        String dir = this.getDictDir() + File.separator + appFilesDir;
        File dirFile = new File(this.cleanString(dir));
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        tpl = tpl.replace("%EntitySummary%", entityLongName);
        tpl = tpl.replace("%Tables%", sbTables.toString());
        this.writeHtml2File(tpl, dir + File.separator + entityHtmlFilename);
    }

    private void buildTableSummary(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("<div class=\"tbl-m\">\n").append("    <div class=\"tbl-s\">\n").append("        <dl>\n").append("            <h3 class=\"tbl-s-h\">\n").append("                ").append(this.cleanXSSContent(tableInfo.getName())).append(" ").append(this.cleanXSSContent(tableInfo.getCode())).append("\n").append("            </h3>\n").append("            <div class=\"tbl-s-r1\">\n").append("                <dt class=\"tbl-s-t1\">\n").append(ResManager.loadKDString((String)"                    \u8868\u540d\u79f0\uff1a", (String)"DataDictHtmlExporter_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("\n").append("                </dt>\n").append("                <dd class=\"tbl-s-t2\">\n").append("                    ").append(this.cleanXSSContent(tableInfo.getName())).append("\n").append("                </dd>\n").append("            </div>\n").append("            <div class=\"tbl-s-r2\">\n").append("                <dt class=\"tbl-s-t1\">\n").append(ResManager.loadKDString((String)"                    \u8868\u540d\uff1a", (String)"DataDictHtmlExporter_6", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("\n").append("                </dt>\n").append("                <dd class=\"tbl-s-t2\">\n").append("                    ").append(this.cleanXSSContent(tableInfo.getCode())).append("\n").append("                </dd>\n").append("            </div>\n").append("        </dl>\n").append("    </div>\n").append("</div>").append("\n");
    }

    private void buildTableDetail(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo, Map<String, String> dictionaries) {
        sbTables.append(ResManager.loadKDString((String)"    <!-- \u8868\u683c\u5217\u5b9a\u4e49 -->", (String)"DataDictHtmlExporter_7", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("\n").append("    <div class=\"tbl-c\">").append("\n");
        this.buildTableHead(sbTables, entity, tableInfo);
        this.buildTableColumns(sbTables, entity, tableInfo, dictionaries);
        sbTables.append("    </div>").append("\n");
    }

    private void buildTableHead(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("        <h3 class=\"tbl-c-h\">\n").append("            ").append(this.getTableLongName(tableInfo)).append(ResManager.loadKDString((String)"- \u8868\u683c\u5217\u5b9a\u4e49", (String)"DataDictHtmlExporter_8", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("\n").append("        </h3>").append("\n");
    }

    private String getTableLongName(DesignerTable tableInfo) {
        if (StringUtils.isBlank((CharSequence)tableInfo.getName()) || tableInfo.getName().equalsIgnoreCase(tableInfo.getCode())) {
            return this.cleanXSSContent(tableInfo.getCode());
        }
        return this.cleanXSSContent(tableInfo.getName() + " " + tableInfo.getCode());
    }

    private void buildTableColumns(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo, Map<String, String> dictionaries) {
        sbTables.append("        <div class=\"tbl-c-m1\">\n            <div class=\"tbl-c-m2\">\n                <div class=\"tbl-c-m3\">\n                    <div\n                        class=\"tbl-c-m4\">\n                        <table class=\"tbl-c-t\">\n");
        this.buildTableColumnHead(sbTables, entity, tableInfo);
        sbTables.append("                            <tbody class=\"tbl-c-tb\">").append("\n");
        int seq = 1;
        HashSet<String> cols = new HashSet<String>(16);
        for (DesignerColumn col : tableInfo.getCols()) {
            if (cols.contains(col.getCode())) continue;
            this.buildTableColumn(sbTables, col, seq, dictionaries);
            cols.add(col.getCode());
            ++seq;
        }
        sbTables.append("                            </tbody>").append("\n");
        sbTables.append("                        </table>\n                    </div>\n                </div>\n            </div>\n        </div>").append("\n");
    }

    private void buildTableColumnHead(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("                            <thead class=\"bg-kd-F2\">\n").append("                                <tr class=\"tbl-c-th\">\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3 \">").append(ResManager.loadKDString((String)"                                        \u5e8f\u53f7", (String)"DataDictHtmlExporter_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u5217\u6807\u9898", (String)"DataDictHtmlExporter_10", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u5217\u540d\u79f0", (String)"DataDictHtmlExporter_11", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3 \">").append(ResManager.loadKDString((String)"                                        \u7c7b\u578b", (String)"DataDictHtmlExporter_12", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u957f\u5ea6", (String)"DataDictHtmlExporter_13", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u7cbe\u5ea6", (String)"DataDictHtmlExporter_14", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u975e\u7a7a", (String)"DataDictHtmlExporter_15", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u9ed8\u8ba4\u503c", (String)"DataDictHtmlExporter_16", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u5907\u6ce8", (String)"DataDictHtmlExporter_17", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                </tr>\n").append("                            </thead>\n").append("\n");
    }

    private void buildTableColumn(StringBuilder sbTables, DesignerColumn col, int seq, Map<String, String> dictionaries) {
        boolean isBase = col.isBase();
        String entityNumber = col.getBaseNumber();
        String comment1 = "                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ";
        String comment2 = "";
        String comment3 = "";
        String comment4 = "";
        if (isBase && StringUtils.isNotBlank((CharSequence)dictionaries.get(entityNumber))) {
            comment1 = "                                    </td>\n                                    <td class=\"px-4 py-2\">                                        <a href=\"";
            comment2 = dictionaries.get(entityNumber);
            comment3 = "\" target=\"_blank\" style = 'color:-webkit-link'>";
            comment4 = "</a>";
        }
        sbTables.append("                                <tr class=\"tbl-c-tbr\">").append("\n");
        sbTables.append("                                    <td class=\"px-4 py-2 whitespace-nowrap\">                                        ").append(seq).append("                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ").append(col.getCode()).append("                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ").append(col.getName()).append("                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ").append(col.getType()).append("                                    </td>\n                                    <td class=\"px-4 py-2 whitespace-nowrap\">                                        ").append(col.getLength() < 0L ? "" : Long.valueOf(col.getLength())).append("                                    </td>\n                                    <td class=\"px-4 py-2 whitespace-nowrap\">                                        ").append(col.getScale() > 0 ? Integer.valueOf(col.getScale()) : "").append("                                    </td>\n                                    <td class=\"px-4 py-2 whitespace-nowrap\">                                        ").append(col.isNotnull() ? "\u221a" : "").append("                                    </td>\n                                    <td class=\"px-4 py-2 whitespace-nowrap\">                                        ").append(col.getDefValue()).append(comment1).append(comment2).append(comment3).append(col.getComment()).append(comment4).append("                                    </td>\n");
        sbTables.append("                                </tr>").append("\n");
    }

    private void buildConstaints(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append(ResManager.loadKDString((String)"    <!-- \u5217\u89c4\u5219\u5b9a\u4e49 -->", (String)"DataDictHtmlExporter_18", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("\n").append("    <div class=\"px-4 py-5 sm:px-6\">\n");
        this.buildConstaintHead(sbTables, entity, tableInfo);
        this.buildConstaintColumns(sbTables, entity, tableInfo);
        sbTables.append("    </div>").append("\n");
    }

    private void buildConstaintHead(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("        <h3 class=\"tbl-c-h\">\n").append("            ").append(this.getTableLongName(tableInfo)).append(ResManager.loadKDString((String)"- \u5217\u89c4\u5219\u5b9a\u4e49", (String)"DataDictHtmlExporter_19", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("\n").append("        </h3>").append("\n");
    }

    private void buildConstaintColumns(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("        <div class=\"tbl-c-m1\">\n            <div class=\"tbl-c-m2\">\n                <div class=\"tbl-c-m3\">\n                    <div\n                        class=\"tbl-c-m4\">\n                        <table class=\"tbl-c-t\">\n");
        this.buildConstaintColumnHead(sbTables, entity, tableInfo);
        sbTables.append("                            <tbody class=\"tbl-c-tb\">").append("\n");
        int seq = 1;
        for (DesignerConstaint constaint : tableInfo.getConstaints()) {
            this.buildConstaintColumn(sbTables, constaint, seq);
            ++seq;
        }
        sbTables.append("                            </tbody>").append("\n");
        sbTables.append("                        </table>\n                    </div>\n                </div>\n            </div>\n        </div>").append("\n");
    }

    private void buildConstaintColumnHead(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("                            <thead class=\"bg-kd-F2\">\n").append("                                <tr class=\"tbl-c-th\">").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3 \">").append(ResManager.loadKDString((String)"                                        \u5e8f\u53f7", (String)"DataDictHtmlExporter_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3 \">").append(ResManager.loadKDString((String)"                                        \u952e\u7f16\u7801", (String)"DataDictHtmlExporter_20", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u5217\u5b57\u6bb5", (String)"DataDictHtmlExporter_21", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                </tr>\n").append("                            </thead>\n");
    }

    private void buildConstaintColumn(StringBuilder sbTables, DesignerConstaint constaint, int seq) {
        sbTables.append("                                <tr class=\"tbl-c-tbr\">").append("\n");
        sbTables.append("                                    <td class=\"px-4 py-2 whitespace-nowrap\">                                        ").append(seq).append("                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ").append(constaint.getCode()).append("                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ").append(String.join((CharSequence)",", constaint.getRefCols())).append("                                    </td>\n");
        sbTables.append("                                </tr>").append("\n");
    }

    private void buildIndexs(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append(ResManager.loadKDString((String)"    <!-- \u7d22\u5f15\u5b9a\u4e49 -->", (String)"DataDictHtmlExporter_22", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("\n").append("    <div class=\"px-4 py-5 sm:px-6\">\n");
        this.buildIndexHead(sbTables, entity, tableInfo);
        this.buildIndexColumns(sbTables, entity, tableInfo);
        sbTables.append("    </div>").append("\n");
    }

    private void buildIndexHead(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("        <h3 class=\"tbl-c-h\">\n").append("            ").append(this.getTableLongName(tableInfo)).append(ResManager.loadKDString((String)"- \u7d22\u5f15\u5b9a\u4e49", (String)"DataDictHtmlExporter_23", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("\n").append("        </h3>").append("\n");
    }

    private void buildIndexColumns(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("        <div class=\"tbl-c-m1\">\n            <div class=\"tbl-c-m2\">\n                <div class=\"tbl-c-m3\">\n                    <div\n                        class=\"tbl-c-m4\">\n                        <table class=\"tbl-c-t\">\n");
        this.buildIndexColumnHead(sbTables, entity, tableInfo);
        sbTables.append("                            <tbody class=\"tbl-c-tb\">").append("\n");
        int seq = 1;
        for (DesignerIndex idx : tableInfo.getIdxs()) {
            this.buildIndexColumn(sbTables, idx, seq);
            ++seq;
        }
        sbTables.append("                            </tbody>").append("\n");
        sbTables.append("                        </table>\n                    </div>\n                </div>\n            </div>\n        </div>").append("\n");
    }

    private void buildIndexColumnHead(StringBuilder sbTables, DynamicObject entity, DesignerTable tableInfo) {
        sbTables.append("                            <thead class=\"bg-kd-F2\">\n").append("                                <tr class=\"tbl-c-th\">").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3 \">").append(ResManager.loadKDString((String)"                                        \u5e8f\u53f7", (String)"DataDictHtmlExporter_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3 \">").append(ResManager.loadKDString((String)"                                        \u7d22\u5f15\u540d", (String)"DataDictHtmlExporter_24", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3 \">").append(ResManager.loadKDString((String)"                                        \u552f\u4e00", (String)"DataDictHtmlExporter_25", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                    <th scope=\"col\"").append("                                        class=\"px-4 py-3\">").append(ResManager.loadKDString((String)"                                        \u5217\u5b57\u6bb5", (String)"DataDictHtmlExporter_21", (String)"bos-devportal-new-plugin", (Object[])new Object[0])).append("                                    </th>\n").append("                                </tr>\n").append("                            </thead>\n");
    }

    private void buildIndexColumn(StringBuilder sbTables, DesignerIndex idx, int seq) {
        sbTables.append("                                <tr class=\"tbl-c-tbr\">").append("\n");
        sbTables.append("                                    <td class=\"px-4 py-2 whitespace-nowrap\">                                        ").append(seq).append("                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ").append(this.cleanXSSContent(idx.getCode())).append("                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ").append(IndexType.Unique.equal(idx.getIndexType()) ? "\u221a" : "").append("                                    </td>\n                                    <td class=\"px-4 py-2\">                                        ").append(String.join((CharSequence)",", idx.getRefCols())).append("                                    </td>\n");
        sbTables.append("                                </tr>").append("\n");
    }

    public String exportHtml() throws IOException {
        System.out.print("abcde being exportHtml");
        Map<String, String> dictionaries = this.buildBaseDiction();
        String indexContent = this.buildIndexPage(dictionaries);
        String indexFullFileName = this.getDictDir() + File.separator + DICT_INDEX;
        this.indexUrl = this.writeHtml2File(indexContent, indexFullFileName);
        this.deleteTemplate();
        String zipUrl = this.packageHtmlZip();
        this.deleteDictDir();
        System.out.print("abcde end exportHtml");
        return zipUrl;
    }

    private String packageHtmlZip() throws IOException {
        String zipFileName = String.format("%s.zip", this.fileNameNoExt);
        File zipFile = new File(this.getTempDir() + File.separator + zipFileName);
        this.doZip(this.getDictDir(), zipFile);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));){
            String string = tempFileCache.saveAsUrl(zipFileName, (InputStream)in, 7200);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeHtml2File(String content, String fullFileName) throws IOException {
        FileOutputStream outStream = null;
        FileInputStream inStream = null;
        try {
            File temp = new File(this.cleanString(fullFileName));
            if (!temp.exists()) {
                temp.createNewFile();
            }
            try (FileOutputStream fos = new FileOutputStream(temp);){
                ((OutputStream)fos).write(content.getBytes(StandardCharsets.UTF_8));
                fos.flush();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new KDException(BosErrorCode.bOS, new Object[]{e.getMessage()});
            }
            String string = temp.getPath();
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public String getIndexTemplate() throws IOException {
        String tplFileName = this.getDictDir() + File.separator + DICT_TPL_INDEX;
        File tplFile = new File(this.cleanString(tplFileName));
        if (!tplFile.exists()) {
            tplFile.createNewFile();
        }
        FileInputStream in = new FileInputStream(tplFile);
        return this.getFile(in);
    }

    public void deleteDictDir() throws FileNotFoundException {
        File file = new File(this.cleanString(this.getDictDir()));
        if (file.exists()) {
            file.delete();
        }
    }

    public String getCloudTemplate() throws IOException {
        String tplFileName = this.getDictDir() + File.separator + DICT_TPL_CLOUD;
        File tplFile = new File(this.cleanString(tplFileName));
        if (!tplFile.exists()) {
            tplFile.createNewFile();
        }
        FileInputStream in = new FileInputStream(tplFile);
        return this.getFile(in);
    }

    public String getAppTemplate() throws IOException {
        String tplFileName = this.getDictDir() + File.separator + DICT_TPL_APP;
        File tplFile = new File(this.cleanString(tplFileName));
        if (!tplFile.exists()) {
            tplFile.createNewFile();
        }
        FileInputStream in = new FileInputStream(tplFile);
        return this.getFile(in);
    }

    public String getEntityTemplate() throws IOException {
        String tplFileName = this.getDictDir() + File.separator + DICT_TPL_ENTITY;
        File tplFile = new File(this.cleanString(tplFileName));
        if (!tplFile.exists()) {
            tplFile.createNewFile();
        }
        FileInputStream in = new FileInputStream(tplFile);
        return this.getFile(in);
    }

    public void deleteTemplate() throws FileNotFoundException {
        String tableTplFileName;
        File tableFile;
        String appTplFileName;
        File appFile;
        String cloudTplFileName;
        File cloudFile;
        String indexTplFileName = this.getDictDir() + File.separator + DICT_TPL_INDEX;
        File idxFile = new File(this.cleanString(indexTplFileName));
        if (idxFile.exists()) {
            idxFile.delete();
        }
        if ((cloudFile = new File(this.cleanString(cloudTplFileName = this.getDictDir() + File.separator + DICT_TPL_CLOUD))).exists()) {
            cloudFile.delete();
        }
        if ((appFile = new File(this.cleanString(appTplFileName = this.getDictDir() + File.separator + DICT_TPL_APP))).exists()) {
            appFile.delete();
        }
        if ((tableFile = new File(this.cleanString(tableTplFileName = this.getDictDir() + File.separator + DICT_TPL_ENTITY))).exists()) {
            tableFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFile(InputStream in) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            in.close();
            String string = sb.toString();
            return string;
        }
        catch (Throwable t) {
            LOG.error(t);
            String string = "";
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private String getBizVersion() {
        List versions = IndustryVersionServiceHelper.getVersionInfos();
        String bosVer = "";
        StringBuilder bizVer = new StringBuilder("V");
        for (IndustryVersionInfo version : versions) {
            if (COSMIC_BOS.equals(version.getProductNumber())) {
                bosVer = version.getVersion();
                continue;
            }
            if (!version.getProductNumber().startsWith(CCS_PREFIX)) continue;
            bizVer.append(version.getVersion());
        }
        if (bizVer.length() == 1) {
            if (bosVer.length() > 0) {
                bizVer.append(bosVer);
            } else {
                bizVer.append(DBVersion.getVer());
            }
        }
        return bizVer.toString();
    }

    private String getIdentify(String number, String name) {
        if (StringUtils.isNotBlank((CharSequence)number)) {
            return number.toLowerCase();
        }
        if (name == null) {
            return null;
        }
        return name.toLowerCase();
    }

    private String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    private String getDictDir() {
        File file;
        String dir = this.getTempDir();
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(file = new File(this.cleanString(dir = dir + this.fileNameNoExt))).exists()) {
            file.mkdirs();
        }
        return dir;
    }

    private void doZip(String dir, File dest) {
        try {
            FileOutputStream fos = new FileOutputStream(dest);
            ZipOutputStream zos = new ZipOutputStream(fos);
            String baseDir = "";
            File d = new File(this.cleanString(dir));
            this.compressbyType(d, zos, baseDir);
            zos.close();
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            throw new KDException(BosErrorCode.bOS, new Object[]{ex.getMessage()});
        }
    }

    private void compressbyType(File src, ZipOutputStream zos, String baseDir) {
        if (!src.exists()) {
            return;
        }
        System.out.println("\u538b\u7f29\u8def\u5f84" + baseDir + src.getName());
        if (src.isFile()) {
            this.compressFile(src, zos, baseDir);
        } else if (src.isDirectory()) {
            this.compressDir(src, zos, baseDir);
        }
    }

    private void compressFile(File file, ZipOutputStream zos, String baseDir) {
        if (!file.exists()) {
            return;
        }
        BufferedInputStream bis = null;
        try {
            int count;
            bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(baseDir + file.getName());
            zos.putNextEntry(entry);
            byte[] buf = new byte[1024];
            while ((count = bis.read(buf)) != -1) {
                zos.write(buf, 0, count);
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            throw new KDException(BosErrorCode.bOS, new Object[]{ex.getMessage()});
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    private void compressDir(File dir, ZipOutputStream zos, String baseDir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files.length == 0) {
            try {
                zos.putNextEntry(new ZipEntry(baseDir + dir.getName() + File.separator));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                throw new KDException(BosErrorCode.bOS, new Object[]{e.getMessage()});
            }
        }
        for (File file : files) {
            this.compressbyType(file, zos, baseDir + dir.getName() + File.separator);
        }
    }

    private void sureUnZipTpl() {
        InputStream dictTpl = null;
        try {
            dictTpl = DataDictHtmlExporter.class.getResourceAsStream("/dictTpl.zip");
            this.unzip(dictTpl, this.getDictDir());
            dictTpl.close();
        }
        catch (Throwable ex) {
            LOG.error(ex);
            throw new KDException(BosErrorCode.bOS, new Object[]{ex.getMessage()});
        }
        finally {
            try {
                if (dictTpl != null) {
                    dictTpl.close();
                }
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    private void unzip(InputStream zipFile, String targetDir) throws IOException {
        File targetfolder = new File(this.cleanString(targetDir));
        ZipInputStream zip = new ZipInputStream(zipFile, Charset.forName("GBK"));
        ZipEntry ze = null;
        FileOutputStream fo = null;
        byte[] buff = new byte[1024];
        while ((ze = zip.getNextEntry()) != null) {
            File _file = new File(targetfolder, ze.getName());
            if (!_file.getParentFile().exists()) {
                _file.getParentFile().mkdirs();
            }
            if (ze.isDirectory()) {
                _file.mkdir();
            } else {
                try {
                    int len;
                    fo = new FileOutputStream(_file);
                    while ((len = zip.read(buff)) > 0) {
                        fo.write(buff, 0, len);
                    }
                }
                catch (Throwable ex) {
                    LOG.error(ex);
                    throw new KDException(BosErrorCode.bOS, new Object[]{ex.getMessage()});
                }
                finally {
                    try {
                        if (fo != null) {
                            fo.close();
                        }
                    }
                    catch (IOException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }
            zip.closeEntry();
        }
        zip.close();
    }

    private List<DynamicObject> getEntitiesByApp(List<String> appIds) {
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add(FIELD_NAME_ENTITY_ID);
        selectFields.add(FIELD_NAME_ENTITY_NUMBER);
        selectFields.add(FIELD_NAME_ENTITY_NAME);
        selectFields.add(FIELD_NAME_ENTITY_DENTITYID);
        selectFields.add(FIELD_NAME_ENTITY_TABLENAME);
        selectFields.add(FIELD_NAME_ENTITY_PKFIELDNAME);
        selectFields.add(FIELD_NAME_ENTITY_PKFIELDTYPE);
        selectFields.add(FIELD_NAME_ENTITY_MODELTYPE);
        ArrayList<DynamicObject> r = new ArrayList<DynamicObject>(16);
        QFilter modelTypeFilter = new QFilter(FIELD_NAME_ENTITY_MODELTYPE, "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter};
        for (String id : appIds) {
            Map entityInfos = EntityObjectReader.loadEntityObjectsInApp((String)id, selectFields, (QFilter[])filters);
            for (Map.Entry entryItem : entityInfos.entrySet()) {
                DynamicObject entityInfo = (DynamicObject)entryItem.getValue();
                r.add(entityInfo);
            }
        }
        return r;
    }

    private List<DynamicObject> getApps(String appId) {
        return this.allSelectedCloudApps.stream().filter(d -> d.getString(FIELD_NAME_APP_ID).equalsIgnoreCase(appId) || d.getString(FIELD_NAME_MASTER_ID).equalsIgnoreCase(appId)).collect(Collectors.toList());
    }

    private List<String> getAppIdsBy(String appId) {
        return this.allSelectedCloudApps.stream().filter(d -> d.getString(FIELD_NAME_APP_ID).equalsIgnoreCase(appId) || d.getString(FIELD_NAME_MASTER_ID).equalsIgnoreCase(appId)).map(t -> t.getString(FIELD_NAME_APP_ID)).collect(Collectors.toList());
    }

    private Tuple<String, String> getAppExtNumberName(String appId) {
        List<Object> apps = this.getApps(appId);
        apps = apps.stream().sorted((a, b) -> a.getString(FIELD_NAME_CLOUD_INHERIT_PATH).compareTo(b.getString(FIELD_NAME_CLOUD_INHERIT_PATH))).collect(Collectors.toList());
        DynamicObject lastExt = (DynamicObject)apps.get(apps.size() - 1);
        return new Tuple((Object)lastExt.getString(FIELD_NAME_APP_NUMBER), (Object)lastExt.getString(FIELD_NAME_APP_NAME));
    }

    private List<DynamicObject> getAppsByCloud(DynamicObject cloud) {
        return this.allSelectedCloudApps.stream().filter(d -> cloud.getString(FIELD_NAME_CLOUD_ID) != null && cloud.getString(FIELD_NAME_CLOUD_ID).equalsIgnoreCase(d.getString(FIELD_NAME_CLOUD_ID))).collect(Collectors.toList());
    }

    private List<DynamicObject> getDistinctClouds() {
        return this.allSelectedCloudApps.stream().filter(this.distinctByCloud(p -> p.getString(FIELD_NAME_CLOUD_ID))).collect(Collectors.toList());
    }

    private <T> Predicate<T> distinctByCloud(Function<? super T, Object> cloudExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> {
            Object apply = cloudExtractor.apply(t);
            if (apply != null) {
                return map.putIfAbsent(apply, Boolean.TRUE) == null;
            }
            return false;
        };
    }

    private String cleanXSSContent(String value) {
        if (value == null) {
            return null;
        }
        String cleanValue = value;
        cleanValue = cleanValue.replace("'", "&#39;");
        cleanValue = cleanValue.replace("<", "&lt;");
        cleanValue = cleanValue.replace(">", "&gt;");
        cleanValue = cleanValue.replace("\"", "&quot;");
        cleanValue = cleanValue.replace("'", "&#x27;");
        cleanValue = cleanValue.replace("/", "&#x2f;");
        return cleanValue;
    }

    private String cleanString(String filePath) {
        return filePath.replace("../", "#");
    }
}

