/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class DataExporterNodePlugin
extends AbstractFormPlugin {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        BizAppService appService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        this.getModel().setValue("exportformat", (Object)"1");
        TreeNode root = (TreeNode)appService.getSubsysTree(null, null, null, "app", true, false, false);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"DataExporterNodePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        treeView.addNode(root);
        this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)root));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String rootNodeStr = this.getPageCache().get("rootNode");
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        switch (btn.getKey()) {
            case "btnok": {
                if (this.getModel().getValue("exportformat") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u6587\u4ef6\u683c\u5f0f\u3002", (String)"DataExporterNodePlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String exportFormat = (String)this.getModel().getValue("exportformat");
                TreeView view = (TreeView)this.getView().getControl("treeview");
                List ids = view.getTreeState().getSelectedNodeId();
                HashSet<String> exportAppIds = new HashSet<String>();
                for (String id : ids) {
                    TreeNode node = root.getTreeNode(id, 10);
                    Object type = node.getData();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"cloud", (CharSequence)String.valueOf(type))) {
                        List appIds = BizAppServiceHelp.getAppsIdByCloudId((String)node.getId());
                        for (Object appId : appIds) {
                            exportAppIds.add((String)appId);
                        }
                        continue;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"app", (CharSequence)String.valueOf(type))) {
                        exportAppIds.addAll(this.getAppIdsBy(node.getId()));
                        continue;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"root", (CharSequence)String.valueOf(type))) continue;
                    for (DynamicObject obj : BizAppServiceHelp.getAllBizApps()) {
                        Object appId;
                        appId = obj.get("id");
                        if (appId == null) continue;
                        exportAppIds.add(appId.toString());
                    }
                    break;
                }
                if (exportAppIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u52fe\u9009\u5bfc\u51fa\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataExporterNodePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                ArrayList appIds = new ArrayList(exportAppIds);
                returnData.put("exportAppIds", appIds);
                returnData.put("exportFormat", exportFormat);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            default: {
                this.getView().close();
            }
        }
    }

    private List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)tType)) {
                return app.getString("id");
            }
            return app.getString("masterid");
        }).orElse("");
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return new ArrayList<String>();
        }
        return allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }
}

