/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.newdevportal.table.DesignerColumn;
import kd.bos.newdevportal.table.DesignerConstaint;
import kd.bos.newdevportal.table.DesignerIndex;
import kd.bos.newdevportal.table.EntityMetaTableBinder;

public final class DesignerTable
implements Cloneable,
Serializable {
    private String id;
    private String code;
    private String name;
    private ILocaleString comment = new LocaleString("");
    private List<DesignerColumn> cols = new ArrayList<DesignerColumn>();
    private List<DesignerConstaint> constaints = new ArrayList<DesignerConstaint>();
    private List<DesignerIndex> idxs = new ArrayList<DesignerIndex>();
    private String dbroute;
    private String appId;
    private String ownerEntityNum;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ILocaleString getComment() {
        return this.comment;
    }

    public void setComment(ILocaleString comment) {
        this.comment = comment;
    }

    public List<DesignerColumn> getCols() {
        return this.cols;
    }

    public void setCols(List<DesignerColumn> cols) {
        this.cols = cols;
    }

    public List<DesignerConstaint> getConstaints() {
        return this.constaints;
    }

    public void setConstaints(List<DesignerConstaint> constaints) {
        this.constaints = constaints;
    }

    public List<DesignerIndex> getIdxs() {
        return this.idxs;
    }

    public void setIdxs(List<DesignerIndex> idxs) {
        this.idxs = idxs;
    }

    public String tranToDDL() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ").append(this.name).append(" (").append("\r\n");
        int lastColumn = this.getCols().size();
        int i = 1;
        for (DesignerColumn column : this.getCols()) {
            builder.append(column.getName()).append(" ").append(column.getType()).append(" ").append(column.isNotnull() ? " NOT NULL " : " NULL ").append(" DEFAULT ").append(column.getDefValue());
            if (++i < lastColumn) {
                builder.append("  ,  ");
            }
            builder.append("\r\n");
        }
        i = 0;
        int lastConstaint = this.getConstaints().size();
        for (DesignerConstaint constaint : this.getConstaints()) {
            builder.append("CONSTRAINT ").append(constaint.getName()).append(" ").append(constaint.getConstaintType().toString()).append(" ").append("(").append(String.join((CharSequence)",", constaint.getRefCols())).append(")");
            if (++i < lastConstaint) {
                builder.append("  ,  ");
            }
            builder.append("\r\n");
        }
        builder.append(")").append(";");
        builder.append("\r\n");
        for (DesignerIndex index : this.getIdxs()) {
            builder.append(index.getIndexdef()).append(";").append("\r\n");
        }
        return builder.toString();
    }

    public String getOwnerEntityNum() {
        return this.ownerEntityNum;
    }

    public void setOwnerEntityNum(String ownerEntityNum) {
        this.ownerEntityNum = ownerEntityNum;
    }

    public void bindEntityMeta(String entityNum) {
        this.bindEntityMeta(entityNum, false);
    }

    public void bindEntityMeta(String entityNum, boolean fastMode) {
        if (StringUtils.isBlank((CharSequence)entityNum)) {
            return;
        }
        EntityMetaTableBinder binder = new EntityMetaTableBinder(entityNum, fastMode);
        binder.bind(this);
        this.ownerEntityNum = entityNum;
    }

    public String getDbroute() {
        return this.dbroute;
    }

    public void setDbroute(String dbroute) {
        this.dbroute = dbroute;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public static DesignerTable copy(DesignerTable table) {
        DesignerTable newTable = new DesignerTable();
        newTable.id = table.id;
        newTable.code = table.code;
        newTable.name = table.name;
        newTable.comment.putAll((Map)table.comment);
        for (DesignerColumn col : table.cols) {
            newTable.cols.add(DesignerColumn.copy(col));
        }
        for (DesignerConstaint constaint : table.constaints) {
            newTable.constaints.add(DesignerConstaint.copy(constaint));
        }
        for (DesignerIndex index : table.idxs) {
            newTable.idxs.add(DesignerIndex.copy(index));
        }
        newTable.dbroute = table.dbroute;
        newTable.appId = table.appId;
        newTable.ownerEntityNum = table.ownerEntityNum;
        return newTable;
    }
}

