/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PeriodProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.property.UserProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.newdevportal.table.DesignerColumn;
import kd.bos.newdevportal.table.DesignerTable;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class EntityMetaTableBinder {
    private static Log log = LogFactory.getLog(EntityMetaTableBinder.class);
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private boolean fastMode = false;
    private MainEntityType mainType = null;
    private EntityMetadata entityMetadata = null;
    private boolean export = false;
    private Map<String, IDataEntityType> tableEntryMapping = new CaseInsensitiveMap();
    private Map<String, Map<String, IDataEntityProperty>> simpleFieldsMapping = new CaseInsensitiveMap();
    private Map<String, ILocaleString> tableDescs = new CaseInsensitiveMap();
    private Map<String, Map<String, IComplexProperty>> complexRefFieldMapping = new CaseInsensitiveMap();
    private Map<String, String> splitTableDesc = new CaseInsensitiveMap();

    public EntityMetaTableBinder(EntityMetadata meta) {
        this.mainType = meta.buildDataEntityType();
        this.build();
    }

    public EntityMetaTableBinder(String entityNum, boolean fastMode) {
        this(entityNum, fastMode, false);
    }

    public EntityMetaTableBinder(MainEntityType mainType) {
        this.mainType = mainType;
        this.build();
    }

    public EntityMetaTableBinder(EntityMetadata entityMetadata, MainEntityType mainType) {
        this.entityMetadata = entityMetadata;
        this.mainType = mainType;
        this.build();
    }

    public EntityMetaTableBinder(String entityNum, boolean fastMode, boolean export) {
        this.export = export;
        this.fastMode = fastMode;
        try {
            if (!fastMode) {
                this.entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
                this.mainType = this.entityMetadata.buildDataEntityType();
                this.mainType.endInit();
            } else {
                this.mainType = EntityMetadataCache.getDataEntityType((String)entityNum);
            }
        }
        catch (Throwable e) {
            log.error("\u5143\u6570\u636e\u52a0\u8f7d\u5931\u8d25", e);
            return;
        }
        this.build();
    }

    private void build() {
        if (this.mainType == null) {
            return;
        }
        if (this.mainType.isDbIgnore()) {
            return;
        }
        if (this.entityMetadata != null) {
            for (Entity entity : this.entityMetadata.getEntitys()) {
                for (SplitTable splitTable : entity.getSplitTables()) {
                    this.splitTableDesc.put(String.format("%s_%s", entity.getTableName(), splitTable.getSuffix()), splitTable.getDescription());
                }
            }
        }
        this.tableEntryMapping.put(this.mainType.getAlias(), (IDataEntityType)this.mainType);
        this.tableDescs.put(this.mainType.getAlias(), (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u4e3b\u8868", (String)"EntityMetaTableBinder_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_1", this.mainType.getAlias(), (ILocaleString)this.mainType.getDisplayName()));
        if (this.mainType instanceof BasedataEntityType) {
            String useregtable = String.format("%s_%s", this.mainType.getAlias(), "usereg");
            String exctable = String.format("%s_%s", this.mainType.getAlias(), "exc");
            String utable = String.format("%s_%s", this.mainType.getAlias(), "u");
            String mtable = String.format("%s_%s", this.mainType.getAlias(), "m");
            this.tableEntryMapping.put(useregtable, (IDataEntityType)this.mainType);
            this.tableEntryMapping.put(exctable, (IDataEntityType)this.mainType);
            this.tableEntryMapping.put(utable, (IDataEntityType)this.mainType);
            this.tableEntryMapping.put(mtable, (IDataEntityType)this.mainType);
            this.tableDescs.put(useregtable, (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u4f7f\u7528\u767b\u8bb0\u8868", (String)"EntityMetaTableBinder_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_8", useregtable, (ILocaleString)this.mainType.getDisplayName()));
            this.tableDescs.put(exctable, (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6392\u9664\u8868", (String)"EntityMetaTableBinder_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_9", exctable, (ILocaleString)this.mainType.getDisplayName()));
            this.tableDescs.put(utable, (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u4f7f\u7528\u8303\u56f4\u8868", (String)"EntityMetaTableBinder_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_10", utable, (ILocaleString)this.mainType.getDisplayName()));
            this.tableDescs.put(mtable, (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u4f7f\u7528\u8303\u56f4\u4f4d\u56fe\u8868", (String)"EntityMetaTableBinder_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_11", mtable, (ILocaleString)this.mainType.getDisplayName()));
        } else if (this.entityMetadata != null && this.entityMetadata.getRootEntity() instanceof BillEntity) {
            String tracker = ((BillEntity)this.entityMetadata.getRootEntity()).getLinkSet().getTrackerTable();
            String wbsnap = ((BillEntity)this.entityMetadata.getRootEntity()).getLinkSet().getWbSnapTable();
            if (StringUtils.isNotBlank((CharSequence)tracker)) {
                this.tableDescs.putIfAbsent(tracker, (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u5173\u8054\u8ffd\u8e2a\u8868", (String)"EntityMetaTableBinder_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_12", tracker, (ILocaleString)this.mainType.getDisplayName()));
            }
            if (StringUtils.isNotBlank((CharSequence)wbsnap)) {
                this.tableDescs.putIfAbsent(wbsnap, (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u53cd\u5199\u8bb0\u5f55\u8868", (String)"EntityMetaTableBinder_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_13", wbsnap, (ILocaleString)this.mainType.getDisplayName()));
            }
        }
        for (IDataEntityProperty prop : this.mainType.getProperties()) {
            if (prop instanceof ISimpleProperty) {
                this.recordSimpleProp((ISimpleProperty)prop, this.mainType.getAlias());
                continue;
            }
            if (prop instanceof ICollectionProperty) {
                this.recordCollectionProp((ICollectionProperty)prop);
                continue;
            }
            if (!(prop instanceof IComplexProperty)) continue;
            this.recordComplexProp((IComplexProperty)prop);
        }
    }

    public static LocaleString appendSuffix(String suffix, String resourceId, String tableName, ILocaleString orgin) {
        LocaleString names = new LocaleString("");
        names.setLocaleValue(tableName);
        if (orgin == null || orgin.isEmpty()) {
            return names;
        }
        orgin.forEach((k, v) -> {
            if (!"GLang".equalsIgnoreCase((String)k)) {
                try {
                    names.put(k, (Object)String.format("%s-%s", v == null ? tableName : v, PromptWordCacheNew.getPromptWord((String)suffix, (String)resourceId, (Lang)Lang.valueOf((String)k), (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])));
                }
                catch (Exception e) {
                    log.error("\u591a\u8bed\u8a00\u7ffb\u8bd1\u62a5\u9519:" + e.getMessage(), (Throwable)e);
                }
            }
        });
        return names;
    }

    private void recordSimpleProp(ISimpleProperty prop, String tableName) {
        CaseInsensitiveMap fields;
        if (prop.isDbIgnore()) {
            return;
        }
        String group = prop.getTableGroup();
        String realTableName = tableName;
        if (StringUtils.isNotBlank((CharSequence)group)) {
            realTableName = String.format("%s_%s", tableName, group);
            LocaleString pEntityName = prop.getParent().getDisplayName();
            this.tableDescs.putIfAbsent(realTableName, (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u5206\u8868", (String)"EntityMetaTableBinder_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_2", tableName, (ILocaleString)pEntityName));
            this.tableEntryMapping.put(realTableName, prop.getParent());
        }
        if ((fields = this.simpleFieldsMapping.get(realTableName)) == null) {
            fields = new CaseInsensitiveMap();
            this.simpleFieldsMapping.put(realTableName, (Map<String, IDataEntityProperty>)fields);
        }
        fields.put(prop.getAlias(), prop);
    }

    private void recordCollectionProp(ICollectionProperty prop) {
        if (prop.isDbIgnore()) {
            return;
        }
        String tableName = prop.getItemType().getAlias();
        this.tableEntryMapping.put(tableName, prop.getItemType());
        LocaleString tableNames = new LocaleString(tableName);
        LocaleString pTableName = prop.getDisplayName();
        if (prop instanceof DynamicLocaleProperty) {
            pTableName = prop.getParent().getDisplayName();
            tableNames = EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u8868", (String)"EntityMetaTableBinder_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_3", tableName, (ILocaleString)pTableName);
        } else if (prop instanceof AttachmentProp) {
            tableNames = EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u9644\u4ef6\u8868", (String)"EntityMetaTableBinder_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_4", tableName, (ILocaleString)pTableName);
        } else if (prop instanceof MulBasedataProp) {
            tableNames = EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u8868", (String)"EntityMetaTableBinder_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_5", tableName, (ILocaleString)pTableName);
        } else if (prop instanceof EntryProp) {
            tableNames = EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u5b50\u8868", (String)"EntityMetaTableBinder_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_6", tableName, (ILocaleString)pTableName);
        }
        this.tableDescs.put(tableName, (ILocaleString)tableNames);
        CaseInsensitiveMap fields = this.simpleFieldsMapping.get(tableName);
        if (fields == null) {
            fields = new CaseInsensitiveMap();
            this.simpleFieldsMapping.put(tableName, (Map<String, IDataEntityProperty>)fields);
        }
        fields.put(prop.getAlias(), prop);
        for (IDataEntityProperty child : prop.getItemType().getProperties()) {
            if (child instanceof ISimpleProperty) {
                this.recordSimpleProp((ISimpleProperty)child, tableName);
                continue;
            }
            if (child instanceof ICollectionProperty) {
                this.recordCollectionProp((ICollectionProperty)child);
                continue;
            }
            if (!(child instanceof IComplexProperty)) continue;
            this.recordComplexProp((IComplexProperty)child);
        }
    }

    private void recordComplexProp(IComplexProperty prop) {
        String parentAlias = prop.getParent().getAlias();
        if (StringUtils.isNotBlank((CharSequence)prop.getTableGroup())) {
            parentAlias = String.format("%s_%s", prop.getParent().getAlias(), prop.getTableGroup());
        }
        this.complexRefFieldMapping.putIfAbsent(parentAlias, (Map<String, IComplexProperty>)new CaseInsensitiveMap());
        this.complexRefFieldMapping.get(parentAlias).put(prop.getAlias(), prop);
        String group = prop.getTableGroup();
        if (StringUtils.isNotBlank((CharSequence)group)) {
            LocaleString pEntityName = prop.getParent().getDisplayName();
            this.tableDescs.putIfAbsent(parentAlias, (ILocaleString)EntityMetaTableBinder.appendSuffix(ResManager.loadKDString((String)"\u5206\u8868", (String)"EntityMetaTableBinder_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), "EntityMetaTableBinder_2", parentAlias, (ILocaleString)pEntityName));
            this.tableEntryMapping.put(parentAlias, prop.getParent());
        }
        if (prop.isDbIgnore()) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.mainType.getName(), (CharSequence)prop.getName())) {
            return;
        }
        String tableName = prop.getComplexType().getAlias();
        this.tableEntryMapping.put(tableName, prop.getComplexType());
        for (IDataEntityProperty child : prop.getComplexType().getProperties()) {
            if (child instanceof ISimpleProperty) {
                this.recordSimpleProp((ISimpleProperty)child, tableName);
                continue;
            }
            if (child instanceof ICollectionProperty) {
                this.recordCollectionProp((ICollectionProperty)child);
                continue;
            }
            if (!(prop instanceof IComplexProperty)) continue;
            this.recordComplexProp((IComplexProperty)child);
        }
    }

    public void bind(DesignerTable dbTable) {
        LocaleString displayName;
        String tableName = dbTable.getCode();
        IDataEntityType dt = this.tableEntryMapping.get(dbTable.getCode());
        if (dt == null) {
            if (this.splitTableDesc.get(tableName) != null) {
                dbTable.setComment((ILocaleString)new LocaleString(this.splitTableDesc.get(tableName)));
            }
            dbTable.setName(this.tableDescs.getOrDefault(tableName, (ILocaleString)new LocaleString(tableName)).toString());
            return;
        }
        if (this.mainType != null) {
            dbTable.setDbroute(this.mainType.getDBRouteKey());
            dbTable.setAppId(this.mainType.getAppId());
        }
        if ((displayName = dt.getDisplayName()) != null && !displayName.isEmpty()) {
            dbTable.setName(this.tableDescs.getOrDefault(tableName, (ILocaleString)displayName).toString());
        } else {
            dbTable.setName(this.tableDescs.getOrDefault(tableName, (ILocaleString)new LocaleString(tableName)).toString());
        }
        if (this.splitTableDesc.get(tableName) != null) {
            dbTable.setComment((ILocaleString)new LocaleString(this.splitTableDesc.get(tableName)));
        }
        if (this.simpleFieldsMapping.get(tableName) == null) {
            return;
        }
        if (dbTable.getCols() == null) {
            return;
        }
        for (DesignerColumn col : dbTable.getCols()) {
            IComplexProperty prop;
            IDataEntityProperty colProp = this.simpleFieldsMapping.getOrDefault(tableName, (Map<String, IDataEntityProperty>)new CaseInsensitiveMap()).get(col.getCode());
            IDataEntityProperty refComplexProp = (IDataEntityProperty)this.complexRefFieldMapping.getOrDefault(tableName, (Map<String, IComplexProperty>)new CaseInsensitiveMap()).get(col.getCode());
            if (colProp == null && refComplexProp == null) continue;
            IDataEntityProperty direct = colProp == null ? refComplexProp : colProp;
            String extInfo = "";
            extInfo = this.getColumnExportExtInfo(tableName, direct, this.mainType);
            LocaleString colDisplayName = direct.getDisplayName();
            if (refComplexProp != null) {
                colDisplayName = refComplexProp.getDisplayName();
            }
            if (colDisplayName != null && !colDisplayName.isEmpty()) {
                col.setComment((ILocaleString)colDisplayName);
                col.setName(colDisplayName.toString());
            } else {
                col.setComment((ILocaleString)new LocaleString(direct.getName()));
            }
            if (colProp instanceof ISimpleProperty && this.complexRefFieldMapping.get(tableName) != null && (prop = this.complexRefFieldMapping.get(tableName).get(colProp.getAlias())) != null && (prop.getClass().isAssignableFrom(BasedataProp.class) || prop instanceof UserProp || prop instanceof OrgProp || prop instanceof AssistantProp || prop instanceof CreaterProp || prop instanceof CurrencyProp || prop instanceof GroupProp || prop instanceof ModifierProp || prop instanceof MaterielProp || prop instanceof PeriodProp || prop instanceof UnitProp)) {
                col.setBase(true);
            }
            if (!StringUtils.isNotBlank((CharSequence)extInfo)) continue;
            if (col.isBase()) {
                String baseNumber = "";
                String[] s = extInfo.split(" ");
                if (s.length > 1) {
                    baseNumber = s[1];
                }
                col.setBaseNumber(baseNumber);
            }
            col.setComment((ILocaleString)new LocaleString(extInfo));
        }
    }

    private String getColumnExportExtInfo(String tableName, IDataEntityProperty colProp, MainEntityType mainType) {
        StringBuilder builder = new StringBuilder();
        try {
            if (colProp instanceof ComboProp) {
                builder.append(colProp.getDisplayName()).append(",");
                builder.append(ResManager.loadKDString((String)"\u679a\u4e3e: ", (String)"EntityMetaTableBinder_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                List items = ((ComboProp)colProp).getComboItems();
                for (ValueMapItem item : items) {
                    builder.append(item.getValue()).append(" :").append(item.getName()).append("  ");
                }
            } else if (colProp instanceof ISimpleProperty) {
                if (this.complexRefFieldMapping.get(tableName) == null) {
                    return "";
                }
                IComplexProperty complexProperty = this.complexRefFieldMapping.get(tableName).get(colProp.getAlias());
                if (complexProperty != null) {
                    builder.append(complexProperty.getComplexType().getDisplayName()).append(" ").append(complexProperty.getComplexType().getName());
                }
            } else if (colProp instanceof IComplexProperty) {
                IComplexProperty complexProperty = (IComplexProperty)colProp;
                if (complexProperty.getComplexType() != null) {
                    builder.append(complexProperty.getComplexType().getDisplayName()).append(" ").append(complexProperty.getComplexType().getName());
                } else {
                    builder.append(complexProperty.getDisplayName()).append(" ").append(complexProperty.getName());
                }
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return builder.toString();
    }

    public Map<String, ILocaleString> getTableDesc() {
        return this.tableDescs;
    }

    public Map<String, IDataEntityType> getTableEntryProps() {
        return this.tableEntryMapping;
    }
}

