/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.newdevportal.table.EntityMetaTableBinder;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

class EntityTableUtil {
    private static Log log = LogFactory.getLog(EntityTableUtil.class);
    private static int maxSize = Math.min(Integer.getInteger("entityTableSync.maxThread", 5), 50);
    private static String INSERTSQL = "insert into T_META_TABLEDICTION(fid,ftablename,fmainentityid,fappid,fdata) values (?, ?, ?, ?, ?)";
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"entityTableUpgradeSyncPool", (int)1, (int)maxSize);

    EntityTableUtil() {
    }

    private static Map<String, TableInfo> getTableRef(EntityMetadata entityMeta, MainEntityType mainEntityType) {
        CaseInsensitiveMap tableInfos = new CaseInsensitiveMap();
        CaseInsensitiveMap tableRef = new CaseInsensitiveMap();
        if (entityMeta == null) {
            return tableInfos;
        }
        MainEntityType mainType = mainEntityType;
        if (mainType == null) {
            return tableInfos;
        }
        if (mainType.isDbIgnore()) {
            return tableInfos;
        }
        if ("t_isv_xxx".equalsIgnoreCase(mainType.getAlias())) {
            return tableInfos;
        }
        EntityMetaTableBinder binder = new EntityMetaTableBinder(entityMeta, mainEntityType);
        Map<String, ILocaleString> tableDesc = binder.getTableDesc();
        Map<String, IDataEntityType> tableEntryIndexs = binder.getTableEntryProps();
        tableRef.put(mainType.getAlias(), mainEntityType.getName());
        for (IDataEntityProperty prop : mainType.getProperties()) {
            if (prop instanceof ISimpleProperty) {
                EntityTableUtil.readSimpleProperty((ISimpleProperty)prop, (Map<String, String>)tableRef, mainType);
                continue;
            }
            if (prop instanceof ICollectionProperty) {
                EntityTableUtil.readCollectionProperty((ICollectionProperty)prop, (Map<String, String>)tableRef, mainType);
                continue;
            }
            if (!(prop instanceof IComplexProperty)) continue;
            EntityTableUtil.readComplexProperty((IComplexProperty)prop, (Map<String, String>)tableRef, mainType);
        }
        MainEntity rootEntityMeta = entityMeta.getRootEntity();
        if (rootEntityMeta instanceof BaseEntity) {
            String inheritPath = entityMeta.getInheritPath();
            if (inheritPath.indexOf("6138b0d200000eac") >= 0 || inheritPath.indexOf("ab7efc31000015ac") >= 0 || inheritPath.indexOf("b0d31cea000006ac") >= 0) {
                EntityTableUtil.addBaseDataExtTable((BaseEntity)rootEntityMeta, "UseReg", (Map<String, String>)tableRef);
                EntityTableUtil.addBaseDataExtTable((BaseEntity)rootEntityMeta, "Exc", (Map<String, String>)tableRef);
                EntityTableUtil.addBaseDataExtTable((BaseEntity)rootEntityMeta, "U", (Map<String, String>)tableRef);
                EntityTableUtil.addBaseDataExtTable((BaseEntity)rootEntityMeta, "M", (Map<String, String>)tableRef);
            }
        } else if (rootEntityMeta instanceof BillEntity) {
            String tracker = ((BillEntity)rootEntityMeta).getLinkSet().getTrackerTable();
            String wbsnap = ((BillEntity)rootEntityMeta).getLinkSet().getWbSnapTable();
            if (StringUtils.isNotBlank((CharSequence)tracker)) {
                tableRef.put(tracker, mainType.getName());
                tableEntryIndexs.put(tracker, (IDataEntityType)mainType);
            }
            if (StringUtils.isNotBlank((CharSequence)wbsnap)) {
                tableRef.put(wbsnap, mainType.getName());
                tableEntryIndexs.put(wbsnap, (IDataEntityType)mainType);
            }
        }
        for (Map.Entry it : tableRef.entrySet()) {
            String tableName = (String)it.getKey();
            TableInfo tb = tableInfos.getOrDefault(tableName, new TableInfo());
            tb.setEntityId(entityMeta.getId());
            tb.setAppId(entityMeta.getBizappId());
            tb.setTableName(tableName);
            tb.setEntityNum(entityMeta.getKey());
            Map<String, Object> ext = tb.getExtInfo();
            IDataEntityType tableEntryProp = tableEntryIndexs.get(tableName);
            String ptable = "";
            ptable = StringUtils.equalsIgnoreCase((CharSequence)tableEntryProp.getAlias(), (CharSequence)tableName) ? (tableEntryProp == null ? "" : (tableEntryProp.getParent() == null ? "" : tableEntryProp.getParent().getAlias())) : tableEntryProp.getAlias();
            ext.put("parenttable", ptable.toLowerCase());
            ext.putIfAbsent("caption", tableDesc.get(tableName));
            tb.setExtInfo(ext);
            tableInfos.put(tableName, tb);
        }
        return tableInfos;
    }

    public static Map<String, TableInfo> getTableRef(String entityId) {
        CaseInsensitiveMap tableRef = new CaseInsensitiveMap();
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entityMeta == null) {
            return tableRef;
        }
        MainEntityType mainType = entityMeta.buildDataEntityType();
        if (mainType == null) {
            return tableRef;
        }
        return EntityTableUtil.getTableRef(entityMeta, mainType);
    }

    static void syncTableInfo(EntityMetadata entityMeta, MainEntityType mainEntityType) {
        try (TXHandle txp = TX.requiresNew();){
            Map<String, TableInfo> tableRef = EntityTableUtil.getTableRef(entityMeta, mainEntityType);
            if (tableRef.isEmpty()) {
                return;
            }
            EntityTableUtil.deleteByEntityId(Collections.singletonList(entityMeta.getId()));
            EntityTableUtil.insertTableInfo(tableRef.values());
        }
        catch (Exception e) {
            log.info("\u6570\u636e\u8868\u4fe1\u606f\u540c\u6b65\u5931\u8d25:" + e.getMessage(), (Object)e);
        }
    }

    private static void insertTableInfo(Collection<TableInfo> datas) {
        ArrayList<SqlParameter[]> insertData = new ArrayList<SqlParameter[]>(datas.size());
        String[] pks = DB.genStringIds((String)"t_meta_tablediction", (int)datas.size());
        int i = 0;
        for (TableInfo tableInfo : datas) {
            SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)pks[i]), new SqlParameter(":ftablename", 12, (Object)tableInfo.getTableName()), new SqlParameter(":fmainentityid", 12, (Object)tableInfo.getEntityId()), new SqlParameter(":fappid", 12, (Object)tableInfo.getAppId()), new SqlParameter(":fdata", 2011, (Object)SerializationUtils.toJsonString(tableInfo.getExtInfo()))};
            insertData.add(param);
            ++i;
        }
        DB.executeBatch((DBRoute)DBRoute.meta, (String)INSERTSQL, insertData);
    }

    private static void deleteByEntityId(List<String> entityIds) {
        SqlBuilder builder = new SqlBuilder();
        builder.append(" delete from t_meta_tablediction where ", new Object[0]).appendIn("fmainentityid", entityIds.toArray());
        DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)builder);
    }

    private static void addBaseDataExtTable(BaseEntity baseEntity, String suffix, Map<String, String> tableMapping) {
        String usereg = String.format("%s_%s", baseEntity.getTableName(), suffix).toUpperCase();
        if (!EntityTableUtil.checkBaseDataExtTable() || DB.exitsTable((DBRoute)DBRoute.of((String)baseEntity.getdbRoute()), (String)usereg)) {
            tableMapping.put(usereg, baseEntity.getKey());
        }
    }

    private static boolean checkBaseDataExtTable() {
        return Boolean.parseBoolean(System.getProperty("devp.entitytable.check.enable", "true"));
    }

    private static void readSimpleProperty(ISimpleProperty prop, Map<String, String> tableNames, MainEntityType mainType) {
        tableNames.put(EntityTableUtil.getTableName((IDataEntityProperty)prop), EntityTableUtil.getPropEntryKey(prop));
    }

    private static void readCollectionProperty(ICollectionProperty prop, Map<String, String> tableNames, MainEntityType mainType) {
        if (prop.isDbIgnore() || StringUtils.isBlank((CharSequence)prop.getItemType().getAlias())) {
            return;
        }
        tableNames.put(prop.getItemType().getAlias(), prop.getName());
        for (IDataEntityProperty child : prop.getItemType().getProperties()) {
            if (child instanceof ISimpleProperty) {
                EntityTableUtil.readSimpleProperty((ISimpleProperty)child, tableNames, mainType);
                continue;
            }
            if (child instanceof ICollectionProperty) {
                EntityTableUtil.readCollectionProperty((ICollectionProperty)child, tableNames, mainType);
                continue;
            }
            if (!(child instanceof IComplexProperty)) continue;
            EntityTableUtil.readComplexProperty((IComplexProperty)child, tableNames, mainType);
        }
    }

    private static void readComplexProperty(IComplexProperty prop, Map<String, String> tables, MainEntityType mainType) {
        tables.put(EntityTableUtil.getTableName((IDataEntityProperty)prop), EntityTableUtil.getPropEntryKey(prop));
        if (prop.isDbIgnore()) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)mainType.getName(), (CharSequence)prop.getName())) {
            return;
        }
        String tableName = prop.getComplexType().getAlias();
        tables.put(tableName, prop.getName());
        for (IDataEntityProperty child : prop.getComplexType().getProperties()) {
            if (child instanceof ISimpleProperty) {
                EntityTableUtil.readSimpleProperty((ISimpleProperty)child, tables, mainType);
                continue;
            }
            if (child instanceof ICollectionProperty) {
                EntityTableUtil.readCollectionProperty((ICollectionProperty)child, tables, mainType);
                continue;
            }
            if (!(prop instanceof IComplexProperty)) continue;
            EntityTableUtil.readComplexProperty((IComplexProperty)child, tables, mainType);
        }
    }

    public static String getTableName(IDataEntityProperty prop) {
        if (prop.getParent() == null || prop.getParent().isDbIgnore()) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)prop.getTableGroup())) {
            return prop.getParent().getAlias();
        }
        return String.format("%s_%s", prop.getParent().getAlias(), prop.getTableGroup());
    }

    public static String getPropEntryKey(ISimpleProperty prop) {
        String parentKey = prop.getParent().getName();
        return parentKey == null ? "" : parentKey;
    }

    private static String getPropEntryKey(IComplexProperty prop) {
        String parentKey = prop.getParent().getName();
        return parentKey == null ? "" : parentKey;
    }

    static void syncTableInfoByNum(String entityNum) {
        String id = MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        MainEntityType mainEntityType = entityMetadata.buildDataEntityType();
        EntityTableUtil.syncTableInfo(entityMetadata, mainEntityType);
    }

    private static String getUpgradeLockPath() {
        RequestContext requestContext = RequestContext.get();
        return String.format("%s_%s_%s", Instance.getClusterName(), requestContext.getAccountId(), "devpn_tabledict_sync");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncAll() {
        try {
            long cost = 0L;
            String lockPath = EntityTableUtil.getUpgradeLockPath();
            try (DLock lock = DLock.create((String)lockPath);){
                if (!lock.tryLock(0L)) {
                    log.info("EntityTableSyncTask.log : task is already running");
                    return;
                }
                List mainEntityIds = (List)DB.query((DBRoute)DBRoute.meta, (String)" select t1.fid from t_meta_entitydesign t1 where t1.ftype != '2' and fid not in ( select fmainentityid from t_meta_tablediction )   ", rs -> {
                    ArrayList<String> idList = new ArrayList<String>(10);
                    while (rs.next()) {
                        idList.add(rs.getString("fid"));
                    }
                    return idList;
                });
                ConcurrentLinkedQueue<SqlParameter[]> param = new ConcurrentLinkedQueue<SqlParameter[]>();
                List<SyncTask> tasks = EntityTableUtil.buildTask(mainEntityIds, param, Integer.getInteger("devp.tabledict.upgradethread.size", maxSize / 2 + 1));
                CountDownLatch locker = new CountDownLatch(tasks.size());
                RequestContext rs2 = RequestContext.get();
                for (SyncTask task : tasks) {
                    task.getContext().setBasLocker(locker);
                    pool.execute((Runnable)task, rs2);
                }
                long maxUpgradeTime = 3600L;
                while (locker.getCount() > 0L && cost <= maxUpgradeTime) {
                    try {
                        if (locker.await(5L, TimeUnit.SECONDS)) break;
                        cost += 5L;
                    }
                    catch (InterruptedException e) {
                        log.error("datatablesync err :" + e.getMessage(), (Throwable)e);
                    }
                }
                if (!param.isEmpty()) {
                    ArrayList<SqlParameter[]> insertParams = new ArrayList<SqlParameter[]>(param);
                    String[] ids = DB.genStringIds((String)"t_meta_tablediction", (int)insertParams.size());
                    int i = 0;
                    for (Object[] objectArray : insertParams) {
                        objectArray[0] = new SqlParameter(":fid", 12, (Object)ids[i++]);
                    }
                    DB.executeBatch((DBRoute)DBRoute.meta, (String)INSERTSQL, insertParams);
                }
                EntityTableUtil.clearDuplicateData();
            }
            finally {
                log.info("\u5b9e\u4f53\u6570\u636e\u8868\u4fe1\u606f\u540c\u6b65\u7ed3\u675f");
            }
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u6570\u636e\u8868\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
    }

    public static void clearDuplicateData() {
        String sql = " select fid ,fmainentityid , ftablename from t_meta_tablediction where ftablename in ( select ftablename from t_meta_tablediction group by ftablename,fmainentityid having count(1)>1) ";
        HashMap<String, Boolean> sign = new HashMap<String, Boolean>(16);
        HashSet<String> duplicatePk = new HashSet<String>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"entitytablesync", (DBRoute)DBRoute.meta, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String pk = row.getString("fid");
                String entityId = row.getString("fmainentityid");
                String tableName = row.getString("ftablename");
                Boolean oldValue = sign.put(String.format("%s_%s", entityId, tableName), true);
                if (oldValue == null) continue;
                duplicatePk.add(pk);
            }
        }
        if (duplicatePk.isEmpty()) {
            return;
        }
        SqlBuilder deleteBuild = new SqlBuilder();
        deleteBuild.append("delete from t_meta_tablediction where ", new Object[0]).appendIn("fid", duplicatePk.toArray());
        DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteBuild);
    }

    private static List<SyncTask> buildTask(List<String> mainEntityIds, ConcurrentLinkedQueue<SqlParameter[]> shareParam, int maxConcurrency) {
        ArrayList<SyncTask> tasks = new ArrayList<SyncTask>(1);
        if (mainEntityIds.size() <= maxConcurrency) {
            SyncTaskContext taskContext = new SyncTaskContext(shareParam, mainEntityIds);
            SyncTask task = new SyncTask();
            task.setContext(taskContext);
            tasks.add(task);
        } else {
            int singleTaskNums = mainEntityIds.size() / maxConcurrency + 1;
            for (int i = 0; i < mainEntityIds.size(); i += singleTaskNums) {
                SyncTaskContext context = new SyncTaskContext(shareParam, mainEntityIds.subList(i, Math.min(i + singleTaskNums, mainEntityIds.size())));
                SyncTask task = new SyncTask();
                task.setContext(context);
                tasks.add(task);
            }
        }
        return tasks;
    }

    static class SyncTask
    implements Runnable {
        private SyncTaskContext context;

        SyncTask() {
        }

        public SyncTaskContext getContext() {
            return this.context;
        }

        public void setContext(SyncTaskContext context) {
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setUncaughtExceptionHandler((t, e) -> this.context.getBasLocker().countDown());
            try {
                for (String entityId : this.context.getEntityIds()) {
                    if (this.context.getBasLocker().getCount() <= 0L) {
                        return;
                    }
                    try {
                        Map<String, TableInfo> tableRef = EntityTableUtil.getTableRef(entityId);
                        for (Map.Entry<String, TableInfo> it : tableRef.entrySet()) {
                            SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)""), new SqlParameter(":ftablename", 12, (Object)it.getValue().getTableName()), new SqlParameter(":fmainentityid", 12, (Object)it.getValue().getEntityId()), new SqlParameter(":fappid", 12, (Object)it.getValue().getAppId()), new SqlParameter(":fdata", 2011, (Object)SerializationUtils.toJsonString(it.getValue().getExtInfo()))};
                            this.context.getPrams().add(param);
                        }
                    }
                    catch (Throwable e2) {
                        log.error("synctableref err:" + e2.getMessage(), e2);
                    }
                }
            }
            catch (Exception e3) {
                log.error((Throwable)e3);
            }
            finally {
                this.context.getBasLocker().countDown();
            }
        }
    }

    static final class SyncTaskContext {
        private ConcurrentLinkedQueue<SqlParameter[]> prams;
        private CountDownLatch basLocker;
        private List<String> entityIds;

        public void setBasLocker(CountDownLatch locker) {
            this.basLocker = locker;
        }

        public CountDownLatch getBasLocker() {
            return this.basLocker;
        }

        public ConcurrentLinkedQueue<SqlParameter[]> getPrams() {
            return this.prams;
        }

        public void setPrams(ConcurrentLinkedQueue<SqlParameter[]> prams) {
            this.prams = prams;
        }

        public List<String> getEntityIds() {
            return this.entityIds;
        }

        public void setEntityIds(List<String> entityIds) {
            this.entityIds = entityIds;
        }

        public SyncTaskContext(ConcurrentLinkedQueue<SqlParameter[]> prams, List<String> entityIds) {
            this.prams = prams;
            this.entityIds = entityIds;
        }
    }

    static class TableInfo {
        private String pk;
        private String appId = "";
        private String entityId = "";
        private Map<String, Object> extInfo = new HashMap<String, Object>();
        private String tableName;
        private String entityNum = "";

        public String getPk() {
            return this.pk;
        }

        public void setPk(String pk) {
            this.pk = pk;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public Map<String, Object> getExtInfo() {
            return this.extInfo;
        }

        public void setExtInfo(Map<String, Object> extInfo) {
            this.extInfo = extInfo;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getEntityNum() {
            return this.entityNum;
        }

        public void setEntityNum(String entityNum) {
            this.entityNum = entityNum;
        }

        public TableInfo() {
        }

        public TableInfo(String pk, String appId, String entityId, String entityNum, Map<String, Object> extInfo, String tableName) {
            this.pk = pk;
            this.appId = appId == null ? "" : appId;
            this.entityId = entityId == null ? "" : appId;
            this.extInfo = extInfo == null ? new HashMap() : extInfo;
            this.tableName = tableName;
            this.entityNum = entityNum;
        }
    }
}

