/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.newdevportal.table.ConstaintType;
import kd.bos.newdevportal.table.DesignerColumn;
import kd.bos.newdevportal.table.DesignerConstaint;
import kd.bos.newdevportal.table.DesignerTable;
import kd.bos.newdevportal.table.ErInfo;
import kd.bos.newdevportal.table.TableInfoProvider;

public class ErDataGenerator {
    protected static final Log LOG = LogFactory.getLog(ErDataGenerator.class);
    private static final String CACHEPREFIX = "ERD_";

    public static String getErdData(String entityId, String entityNum, String routkey, String activeTableName, IPageCache pageCache) {
        String sData;
        long beginTime = System.currentTimeMillis();
        if (pageCache != null && StringUtils.isNotBlank((CharSequence)(sData = pageCache.get(CACHEPREFIX + entityId + ErDataGenerator.getEntityMetaVersion(entityId))))) {
            return sData;
        }
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            double x = 50.0;
            double y = 40.0;
            ErInfo erInfo = new ErInfo();
            List<Tuple<String, String>> allTables = ErDataGenerator.getAllTalble(entityId);
            EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            System.out.print("abcd meta:" + (System.currentTimeMillis() - beginTime) + " |");
            MainEntity rootEntity = meta.getRootEntity();
            if (!(rootEntity instanceof BillEntity)) {
                return "";
            }
            BillEntity billEntity = (BillEntity)rootEntity;
            TableInfoProvider provider = TableInfoProvider.create(DBRoute.of((String)(routkey == null ? "sys" : routkey)));
            String billTableName = billEntity.getTableName();
            if (StringUtils.isBlank((CharSequence)billTableName)) {
                return null;
            }
            DesignerTable billTableInfo = provider.getTableInfo(billEntity.getTableName(), entityNum);
            ErInfo.Table billTable = erInfo.getTable().addTable();
            System.out.print("abcd billEntity:" + (System.currentTimeMillis() - beginTime) + " |");
            ErDataGenerator.syncTable(billTableInfo, billTable, billEntity, activeTableName);
            System.out.print("abcd syncTable:" + (System.currentTimeMillis() - beginTime) + " |");
            ErDataGenerator.fixupEntity(billTable, billEntity, x, y);
            System.out.print("abcd fixupEntity billTable:" + (System.currentTimeMillis() - beginTime) + " |");
            x = x + billTable.getTableWidth() + 50.0;
            double maxTableHeight_billRela = ErDataGenerator.buildRela2Entity(erInfo, billTable, billEntity, x, y, allTables, activeTableName, entityNum, provider, meta);
            y = y + Math.max(billTable.getTableHeight(), maxTableHeight_billRela) + 40.0;
            for (EntityItem entityItem : meta.getItems()) {
                EntryEntity entryEntity;
                String tableName;
                if (!(entityItem instanceof EntryEntity) || entityItem instanceof SubEntryEntity || StringUtils.isBlank((CharSequence)(tableName = (entryEntity = (EntryEntity)entityItem).getTableName()))) continue;
                DesignerTable entryTableInfo = provider.getTableInfo(tableName, entityNum);
                ErInfo.Table entryTable = erInfo.getTable().addTable();
                ErDataGenerator.syncTable(entryTableInfo, entryTable, entryEntity, activeTableName);
                ErDataGenerator.fixupEntity(entryTable, entryEntity, x, y);
                ErDataGenerator.fixupRelation(erInfo, billTable, billEntity, entryTable, entryEntity, null, null);
                double sub_x = x + entryTable.getTableWidth() + 50.0;
                double maxTableHeight_entryRela = ErDataGenerator.buildRela2Entity(erInfo, entryTable, entryEntity, sub_x, y, allTables, activeTableName, entityNum, provider, meta);
                double sub_y = y = y + Math.max(entryTable.getTableHeight(), maxTableHeight_entryRela) + 40.0;
                for (EntityItem subItem : ((EntryEntity)entityItem).getItems()) {
                    String subTableName;
                    if (!(subItem instanceof SubEntryEntity)) continue;
                    SubEntryEntity subEntryEntity = (SubEntryEntity)subItem;
                    if (!entryEntity.getId().equalsIgnoreCase(subEntryEntity.getParentEntryId()) || StringUtils.isBlank((CharSequence)(subTableName = subEntryEntity.getTableName()))) continue;
                    DesignerTable subEntryTableInfo = provider.getTableInfo(subTableName, entityNum);
                    ErInfo.Table subEntryTable = erInfo.getTable().addTable();
                    ErDataGenerator.syncTable(subEntryTableInfo, subEntryTable, subEntryEntity, activeTableName);
                    ErDataGenerator.fixupEntity(subEntryTable, subEntryEntity, sub_x, sub_y);
                    ErDataGenerator.fixupRelation(erInfo, entryTable, entryEntity, subEntryTable, subEntryEntity, null, null);
                    double sub_x_l = sub_x + subEntryTable.getTableWidth() + 50.0;
                    double maxTableHeight_subEntryRela = ErDataGenerator.buildRela2Entity(erInfo, subEntryTable, subEntryEntity, sub_x_l, sub_y, allTables, activeTableName, entityNum, provider, meta);
                    sub_y = sub_y + Math.max(subEntryTable.getTableHeight(), maxTableHeight_subEntryRela) + 40.0;
                }
                if (!(sub_y > y)) continue;
                y = sub_y;
            }
            int otherY = (int)ErDataGenerator.getY(erInfo) + 40;
            int otherX = 50;
            ErDataGenerator.buildOthers(erInfo, otherX, otherY, allTables, activeTableName, entityNum, provider);
            erInfo.getCanvas().setWidth(Math.max(erInfo.getCanvas().getWidth(), (int)ErDataGenerator.getX(erInfo)));
            erInfo.getCanvas().setHeight(Math.max(erInfo.getCanvas().getHeight(), (int)ErDataGenerator.getY(erInfo)));
            System.out.print("abcd seria1:" + (System.currentTimeMillis() - beginTime) + " |");
            ObjectMapper mapper = new ObjectMapper();
            String contentStr = null;
            try {
                contentStr = mapper.writeValueAsString((Object)erInfo);
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
            System.out.print("abcd seria2:" + (System.currentTimeMillis() - beginTime) + " |");
            System.out.print("abcd getErpData:" + (System.currentTimeMillis() - beginTime) + " |");
            if (pageCache != null) {
                pageCache.put(CACHEPREFIX + entityId, contentStr);
            }
            return contentStr;
        }
        return null;
    }

    private static void syncTable(DesignerTable src, ErInfo.Table target, Entity<?, ?> entity, String activeTableName) {
        String pkFieldName = null;
        if (entity == null) {
            for (DesignerConstaint constaint : src.getConstaints()) {
                if (!ConstaintType.Primary.equal(constaint.getConstaintType())) continue;
                pkFieldName = constaint.getRefCols().get(0);
            }
        } else if (entity instanceof BillEntity) {
            pkFieldName = ((BillEntity)entity).getPkFieldName();
        } else if (entity instanceof EntryEntity) {
            pkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
        } else if (entity instanceof SubEntryEntity) {
            pkFieldName = ((SubEntryEntity)entity).getEntryPkFieldName();
        }
        if (src != null) {
            target.setId(src.getCode());
            target.setName(src.getCode());
            target.setComment(src.getName());
            for (DesignerColumn col : src.getCols()) {
                ErInfo.Column column = target.addColumn();
                ErDataGenerator.syncColumn(col, column, null);
                if (!col.getCode().equalsIgnoreCase(pkFieldName)) continue;
                column.getOption().setPrimaryKey(true);
                column.getUi().setPk(true);
            }
        } else if (entity != null) {
            target.setId(entity.getTableName());
            target.setName(entity.getTableName());
            target.setComment(entity.getName().getLocaleValue());
            for (DesignerColumn col : entity.getItems()) {
                if (!(col instanceof Field)) continue;
                Field field = (Field)col;
                ErInfo.Column column = target.addColumn();
                ErDataGenerator.syncColumn(null, column, field);
                if (!field.getFieldName().equalsIgnoreCase(pkFieldName)) continue;
                column.getOption().setPrimaryKey(true);
                column.getUi().setPk(true);
            }
        }
        if (src != null && StringUtils.equalsIgnoreCase((CharSequence)src.getCode(), (CharSequence)activeTableName)) {
            target.getUi().setActive(true);
        }
    }

    private static void syncColumn(DesignerColumn src, ErInfo.Column target, Field<?> field) {
        if (src != null) {
            target.setId(UUID.randomUUID().toString());
            target.setName(src.getCode());
            target.setComment(src.getName());
            target.setDataType(src.getType());
            target.setDefault(src.getDefValue());
            target.getOption().setNotNull(src.isNotnull());
        } else {
            target.setId(UUID.randomUUID().toString());
            target.setName(field.getFieldName());
            target.setComment(field.getName().getLocaleValue());
            target.setDataType(field.getBizDataType());
            target.getOption().setNotNull(!field.isEnableNull());
        }
    }

    private static void fixupEntity(ErInfo.Table table, Entity<?, ?> subEntryEntity, double x, double y) {
        table.getUi().setLeft(x);
        table.getUi().setTop(y);
    }

    private static void fixupRelation(ErInfo erInfo, ErInfo.Table srcTable, Entity<?, ?> srcEntity, ErInfo.Table targetTable, Entity<?, ?> targetEntity, String constraintName, String relationshipType) {
        String relaType = "OneN";
        if (StringUtils.isNotBlank((CharSequence)relationshipType)) {
            relaType = relationshipType;
        }
        ErInfo.Relationship r = erInfo.getRelationship().addRelationship();
        r.setRelationshipType(relaType);
        String constraint = targetEntity == null ? "fk_" + srcEntity.getKey() : "fk_" + srcEntity.getKey() + "_" + targetEntity.getKey();
        r.setConstraintName(StringUtils.isBlank((CharSequence)constraintName) ? constraint : constraintName);
        r.setId(UUID.randomUUID().toString());
        r.getStart().setTableId(srcTable.getId());
        r.getStart().setDirection("right");
        List<String> pkColumnIds = srcTable.getPKColumnIds();
        r.getStart().getColumnIds().addAll(pkColumnIds);
        r.getEnd().setTableId(targetTable.getId());
        r.getEnd().setDirection("left");
        List<String> fkColumnIds = targetTable.getFKColumnIds(srcTable.getPKColumnNames());
        r.getEnd().getColumnIds().addAll(fkColumnIds);
    }

    private static double buildRela2Entity(ErInfo erInfo, ErInfo.Table table, Entity<?, ?> entity, double x, double y, List<Tuple<String, String>> allTables, String activeTableName, String entityNum, TableInfoProvider provider, EntityMetadata meta) {
        EntryEntity entryEntity;
        Object tableName;
        double maxHeight = 0.0;
        int relaX = (int)x;
        String multLangTableName = (table.getName() + "_L").toLowerCase();
        if (ErDataGenerator.existTable(allTables, multLangTableName)) {
            DesignerTable billTableInfo_L = provider.getTableInfo(multLangTableName, entityNum);
            ErInfo.Table billTable_L = erInfo.getTable().addTable();
            ErDataGenerator.syncTable(billTableInfo_L, billTable_L, entity, activeTableName);
            ErDataGenerator.fixupEntity(billTable_L, entity, relaX, y);
            ErDataGenerator.fixupRelation(erInfo, table, entity, billTable_L, null, "fk_" + entity.getKey() + "_L", "One");
            if (billTable_L.getTableHeight() > maxHeight) {
                maxHeight = billTable_L.getTableHeight();
            }
            relaX = (int)((double)relaX + (billTable_L.getTableWidth() + 50.0));
        }
        List addedTables = erInfo.getTable().getTables().stream().map(t -> t.getName()).collect(Collectors.toList());
        ArrayList<String> childTables = new ArrayList<String>(16);
        if (entity instanceof BillEntity) {
            for (EntityItem entityItem : meta.getItems()) {
                if (!(entityItem instanceof EntryEntity) || entityItem instanceof SubEntryEntity || !StringUtils.isNotBlank((CharSequence)(tableName = (entryEntity = (EntryEntity)entityItem).getTableName()))) continue;
                childTables.add(((String)tableName).toLowerCase());
            }
        } else if (entity instanceof EntryEntity) {
            for (EntityItem entityItem : meta.getItems()) {
                if (!(entityItem instanceof EntryEntity) || entityItem instanceof SubEntryEntity) continue;
                entryEntity = (EntryEntity)entityItem;
                for (EntityItem subItem : ((EntryEntity)entityItem).getItems()) {
                    String subTableName;
                    if (!(subItem instanceof SubEntryEntity)) continue;
                    SubEntryEntity subEntryEntity = (SubEntryEntity)subItem;
                    if (!entryEntity.getId().equalsIgnoreCase(subEntryEntity.getParentEntryId()) || !StringUtils.isNotBlank((CharSequence)(subTableName = subEntryEntity.getTableName()))) continue;
                    childTables.add(subTableName.toLowerCase());
                }
            }
        }
        int relaIndex = 0;
        for (Tuple<String, String> tbl : allTables) {
            tableName = (String)tbl.item1;
            String parentTableName = (String)tbl.item2;
            if (StringUtils.isBlank((CharSequence)parentTableName) || !StringUtils.equalsIgnoreCase((CharSequence)parentTableName, (CharSequence)table.getName()) || addedTables.contains(tableName) || childTables.contains(tableName)) continue;
            DesignerTable relaTableInfo = provider.getTableInfo((String)tableName, entityNum);
            ErInfo.Table relaTable = erInfo.getTable().addTable();
            ErDataGenerator.syncTable(relaTableInfo, relaTable, null, activeTableName);
            ErDataGenerator.fixupEntity(relaTable, null, relaX, y);
            ErDataGenerator.fixupRelation(erInfo, table, entity, relaTable, null, "fk_" + entity.getKey() + "_" + relaTable.getName() + "_rela" + relaIndex++, "ZeroOne");
            relaX = (int)((double)relaX + (relaTable.getTableWidth() + 50.0));
            if (!(relaTable.getTableHeight() > maxHeight)) continue;
            maxHeight = relaTable.getTableHeight();
        }
        return maxHeight;
    }

    private static void buildOthers(ErInfo erInfo, double x, double y, List<Tuple<String, String>> allTables, String activeTableName, String entityNum, TableInfoProvider provider) {
        int otherX = (int)x;
        List addedTables = erInfo.getTable().getTables().stream().map(t -> t.getName()).collect(Collectors.toList());
        for (Tuple<String, String> tbl : allTables) {
            String tableName = (String)tbl.item1;
            if (addedTables.contains(tableName)) continue;
            DesignerTable otherTableInfo = provider.getTableInfo(tableName, entityNum);
            ErInfo.Table otherTable = erInfo.getTable().addTable();
            ErDataGenerator.syncTable(otherTableInfo, otherTable, null, activeTableName);
            ErDataGenerator.fixupEntity(otherTable, null, otherX, y);
            otherX = (int)((double)otherX + (otherTable.getTableWidth() + 50.0));
        }
    }

    private static double getY(ErInfo erInfo) {
        double maxTop = 0.0;
        double heightOfLastTable = 0.0;
        for (ErInfo.Table table : erInfo.getTable().getTables()) {
            double top = table.getUi().getTop();
            if (!(top > maxTop)) continue;
            maxTop = top;
            heightOfLastTable = table.getTableHeight();
        }
        return maxTop + heightOfLastTable;
    }

    private static double getX(ErInfo erInfo) {
        double maxLeft = 0.0;
        double weightOfLastTable = 0.0;
        for (ErInfo.Table table : erInfo.getTable().getTables()) {
            double left = table.getUi().getLeft();
            if (!(left > maxLeft)) continue;
            maxLeft = left;
            weightOfLastTable = table.getTableWidth();
        }
        return maxLeft + weightOfLastTable;
    }

    private static String getEntityMetaVersion(String entityId) {
        String sql = "select FVersion from t_meta_entitydesign where FId = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)entityId)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return "";
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private static List<Tuple<String, String>> getAllTalble(String entityId) {
        String targetEntityId = ErDataGenerator.getMasterEntityId(entityId);
        String sql = "select ftablename, fdata from t_meta_tablediction where fmainentityid= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":fmainentityid", 12, (Object)targetEntityId)};
        ResultSetHandler action = rs -> {
            ArrayList<Tuple> result = new ArrayList<Tuple>(16);
            while (rs.next()) {
                String tablename = rs.getString("ftablename").toLowerCase();
                String parenttable = null;
                try {
                    String extData = rs.getString("fdata");
                    if (StringUtils.isNotBlank((CharSequence)extData)) {
                        Map obj = (Map)SerializationUtils.fromJsonString((String)extData, Map.class);
                        parenttable = (String)obj.get("parenttable");
                    }
                }
                catch (Exception e) {
                    LOG.error("\u6570\u636e\u8868\u63cf\u8ff0\u67e5\u8be2\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                }
                result.add(new Tuple((Object)tablename, parenttable));
            }
            return result;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private static String getMasterEntityId(String entityId) {
        return MetadataDao.getMasterId((String)entityId);
    }

    private static boolean existTable(List<Tuple<String, String>> allTables, String tableName) {
        return allTables.stream().anyMatch(t -> StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)((CharSequence)t.item1)));
    }
}

